/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.devices;

import com.biglybt.core.devices.DeviceTemplate;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellFactory;
import com.biglybt.ui.swt.devices.DeviceManagerUI;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.Colors;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class DevicesWizard {
    DeviceManagerUI device_manager_ui;
    private Display display;
    Shell shell;
    Font boldFont;
    Font titleFont;
    Font subTitleFont;
    Font textInputFont;
    ImageLoader imageLoader;

    public DevicesWizard(DeviceManagerUI dm_ui) {
        this.device_manager_ui = dm_ui;
        this.imageLoader = ImageLoader.getInstance();
        this.shell = ShellFactory.createMainShell(113);
        this.shell.setSize(650, 400);
        Utils.centreWindow(this.shell);
        this.shell.setMinimumSize(550, 400);
        this.display = this.shell.getDisplay();
        Utils.setShellIcon(this.shell);
        this.createFonts();
        this.shell.setText(MessageText.getString("wizard.device.title"));
        this.shell.addListener(12, new Listener(){

            public void handleEvent(Event event2) {
                DevicesWizard.this.imageLoader.releaseImage("wizard_header_bg");
                if (DevicesWizard.this.titleFont != null && !DevicesWizard.this.titleFont.isDisposed()) {
                    DevicesWizard.this.titleFont.dispose();
                }
                if (DevicesWizard.this.textInputFont != null && !DevicesWizard.this.textInputFont.isDisposed()) {
                    DevicesWizard.this.textInputFont.dispose();
                }
                if (DevicesWizard.this.boldFont != null && !DevicesWizard.this.boldFont.isDisposed()) {
                    DevicesWizard.this.boldFont.dispose();
                }
                if (DevicesWizard.this.subTitleFont != null && !DevicesWizard.this.subTitleFont.isDisposed()) {
                    DevicesWizard.this.subTitleFont.dispose();
                }
            }
        });
        Composite header = new Composite((Composite)this.shell, 0);
        header.setBackgroundImage(this.imageLoader.getImage("wizard_header_bg"));
        Label topSeparator = new Label((Composite)this.shell, 258);
        Composite main = new Composite((Composite)this.shell, 0);
        Label bottomSeparator = new Label((Composite)this.shell, 258);
        Composite footer = new Composite((Composite)this.shell, 0);
        FormLayout layout = new FormLayout();
        this.shell.setLayout((Layout)layout);
        FormData data = new FormData();
        data.top = new FormAttachment(0, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        header.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)header, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        topSeparator.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)topSeparator, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment((Control)bottomSeparator, 0);
        main.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        data.bottom = new FormAttachment((Control)footer, 0);
        bottomSeparator.setLayoutData((Object)data);
        data = new FormData();
        data.bottom = new FormAttachment(100, 0);
        data.left = new FormAttachment(0, 0);
        data.right = new FormAttachment(100, 0);
        footer.setLayoutData((Object)data);
        this.populateHeader(header);
        this.populateFooter(footer);
        this.shell.layout();
        this.shell.open();
    }

    private void populateHeader(Composite header) {
        header.setBackground(Colors.getSystemColor((Device)this.display, 1));
        Label title = new Label(header, 64);
        title.setFont(this.titleFont);
        title.setText(MessageText.getString("device.wizard.header"));
        FillLayout layout = new FillLayout();
        layout.marginHeight = 10;
        layout.marginWidth = 10;
        header.setLayout((Layout)layout);
    }

    private void createFonts() {
        FontData fData;
        FontData[] fDatas;
        FontData[] fontDataArray = fDatas = this.shell.getFont().getFontData();
        int n = fDatas.length;
        int n2 = 0;
        while (n2 < n) {
            fData = fontDataArray[n2];
            fData.setStyle(1);
            ++n2;
        }
        this.boldFont = new Font((Device)this.display, fDatas);
        fontDataArray = fDatas;
        n = fDatas.length;
        n2 = 0;
        while (n2 < n) {
            fData = fontDataArray[n2];
            if (Constants.isOSX) {
                fData.setHeight(12);
            } else {
                fData.setHeight(10);
            }
            ++n2;
        }
        this.subTitleFont = new Font((Device)this.display, fDatas);
        fontDataArray = fDatas;
        n = fDatas.length;
        n2 = 0;
        while (n2 < n) {
            fData = fontDataArray[n2];
            if (Constants.isOSX) {
                fData.setHeight(17);
            } else {
                fData.setHeight(14);
            }
            ++n2;
        }
        this.titleFont = new Font((Device)this.display, fDatas);
        fontDataArray = fDatas;
        n = fDatas.length;
        n2 = 0;
        while (n2 < n) {
            fData = fontDataArray[n2];
            if (Constants.isOSX) {
                fData.setHeight(14);
            } else {
                fData.setHeight(12);
            }
            fData.setStyle(0);
            ++n2;
        }
        this.textInputFont = new Font((Device)this.display, fDatas);
    }

    private void populateFooter(Composite footer) {
        Button cancelButton = new Button(footer, 8);
        cancelButton.setText(MessageText.getString("Button.cancel"));
        Button createButton = new Button(footer, 8);
        createButton.setText(MessageText.getString("device.wizard.create"));
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        layout.spacing = 5;
        footer.setLayout((Layout)layout);
        FormData data = new FormData();
        data.right = new FormAttachment(100);
        data.width = 100;
        cancelButton.setLayoutData((Object)data);
        data = new FormData();
        data.left = new FormAttachment(0);
        data.width = 175;
        createButton.setLayoutData((Object)data);
        createButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                try {
                    DeviceTemplate[] templates;
                    DeviceTemplate[] deviceTemplateArray = templates = DevicesWizard.this.device_manager_ui.getDeviceManager().getDeviceTemplates(3);
                    int n = templates.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DeviceTemplate template = deviceTemplateArray[n2];
                        if (!template.isAuto()) {
                            com.biglybt.core.devices.Device device = template.createInstance(String.valueOf(template.getName()) + " test!");
                            device.requestAttention();
                            break;
                        }
                        ++n2;
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        });
        cancelButton.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                DevicesWizard.this.shell.close();
            }
        });
    }
}

