/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.devices;

import com.biglybt.core.Core;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreOperation;
import com.biglybt.core.CoreOperationListener;
import com.biglybt.core.CoreRunningListener;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.devices.Device;
import com.biglybt.core.devices.DeviceContentDirectory;
import com.biglybt.core.devices.DeviceManager;
import com.biglybt.core.devices.DeviceManagerException;
import com.biglybt.core.devices.DeviceManagerFactory;
import com.biglybt.core.devices.DeviceManagerListener;
import com.biglybt.core.devices.DeviceMediaRenderer;
import com.biglybt.core.devices.DeviceSearchListener;
import com.biglybt.core.devices.DeviceTemplate;
import com.biglybt.core.devices.DeviceUPnP;
import com.biglybt.core.devices.TranscodeException;
import com.biglybt.core.devices.TranscodeFile;
import com.biglybt.core.devices.TranscodeJob;
import com.biglybt.core.devices.TranscodeManager;
import com.biglybt.core.devices.TranscodeManagerListener;
import com.biglybt.core.devices.TranscodeProfile;
import com.biglybt.core.devices.TranscodeProvider;
import com.biglybt.core.devices.TranscodeQueue;
import com.biglybt.core.devices.TranscodeQueueListener;
import com.biglybt.core.devices.TranscodeTarget;
import com.biglybt.core.devices.TranscodeTargetListener;
import com.biglybt.core.download.DiskManagerFileInfoFile;
import com.biglybt.core.download.DiskManagerFileInfoURL;
import com.biglybt.core.download.StreamManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.TagUtils;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.FrequencyLimitedDispatcher;
import com.biglybt.core.util.GeneralUtils;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.RegExUtil;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.core.util.average.AverageFactory;
import com.biglybt.core.util.average.MovingAverage;
import com.biglybt.core.vuzefile.VuzeFile;
import com.biglybt.core.vuzefile.VuzeFileHandler;
import com.biglybt.net.upnp.UPnPDevice;
import com.biglybt.net.upnp.UPnPRootDevice;
import com.biglybt.net.upnp.UPnPService;
import com.biglybt.net.upnp.services.UPnPWANCommonInterfaceConfig;
import com.biglybt.net.upnpms.UPNPMSBrowser;
import com.biglybt.net.upnpms.UPNPMSBrowserFactory;
import com.biglybt.net.upnpms.UPNPMSBrowserListener;
import com.biglybt.net.upnpms.UPNPMSContainer;
import com.biglybt.net.upnpms.UPNPMSItem;
import com.biglybt.net.upnpms.UPNPMSNode;
import com.biglybt.net.upnpms.UPnPMSException;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginManager;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.installer.PluginInstaller;
import com.biglybt.pif.installer.StandardPlugin;
import com.biglybt.pif.ui.UIInputReceiver;
import com.biglybt.pif.ui.UIInputReceiverListener;
import com.biglybt.pif.ui.UIInstance;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.UIManagerListener;
import com.biglybt.pif.ui.config.ActionParameter;
import com.biglybt.pif.ui.config.BooleanParameter;
import com.biglybt.pif.ui.config.DirectoryParameter;
import com.biglybt.pif.ui.config.HyperlinkParameter;
import com.biglybt.pif.ui.config.IntParameter;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pif.ui.menus.MenuItemFillListener;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.menus.MenuManager;
import com.biglybt.pif.ui.model.BasicPluginConfigModel;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.pif.ui.tables.TableManager;
import com.biglybt.pif.ui.tables.TableRow;
import com.biglybt.pif.utils.StaticUtilities;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.platform.PlatformManager;
import com.biglybt.platform.PlatformManagerCapabilities;
import com.biglybt.platform.PlatformManagerFactory;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfo;
import com.biglybt.ui.common.viewtitleinfo.ViewTitleInfoManager;
import com.biglybt.ui.mdi.MdiCloseListener;
import com.biglybt.ui.mdi.MdiEntry;
import com.biglybt.ui.mdi.MdiEntryCreationListener;
import com.biglybt.ui.mdi.MdiEntryDropListener;
import com.biglybt.ui.mdi.MdiEntryVitalityImage;
import com.biglybt.ui.mdi.MdiEntryVitalityImageListener;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.swt.FixedURLTransfer;
import com.biglybt.ui.swt.MenuBuildUtils;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.PropertiesWindow;
import com.biglybt.ui.swt.UIExitUtilsSWT;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BufferedLabel;
import com.biglybt.ui.swt.components.Legend;
import com.biglybt.ui.swt.components.graphics.MultiPlotGraphic;
import com.biglybt.ui.swt.components.graphics.ValueFormater;
import com.biglybt.ui.swt.components.graphics.ValueSource;
import com.biglybt.ui.swt.devices.DeviceInternetView;
import com.biglybt.ui.swt.devices.DevicesFTUX;
import com.biglybt.ui.swt.devices.TranscodeChooser;
import com.biglybt.ui.swt.devices.add.DeviceTemplateChooser;
import com.biglybt.ui.swt.devices.add.ManufacturerChooser;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.mainwindow.TorrentOpener;
import com.biglybt.ui.swt.mdi.MdiEntrySWT;
import com.biglybt.ui.swt.mdi.MultipleDocumentInterfaceSWT;
import com.biglybt.ui.swt.pif.UISWTInputReceiver;
import com.biglybt.ui.swt.pif.UISWTInstance;
import com.biglybt.ui.swt.pif.UISWTView;
import com.biglybt.ui.swt.pif.UISWTViewBuilder;
import com.biglybt.ui.swt.pif.UISWTViewEvent;
import com.biglybt.ui.swt.pif.UISWTViewEventListener;
import com.biglybt.ui.swt.pif.UISWTViewMultiInstance;
import com.biglybt.ui.swt.pifimpl.UISWTViewBuilderCore;
import com.biglybt.ui.swt.shells.CoreWaiterSWT;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.utils.DragDropUtils;
import com.biglybt.ui.swt.views.ViewManagerSWT;
import com.biglybt.ui.swt.views.skin.SkinView;
import com.biglybt.ui.swt.views.skin.SkinViewManager;
import com.biglybt.ui.swt.views.skin.sidebar.SideBar;
import com.biglybt.ui.swt.views.utils.ManagerUtils;
import com.biglybt.ui.swt.views.utils.TagUIUtils;
import com.biglybt.util.PlayUtils;
import java.io.File;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.DragSource;
import org.eclipse.swt.dnd.DragSourceAdapter;
import org.eclipse.swt.dnd.DragSourceEvent;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTarget;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MenuAdapter;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class DeviceManagerUI {
    private static final String CONFIG_SECTION_ID = "Devices";
    public static boolean DISABLED = Utils.isAZ2UI();
    public static boolean DISABLED_TRANSCODING = false;
    private static final int MIN_FILE_SIZE_FOR_XCODE = 131072;
    private static final int MAX_FILES_FOR_MULTI_XCODE = 64;
    private static final Object DEVICE_IVIEW_KEY = new Object();
    private static final String CONFIG_VIEW_TYPE = "device.sidebar.ui.viewtype";
    public static final String CONFIG_VIEW_HIDE_REND_GENERIC = "device.sidebar.ui.rend.hidegeneric";
    public static final String CONFIG_VIEW_SHOW_ONLY_TAGGED = "device.sidebar.ui.rend.showonlytagged";
    private static final String SPINNER_IMAGE_ID = "image.sidebar.vitality.dl";
    private static final String INFO_IMAGE_ID = "image.sidebar.vitality.info";
    private static final String ALERT_IMAGE_ID = "image.sidebar.vitality.alert";
    private static final boolean SHOW_RENDERER_VITALITY = false;
    private static final boolean SHOW_OD_VITALITY = true;
    private static Color[] colors = new Color[]{Colors.fadedGreen, Colors.fadedGreen, Colors.blues[9], Colors.blues[9]};
    private DeviceManager device_manager;
    private DeviceManagerListener device_manager_listener;
    private boolean device_manager_listener_added;
    private final PluginInterface plugin_interface;
    private final UIManager ui_manager;
    private UISWTInstance swt_ui;
    private boolean ui_setup;
    private MultipleDocumentInterfaceSWT mdi;
    private boolean sidebar_built;
    private static final int SBV_SIMPLE = 0;
    private static final int SBV_FULL = Integer.MAX_VALUE;
    private int side_bar_view_type = COConfigurationManager.getIntParameter("device.sidebar.ui.viewtype", 0);
    private boolean side_bar_hide_rend_gen = COConfigurationManager.getBooleanParameter("device.sidebar.ui.rend.hidegeneric", true);
    private boolean side_bar_show_tagged = COConfigurationManager.getBooleanParameter("device.sidebar.ui.rend.showonlytagged", false);
    private int next_sidebar_id;
    private List<categoryView> categories = new ArrayList<categoryView>();
    private int last_job_count = 0;
    private MenuItemListener properties_listener;
    private MenuItemListener hide_listener;
    private MenuItemListener rename_listener;
    private MenuItemListener export_listener;
    private MenuItemFillListener will_remove_listener;
    private MenuItemListener remove_listener;
    private MenuItemFillListener show_fill_listener;
    private MenuItemListener show_listener;
    private MenuItemFillListener will_tag_listener;
    private MenuItemListener tag_listener;
    private MenuItemFillListener will_browse_listener;
    private boolean offline_menus_setup;
    private MdiEntry mdiEntryOverview;
    private boolean needsAddAllDevices;
    private MdiEntry entryHeader;
    private static final String OXC_NOTHING = "Nothing";
    private static final String OXC_QUIT_VUZE = "QuitVuze";
    private static final String OXC_SLEEP = "Sleep";
    private static final String OXC_HIBERNATE = "Hibernate";
    private static final String OXC_SHUTDOWN = "Shutdown";
    private String oxc_action = "Nothing";
    private boolean oxc_trigger_set = false;
    private static final int MAX_MS_DISPLAY_LINE_DEFAULT = 5000;
    private DeviceManagerListener device_manager_listener_setupui;
    private TranscodeQueueListener transcodeQueueListener;
    private ParameterListener configListener;
    private DeviceManagerListener deviceManagerListener;
    private TranscodeManagerListener transcodeManagerListener;
    private ParameterListener parameterListener;
    private UIExitUtilsSWT.canCloseListener canCloseListener;
    private BasicPluginConfigModel configModel;
    private Map<String, String> builder_map = new HashMap<String, String>();

    public DeviceManagerUI(Core core) {
        this.plugin_interface = PluginInitializer.getDefaultInterface();
        this.ui_manager = this.plugin_interface.getUIManager();
        if (DISABLED) {
            return;
        }
        this.ui_manager.addUIListener(new UIManagerListener(){

            @Override
            public void UIAttached(UIInstance instance) {
                if (instance instanceof UISWTInstance) {
                    DeviceManagerUI.this.swt_ui = (UISWTInstance)instance;
                    CoreFactory.addCoreRunningListener(new CoreRunningListener(){

                        @Override
                        public void coreRunning(Core core) {
                            DeviceManagerUI.this.uiAttachedAndCoreRunning(core);
                        }
                    });
                    DeviceManagerUI.this.ui_manager.removeUIListener(this);
                }
            }

            @Override
            public void UIDetached(UIInstance instance) {
            }
        });
    }

    private void uiAttachedAndCoreRunning(Core core) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                MultipleDocumentInterfaceSWT mdi = UIFunctionsManagerSWT.getUIFunctionsSWT().getMDISWT();
                if (mdi != null) {
                    DeviceManagerUI.this.setupUI(mdi);
                } else {
                    SkinViewManager.addListener(new SkinViewManager.SkinViewManagerListener(){

                        @Override
                        public void skinViewAdded(SkinView skinview) {
                            if (skinview instanceof SideBar) {
                                DeviceManagerUI.this.setupUI((SideBar)skinview);
                                SkinViewManager.RemoveListener(this);
                            }
                        }
                    });
                }
            }
        });
        this.canCloseListener = new UIExitUtilsSWT.canCloseListener(){

            @Override
            public boolean canClose() {
                TranscodeJob job;
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                try {
                                    if (DeviceManagerUI.this.device_manager != null) break block6;
                                    return true;
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                    return true;
                                }
                            }
                            if (DeviceManagerUI.this.device_manager.isTranscodeManagerInitialized()) break block7;
                            return true;
                        }
                        job = DeviceManagerUI.this.device_manager.getTranscodeManager().getQueue().getCurrentJob();
                        if (job != null && job.getState() == 1) break block8;
                        return true;
                    }
                    if (!job.getTranscodeFile().getDevice().isHidden()) break block9;
                    return true;
                }
                String title = MessageText.getString("device.quit.transcoding.title");
                String text = MessageText.getString("device.quit.transcoding.text", new String[]{job.getName(), job.getTarget().getDevice().getName(), String.valueOf(job.getPercentComplete())});
                MessageBoxShell mb = new MessageBoxShell(title, text, new String[]{MessageText.getString("UpdateWindow.quit"), MessageText.getString("Content.alert.notuploaded.button.abort")}, 1);
                mb.open(null);
                mb.waitUntilClosed();
                return mb.getResult() == 0;
            }
        };
        UIExitUtilsSWT.addListener(this.canCloseListener);
    }

    protected DeviceManager getDeviceManager() {
        return this.device_manager;
    }

    protected PluginInterface getPluginInterface() {
        return this.plugin_interface;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setupUI(MultipleDocumentInterfaceSWT mdi) {
        DeviceManagerUI deviceManagerUI = this;
        synchronized (deviceManagerUI) {
            if (this.ui_setup) {
                return;
            }
            this.ui_setup = true;
        }
        this.mdi = mdi;
        this.device_manager = DeviceManagerFactory.getSingleton();
        this.setupMenuListeners();
        mdi.registerEntry(CONFIG_SECTION_ID, new MdiEntryCreationListener(){

            @Override
            public MdiEntry createMDiEntry(String id) {
                if (DeviceManagerUI.this.sidebar_built) {
                    DeviceManagerUI.this.removeAllDevices();
                    DeviceManagerUI.this.buildSideBar(true);
                } else {
                    DeviceManagerUI.this.buildSideBar(false);
                }
                DeviceManagerUI.this.addAllDevices();
                return DeviceManagerUI.this.mdiEntryOverview;
            }
        });
        this.device_manager_listener_setupui = new DeviceManagerListener(){

            @Override
            public void deviceRemoved(Device device) {
            }

            @Override
            public void deviceManagerLoaded() {
                DeviceManagerUI.this.device_manager.removeListener(this);
                DeviceManagerUI.this.setupUIwithDeviceManager();
            }

            @Override
            public void deviceChanged(Device device) {
            }

            @Override
            public void deviceAttentionRequest(Device device) {
            }

            @Override
            public void deviceAdded(Device device) {
            }
        };
        this.device_manager.addListener(this.device_manager_listener_setupui);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupUIwithDeviceManager() {
        boolean add_all = false;
        DeviceManagerUI deviceManagerUI = this;
        synchronized (deviceManagerUI) {
            this.device_manager_listener = new DeviceManagerListener(){

                @Override
                public void deviceAdded(Device device) {
                    DeviceManagerUI.this.addOrChangeDevice(device);
                }

                @Override
                public void deviceChanged(Device device) {
                    DeviceManagerUI.this.addOrChangeDevice(device);
                }

                @Override
                public void deviceAttentionRequest(Device device) {
                    DeviceManagerUI.this.showDevice(device);
                }

                @Override
                public void deviceRemoved(Device device) {
                    DeviceManagerUI.this.removeDevice(device);
                }

                @Override
                public void deviceManagerLoaded() {
                }
            };
            if (this.needsAddAllDevices) {
                add_all = true;
                this.needsAddAllDevices = false;
            }
        }
        TranscodeManager transMan = this.device_manager.getTranscodeManager();
        final TranscodeQueue transQ = transMan.getQueue();
        this.transcodeQueueListener = new TranscodeQueueListener(){
            {
                this.check();
            }

            @Override
            public void jobAdded(TranscodeJob job) {
                this.check();
            }

            @Override
            public void jobChanged(TranscodeJob job) {
                this.check();
            }

            @Override
            public void jobRemoved(TranscodeJob job) {
                this.check();
            }

            protected void check() {
                try {
                    int job_count = transQ.getJobCount();
                    if (job_count != DeviceManagerUI.this.last_job_count) {
                        MdiEntry main_entry;
                        MultipleDocumentInterface mdi;
                        if ((job_count == 0 || DeviceManagerUI.this.last_job_count == 0) && (mdi = UIFunctionsManager.getUIFunctions().getMDI()) != null && (main_entry = mdi.getEntry(DeviceManagerUI.CONFIG_SECTION_ID)) != null) {
                            ViewTitleInfoManager.refreshTitleInfo(main_entry.getViewTitleInfo());
                        }
                        DeviceManagerUI.this.last_job_count = job_count;
                    }
                }
                finally {
                    DeviceManagerUI.this.checkOXCState();
                }
            }
        };
        transQ.addListener(this.transcodeQueueListener);
        this.setupListeners();
        this.setupConfigUI();
        if (add_all) {
            this.addAllDevices();
        }
        this.setupTranscodeMenus();
    }

    public void setupConfigUI() {
        this.configModel = this.ui_manager.createBasicPluginConfigModel("root", CONFIG_SECTION_ID);
        final BooleanParameter as = this.configModel.addBooleanParameter2("device.search.auto", "device.search.auto", this.device_manager.getAutoSearch());
        as.addListener(new com.biglybt.pif.ui.config.ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                DeviceManagerUI.this.device_manager.setAutoSearch(as.getValue());
                if (DeviceManagerUI.this.device_manager.getAutoSearch()) {
                    DeviceManagerUI.this.search();
                }
            }
        });
        final BooleanParameter config_simple_view = this.configModel.addBooleanParameter2(CONFIG_VIEW_TYPE, "devices.sidebar.simple", this.side_bar_view_type == 0);
        config_simple_view.addListener(new com.biglybt.pif.ui.config.ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                COConfigurationManager.setParameter(DeviceManagerUI.CONFIG_VIEW_TYPE, config_simple_view.getValue() ? 0 : Integer.MAX_VALUE);
            }
        });
        this.configListener = new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                config_simple_view.setValue(COConfigurationManager.getIntParameter(DeviceManagerUI.CONFIG_VIEW_TYPE, 0) == 0);
            }
        };
        COConfigurationManager.addWeakParameterListener(this.configListener, false, CONFIG_VIEW_TYPE);
        this.configModel.addBooleanParameter2("!device.sidebar.ui.rend.hidegeneric!", "devices.sidebar.hide.rend.generic", this.side_bar_hide_rend_gen);
        this.configModel.addBooleanParameter2("!device.sidebar.ui.rend.showonlytagged!", "devices.sidebar.show.only.tagged", this.side_bar_show_tagged);
        final IntParameter auto_hide_old = this.configModel.addIntParameter2("device.config.autohide.old.devices", "device.config.autohide.old.devices", this.device_manager.getAutoHideOldDevicesDays(), 0, 2048);
        auto_hide_old.addListener(new com.biglybt.pif.ui.config.ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                DeviceManagerUI.this.device_manager.setAutoHideOldDevicesDays(auto_hide_old.getValue());
            }
        });
        if (!DISABLED_TRANSCODING) {
            this.createTranscodingSection();
        }
        IntParameter max_ms_lines = this.configModel.addIntParameter2("device.config.ms.maxlines", "device.config.ms.maxlines", 5000, 0, Integer.MAX_VALUE);
        this.configModel.createGroup("device.ms.group", max_ms_lines);
        final BooleanParameter rss_enable = this.configModel.addBooleanParameter2("device.rss.enable", "device.rss.enable", this.device_manager.isRSSPublishEnabled());
        rss_enable.addListener(new com.biglybt.pif.ui.config.ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                DeviceManagerUI.this.device_manager.setRSSPublishEnabled(rss_enable.getValue());
            }
        });
        HyperlinkParameter rss_view = this.configModel.addHyperlinkParameter2("device.rss.view", this.device_manager.getRSSLink());
        rss_enable.addEnabledOnSelection((Parameter)rss_view);
        this.configModel.createGroup("device.rss.group", rss_enable, rss_view);
        final StreamManager sm = StreamManager.getSingleton();
        final IntParameter pn_buffer = this.configModel.addIntParameter2("device.playnow.buffer", "device.playnow.buffer", sm.getBufferSecs());
        pn_buffer.addListener(new com.biglybt.pif.ui.config.ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                sm.setBufferSecs(pn_buffer.getValue());
            }
        });
        IntParameter pn_min_buffer = this.configModel.addIntParameter2("device.playnow.min_buffer", "device.playnow.min_buffer", sm.getMinBufferSecs());
        pn_min_buffer.addListener(new com.biglybt.pif.ui.config.ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                sm.setMinBufferSecs(pn_buffer.getValue());
            }
        });
        this.configModel.createGroup("device.playnow.group", pn_buffer, pn_min_buffer);
        if (!DISABLED_TRANSCODING) {
            final BooleanParameter tivo_enable = this.configModel.addBooleanParameter2("device.tivo.enable", "device.tivo.enable", false);
            tivo_enable.setValue(this.device_manager.isTiVoEnabled());
            tivo_enable.addListener(new com.biglybt.pif.ui.config.ParameterListener(){

                @Override
                public void parameterChanged(Parameter param) {
                    DeviceManagerUI.this.device_manager.setTiVoEnabled(tivo_enable.getValue());
                    DeviceManagerUI.this.rebuildSideBarIfExists();
                }
            });
        }
    }

    public void createTranscodingSection() {
        BooleanParameter disable_sleep;
        String def = this.device_manager.getDefaultWorkingDirectory().getAbsolutePath();
        final DirectoryParameter def_work_dir = this.configModel.addDirectoryParameter2("device.config.xcode.workdir", "device.config.xcode.workdir", def);
        def_work_dir.setValue(def);
        def_work_dir.addListener(new com.biglybt.pif.ui.config.ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                DeviceManagerUI.this.device_manager.setDefaultWorkingDirectory(new File(def_work_dir.getValue()));
            }
        });
        final int kinb = DisplayFormatters.getKinB();
        final IntParameter max_xcode = this.configModel.addIntParameter2("device.config.xcode.maxbps", "device.config.xcode.maxbps", (int)(this.device_manager.getTranscodeManager().getQueue().getMaxBytesPerSecond() / (long)kinb), 0, Integer.MAX_VALUE);
        max_xcode.addListener(new com.biglybt.pif.ui.config.ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                DeviceManagerUI.this.device_manager.getTranscodeManager().getQueue().setMaxBytesPerSecond(max_xcode.getValue() * kinb);
            }
        });
        PlatformManager platform = PlatformManagerFactory.getPlatformManager();
        if (platform.hasCapability(PlatformManagerCapabilities.PreventComputerSleep)) {
            disable_sleep = this.configModel.addBooleanParameter2("device.config.xcode.disable_sleep", "device.config.xcode.disable_sleep", this.device_manager.getDisableSleep());
            disable_sleep.addListener(new com.biglybt.pif.ui.config.ParameterListener(){

                @Override
                public void parameterChanged(Parameter param) {
                    DeviceManagerUI.this.device_manager.setDisableSleep(disable_sleep.getValue());
                }
            });
        } else {
            disable_sleep = null;
        }
        final ActionParameter btnITunes = this.configModel.addActionParameter2("devices.button.installitunes", "UpdateWindow.columns.install");
        btnITunes.setEnabled(false);
        CoreFactory.addCoreRunningListener(new CoreRunningListener(){

            @Override
            public void coreRunning(Core core) {
                boolean hasItunes = core.getPluginManager().getPluginInterfaceByID("azitunes") != null;
                btnITunes.setEnabled(!hasItunes);
            }
        });
        btnITunes.addListener(new com.biglybt.pif.ui.config.ParameterListener(){

            @Override
            public void parameterChanged(Parameter param) {
                CoreWaiterSWT.waitForCoreRunning(new CoreRunningListener(){

                    @Override
                    public void coreRunning(Core core) {
                        try {
                            PluginInstaller installer = core.getPluginManager().getPluginInstaller();
                            StandardPlugin itunes_plugin = installer.getStandardPlugin("azitunes");
                            if (itunes_plugin == null) {
                                Debug.out("iTunes standard plugin not found");
                            } else {
                                itunes_plugin.install(false);
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                });
            }
        });
        this.configModel.createGroup("device.xcode.group", def_work_dir, max_xcode, disable_sleep, btnITunes);
    }

    protected void setupMenuListeners() {
        this.properties_listener = new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                if (target instanceof MdiEntry) {
                    MdiEntry info = (MdiEntry)target;
                    Device device = (Device)info.getDataSource();
                    DeviceManagerUI.this.showProperties(device);
                }
            }
        };
        this.hide_listener = new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                if (target instanceof MdiEntry) {
                    MdiEntry info = (MdiEntry)target;
                    Device device = (Device)info.getDataSource();
                    device.setHidden(true);
                }
            }
        };
        this.will_tag_listener = new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object targets) {
                Object[] rows = targets instanceof Object[] ? (Object[])targets : new Object[]{targets};
                if (rows.length > 0 && rows[0] instanceof MdiEntry) {
                    MdiEntry info = (MdiEntry)rows[0];
                    Device device = (Device)info.getDataSource();
                    menu.setData(device.isTagged());
                } else {
                    menu.setEnabled(false);
                }
            }
        };
        this.tag_listener = new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                if (target instanceof MdiEntry) {
                    Device device;
                    MdiEntry info = (MdiEntry)target;
                    device.setTagged(!(device = (Device)info.getDataSource()).isTagged());
                }
            }
        };
        this.rename_listener = new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                if (target instanceof MdiEntry) {
                    MdiEntry info = (MdiEntry)target;
                    final Device device = (Device)info.getDataSource();
                    UISWTInputReceiver entry = (UISWTInputReceiver)DeviceManagerUI.this.swt_ui.getInputReceiver();
                    entry.setPreenteredText(device.getName(), false);
                    entry.maintainWhitespace(false);
                    entry.allowEmptyInput(false);
                    entry.setLocalisedTitle(MessageText.getString("label.rename", new String[]{device.getName()}));
                    entry.prompt(new UIInputReceiverListener(){

                        @Override
                        public void UIInputReceiverClosed(UIInputReceiver entry) {
                            if (!entry.hasSubmittedInput()) {
                                return;
                            }
                            String input = entry.getSubmittedInput().trim();
                            if (input.length() > 0) {
                                device.setName(input, false);
                            }
                        }
                    });
                }
            }
        };
        this.export_listener = new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                if (target instanceof MdiEntry) {
                    MdiEntry info = (MdiEntry)target;
                    Device device = (Device)info.getDataSource();
                    DeviceManagerUI.this.export(device);
                }
            }
        };
        this.will_remove_listener = new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object targets) {
                Object[] rows = targets instanceof Object[] ? (Object[])targets : new Object[]{targets};
                if (rows.length > 0 && rows[0] instanceof MdiEntry) {
                    MdiEntry info = (MdiEntry)rows[0];
                    Device device = (Device)info.getDataSource();
                    menu.setEnabled(device.canRemove());
                } else {
                    menu.setEnabled(false);
                }
            }
        };
        this.remove_listener = new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                if (target instanceof MdiEntry) {
                    MdiEntry info = (MdiEntry)target;
                    Device device = (Device)info.getDataSource();
                    device.remove();
                }
            }
        };
        this.will_browse_listener = new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object targets) {
                menu.removeAllChildItems();
                boolean enabled = false;
                Object[] rows = targets instanceof Object[] ? (Object[])targets : new Object[]{targets};
                if (rows.length > 0 && rows[0] instanceof MdiEntry) {
                    MdiEntry info = (MdiEntry)rows[0];
                    Device device = (Device)info.getDataSource();
                    Device.browseLocation[] locs = device.getBrowseLocations();
                    boolean bl = enabled = locs != null && locs.length > 0;
                    if (enabled) {
                        MenuManager menuManager = DeviceManagerUI.this.ui_manager.getMenuManager();
                        Device.browseLocation[] browseLocationArray = locs;
                        int n = locs.length;
                        int n2 = 0;
                        while (n2 < n) {
                            final Device.browseLocation loc = browseLocationArray[n2];
                            com.biglybt.pif.ui.menus.MenuItem loc_menu = menuManager.addMenuItem(menu, loc.getName());
                            loc_menu.addListener(new MenuItemListener(){

                                @Override
                                public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                                    Utils.launch(loc.getURL().toExternalForm());
                                }
                            });
                            ++n2;
                        }
                    }
                }
                menu.setEnabled(enabled);
            }
        };
        this.show_listener = new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                if (target instanceof MdiEntry) {
                    MdiEntry info = (MdiEntry)target;
                    Object ds = info.getDataSource();
                    if (ds instanceof Device) {
                        Device device = (Device)ds;
                        device.setHidden(true);
                    } else {
                        Device[] devices;
                        int category_type = ds instanceof Integer ? (Integer)ds : 0;
                        Device[] deviceArray = devices = DeviceManagerUI.this.device_manager.getDevices();
                        int n = devices.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Device device = deviceArray[n2];
                            if (category_type == 0 || device.getType() == category_type && device.isHidden()) {
                                device.setHidden(false);
                            }
                            ++n2;
                        }
                    }
                }
            }
        };
        this.show_fill_listener = new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object targets) {
                boolean enabled = false;
                Object[] rows = targets instanceof Object[] ? (Object[])targets : new Object[]{targets};
                Object[] objectArray = rows;
                int n = rows.length;
                int n2 = 0;
                while (n2 < n) {
                    MdiEntry info;
                    Object ds;
                    Object row = objectArray[n2];
                    if (row instanceof MdiEntry && !((ds = (info = (MdiEntry)row).getDataSource()) instanceof Device)) {
                        Device[] devices;
                        int category_type = ds instanceof Number ? ((Number)ds).intValue() : 0;
                        Device[] deviceArray = devices = DeviceManagerUI.this.device_manager.getDevices();
                        int n3 = devices.length;
                        int n4 = 0;
                        while (n4 < n3) {
                            Device device = deviceArray[n4];
                            if ((category_type == 0 || device.getType() == category_type && device.isHidden()) && device.isHidden()) {
                                enabled = true;
                            }
                            ++n4;
                        }
                    }
                    ++n2;
                }
                menu.setEnabled(enabled);
            }
        };
    }

    private void export(final Device device) {
        Utils.execSWTThread(new AERunnable(){

            @Override
            public void runSupport() {
                FileDialog dialog = new FileDialog(Utils.findAnyShell(), 139264);
                dialog.setFilterPath(TorrentOpener.getFilterPathData());
                dialog.setText(MessageText.getString("device.export.select.template.file"));
                dialog.setFilterExtensions(VuzeFileHandler.getVuzeFileFilterExtensions());
                dialog.setFilterNames(VuzeFileHandler.getVuzeFileFilterExtensions());
                String path = TorrentOpener.setFilterPathData(dialog.open());
                if (path != null) {
                    if (!VuzeFileHandler.isAcceptedVuzeFileName(path)) {
                        path = VuzeFileHandler.getVuzeFileName(path);
                    }
                    try {
                        VuzeFile vf = device.getVuzeFile();
                        vf.write(new File(path));
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                    }
                }
            }
        });
    }

    protected void setupListeners() {
        this.parameterListener = new ParameterListener(){

            @Override
            public void parameterChanged(String parameterName) {
                DeviceManagerUI.this.side_bar_view_type = COConfigurationManager.getIntParameter(DeviceManagerUI.CONFIG_VIEW_TYPE, 0);
                DeviceManagerUI.this.side_bar_hide_rend_gen = COConfigurationManager.getBooleanParameter(DeviceManagerUI.CONFIG_VIEW_HIDE_REND_GENERIC, true);
                DeviceManagerUI.this.side_bar_show_tagged = COConfigurationManager.getBooleanParameter(DeviceManagerUI.CONFIG_VIEW_SHOW_ONLY_TAGGED, false);
                DeviceManagerUI.this.rebuildSideBarIfExists();
            }
        };
        COConfigurationManager.addWeakParameterListener(this.parameterListener, true, CONFIG_VIEW_TYPE, CONFIG_VIEW_HIDE_REND_GENERIC, CONFIG_VIEW_SHOW_ONLY_TAGGED);
    }

    protected static void hideIcon(MdiEntryVitalityImage x) {
        if (x == null) {
            return;
        }
        x.setVisible(false);
        x.setToolTip("");
    }

    protected static void showIcon(MdiEntryVitalityImage x, String t) {
        if (x == null) {
            return;
        }
        x.setToolTip(t);
        x.setVisible(true);
    }

    protected void rebuildSideBarIfExists() {
        MdiEntry entry;
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi != null && (entry = mdi.getEntry("header.devices")) != null) {
            this.rebuildSideBar();
        }
    }

    protected void rebuildSideBar() {
        if (this.sidebar_built) {
            this.removeAllDevices();
            this.buildSideBar(true);
        } else {
            this.buildSideBar(false);
        }
        this.addAllDevices();
    }

    private String getHeaderToolTip() {
        if (this.side_bar_hide_rend_gen || this.side_bar_show_tagged) {
            Device[] devices = this.device_manager.getDevices();
            int generic = 0;
            int untagged = 0;
            Device[] deviceArray = devices;
            int n = devices.length;
            int n2 = 0;
            while (n2 < n) {
                Device device = deviceArray[n2];
                if (!device.isHidden() && device.getType() == 3) {
                    DeviceMediaRenderer rend = (DeviceMediaRenderer)device;
                    if (rend.isNonSimple()) {
                        ++generic;
                    }
                    if (!rend.isTagged()) {
                        ++untagged;
                    }
                }
                ++n2;
            }
            if (!this.side_bar_show_tagged) {
                untagged = 0;
            }
            if (generic > 0 || untagged > 0) {
                return MessageText.getString("devices.sidebar.mainheader.tooltip", new String[]{String.valueOf(generic + untagged)});
            }
        }
        return null;
    }

    protected MdiEntry buildSideBar(boolean rebuild) {
        MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
        if (mdi == null) {
            return null;
        }
        if (this.entryHeader == null) {
            this.entryHeader = mdi.getEntry("header.devices");
            if (this.entryHeader != null) {
                this.setupHeader(mdi, this.entryHeader);
            }
        }
        if (!DISABLED_TRANSCODING) {
            this.mdiEntryOverview = mdi.getEntry(CONFIG_SECTION_ID);
            if (this.mdiEntryOverview == null) {
                this.mdiEntryOverview = mdi.createEntryFromSkinRef("header.devices", CONFIG_SECTION_ID, "devicesview", MessageText.getString("mdi.entry.about.devices"), new ViewTitleInfo(){

                    @Override
                    public Object getTitleInfoProperty(int propertyID) {
                        if (propertyID == 1) {
                            return DeviceManagerUI.this.getHeaderToolTip();
                        }
                        if (propertyID == 0 && DeviceManagerUI.this.last_job_count > 0) {
                            return String.valueOf(DeviceManagerUI.this.last_job_count);
                        }
                        return null;
                    }
                }, null, false, "");
                this.mdiEntryOverview.setImageLeftID("image.sidebar.aboutdevices");
            }
        }
        if (mdi.getEntry("header.devices") == null) {
            DeviceManagerUI.registerDiskOps(mdi, "header.transfers", true);
        } else {
            DeviceManagerUI.registerDiskOps(mdi, "header.devices", false);
            mdi.loadEntryByID("DiskOps", false);
        }
        if (rebuild) {
            for (categoryView category : this.categories) {
                category.destroy();
            }
        }
        this.categories.clear();
        this.buildCategories(this.side_bar_view_type == Integer.MAX_VALUE);
        this.sidebar_built = true;
        return this.mdiEntryOverview;
    }

    public static void registerDiskOps(final MultipleDocumentInterface mdi, final String parent, final boolean closeable) {
        if (mdi.getEntry("DiskOps") == null) {
            mdi.registerEntry("DiskOps", new MdiEntryCreationListener(){

                @Override
                public MdiEntry createMDiEntry(String id) {
                    final MdiEntry mdiEntryDiskOps = mdi.createEntryFromSkinRef(parent, "DiskOps", "diskopsview", MessageText.getString("mdi.entry.about.diskops"), new ViewTitleInfo(){

                        @Override
                        public Object getTitleInfoProperty(int propertyID) {
                            return null;
                        }
                    }, null, closeable, DeviceManagerUI.CONFIG_SECTION_ID);
                    mdiEntryDiskOps.setImageLeftID("image.sidebar.aboutdiskops");
                    final Core core = CoreFactory.getSingleton();
                    final ViewTitleInfo viewTitleInfo = new ViewTitleInfo(){

                        @Override
                        public Object getTitleInfoProperty(int pid) {
                            int ops;
                            if (pid == 0 && (ops = core.getOperations().size()) > 0) {
                                return "" + ops;
                            }
                            return null;
                        }
                    };
                    mdiEntryDiskOps.setViewTitleInfo(viewTitleInfo);
                    CoreOperationListener opListener = new CoreOperationListener(){
                        FrequencyLimitedDispatcher disp = new FrequencyLimitedDispatcher(AERunnable.create(() -> {
                            ViewTitleInfoManager.refreshTitleInfo(viewTitleInfo2);
                            mdiEntry.redraw();
                        }), 1000);

                        @Override
                        public void operationRemoved(CoreOperation operation) {
                            this.disp.dispatch();
                        }

                        @Override
                        public boolean operationExecuteRequest(CoreOperation operation) {
                            return false;
                        }

                        @Override
                        public void operationAdded(CoreOperation operation) {
                            this.disp.dispatch();
                        }
                    };
                    core.addOperationListener(opListener);
                    mdiEntryDiskOps.addListener((ev, u) -> core.removeOperationListener(opListener));
                    return mdiEntryDiskOps;
                }
            });
        }
    }

    private void buildCategories(boolean full) {
        if (full) {
            MenuManager menu_manager = this.ui_manager.getMenuManager();
            categoryView renderers_category = this.addDeviceCategory(3, "device.renderer.view.title", "image.sidebar.device.renderer");
            this.categories.add(renderers_category);
            com.biglybt.pif.ui.menus.MenuItem re_menu_item = menu_manager.addMenuItem("sidebar." + renderers_category.getKey(), "device.show");
            re_menu_item.setDisposeWithUIDetach("swt");
            re_menu_item.addListener(this.show_listener);
            re_menu_item.addFillListener(this.show_fill_listener);
            re_menu_item = menu_manager.addMenuItem("sidebar." + renderers_category.getKey(), "sep_re");
            re_menu_item.setDisposeWithUIDetach("swt");
            re_menu_item.setStyle(4);
            re_menu_item = menu_manager.addMenuItem("sidebar." + renderers_category.getKey(), "device.renderer.remove_all");
            re_menu_item.setDisposeWithUIDetach("swt");
            re_menu_item.addListener(new MenuItemListener(){

                @Override
                public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                    new AEThread2("doit"){

                        @Override
                        public void run() {
                            UIManager ui_manager = StaticUtilities.getUIManager(120000L);
                            long res = ui_manager.showMessageBox("device.mediaserver.remove_all.title", "device.renderer.remove_all.desc", 12L);
                            if (res == 4L) {
                                Device[] devices;
                                Device[] deviceArray = devices = DeviceManagerUI.this.device_manager.getDevices();
                                int n = devices.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Device d = deviceArray[n2];
                                    if (d.getType() == 3 && d.canRemove()) {
                                        d.remove();
                                    }
                                    ++n2;
                                }
                            }
                        }
                    }.start();
                }
            });
            categoryView media_servers_category = this.addDeviceCategory(2, "device.mediaserver.view.title", "image.sidebar.device.mediaserver");
            this.categories.add(media_servers_category);
            com.biglybt.pif.ui.menus.MenuItem ms_menu_item = menu_manager.addMenuItem("sidebar." + media_servers_category.getKey(), "device.show");
            ms_menu_item.setDisposeWithUIDetach("swt");
            ms_menu_item.addListener(this.show_listener);
            ms_menu_item.addFillListener(this.show_fill_listener);
            ms_menu_item = menu_manager.addMenuItem("sidebar." + media_servers_category.getKey(), "device.mediaserver.configure");
            ms_menu_item.setDisposeWithUIDetach("swt");
            ms_menu_item.addListener(new MenuItemListener(){

                @Override
                public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                    if (uif != null) {
                        uif.getMDI().showEntryByID("ConfigView", "upnpmediaserver.name");
                    }
                }
            });
            ms_menu_item = menu_manager.addMenuItem("sidebar." + media_servers_category.getKey(), "sep_ms");
            ms_menu_item.setDisposeWithUIDetach("swt");
            ms_menu_item.setStyle(4);
            ms_menu_item = menu_manager.addMenuItem("sidebar." + media_servers_category.getKey(), "device.mediaserver.remove_all");
            ms_menu_item.setDisposeWithUIDetach("swt");
            ms_menu_item.addListener(new MenuItemListener(){

                @Override
                public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                    new AEThread2("doit"){

                        @Override
                        public void run() {
                            UIManager ui_manager = StaticUtilities.getUIManager(120000L);
                            long res = ui_manager.showMessageBox("device.mediaserver.remove_all.title", "device.mediaserver.remove_all.desc", 12L);
                            if (res == 4L) {
                                Device[] devices;
                                Device[] deviceArray = devices = DeviceManagerUI.this.device_manager.getDevices();
                                int n = devices.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Device d = deviceArray[n2];
                                    if (d.getType() == 2 && d.canRemove()) {
                                        d.remove();
                                    }
                                    ++n2;
                                }
                            }
                        }
                    }.start();
                }
            });
            categoryView routers_category = this.addDeviceCategory(1, "device.router.view.title", "image.sidebar.device.router");
            this.categories.add(routers_category);
            com.biglybt.pif.ui.menus.MenuItem rt_menu_item = menu_manager.addMenuItem("sidebar." + routers_category.getKey(), "device.show");
            rt_menu_item.setDisposeWithUIDetach("swt");
            rt_menu_item.addListener(this.show_listener);
            rt_menu_item.addFillListener(this.show_fill_listener);
            rt_menu_item = menu_manager.addMenuItem("sidebar." + routers_category.getKey(), "device.router.configure");
            rt_menu_item.setDisposeWithUIDetach("swt");
            rt_menu_item.addListener(new MenuItemListener(){

                @Override
                public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                    if (uif != null) {
                        uif.getMDI().showEntryByID("ConfigView", "UPnP");
                    }
                }
            });
            rt_menu_item = menu_manager.addMenuItem("sidebar." + routers_category.getKey(), "sep_rou");
            rt_menu_item.setDisposeWithUIDetach("swt");
            rt_menu_item.setStyle(4);
            rt_menu_item = menu_manager.addMenuItem("sidebar." + routers_category.getKey(), "device.router.remove_all");
            rt_menu_item.setDisposeWithUIDetach("swt");
            rt_menu_item.addListener(new MenuItemListener(){

                @Override
                public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                    new AEThread2("doit"){

                        @Override
                        public void run() {
                            UIManager ui_manager = StaticUtilities.getUIManager(120000L);
                            long res = ui_manager.showMessageBox("device.mediaserver.remove_all.title", "device.router.remove_all.desc", 12L);
                            if (res == 4L) {
                                Device[] devices;
                                Device[] deviceArray = devices = DeviceManagerUI.this.device_manager.getDevices();
                                int n = devices.length;
                                int n2 = 0;
                                while (n2 < n) {
                                    Device d = deviceArray[n2];
                                    if (d.getType() == 1 && d.canRemove()) {
                                        d.remove();
                                    }
                                    ++n2;
                                }
                            }
                        }
                    }.start();
                }
            });
        }
        categoryView internet_category = this.addDeviceCategory(4, "MainWindow.about.section.internet", "image.sidebar.device.internet");
        this.categories.add(internet_category);
    }

    private void setupHeader(MultipleDocumentInterface mdi, final MdiEntry entryHeader) {
        this.addDefaultDropListener(entryHeader);
        entryHeader.setViewTitleInfo(new ViewTitleInfo(){
            private int last_indicator = 0;
            MdiEntryVitalityImage spinner;
            MdiEntryVitalityImage warning;
            MdiEntryVitalityImage info;
            {
                this.spinner = mdiEntry.addVitalityImage(DeviceManagerUI.SPINNER_IMAGE_ID);
                this.warning = mdiEntry.addVitalityImage(DeviceManagerUI.ALERT_IMAGE_ID);
                this.info = mdiEntry.addVitalityImage(DeviceManagerUI.INFO_IMAGE_ID);
                DeviceManagerUI.hideIcon(this.spinner);
                DeviceManagerUI.hideIcon(this.warning);
                DeviceManagerUI.hideIcon(this.info);
            }

            @Override
            public Object getTitleInfoProperty(int propertyID) {
                boolean expanded = entryHeader.isExpanded();
                if (propertyID == 0) {
                    this.spinner.setVisible(!expanded && DeviceManagerUI.this.device_manager.isBusy(0));
                    if (!expanded) {
                        Device[] devices = DeviceManagerUI.this.device_manager.getDevices();
                        this.last_indicator = 0;
                        String all_errors = "";
                        String all_infos = "";
                        Device[] deviceArray = devices;
                        int n = devices.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String info;
                            Device device = deviceArray[n2];
                            String error = device.getError();
                            if (error != null) {
                                all_errors = String.valueOf(all_errors) + (all_errors.length() == 0 ? "" : "; ") + error;
                            }
                            if ((info = device.getInfo()) != null) {
                                all_infos = String.valueOf(all_infos) + (all_infos.length() == 0 ? "" : "; ") + info;
                            }
                            if (device instanceof DeviceMediaRenderer) {
                                // empty if block
                            }
                            ++n2;
                        }
                        if (all_errors.length() > 0) {
                            DeviceManagerUI.hideIcon(this.info);
                            DeviceManagerUI.showIcon(this.warning, all_errors);
                        } else {
                            DeviceManagerUI.hideIcon(this.warning);
                            if (all_infos.length() > 0) {
                                DeviceManagerUI.showIcon(this.info, all_infos);
                            } else {
                                DeviceManagerUI.hideIcon(this.info);
                            }
                        }
                        if (this.last_indicator > 0) {
                            return String.valueOf(this.last_indicator);
                        }
                    } else {
                        DeviceManagerUI.hideIcon(this.warning);
                        DeviceManagerUI.hideIcon(this.info);
                    }
                } else if (propertyID != 8 && propertyID == 1) {
                    return DeviceManagerUI.this.getHeaderToolTip();
                }
                return null;
            }
        });
        if (!DISABLED_TRANSCODING) {
            this.deviceManagerListener = new DeviceManagerListener(){

                @Override
                public void deviceRemoved(Device device) {
                }

                @Override
                public void deviceManagerLoaded() {
                    MdiEntryVitalityImage turnon;
                    DeviceManagerUI.this.device_manager.removeListener(this);
                    if (entryHeader == null || entryHeader.isEntryDisposed()) {
                        return;
                    }
                    PluginManager pm = CoreFactory.getSingleton().getPluginManager();
                    PluginInterface pi = pm.getPluginInterfaceByID("vuzexcode");
                    if ((DeviceManagerUI.this.device_manager.getTranscodeManager().getProviders().length == 0 || pi == null) && (turnon = entryHeader.addVitalityImage("image.sidebar.turnon")) != null) {
                        turnon.addListener(new MdiEntryVitalityImageListener(){

                            @Override
                            public void mdiEntryVitalityImage_clicked(int x, int y) {
                                DevicesFTUX.ensureInstalled(null);
                            }
                        });
                        DeviceManagerUI.this.transcodeManagerListener = new TranscodeManagerListener(){

                            @Override
                            public void providerAdded(TranscodeProvider provider) {
                                turnon.setVisible(false);
                            }

                            @Override
                            public void providerUpdated(TranscodeProvider provider) {
                            }

                            @Override
                            public void providerRemoved(TranscodeProvider provider) {
                            }
                        };
                        DeviceManagerUI.this.device_manager.getTranscodeManager().addListener(DeviceManagerUI.this.transcodeManagerListener);
                    }
                }

                @Override
                public void deviceChanged(Device device) {
                }

                @Override
                public void deviceAttentionRequest(Device device) {
                }

                @Override
                public void deviceAdded(Device device) {
                }
            };
            this.device_manager.addListener(this.deviceManagerListener);
        }
        entryHeader.addListener(new MdiCloseListener(){

            @Override
            public void mdiEntryClosed(MdiEntry entry, boolean userClosed) {
                if (DeviceManagerUI.this.device_manager != null) {
                    DeviceManagerUI.this.device_manager.removeListener(DeviceManagerUI.this.deviceManagerListener);
                    if (DeviceManagerUI.this.transcodeManagerListener != null) {
                        DeviceManagerUI.this.device_manager.getTranscodeManager().removeListener(DeviceManagerUI.this.transcodeManagerListener);
                    }
                }
            }
        });
        MenuManager menu_manager = this.ui_manager.getMenuManager();
        this.createOverallMenu(menu_manager, "sidebar.header.devices");
        this.createOverallMenu(menu_manager, "sidebar.Devices");
    }

    private void createOverallMenu(final MenuManager menu_manager, String parentID) {
        com.biglybt.pif.ui.menus.MenuItem de_menu_item = menu_manager.addMenuItem(parentID, "device.search");
        de_menu_item.setDisposeWithUIDetach("swt");
        de_menu_item.addListener(new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                DeviceManagerUI.this.search();
            }
        });
        de_menu_item = menu_manager.addMenuItem(parentID, "device.showGeneric");
        de_menu_item.setDisposeWithUIDetach("swt");
        de_menu_item.setStyle(2);
        de_menu_item.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                boolean is_hidden = COConfigurationManager.getBooleanParameter(DeviceManagerUI.CONFIG_VIEW_HIDE_REND_GENERIC, true);
                menu.setData(!is_hidden);
                boolean enabled = false;
                if (is_hidden) {
                    Device[] devices;
                    Device[] deviceArray = devices = DeviceManagerUI.this.device_manager.getDevices();
                    int n = devices.length;
                    int n2 = 0;
                    while (n2 < n) {
                        DeviceMediaRenderer rend;
                        Device d = deviceArray[n2];
                        if (!d.isHidden() && d instanceof DeviceMediaRenderer && (rend = (DeviceMediaRenderer)d).isNonSimple()) {
                            enabled = true;
                        }
                        ++n2;
                    }
                } else {
                    enabled = true;
                }
                menu.setEnabled(enabled);
            }
        });
        de_menu_item.addListener(new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                COConfigurationManager.setParameter(DeviceManagerUI.CONFIG_VIEW_HIDE_REND_GENERIC, !COConfigurationManager.getBooleanParameter(DeviceManagerUI.CONFIG_VIEW_HIDE_REND_GENERIC, true));
            }
        });
        de_menu_item = menu_manager.addMenuItem(parentID, "device.onlyShowTagged");
        de_menu_item.setDisposeWithUIDetach("swt");
        de_menu_item.setStyle(2);
        de_menu_item.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                menu.setData(COConfigurationManager.getBooleanParameter(DeviceManagerUI.CONFIG_VIEW_SHOW_ONLY_TAGGED, false));
                Device[] devices = DeviceManagerUI.this.device_manager.getDevices();
                boolean has_tagged = false;
                Device[] deviceArray = devices;
                int n = devices.length;
                int n2 = 0;
                while (n2 < n) {
                    Device d = deviceArray[n2];
                    if (d.isTagged()) {
                        has_tagged = true;
                        break;
                    }
                    ++n2;
                }
                menu.setEnabled(has_tagged);
            }
        });
        de_menu_item.addListener(new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                COConfigurationManager.setParameter(DeviceManagerUI.CONFIG_VIEW_SHOW_ONLY_TAGGED, !COConfigurationManager.getBooleanParameter(DeviceManagerUI.CONFIG_VIEW_SHOW_ONLY_TAGGED, false));
            }
        });
        de_menu_item = menu_manager.addMenuItem(parentID, "device.show");
        de_menu_item.setDisposeWithUIDetach("swt");
        de_menu_item.addListener(this.show_listener);
        de_menu_item.addFillListener(this.show_fill_listener);
        de_menu_item = menu_manager.addMenuItem(parentID, "devices.sidebar.simple");
        de_menu_item.setDisposeWithUIDetach("swt");
        de_menu_item.setStyle(2);
        de_menu_item.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                menu.setData(COConfigurationManager.getIntParameter(DeviceManagerUI.CONFIG_VIEW_TYPE, 0) == 0);
            }
        });
        de_menu_item.addListener(new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                COConfigurationManager.setParameter(DeviceManagerUI.CONFIG_VIEW_TYPE, (Boolean)menu.getData() != false ? 0 : Integer.MAX_VALUE);
            }
        });
        de_menu_item = menu_manager.addMenuItem(parentID, "sep");
        de_menu_item.setDisposeWithUIDetach("swt");
        de_menu_item.setStyle(4);
        final com.biglybt.pif.ui.menus.MenuItem de_oxc_menu = menu_manager.addMenuItem(parentID, "devices.sidebar.onxcodecomplete");
        de_oxc_menu.setDisposeWithUIDetach("swt");
        de_oxc_menu.setStyle(5);
        de_oxc_menu.addFillListener(new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                menu.removeAllChildItems();
                ArrayList<com.biglybt.pif.ui.menus.MenuItem> oxc_items = new ArrayList<com.biglybt.pif.ui.menus.MenuItem>();
                final com.biglybt.pif.ui.menus.MenuItem oxc_nothing = menu_manager.addMenuItem(de_oxc_menu, "devices.sidebar.oxc.nothing");
                oxc_items.add(oxc_nothing);
                oxc_nothing.setStyle(2);
                oxc_nothing.setData(DeviceManagerUI.this.oxc_action == DeviceManagerUI.OXC_NOTHING);
                final com.biglybt.pif.ui.menus.MenuItem oxc_close_vuze = menu_manager.addMenuItem(de_oxc_menu, "devices.sidebar.oxc.closevuze");
                oxc_items.add(oxc_close_vuze);
                oxc_close_vuze.setStyle(2);
                oxc_close_vuze.setData(DeviceManagerUI.this.oxc_action == DeviceManagerUI.OXC_QUIT_VUZE);
                PlatformManager pm = PlatformManagerFactory.getPlatformManager();
                int sdt = pm.getShutdownTypes();
                final HashMap<com.biglybt.pif.ui.menus.MenuItem, String> oxc_pm_map = new HashMap<com.biglybt.pif.ui.menus.MenuItem, String>();
                int[] nArray = PlatformManager.SD_ALL;
                int n = PlatformManager.SD_ALL.length;
                int n2 = 0;
                while (n2 < n) {
                    int type = nArray[n2];
                    if ((sdt | type) != 0) {
                        String action = DeviceManagerUI.OXC_NOTHING;
                        if (type == 4) {
                            action = DeviceManagerUI.OXC_SLEEP;
                        } else if (type == 2) {
                            action = DeviceManagerUI.OXC_HIBERNATE;
                        } else if (type == 1) {
                            action = DeviceManagerUI.OXC_SHUTDOWN;
                        } else {
                            Debug.out("Unknown type: " + type);
                        }
                        com.biglybt.pif.ui.menus.MenuItem oxc_pm = menu_manager.addMenuItem(de_oxc_menu, "devices.sidebar.oxc.pm." + type);
                        oxc_items.add(oxc_pm);
                        oxc_pm.setStyle(2);
                        oxc_pm.setData(DeviceManagerUI.this.oxc_action == action);
                        oxc_pm_map.put(oxc_pm, action);
                    }
                    ++n2;
                }
                MenuItemListener oxc_mil = new MenuItemListener(){

                    @Override
                    public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                        if (((Boolean)menu.getData()).booleanValue()) {
                            if (menu == oxc_nothing) {
                                DeviceManagerUI.this.setOXCState(DeviceManagerUI.OXC_NOTHING);
                            } else if (menu == oxc_close_vuze) {
                                DeviceManagerUI.this.setOXCState(DeviceManagerUI.OXC_QUIT_VUZE);
                            } else {
                                DeviceManagerUI.this.setOXCState((String)oxc_pm_map.get(menu));
                            }
                        }
                    }
                };
                for (com.biglybt.pif.ui.menus.MenuItem mi : oxc_items) {
                    mi.addListener(oxc_mil);
                }
            }
        });
        de_menu_item = menu_manager.addMenuItem(parentID, "sep2");
        de_menu_item.setDisposeWithUIDetach("swt");
        de_menu_item.setStyle(4);
        de_menu_item = menu_manager.addMenuItem(parentID, "menu.device.options");
        de_menu_item.setDisposeWithUIDetach("swt");
        de_menu_item.addListener(new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                UIFunctions uif = UIFunctionsManager.getUIFunctions();
                if (uif != null) {
                    uif.getMDI().showEntryByID("ConfigView", DeviceManagerUI.CONFIG_SECTION_ID);
                }
            }
        });
        if (Constants.isCVSVersion()) {
            de_menu_item = menu_manager.addMenuItem(parentID, "!(CVS Only)Show FTUX!");
            de_menu_item.setDisposeWithUIDetach("swt");
            de_menu_item.addListener(new MenuItemListener(){

                @Override
                public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                    DevicesFTUX.showForDebug();
                }
            });
        }
    }

    protected void addNewDevice() {
        ManufacturerChooser mfChooser = new ManufacturerChooser();
        mfChooser.open(new ManufacturerChooser.ClosedListener(){

            @Override
            public void MfChooserClosed(DeviceManager.DeviceManufacturer mf) {
                if (mf == null) {
                    return;
                }
                DeviceTemplateChooser deviceTemplateChooser = new DeviceTemplateChooser(mf);
                deviceTemplateChooser.open(new DeviceTemplateChooser.DeviceTemplateClosedListener(){

                    @Override
                    public void deviceTemplateChooserClosed(DeviceTemplate deviceTemplate) {
                        if (deviceTemplate == null) {
                            return;
                        }
                        try {
                            Device device = deviceTemplate.createInstance(String.valueOf(deviceTemplate.getName()) + " test!");
                            device.requestAttention();
                        }
                        catch (DeviceManagerException e) {
                            Debug.out(e);
                        }
                    }
                });
            }
        });
    }

    private void setOXCState(String new_action) {
        this.oxc_action = new_action;
        this.checkOXCState();
    }

    private void checkOXCState() {
        if (this.oxc_action == OXC_NOTHING) {
            this.oxc_trigger_set = false;
            return;
        }
        int jobs = this.device_manager.getTranscodeManager().getQueue().getJobCount();
        if (jobs > 0) {
            this.oxc_trigger_set = true;
        } else if (this.oxc_trigger_set) {
            this.oxc_trigger_set = false;
            CoreFactory.getSingleton().executeCloseAction(this.oxc_action, MessageText.getString("core.shutdown.xcode"));
        }
    }

    private void setupTranscodeMenus() {
        if (DISABLED_TRANSCODING) {
            return;
        }
        String[] tables = new String[]{"MyTorrents", "MyTorrents.big", "MySeeders", "MySeeders.big", "Files", "Unopened", "Unopened.big", "MyLibrary.big", "MyLibrary.small"};
        TableManager table_manager = this.plugin_interface.getUIManager().getTableManager();
        MenuItemFillListener menu_fill_listener = new MenuItemFillListener(){

            @Override
            public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object _target) {
                final TableRow[] target = _target instanceof TableRow ? new TableRow[]{(TableRow)_target} : (TableRow[])_target;
                boolean enabled = target.length > 0;
                TableRow[] tableRowArray = target;
                int n = target.length;
                int n2 = 0;
                while (n2 < n) {
                    TableRow row = tableRowArray[n2];
                    Object obj = row.getDataSource();
                    if (obj instanceof Download) {
                        Download download = (Download)obj;
                        if (download.getState() == 8) {
                            enabled = false;
                        }
                    } else if (obj instanceof DiskManagerFileInfo) {
                        DiskManagerFileInfo file = (DiskManagerFileInfo)obj;
                        try {
                            if (file.getIndex() < 0 || file.getDownload().getState() == 8) {
                                enabled = false;
                            }
                        }
                        catch (Throwable e) {
                            enabled = false;
                        }
                    }
                    ++n2;
                }
                menu.setEnabled(enabled);
                menu.removeAllChildItems();
                if (enabled) {
                    Device[] devices = DeviceManagerUI.this.device_manager.getDevices();
                    int devices_added = 0;
                    Device[] deviceArray = devices;
                    int n3 = devices.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Device device = deviceArray[n4];
                        if (!device.isHidden() && device instanceof TranscodeTarget) {
                            ++devices_added;
                            final TranscodeTarget renderer = (TranscodeTarget)((Object)device);
                            TranscodeProfile[] profiles = renderer.getTranscodeProfiles();
                            TableContextMenuItem device_item = DeviceManagerUI.this.plugin_interface.getUIManager().getTableManager().addContextMenuItem((TableContextMenuItem)menu, "!" + device.getName() + (profiles.length == 0 ? " (No Profiles)" : "") + "!");
                            device_item.setStyle(5);
                            if (profiles.length == 0) {
                                device_item.setEnabled(false);
                            } else {
                                Arrays.sort(profiles, new Comparator<TranscodeProfile>(){

                                    @Override
                                    public int compare(TranscodeProfile o1, TranscodeProfile o2) {
                                        int i2;
                                        int i1 = o1.getIconIndex();
                                        if (i1 == (i2 = o2.getIconIndex())) {
                                            return o1.getName().compareToIgnoreCase(o2.getName());
                                        }
                                        return i1 - i2;
                                    }
                                });
                                TranscodeProfile[] transcodeProfileArray = profiles;
                                int n5 = profiles.length;
                                int n6 = 0;
                                while (n6 < n5) {
                                    final TranscodeProfile profile = transcodeProfileArray[n6];
                                    TableContextMenuItem profile_item = DeviceManagerUI.this.plugin_interface.getUIManager().getTableManager().addContextMenuItem(device_item, "!" + profile.getName() + "!");
                                    profile_item.addMultiListener(new MenuItemListener(){

                                        @Override
                                        public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object x) {
                                            TableRow[] tableRowArray = target;
                                            int n = target.length;
                                            int n2 = 0;
                                            while (n2 < n) {
                                                TableRow row = tableRowArray[n2];
                                                Object obj = row.getDataSource();
                                                try {
                                                    if (obj instanceof Download) {
                                                        Download download = (Download)obj;
                                                        DeviceManagerUI.addDownload(renderer, profile, -1, download);
                                                    } else {
                                                        DiskManagerFileInfo file = (DiskManagerFileInfo)obj;
                                                        DeviceManagerUI.addFile(renderer, profile, -1, file);
                                                    }
                                                }
                                                catch (Throwable e) {
                                                    Debug.out(e);
                                                }
                                                ++n2;
                                            }
                                        }
                                    });
                                    ++n6;
                                }
                            }
                        }
                        ++n4;
                    }
                    if (devices_added == 0) {
                        TableContextMenuItem device_item = DeviceManagerUI.this.plugin_interface.getUIManager().getTableManager().addContextMenuItem((TableContextMenuItem)menu, "!(No Devices)!");
                        device_item.setEnabled(false);
                    }
                }
            }
        };
        String[] stringArray = tables;
        int n = tables.length;
        int n2 = 0;
        while (n2 < n) {
            String table = stringArray[n2];
            TableContextMenuItem menu = table_manager.addContextMenuItem(table, "devices.contextmenu.xcode");
            menu.setStyle(5);
            menu.setHeaderCategory("Content");
            menu.addFillListener(menu_fill_listener);
            menu.setDisposeWithUIDetach("swt");
            ++n2;
        }
    }

    protected void search() {
        this.device_manager.search(10000, new DeviceSearchListener(){

            @Override
            public void deviceFound(Device device) {
            }

            @Override
            public void complete() {
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addOrChangeDevice(Device device) {
        DeviceMediaRenderer rend;
        int type = device.getType();
        String parent_key = null;
        if (this.side_bar_view_type == Integer.MAX_VALUE) {
            for (categoryView view : this.categories) {
                if (view.getDeviceType() != type) continue;
                parent_key = view.getKey();
                break;
            }
        } else {
            if (type != 3 && type != 1) {
                return;
            }
            parent_key = "header.devices";
        }
        if (parent_key == null) {
            Debug.out("Unknown device type: " + device.getString());
            return;
        }
        boolean hide_device = device.isHidden();
        if (type == 3 && this.side_bar_hide_rend_gen && (rend = (DeviceMediaRenderer)device).isNonSimple()) {
            hide_device = true;
        }
        if (this.side_bar_show_tagged && !device.isTagged()) {
            hide_device = true;
        }
        if (hide_device) {
            this.removeDevice(device);
            return;
        }
        String parent = parent_key;
        DeviceManagerUI deviceManagerUI = this;
        synchronized (deviceManagerUI) {
            deviceItem existing_di = (deviceItem)device.getTransientProperty(DEVICE_IVIEW_KEY);
            if (existing_di == null) {
                if (!device.isHidden()) {
                    deviceItem new_di = new deviceItem();
                    device.setTransientProperty(DEVICE_IVIEW_KEY, new_di);
                    this.setupEntry(new_di, device, parent);
                }
            } else {
                ViewTitleInfoManager.refreshTitleInfo(existing_di.getView());
                this.setStatus(device, existing_di);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setupEntry(deviceItem new_di, final Device device, String parent) {
        DeviceManagerUI deviceManagerUI = this;
        synchronized (deviceManagerUI) {
            com.biglybt.pif.ui.menus.MenuItem menu_item;
            DeviceMediaRenderer renderer;
            MdiEntry entry;
            if (new_di.isDestroyed()) {
                return;
            }
            final DeviceView view = new DeviceView(parent, device);
            new_di.setView(view);
            String mdi_key = String.valueOf(parent) + "/" + device.getID() + ":" + this.nextSidebarID();
            int device_type = device.getType();
            if (device_type == 3) {
                entry = this.mdi.createEntryFromSkinRef(parent, mdi_key, "devicerendererview", device.getName(), view, null, false, null);
            } else {
                String old_mdi_key;
                final String builder_key = "DeviceManager::DeviceView::" + device.getID();
                UISWTViewBuilderCore builder = new UISWTViewBuilderCore(mdi_key, null, view).setParentEntryID(parent).setListenerInstantiator(new UISWTViewBuilder.UISWTViewEventListenerInstantiator(){

                    @Override
                    public boolean supportsMultipleViews() {
                        return true;
                    }

                    @Override
                    public UISWTViewEventListener createNewInstance(UISWTViewBuilder Builder2, UISWTView forView) throws Exception {
                        return view;
                    }

                    @Override
                    public String getUID() {
                        return builder_key;
                    }
                });
                ViewManagerSWT vi = ViewManagerSWT.getInstance();
                Map<String, String> map = this.builder_map;
                synchronized (map) {
                    old_mdi_key = this.builder_map.put(builder_key, mdi_key);
                }
                if (old_mdi_key != null) {
                    vi.unregisterView("Internal", old_mdi_key);
                }
                vi.registerView("Internal", builder);
                entry = this.mdi.createEntry(builder, false);
                entry.setExpanded(true);
            }
            entry.setDatasource(device);
            entry.addListener(new MdiCloseListener(){

                @Override
                public void mdiEntryClosed(MdiEntry entry, boolean userClosed) {
                    if (device != null) {
                        device.setTransientProperty(DEVICE_IVIEW_KEY, null);
                    }
                }
            });
            new_di.setMdiEntry(entry);
            this.setStatus(device, new_di);
            if (device instanceof TranscodeTarget) {
                entry.addListener(new MdiEntryDropListener(){

                    @Override
                    public boolean mdiEntryDrop(MdiEntry entry, Object payload) {
                        return DeviceManagerUI.handleDrop((TranscodeTarget)((Object)device), payload);
                    }
                });
            }
            final MenuManager menu_manager = this.ui_manager.getMenuManager();
            boolean need_sep = false;
            if (device instanceof TranscodeTarget) {
                need_sep = true;
                com.biglybt.pif.ui.menus.MenuItem explore_menu_item = menu_manager.addMenuItem("sidebar." + mdi_key, "v3.menu.device.exploreTranscodes");
                explore_menu_item.setDisposeWithUIDetach("swt");
                explore_menu_item.addListener(new MenuItemListener(){

                    @Override
                    public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                        ManagerUtils.open(((TranscodeTarget)((Object)device)).getWorkingDirectory());
                    }
                });
            }
            if (device instanceof DeviceMediaRenderer) {
                need_sep = true;
                renderer = (DeviceMediaRenderer)device;
                if (renderer.canFilterFilesView()) {
                    com.biglybt.pif.ui.menus.MenuItem filterfiles_menu_item = menu_manager.addMenuItem("sidebar." + mdi_key, "devices.xcode.only.show");
                    filterfiles_menu_item.setDisposeWithUIDetach("swt");
                    filterfiles_menu_item.setStyle(2);
                    filterfiles_menu_item.addFillListener(new MenuItemFillListener(){

                        @Override
                        public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                            menu.setData(renderer.getFilterFilesView());
                        }
                    });
                    filterfiles_menu_item.addListener(new MenuItemListener(){

                        @Override
                        public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                            renderer.setFilterFilesView((Boolean)menu.getData());
                        }
                    });
                }
                if (renderer.canShowCategories()) {
                    com.biglybt.pif.ui.menus.MenuItem showcat_menu_item = menu_manager.addMenuItem("sidebar." + mdi_key, "devices.xcode.show.cat");
                    showcat_menu_item.setDisposeWithUIDetach("swt");
                    showcat_menu_item.setStyle(2);
                    showcat_menu_item.addFillListener(new MenuItemFillListener(){

                        @Override
                        public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                            menu.setData(renderer.getShowCategories());
                        }
                    });
                    showcat_menu_item.addListener(new MenuItemListener(){

                        @Override
                        public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                            renderer.setShowCategories((Boolean)menu.getData());
                        }
                    });
                }
                if (!DISABLED_TRANSCODING) {
                    com.biglybt.pif.ui.menus.MenuItem alwayscache_menu_item = menu_manager.addMenuItem("sidebar." + mdi_key, "devices.always.cache");
                    alwayscache_menu_item.setDisposeWithUIDetach("swt");
                    alwayscache_menu_item.setStyle(2);
                    alwayscache_menu_item.addFillListener(new MenuItemFillListener(){

                        @Override
                        public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                            menu.setData(renderer.getAlwaysCacheFiles());
                        }
                    });
                    alwayscache_menu_item.addListener(new MenuItemListener(){

                        @Override
                        public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                            renderer.setAlwaysCacheFiles((Boolean)menu.getData());
                        }
                    });
                }
            }
            if (need_sep) {
                menu_item = menu_manager.addMenuItem("sidebar." + mdi_key, "1");
                menu_item.setStyle(4);
                menu_item.setDisposeWithUIDetach("swt");
            }
            need_sep = false;
            if (device instanceof DeviceMediaRenderer) {
                TranscodeProfile[] transcodeProfiles;
                com.biglybt.pif.ui.menus.MenuItem mancopy_menu_item;
                com.biglybt.pif.ui.menus.MenuItem autocopy_menu_item;
                renderer = (DeviceMediaRenderer)device;
                if (renderer.canCopyToFolder()) {
                    need_sep = true;
                    autocopy_menu_item = menu_manager.addMenuItem("sidebar." + mdi_key, "devices.xcode.autoCopy");
                    autocopy_menu_item.setDisposeWithUIDetach("swt");
                    autocopy_menu_item.setStyle(2);
                    autocopy_menu_item.addFillListener(new MenuItemFillListener(){

                        @Override
                        public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                            menu.setData(renderer.getAutoCopyToFolder());
                        }
                    });
                    autocopy_menu_item.addListener(new MenuItemListener(){

                        @Override
                        public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                            renderer.setAutoCopyToFolder((Boolean)menu.getData());
                        }
                    });
                    mancopy_menu_item = menu_manager.addMenuItem("sidebar." + mdi_key, "devices.xcode.mancopy");
                    mancopy_menu_item.setDisposeWithUIDetach("swt");
                    mancopy_menu_item.setStyle(1);
                    mancopy_menu_item.addListener(new MenuItemListener(){

                        @Override
                        public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                            try {
                                renderer.manualCopy();
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    });
                    mancopy_menu_item.addFillListener(new MenuItemFillListener(){

                        @Override
                        public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                            File target;
                            boolean enabled = false;
                            if (!renderer.getAutoCopyToFolder() && (target = renderer.getCopyToFolder()) != null && target.exists()) {
                                enabled = renderer.getCopyToFolderPending() > 0;
                            }
                            mancopy_menu_item.setEnabled(enabled);
                        }
                    });
                    com.biglybt.pif.ui.menus.MenuItem setcopyto_menu_item = menu_manager.addMenuItem("sidebar." + mdi_key, "devices.xcode.setcopyto");
                    setcopyto_menu_item.setDisposeWithUIDetach("swt");
                    setcopyto_menu_item.setStyle(1);
                    setcopyto_menu_item.addListener(new MenuItemListener(){

                        @Override
                        public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                            Shell shell = Utils.findAnyShell();
                            DirectoryDialog dd = new DirectoryDialog(shell);
                            File existing = renderer.getCopyToFolder();
                            if (existing != null) {
                                dd.setFilterPath(existing.getAbsolutePath());
                            }
                            dd.setText(MessageText.getString("devices.xcode.setcopyto.title"));
                            String path = dd.open();
                            if (path != null) {
                                renderer.setCopyToFolder(new File(path));
                            }
                        }
                    });
                }
                if (renderer.canCopyToDevice()) {
                    need_sep = true;
                    autocopy_menu_item = menu_manager.addMenuItem("sidebar." + mdi_key, "devices.xcode.autoCopy.device");
                    autocopy_menu_item.setDisposeWithUIDetach("swt");
                    autocopy_menu_item.setStyle(2);
                    autocopy_menu_item.addFillListener(new MenuItemFillListener(){

                        @Override
                        public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                            menu.setData(renderer.getAutoCopyToDevice());
                        }
                    });
                    autocopy_menu_item.addListener(new MenuItemListener(){

                        @Override
                        public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                            renderer.setAutoCopyToDevice((Boolean)menu.getData());
                        }
                    });
                    mancopy_menu_item = menu_manager.addMenuItem("sidebar." + mdi_key, "devices.xcode.mancopy");
                    mancopy_menu_item.setDisposeWithUIDetach("swt");
                    mancopy_menu_item.setStyle(1);
                    mancopy_menu_item.addListener(new MenuItemListener(){

                        @Override
                        public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                            try {
                                renderer.manualCopy();
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    });
                    mancopy_menu_item.addFillListener(new MenuItemFillListener(){

                        @Override
                        public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                            boolean enabled = false;
                            if (!renderer.getAutoCopyToDevice()) {
                                enabled = renderer.getCopyToDevicePending() > 0;
                            }
                            mancopy_menu_item.setEnabled(enabled);
                        }
                    });
                }
                if (renderer.canAutoStartDevice()) {
                    need_sep = true;
                    com.biglybt.pif.ui.menus.MenuItem autostart_menu_item = menu_manager.addMenuItem("sidebar." + mdi_key, "devices.xcode.autoStart");
                    autostart_menu_item.setDisposeWithUIDetach("swt");
                    autostart_menu_item.setStyle(2);
                    autostart_menu_item.addFillListener(new MenuItemFillListener(){

                        @Override
                        public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                            menu.setData(renderer.getAutoStartDevice());
                        }
                    });
                    autostart_menu_item.addListener(new MenuItemListener(){

                        @Override
                        public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                            renderer.setAutoStartDevice((Boolean)menu.getData());
                        }
                    });
                }
                if (renderer.canAssociate()) {
                    need_sep = true;
                    final com.biglybt.pif.ui.menus.MenuItem menu_associate = menu_manager.addMenuItem("sidebar." + mdi_key, "devices.associate");
                    menu_associate.setDisposeWithUIDetach("swt");
                    menu_associate.setStyle(5);
                    menu_associate.addFillListener(new MenuItemFillListener(){

                        @Override
                        public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                            menu_associate.removeAllChildItems();
                            if (renderer.isAlive()) {
                                InetAddress a = renderer.getAddress();
                                String address = a == null ? "" : a.getHostAddress();
                                com.biglybt.pif.ui.menus.MenuItem menu_none = menu_manager.addMenuItem(menu_associate, "!" + MessageText.getString("devices.associate.already") + ": " + address + "!");
                                menu_none.setEnabled(false);
                                menu_associate.setEnabled(true);
                            } else {
                                DeviceManager.UnassociatedDevice[] unassoc = DeviceManagerUI.this.device_manager.getUnassociatedDevices();
                                if (unassoc.length == 0) {
                                    menu_associate.setEnabled(false);
                                } else {
                                    menu_associate.setEnabled(true);
                                    DeviceManager.UnassociatedDevice[] unassociatedDeviceArray = unassoc;
                                    int n = unassoc.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        final DeviceManager.UnassociatedDevice un = unassociatedDeviceArray[n2];
                                        com.biglybt.pif.ui.menus.MenuItem menu_un = menu_manager.addMenuItem(menu_associate, "!" + un.getAddress().getHostAddress() + ": " + un.getDescription() + "!");
                                        menu_un.addListener(new MenuItemListener(){

                                            @Override
                                            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                                                renderer.associate(un);
                                            }
                                        });
                                        ++n2;
                                    }
                                }
                            }
                        }
                    });
                }
                need_sep = true;
                com.biglybt.pif.ui.menus.MenuItem menu_ra = menu_manager.addMenuItem("sidebar." + mdi_key, "menu.add.file");
                menu_ra.setDisposeWithUIDetach("swt");
                menu_ra.addListener(new MenuItemListener(){

                    @Override
                    public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                        Utils.execSWTThread(() -> {
                            FileDialog dialog = new FileDialog(Utils.findAnyShell(), 135170);
                            String filter_path = TorrentOpener.getFilterPathData();
                            dialog.setFilterPath(filter_path);
                            dialog.setText(MessageText.getString("wizard.maketorrent.choosefile"));
                            String str = dialog.open();
                            String path = TorrentOpener.setFilterPathData(str);
                            if (path != null) {
                                String[] paths;
                                String[] names = dialog.getFileNames();
                                if (names != null && names.length > 0) {
                                    filter_path = dialog.getFilterPath();
                                    paths = new String[names.length];
                                    int i = 0;
                                    while (i < names.length) {
                                        paths[i] = String.valueOf(filter_path) + File.separator + names[i];
                                        ++i;
                                    }
                                } else {
                                    paths = new String[]{path};
                                }
                                DeviceManagerUI.handleDrop(renderer, paths);
                            }
                        });
                    }
                });
                if (renderer.canRestrictAccess()) {
                    need_sep = true;
                    menu_ra = menu_manager.addMenuItem("sidebar." + mdi_key, "devices.restrict_access");
                    menu_ra.setDisposeWithUIDetach("swt");
                    menu_ra.addListener(new MenuItemListener(){

                        @Override
                        public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                            if (target instanceof MdiEntry) {
                                UISWTInputReceiver entry = (UISWTInputReceiver)DeviceManagerUI.this.swt_ui.getInputReceiver();
                                entry.setMessage("devices.restrict_access.msg");
                                entry.setPreenteredText(renderer.getAccessRestriction(), false);
                                entry.maintainWhitespace(false);
                                entry.allowEmptyInput(true);
                                entry.setLocalisedTitle(MessageText.getString("devices.restrict_access.prompt", new String[]{device.getName()}));
                                entry.prompt(new UIInputReceiverListener(){

                                    @Override
                                    public void UIInputReceiverClosed(UIInputReceiver entry) {
                                        if (!entry.hasSubmittedInput()) {
                                            return;
                                        }
                                        String input = entry.getSubmittedInput().trim();
                                        renderer.setAccessRestriction(input);
                                    }
                                });
                            }
                        }
                    });
                }
                if ((transcodeProfiles = renderer.getTranscodeProfiles()).length > 0) {
                    Arrays.sort(transcodeProfiles, new Comparator<TranscodeProfile>(){

                        @Override
                        public int compare(TranscodeProfile o1, TranscodeProfile o2) {
                            int i2;
                            int i1 = o1.getIconIndex();
                            if (i1 == (i2 = o2.getIconIndex())) {
                                return o1.getName().compareToIgnoreCase(o2.getName());
                            }
                            return i1 - i2;
                        }
                    });
                    need_sep = true;
                    com.biglybt.pif.ui.menus.MenuItem menu_default_profile = menu_manager.addMenuItem("sidebar." + mdi_key, "v3.menu.device.defaultprofile");
                    menu_default_profile.setDisposeWithUIDetach("swt");
                    menu_default_profile.setStyle(5);
                    com.biglybt.pif.ui.menus.MenuItem menu_profile_never = menu_manager.addMenuItem(menu_default_profile, "v3.menu.device.defaultprofile.never");
                    menu_profile_never.setStyle(2);
                    menu_profile_never.setData(Boolean.TRUE);
                    menu_profile_never.addListener(new MenuItemListener(){

                        @Override
                        public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                            renderer.setTranscodeRequirement((Boolean)menu.getData() != false ? 1 : 2);
                        }
                    });
                    menu_profile_never.addFillListener(new MenuItemFillListener(){

                        @Override
                        public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                            boolean never = renderer.getTranscodeRequirement() == 1;
                            menu.setData(never);
                        }
                    });
                    com.biglybt.pif.ui.menus.MenuItem menu_profile_none = menu_manager.addMenuItem(menu_default_profile, "option.askeverytime");
                    menu_profile_none.setStyle(3);
                    menu_profile_none.setData(Boolean.FALSE);
                    menu_profile_none.addListener(new MenuItemListener(){

                        @Override
                        public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                            renderer.setDefaultTranscodeProfile(null);
                        }
                    });
                    menu_profile_none.addFillListener(new MenuItemFillListener(){

                        @Override
                        public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                            if (transcodeProfiles.length <= 1) {
                                menu.setData(Boolean.FALSE);
                                menu.setEnabled(false);
                            } else {
                                TranscodeProfile profile = null;
                                try {
                                    profile = renderer.getDefaultTranscodeProfile();
                                }
                                catch (TranscodeException transcodeException) {
                                    // empty catch block
                                }
                                menu.setData(profile == null ? Boolean.TRUE : Boolean.FALSE);
                                menu.setEnabled(renderer.getTranscodeRequirement() != 1);
                            }
                        }
                    });
                    TranscodeProfile[] transcodeProfileArray = transcodeProfiles;
                    int n = transcodeProfiles.length;
                    int n2 = 0;
                    while (n2 < n) {
                        final TranscodeProfile profile = transcodeProfileArray[n2];
                        com.biglybt.pif.ui.menus.MenuItem menuItem = menu_manager.addMenuItem(menu_default_profile, "!" + profile.getName() + "!");
                        menuItem.setStyle(3);
                        menuItem.setData(Boolean.FALSE);
                        menuItem.addListener(new MenuItemListener(){

                            @Override
                            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                                renderer.setDefaultTranscodeProfile(profile);
                            }
                        });
                        menuItem.addFillListener(new MenuItemFillListener(){

                            @Override
                            public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                                if (transcodeProfiles.length <= 1) {
                                    menu.setData(Boolean.TRUE);
                                    menu.setEnabled(false);
                                } else {
                                    TranscodeProfile dprofile = null;
                                    try {
                                        dprofile = renderer.getDefaultTranscodeProfile();
                                    }
                                    catch (TranscodeException transcodeException) {
                                        // empty catch block
                                    }
                                    menu.setData(profile.equals(dprofile) ? Boolean.TRUE : Boolean.FALSE);
                                    menu.setEnabled(renderer.getTranscodeRequirement() != 1);
                                }
                            }
                        });
                        ++n2;
                    }
                }
                need_sep = true;
                final com.biglybt.pif.ui.menus.MenuItem rss_menu_item = menu_manager.addMenuItem("sidebar." + mdi_key, "devices.xcode.rsspub");
                rss_menu_item.setDisposeWithUIDetach("swt");
                rss_menu_item.setStyle(2);
                rss_menu_item.addFillListener(new MenuItemFillListener(){

                    @Override
                    public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                        rss_menu_item.setEnabled(DeviceManagerUI.this.device_manager.isRSSPublishEnabled());
                        menu.setData(DeviceManagerUI.this.device_manager.isRSSPublishEnabled() && renderer.isRSSPublishEnabled());
                    }
                });
                rss_menu_item.addListener(new MenuItemListener(){

                    @Override
                    public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                        renderer.setRSSPublishEnabled((Boolean)menu.getData());
                    }
                });
                rss_menu_item.setEnabled(this.device_manager.isRSSPublishEnabled());
                need_sep = true;
                com.biglybt.pif.ui.menus.MenuItem aswt_menu_item = menu_manager.addMenuItem("sidebar." + mdi_key, "devices.xcode.tagshare");
                aswt_menu_item.setDisposeWithUIDetach("swt");
                aswt_menu_item.setStyle(5);
                aswt_menu_item.addFillListener(new MenuItemFillListener(){

                    @Override
                    public void menuWillBeShown(com.biglybt.pif.ui.menus.MenuItem menu, Object data) {
                        DeviceManagerUI.addTagSubMenu(menu_manager, menu, renderer);
                    }
                });
            }
            if (device.isBrowsable()) {
                need_sep = true;
                com.biglybt.pif.ui.menus.MenuItem browse_menu_item = menu_manager.addMenuItem("sidebar." + mdi_key, "device.browse");
                browse_menu_item.setDisposeWithUIDetach("swt");
                browse_menu_item.setStyle(5);
                browse_menu_item.addFillListener(this.will_browse_listener);
            }
            if (need_sep) {
                menu_item = menu_manager.addMenuItem("sidebar." + mdi_key, "s2");
                menu_item.setDisposeWithUIDetach("swt");
                menu_item.setStyle(4);
            }
            com.biglybt.pif.ui.menus.MenuItem rename_menu_item = menu_manager.addMenuItem("sidebar." + mdi_key, "MyTorrentsView.menu.rename");
            rename_menu_item.setDisposeWithUIDetach("swt");
            rename_menu_item.addListener(this.rename_listener);
            if (device.isExportable()) {
                com.biglybt.pif.ui.menus.MenuItem export_item = menu_manager.addMenuItem("sidebar." + mdi_key, "Subscription.menu.export");
                export_item.setDisposeWithUIDetach("swt");
                export_item.addListener(this.export_listener);
            }
            com.biglybt.pif.ui.menus.MenuItem hide_menu_item = menu_manager.addMenuItem("sidebar." + mdi_key, "device.hide");
            hide_menu_item.setDisposeWithUIDetach("swt");
            hide_menu_item.addListener(this.hide_listener);
            com.biglybt.pif.ui.menus.MenuItem tag_menu_item = menu_manager.addMenuItem("sidebar." + mdi_key, "device.tag");
            tag_menu_item.setDisposeWithUIDetach("swt");
            tag_menu_item.setStyle(2);
            tag_menu_item.addFillListener(this.will_tag_listener);
            tag_menu_item.addListener(this.tag_listener);
            com.biglybt.pif.ui.menus.MenuItem remove_menu_item = menu_manager.addMenuItem("sidebar." + mdi_key, "MySharesView.menu.remove");
            remove_menu_item.setDisposeWithUIDetach("swt");
            remove_menu_item.addFillListener(this.will_remove_listener);
            remove_menu_item.addListener(this.remove_listener);
            com.biglybt.pif.ui.menus.MenuItem menu_item_sep = menu_manager.addMenuItem("sidebar." + mdi_key, "s3");
            menu_item_sep.setStyle(4);
            menu_item_sep.setDisposeWithUIDetach("swt");
            final URL wiki_url = device.getWikiURL();
            if (wiki_url != null) {
                com.biglybt.pif.ui.menus.MenuItem wiki_menu_item = menu_manager.addMenuItem("sidebar." + mdi_key, "device.wiki");
                wiki_menu_item.setDisposeWithUIDetach("swt");
                wiki_menu_item.addListener(new MenuItemListener(){

                    @Override
                    public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                        Utils.launch(wiki_url.toExternalForm());
                    }
                });
            }
            com.biglybt.pif.ui.menus.MenuItem menu_item2 = menu_manager.addMenuItem("sidebar." + mdi_key, "Subscription.menu.properties");
            menu_item2.setDisposeWithUIDetach("swt");
            menu_item2.addListener(this.properties_listener);
        }
    }

    protected static String[] getDeviceImageIDs(Device device) {
        String classification;
        List<String> imageIDs = device.getImageIDs();
        if (!imageIDs.isEmpty()) {
            return imageIDs.toArray(new String[imageIDs.size()]);
        }
        if (!(device instanceof DeviceMediaRenderer)) {
            return new String[]{"6"};
        }
        int species = ((DeviceMediaRenderer)device).getRendererSpecies();
        String id = species != 6 ? String.valueOf(species) : ((classification = device.getClassification()).equals("sony.PSP") ? "psp" : (classification.startsWith("tivo.") ? "tivo" : (classification.startsWith("samsung.") ? "samsung" : (classification.startsWith("western.digital.") ? "wdtv" : (classification.startsWith("boxee.") ? "boxee" : (classification.startsWith("sony.bravia") ? "bravia" : (classification.startsWith("ms_wmp.") ? "mswmp" : (classification.toLowerCase().contains("android") ? "android" : (classification.toLowerCase().contains("neotv") ? "neotv" : (classification.startsWith("vuze-ms-browser.") ? "vuze" : (device.isGenericUSB() ? "usb" : String.valueOf(species))))))))))));
        return new String[]{id};
    }

    private static void addTagSubMenu(MenuManager menu_manager, com.biglybt.pif.ui.menus.MenuItem menu, final DeviceMediaRenderer device) {
        menu.removeAllChildItems();
        TagManager tm = TagManagerFactory.getTagManager();
        List<Tag> tags = tm.getTagType(3).getTags();
        tags = TagUtils.sortTags(tags);
        long tag_id = device.getAutoShareToTagID();
        Tag assigned_tag = tm.lookupTagByUID(tag_id);
        com.biglybt.pif.ui.menus.MenuItem m = menu_manager.addMenuItem(menu, "label.no.tag");
        m.setStyle(3);
        m.setData(assigned_tag == null);
        m.addListener(new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                device.setAutoShareToTagID(-1L);
            }
        });
        m = menu_manager.addMenuItem(menu, "sep1");
        m.setStyle(4);
        ArrayList<String> menu_names = new ArrayList<String>();
        IdentityHashMap<String, Tag> menu_name_map = new IdentityHashMap<String, Tag>();
        for (Tag t : tags) {
            if (t.isTagAuto()[0]) continue;
            String name = t.getTagName(true);
            menu_names.add(name);
            menu_name_map.put(name, t);
        }
        List<Object> menu_structure = MenuBuildUtils.splitLongMenuListIntoHierarchy(menu_names, 20);
        for (Object obj : menu_structure) {
            com.biglybt.pif.ui.menus.MenuItem parent_menu;
            ArrayList<Tag> bucket_tags = new ArrayList<Tag>();
            if (obj instanceof String) {
                parent_menu = menu;
                bucket_tags.add((Tag)menu_name_map.get((String)obj));
            } else {
                Object[] entry = (Object[])obj;
                List tag_names = (List)entry[1];
                boolean has_selected = false;
                for (String name : tag_names) {
                    Tag tag = (Tag)menu_name_map.get(name);
                    bucket_tags.add(tag);
                    if (assigned_tag != tag) continue;
                    has_selected = true;
                }
                parent_menu = menu_manager.addMenuItem(menu, "!" + (String)entry[0] + (has_selected ? " (*)" : "") + "!");
                parent_menu.setStyle(5);
            }
            for (final Tag tag : bucket_tags) {
                m = menu_manager.addMenuItem(parent_menu, tag.getTagName(false));
                m.setStyle(3);
                m.setData(assigned_tag == tag);
                TagUIUtils.setMenuIcon(m, tag);
                m.addListener(new MenuItemListener(){

                    @Override
                    public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                        device.setAutoShareToTagID(tag.getTagUID());
                    }
                });
            }
        }
        m = menu_manager.addMenuItem(menu, "sep2");
        m.setStyle(4);
        m = menu_manager.addMenuItem(menu, "label.add.tag");
        m.addListener(new MenuItemListener(){

            @Override
            public void selected(com.biglybt.pif.ui.menus.MenuItem menu, Object target) {
                TagUIUtils.createManualTag(new UIFunctions.TagReturner(){

                    @Override
                    public void returnedTags(Tag[] tags) {
                        if (tags != null) {
                            Tag[] tagArray = tags;
                            int n = tags.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Tag new_tag = tagArray[n2];
                                device.setAutoShareToTagID(new_tag.getTagUID());
                                ++n2;
                            }
                        }
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void showDevice(Device device) {
        DeviceManagerUI deviceManagerUI = this;
        synchronized (deviceManagerUI) {
            MultipleDocumentInterface mdi;
            deviceItem existing_di = (deviceItem)device.getTransientProperty(DEVICE_IVIEW_KEY);
            if (existing_di != null && (mdi = UIFunctionsManager.getUIFunctions().getMDI()) != null) {
                mdi.showEntry(existing_di.getMdiEntry());
            }
        }
    }

    public static boolean handleDrop(TranscodeTarget target, Object payload) {
        return DeviceManagerUI.handleDropSupport(target, payload, true);
    }

    private static boolean handleDropSupport(final TranscodeTarget target, final Object payload, final boolean allow_retry) {
        if (!(payload instanceof String[] || payload instanceof String || payload instanceof FixedURLTransfer.URLType)) {
            return false;
        }
        TranscodeChooser deviceChooser = new TranscodeChooser(target){

            @Override
            public void closed() {
                if (this.selectedTranscodeTarget != null && this.selectedProfile != null) {
                    DeviceManagerUI.handleDrop(this.selectedTranscodeTarget, this.selectedProfile, payload, this.getTranscodeRequirement());
                }
            }
        };
        deviceChooser.show(new Runnable(){

            @Override
            public void run() {
                if (allow_retry) {
                    DeviceManagerUI.handleDropSupport(target, payload, false);
                }
            }
        });
        return true;
    }

    protected static void addDownload(TranscodeTarget target, TranscodeProfile profile, int transcode_requirement, byte[] hash) {
        try {
            DeviceManagerUI.addDownload(target, profile, transcode_requirement, CoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getShortCuts().getDownload(hash));
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    protected static void addDownload(TranscodeTarget target, TranscodeProfile profile, int transcode_requirement, Download download) {
        DiskManagerFileInfo[] dm_files = download.getDiskManagerFileInfo();
        int num_added = 0;
        DiskManagerFileInfo[] diskManagerFileInfoArray = dm_files;
        int n = dm_files.length;
        int n2 = 0;
        while (n2 < n) {
            DiskManagerFileInfo dm_file = diskManagerFileInfoArray[n2];
            if (num_added > 64) break;
            if (dm_files.length == 1 || dm_file.getLength() >= 131072L) {
                DeviceManagerUI.addFile(target, profile, transcode_requirement, dm_file);
                ++num_added;
            }
            ++n2;
        }
    }

    protected static void addFile(TranscodeTarget target, TranscodeProfile profile, int transcode_requirement, DiskManagerFileInfo file) {
        try {
            DeviceManagerFactory.getSingleton().getTranscodeManager().getQueue().add(target, profile, file, transcode_requirement, false);
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    protected static void addDirectory(TranscodeTarget target, TranscodeProfile profile, int transcode_requirement, File file) {
        if (!file.isDirectory()) {
            return;
        }
        File[] files = file.listFiles();
        int num_added = 0;
        File[] fileArray = files;
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            File f = fileArray[n2];
            if (num_added > 64) break;
            if (!f.isDirectory() && f.length() > 131072L) {
                DeviceManagerUI.addFile(target, profile, transcode_requirement, f);
                ++num_added;
            }
            ++n2;
        }
    }

    protected static void addFile(TranscodeTarget target, TranscodeProfile profile, int transcode_requirement, File file) {
        if (file.exists() && file.isFile()) {
            try {
                DeviceManagerFactory.getSingleton().getTranscodeManager().getQueue().add(target, profile, new DiskManagerFileInfoFile(file), transcode_requirement, false);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        } else {
            Debug.out("Drop to " + target.getDevice().getName() + " for " + file + " failed, file doesn't exist");
        }
    }

    protected static void addURL(TranscodeTarget target, TranscodeProfile profile, int transcode_requirement, String url) {
        try {
            DeviceManagerFactory.getSingleton().getTranscodeManager().getQueue().add(target, profile, new DiskManagerFileInfoURL(new URL(url)), transcode_requirement, false);
        }
        catch (Throwable e) {
            Debug.out(e);
        }
    }

    protected static void handleDrop(TranscodeTarget target, TranscodeProfile profile, Object payload, int transcode_requirement) {
        String url;
        if (payload instanceof String[]) {
            String[] files;
            String[] stringArray = files = (String[])payload;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                String file = stringArray[n2];
                File f = new File(file);
                if (f.isFile()) {
                    DeviceManagerUI.addFile(target, profile, transcode_requirement, f);
                } else {
                    DeviceManagerUI.addDirectory(target, profile, transcode_requirement, f);
                }
                ++n2;
            }
        } else if (payload instanceof String) {
            String stuff = (String)payload;
            if (stuff.startsWith("DownloadManager\n") || stuff.startsWith("DiskManagerFileInfo\n")) {
                String[] bits = RegExUtil.PAT_SPLIT_SLASH_N.split(stuff);
                int i = 1;
                while (i < bits.length) {
                    String hash_str = bits[i];
                    int pos = hash_str.indexOf(59);
                    try {
                        if (pos == -1) {
                            byte[] hash = Base32.decode(bits[i]);
                            DeviceManagerUI.addDownload(target, profile, transcode_requirement, hash);
                        } else {
                            String[] files = hash_str.split(";");
                            byte[] hash = Base32.decode(files[0].trim());
                            DiskManagerFileInfo[] dm_files = CoreFactory.getSingleton().getPluginManager().getDefaultPluginInterface().getShortCuts().getDownload(hash).getDiskManagerFileInfo();
                            int j = 1;
                            while (j < files.length) {
                                DiskManagerFileInfo dm_file = dm_files[Integer.parseInt(files[j].trim())];
                                DeviceManagerUI.addFile(target, profile, transcode_requirement, dm_file);
                                ++j;
                            }
                        }
                    }
                    catch (Throwable e) {
                        Debug.out("Failed to get download for hash " + bits[1]);
                    }
                    ++i;
                }
            } else if (stuff.startsWith("TranscodeFile\n")) {
                String[] bits = RegExUtil.PAT_SPLIT_SLASH_N.split(stuff);
                int i = 1;
                while (i < bits.length) {
                    File f = new File(bits[i]);
                    if (f.isFile()) {
                        DeviceManagerUI.addFile(target, profile, transcode_requirement, f);
                    }
                    ++i;
                }
            } else if (stuff.startsWith("http:") || stuff.startsWith("https://")) {
                DeviceManagerUI.addURL(target, profile, transcode_requirement, stuff);
            }
        } else if (payload instanceof FixedURLTransfer.URLType && (url = ((FixedURLTransfer.URLType)payload).linkURL) != null) {
            DeviceManagerUI.addURL(target, profile, transcode_requirement, url);
        }
    }

    protected void setStatus(Device device, deviceItem sbi) {
        sbi.setStatus(device);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addAllDevices() {
        DeviceManagerUI deviceManagerUI = this;
        synchronized (deviceManagerUI) {
            if (this.device_manager_listener == null) {
                this.needsAddAllDevices = true;
                return;
            }
            if (!this.device_manager_listener_added) {
                this.device_manager_listener_added = true;
                this.device_manager.addListener(this.device_manager_listener);
            }
        }
        Device[] devices = this.device_manager.getDevices();
        Arrays.sort(devices, new Comparator<Device>(){

            @Override
            public int compare(Device o1, Device o2) {
                return o1.getName().compareToIgnoreCase(o2.getName());
            }
        });
        Device[] deviceArray = devices;
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            Device device = deviceArray[n2];
            this.addOrChangeDevice(device);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeAllDevices() {
        Device[] devices;
        DeviceManagerUI deviceManagerUI = this;
        synchronized (deviceManagerUI) {
            if (this.device_manager_listener_added) {
                this.device_manager_listener_added = false;
                this.device_manager.removeListener(this.device_manager_listener);
            }
        }
        Device[] deviceArray = devices = this.device_manager.getDevices();
        int n = devices.length;
        int n2 = 0;
        while (n2 < n) {
            Device device = deviceArray[n2];
            this.removeDevice(device);
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeDevice(Device device) {
        DeviceManagerUI deviceManagerUI = this;
        synchronized (deviceManagerUI) {
            deviceItem existing_di = (deviceItem)device.getTransientProperty(DEVICE_IVIEW_KEY);
            if (existing_di != null) {
                device.setTransientProperty(DEVICE_IVIEW_KEY, null);
                existing_di.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected categoryView addDeviceCategory(int device_type, String category_title, String category_image_id) {
        String old_mdi_key;
        String mdi_key = "Device_" + category_title + ":" + this.nextSidebarID();
        final categoryView eventListener = device_type == 4 ? new DeviceInternetView(this, category_title) : new categoryViewGeneric(this, device_type, category_title);
        final String builder_key = "DeviceManager::CategoryView::" + device_type + "::" + category_title;
        UISWTViewBuilderCore builder = new UISWTViewBuilderCore(mdi_key, null).setInitialDatasource(device_type).setListenerInstantiator(new UISWTViewBuilder.UISWTViewEventListenerInstantiator(){

            @Override
            public boolean supportsMultipleViews() {
                return true;
            }

            @Override
            public UISWTViewEventListener createNewInstance(UISWTViewBuilder Builder2, UISWTView forView) throws Exception {
                return eventListener;
            }

            @Override
            public String getUID() {
                return builder_key;
            }
        }).setParentEntryID("header.devices");
        ViewManagerSWT vi = ViewManagerSWT.getInstance();
        Map<String, String> map = this.builder_map;
        synchronized (map) {
            old_mdi_key = this.builder_map.put(builder_key, mdi_key);
        }
        if (old_mdi_key != null) {
            vi.unregisterView("Internal", old_mdi_key);
        }
        vi.registerView("Internal", builder);
        MdiEntrySWT entry = this.mdi.createEntry(builder, false);
        this.addDefaultDropListener(entry);
        entry.setImageLeftID(category_image_id);
        eventListener.setDetails(entry, mdi_key);
        return eventListener;
    }

    protected void addDefaultDropListener(MdiEntry mainSbEntry) {
        mainSbEntry.addListener(new MdiEntryDropListener(){

            @Override
            public boolean mdiEntryDrop(MdiEntry entry, Object payload) {
                return DeviceManagerUI.handleDrop(null, payload);
            }
        });
    }

    protected void showProperties(Device device) {
        String[][] props = device.getDisplayProperties();
        new PropertiesWindow(device.getName(), props[0], props[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int nextSidebarID() {
        DeviceManagerUI deviceManagerUI = this;
        synchronized (deviceManagerUI) {
            return this.next_sidebar_id++;
        }
    }

    public void dispose() {
        if (this.device_manager != null) {
            TranscodeQueue transQ;
            TranscodeManager transMan;
            if (this.device_manager_listener_setupui != null) {
                this.device_manager.removeListener(this.device_manager_listener_setupui);
            }
            if (this.device_manager_listener != null && this.device_manager_listener_added) {
                this.device_manager.removeListener(this.device_manager_listener);
            }
            if (this.transcodeQueueListener != null && (transMan = this.device_manager.getTranscodeManager()) != null && (transQ = transMan.getQueue()) != null) {
                transQ.removeListener(this.transcodeQueueListener);
            }
        }
        if (this.parameterListener != null) {
            COConfigurationManager.removeWeakParameterListener(this.parameterListener, CONFIG_VIEW_TYPE, CONFIG_VIEW_HIDE_REND_GENERIC, CONFIG_VIEW_SHOW_ONLY_TAGGED);
        }
        if (this.canCloseListener != null) {
            UIExitUtilsSWT.removeListener(this.canCloseListener);
            this.canCloseListener = null;
        }
        if (this.configModel != null) {
            this.configModel.destroy();
            this.configModel = null;
        }
    }

    public static class DeviceView
    extends UISWTViewMultiInstance
    implements ViewTitleInfo {
        private final String parent_key;
        private final Device device;
        private int last_indicator;

        public DeviceView(String _parent_key, Device _device) {
            this.parent_key = _parent_key;
            this.device = _device;
        }

        public String getTitle() {
            return this.device.getName();
        }

        @Override
        public Object getTitleInfoProperty(int propertyID) {
            if (propertyID == 5) {
                return this.getTitle();
            }
            if (propertyID == 2) {
                String imageID = null;
                final String[] ids = DeviceManagerUI.getDeviceImageIDs(this.device);
                if (ids.length > 0) {
                    imageID = "image.sidebar.device." + ids[0] + ".small";
                    if (ids[0].startsWith("http")) {
                        boolean found = false;
                        String[] stringArray = ids;
                        int n = ids.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String id = stringArray[n2];
                            Image[] existing = ImageLoader.getInstance().imageAdded_NoSWT(id);
                            if (existing != null) {
                                found = true;
                                imageID = id;
                                if (existing.length > 0) break;
                            }
                            ++n2;
                        }
                        if (!found) {
                            Utils.execSWTThreadLater(0, new AERunnable(){

                                @Override
                                public void runSupport() {
                                    String[] stringArray = ids;
                                    int n = ids.length;
                                    int n2 = 0;
                                    while (n2 < n) {
                                        String id = stringArray[n2];
                                        ImageLoader.getInstance().getUrlImage(id, new ImageLoader.ImageDownloaderListener(){

                                            @Override
                                            public void imageDownloaded(Image image, String key, boolean returnedImmediately) {
                                                ViewTitleInfoManager.refreshTitleInfo(this);
                                            }
                                        });
                                        ++n2;
                                    }
                                }
                            });
                        }
                    }
                }
                return imageID;
            }
            if (propertyID == 0) {
                if (this.device instanceof DeviceMediaRenderer) {
                    // empty if block
                }
                if (this.last_indicator > 0) {
                    return String.valueOf(this.last_indicator);
                }
            } else if (propertyID != 8) {
                if (propertyID == 9) {
                    if (this.device.isLivenessDetectable()) {
                        return new Long(this.device.isAlive() ? 1 : 2);
                    }
                } else if (propertyID == 1) {
                    return this.device.getStatus();
                }
            }
            return null;
        }

        protected void refreshTitles() {
            ViewTitleInfoManager.refreshTitleInfo(this);
            String key = this.parent_key;
            while (key != null) {
                MultipleDocumentInterface mdi = UIFunctionsManager.getUIFunctions().getMDI();
                if (mdi == null) break;
                MdiEntry parent = mdi.getEntry(key);
                if (parent != null) {
                    ViewTitleInfoManager.refreshTitleInfo(parent.getViewTitleInfo());
                    key = parent.getParentID();
                    continue;
                }
                key = null;
            }
        }

        @Override
        public UISWTViewMultiInstance.ViewInstance createInstance(UISWTView view) {
            return new DeviceViewInstance(this, view, this.device);
        }
    }

    private static class DeviceViewInstance
    implements UISWTViewMultiInstance.ViewInstance,
    TranscodeTargetListener {
        private final DeviceView parent;
        private final UISWTView view;
        private final Device device;
        private Composite parent_composite;
        private Composite composite;
        private Runnable refresher;

        protected DeviceViewInstance(DeviceView _parent, UISWTView _view, Device _device) {
            this.parent = _parent;
            this.view = _view;
            this.device = _device;
            this.view.setTitle(this.parent.getTitle());
            if (this.device instanceof DeviceMediaRenderer) {
                DeviceMediaRenderer renderer = (DeviceMediaRenderer)this.device;
                renderer.addListener(this);
            }
        }

        @Override
        public void initialize(Composite _parent_composite) {
            this.parent_composite = _parent_composite;
            this.composite = new Composite(this.parent_composite, 0);
            if (this.device instanceof DeviceContentDirectory) {
                FormLayout layout = new FormLayout();
                layout.marginTop = 2;
                layout.marginLeft = 2;
                layout.marginRight = 2;
                layout.marginBottom = 2;
                this.composite.setLayout((Layout)layout);
                Label ms_label = new Label(this.composite, 0);
                ms_label.setText("Media Server: " + this.device.getName());
                final Button refresh = new Button(this.composite, 8);
                refresh.setText("Refresh");
                final StyledText info = new StyledText(this.composite, 2818){
                    private boolean adding;
                    private Event last_event;
                    {
                        super($anonymous0, $anonymous1);
                        this.adding = false;
                    }

                    public void addListener(int eventType, final Listener listener) {
                        if (eventType == 3 && !this.adding) {
                            try {
                                this.adding = true;
                                super.addListener(eventType, new Listener(){

                                    public void handleEvent(Event event2) {
                                        if (event2.type == 3 && event2 != last_event && event2.button == 1 && event2.stateMask != 262144) {
                                            last_event = event2;
                                            try {
                                                Object data;
                                                StyleRange style;
                                                int offset = this.getOffsetAtPoint(new Point(event2.x, event2.y));
                                                if (offset != -1 && (style = this.getStyleRangeAtOffset(offset)) != null && (data = style.data) instanceof UPNPMSItem) {
                                                    int line = this.getLineAtOffset(offset);
                                                    int lineOffset = this.getOffsetAtLine(line);
                                                    this.setSelection(lineOffset, lineOffset + this.getLine(line).length());
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                // empty catch block
                                            }
                                        }
                                        listener.handleEvent(event2);
                                    }
                                });
                            }
                            finally {
                                this.adding = false;
                            }
                        } else {
                            super.addListener(eventType, listener);
                        }
                    }
                };
                info.setEditable(false);
                info.setSelectionForeground(info.getForeground());
                info.setSelectionBackground(info.getBackground());
                FormData data = new FormData();
                data.left = new FormAttachment(0, 0);
                data.bottom = new FormAttachment((Control)info, -8);
                ms_label.setLayoutData((Object)data);
                data = new FormData();
                data.left = new FormAttachment((Control)ms_label, 4);
                data.top = new FormAttachment((Control)this.composite, 0);
                refresh.setLayoutData((Object)data);
                data = new FormData();
                data.left = new FormAttachment(0, 0);
                data.right = new FormAttachment(100, 0);
                data.top = new FormAttachment((Control)refresh, 4);
                data.bottom = new FormAttachment(100, 0);
                info.setLayoutData((Object)data);
                final Runnable do_refresh = new Runnable(){
                    private UPNPMSItem dragging_item;
                    boolean play_available;
                    {
                        final DragSource drag_source = DragDropUtils.createDragSource((Control)styledText, 3);
                        drag_source.setTransfer(new Transfer[]{TextTransfer.getInstance()});
                        drag_source.addDragListener((DragSourceListener)new DragSourceAdapter(){

                            public void dragStart(DragSourceEvent event2) {
                                event2.doit = false;
                                try {
                                    UPNPMSItem item;
                                    Object data;
                                    StyleRange style;
                                    int offset = styledText.getOffsetAtPoint(new Point(event2.x, event2.y));
                                    if (offset != 0 && (style = styledText.getStyleRangeAtOffset(offset)) != null && (data = style.data) instanceof UPNPMSItem && (item = (UPNPMSItem)data).getURL() != null) {
                                        dragging_item = item;
                                        event2.doit = true;
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }

                            public void dragSetData(DragSourceEvent event2) {
                                if (dragging_item != null) {
                                    String url = dragging_item.getURL().toExternalForm();
                                    url = String.valueOf(url) + (url.contains("?") ? "&" : "?") + "azcdid=" + RandomUtils.INSTANCE_ID + "&azcddn=" + UrlUtils.encode(dragging_item.getTitle());
                                    event2.data = url;
                                } else {
                                    event2.data = null;
                                    event2.doit = false;
                                }
                            }

                            public void dragFinished(DragSourceEvent event2) {
                                dragging_item = null;
                                try {
                                    Point selection = styledText.getSelection();
                                    styledText.setSelection(selection.x, selection.x);
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        });
                        final DropTarget drop_target = new DropTarget((Control)styledText, 7);
                        drop_target.setTransfer(new Transfer[0]);
                        styledText.addDisposeListener(new DisposeListener(){

                            public void widgetDisposed(DisposeEvent e) {
                                if (!drag_source.isDisposed()) {
                                    drag_source.dispose();
                                }
                                if (!drop_target.isDisposed()) {
                                    drop_target.dispose();
                                }
                            }
                        });
                        styledText.addMouseListener(new MouseListener(){

                            public void mouseDoubleClick(MouseEvent arg0) {
                            }

                            public void mouseDown(MouseEvent event2) {
                                if (styledText.isDisposed()) {
                                    return;
                                }
                                try {
                                    Object data;
                                    StyleRange style;
                                    int offset = styledText.getOffsetAtPoint(new Point(event2.x, event2.y));
                                    if (offset != -1 && (style = styledText.getStyleRangeAtOffset(offset)) != null && (data = style.data) instanceof UPNPMSItem) {
                                        UPNPMSItem item = (UPNPMSItem)data;
                                        if (event2.button == 3 || event2.button == 1 && event2.stateMask == 262144) {
                                            final Menu menu = new Menu((Decorations)styledText.getShell(), 8);
                                            final URL url = item.getURL();
                                            if (url != null) {
                                                MenuItem menu_item = new MenuItem(menu, 0);
                                                menu_item.setText(MessageText.getString("devices.copy_url"));
                                                menu_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                                    public void widgetSelected(SelectionEvent arg0) {
                                                        ClipboardCopy.copyToClipBoard(url.toExternalForm());
                                                    }
                                                });
                                                menu_item = new MenuItem(menu, 0);
                                                menu_item.setText(MessageText.getString("iconBar.run"));
                                                menu_item.addSelectionListener((SelectionListener)new SelectionAdapter(){

                                                    public void widgetSelected(SelectionEvent arg0) {
                                                        Utils.launch(url);
                                                    }
                                                });
                                                menu_item.setEnabled(item.getItemClass() != "other");
                                            }
                                            styledText.setMenu(menu);
                                            menu.addMenuListener((MenuListener)new MenuAdapter(){

                                                public void menuHidden(MenuEvent arg0) {
                                                    if (styledText.getMenu() == menu) {
                                                        styledText.setMenu(null);
                                                    }
                                                }
                                            });
                                            menu.setVisible(true);
                                        }
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }

                            public void mouseUp(MouseEvent event2) {
                                if (styledText.isDisposed()) {
                                    return;
                                }
                                try {
                                    Object data;
                                    StyleRange style;
                                    int offset = styledText.getOffsetAtPoint(new Point(event2.x, event2.y));
                                    if (offset != 0 && (style = styledText.getStyleRangeAtOffset(offset)) != null && (data = style.data) instanceof UPNPMSItem) {
                                        URL url;
                                        UPNPMSItem item = (UPNPMSItem)data;
                                        if (event2.button == 1 && style.underline && (url = item.getURL()) != null) {
                                            PlayUtils.playURL(url, item.getTitle());
                                        }
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        });
                        styledText.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

                            public void mouseHover(MouseEvent event2) {
                                if (styledText.isDisposed()) {
                                    return;
                                }
                                String tooltip = "";
                                try {
                                    UPNPMSItem item;
                                    Object data;
                                    StyleRange style;
                                    int offset = styledText.getOffsetAtPoint(new Point(event2.x, event2.y));
                                    if (offset != 0 && (style = styledText.getStyleRangeAtOffset(offset)) != null && (data = style.data) instanceof UPNPMSItem && (item = (UPNPMSItem)data) != null) {
                                        tooltip = DisplayFormatters.formatByteCountToKiBEtc(item.getSize());
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                                Utils.setTT((Control)styledText, tooltip);
                            }
                        });
                        styledText.addMouseMoveListener(new MouseMoveListener(){
                            private StyleRange last_style;

                            public void mouseMove(MouseEvent event2) {
                                try {
                                    StyleRange style;
                                    int offset = styledText.getOffsetAtPoint(new Point(event2.x, event2.y));
                                    if (offset != -1 && (style = styledText.getStyleRangeAtOffset(offset)) != this.last_style) {
                                        this.last_style = style;
                                        Utils.setTT((Control)styledText, "");
                                    }
                                }
                                catch (Throwable throwable) {
                                    // empty catch block
                                }
                            }
                        });
                    }

                    @Override
                    public void run() {
                        boolean went_async = false;
                        final int max_ms_display_lines = COConfigurationManager.getIntParameter("Plugin.default.device.config.ms.maxlines", 5000);
                        try {
                            refresh.setEnabled(false);
                            info.setText("");
                            this.play_available = PlayUtils.isEMPAvailable();
                            final DeviceContentDirectory cd = (DeviceContentDirectory)device;
                            final List<URL> endpoints = cd.getControlURLs();
                            if (endpoints == null || endpoints.size() == 0) {
                                info.append("Media Server is offline");
                            } else {
                                new AEThread2("CD:populate"){
                                    private int line_count;
                                    private List<Object[]> lines_to_add;
                                    {
                                        super($anonymous0);
                                        this.lines_to_add = new ArrayList<Object[]>();
                                    }

                                    @Override
                                    public void run() {
                                        block5: {
                                            try {
                                                try {
                                                    String client_name = DeviceManagerFactory.getSingleton().getLocalServiceName();
                                                    UPNPMSBrowser browser = UPNPMSBrowserFactory.create(client_name, endpoints, new UPNPMSBrowserListener(){

                                                        @Override
                                                        public void setPreferredURL(URL url) {
                                                            cd.setPreferredControlURL(url);
                                                        }
                                                    });
                                                    this.print(browser.getRoot(), "");
                                                }
                                                catch (Throwable e) {
                                                    Debug.out(e);
                                                    Utils.execSWTThread(new Runnable(this, refresh){
                                                        final /* synthetic */ 6 this$3;
                                                        private final /* synthetic */ Button val$refresh;
                                                        {
                                                            this.this$3 = var1_1;
                                                            this.val$refresh = button;
                                                        }

                                                        @Override
                                                        public void run() {
                                                            if (!this.val$refresh.isDisposed()) {
                                                                this.val$refresh.setEnabled(true);
                                                            }
                                                        }
                                                    });
                                                    break block5;
                                                }
                                            }
                                            catch (Throwable throwable) {
                                                Utils.execSWTThread(new /* invalid duplicate definition of identical inner class */);
                                                throw throwable;
                                            }
                                            Utils.execSWTThread(new /* invalid duplicate definition of identical inner class */);
                                        }
                                    }

                                    private boolean print(UPNPMSContainer container, String indent) throws UPnPMSException {
                                        if (!this.appendLine(indent, container)) {
                                            return false;
                                        }
                                        try {
                                            indent = String.valueOf(indent) + "\t\t";
                                            List<UPNPMSNode> kids = container.getChildren();
                                            for (UPNPMSNode kid : kids) {
                                                if (!(kid instanceof UPNPMSContainer ? !this.print((UPNPMSContainer)kid, indent) : !this.print((UPNPMSItem)kid, indent))) continue;
                                                return false;
                                            }
                                            return true;
                                        }
                                        finally {
                                            this.updateInfo();
                                        }
                                    }

                                    private boolean print(UPNPMSItem item, String indent) {
                                        return this.appendLine(indent, item);
                                    }

                                    private boolean appendLine(String indent, Object obj) {
                                        ++this.line_count;
                                        if (this.line_count >= max_ms_display_lines) {
                                            if (this.line_count == max_ms_display_lines) {
                                                this.lines_to_add.add(new Object[]{indent, "Too many entries, output truncated..."});
                                            }
                                            return false;
                                        }
                                        this.lines_to_add.add(new Object[]{indent, obj});
                                        return true;
                                    }

                                    private void updateInfo() {
                                        if (info.isDisposed()) {
                                            return;
                                        }
                                        final List<Object[]> temp = this.lines_to_add;
                                        this.lines_to_add = new ArrayList<Object[]>();
                                        Utils.execSWTThread(new Runnable(){

                                            @Override
                                            public void run() {
                                                if (info.isDisposed()) {
                                                    return;
                                                }
                                                for (Object[] entry : temp) {
                                                    String indent = (String)entry[0];
                                                    Object obj = entry[1];
                                                    String line = indent;
                                                    if (obj instanceof UPNPMSContainer) {
                                                        UPNPMSContainer container = (UPNPMSContainer)obj;
                                                        line = String.valueOf(line) + container.getTitle();
                                                        line = String.valueOf(line) + "\r\n";
                                                        int start_pos = info.getCharCount();
                                                        info.append(line);
                                                        StyleRange style = new StyleRange(start_pos, line.length(), null, null, 1);
                                                        info.setStyleRange(style);
                                                        continue;
                                                    }
                                                    if (obj instanceof UPNPMSItem) {
                                                        StyleRange style;
                                                        UPNPMSItem item = (UPNPMSItem)obj;
                                                        line = String.valueOf(line) + item.getTitle();
                                                        line = String.valueOf(line) + "\r\n";
                                                        int start_pos = info.getCharCount();
                                                        info.append(line);
                                                        String item_class = item.getItemClass();
                                                        if (play_available && item.getURL() != null && (item_class == "video" || item_class == "audio")) {
                                                            style = new StyleRange(start_pos + indent.length(), line.length() - indent.length(), null, null, 0);
                                                            style.underline = true;
                                                            style.underlineStyle = 4;
                                                            style.data = item;
                                                            info.setStyleRange(style);
                                                            continue;
                                                        }
                                                        style = new StyleRange(start_pos, line.length(), null, null, 2);
                                                        style.data = item;
                                                        info.setStyleRange(style);
                                                        continue;
                                                    }
                                                    line = String.valueOf(line) + (String)obj;
                                                    line = String.valueOf(line) + "\r\n";
                                                    int start_pos = info.getCharCount();
                                                    info.append(line);
                                                    StyleRange style = new StyleRange(start_pos, line.length(), null, null, 0);
                                                    info.setStyleRange(style);
                                                }
                                            }
                                        });
                                    }
                                }.start();
                                went_async = true;
                            }
                        }
                        finally {
                            if (!went_async) {
                                refresh.setEnabled(true);
                            }
                        }
                    }
                };
                do_refresh.run();
                refresh.addListener(13, new Listener(){

                    public void handleEvent(Event arg0) {
                        do_refresh.run();
                    }
                });
            } else {
                try {
                    if (this.device instanceof DeviceUPnP) {
                        Runnable ref = this.refresher = new Runnable(){
                            boolean force = false;

                            @Override
                            public void run() {
                                UPnPService service = this.findService((DeviceUPnP)device, "urn:schemas-upnp-org:service:WANCommonInterfaceConfig:");
                                if (service != null) {
                                    UPnPWANCommonInterfaceConfig config = (UPnPWANCommonInterfaceConfig)service.getSpecificService();
                                    refresher = null;
                                    this.createDeviceUPnP(config, this.force);
                                } else {
                                    this.force = true;
                                }
                            }
                        };
                        this.refresher.run();
                        if (this.refresher != ref) {
                            return;
                        }
                    }
                }
                catch (Throwable ref) {
                    // empty catch block
                }
                GridLayout layout = new GridLayout();
                layout.marginTop = 2;
                layout.marginLeft = 2;
                layout.marginRight = 2;
                layout.marginBottom = 2;
                this.composite.setLayout((Layout)layout);
                Label label = new Label(this.composite, 0);
                label.setText("Nothing to show for " + this.device.getName());
                label.setLayoutData((Object)new GridData(768));
            }
        }

        private void createDeviceUPnP(final UPnPWANCommonInterfaceConfig config, boolean force) {
            if (force) {
                Utils.disposeComposite(this.composite, false);
            }
            GridLayout layout = Utils.getSimpleGridLayout(5);
            layout.horizontalSpacing = 4;
            this.composite.setLayout((Layout)layout);
            Label max_up_down_info = new Label(this.composite, 0);
            Messages.setLanguageText((Widget)max_up_down_info, "label.connection.max.up.down");
            final Label max_up_down = new Label(this.composite, 0);
            GridData gd = new GridData();
            gd.widthHint = 150;
            max_up_down.setLayoutData((Object)gd);
            Label pad = new Label(this.composite, 0);
            pad.setLayoutData((Object)new GridData(768));
            Label total_up_down_info = new Label(this.composite, 0);
            Messages.setLanguageText((Widget)total_up_down_info, "label.total.up.down");
            final BufferedLabel total_up_down = new BufferedLabel(this.composite, 0x20020000);
            total_up_down.setExpandWidth();
            gd = new GridData();
            gd.widthHint = 60;
            total_up_down.setLayoutData(gd);
            int update_secs = 5;
            final MovingAverage up_average = AverageFactory.MovingAverage(12);
            final MovingAverage down_average = AverageFactory.MovingAverage(12);
            final long[] total_sent_received_initial = new long[2];
            final long[] total_sent_received = new long[2];
            final long[] total_sent_received_wrapped = new long[2];
            ValueFormater formatter = new ValueFormater(){

                @Override
                public String format(int value) {
                    return DisplayFormatters.formatByteCountToKiBEtcPerSec(value / 5);
                }
            };
            ValueSource[] sources = new ValueSourceImpl[]{new ValueSourceImpl("Up", 0, colors, true, false, false){
                long last_value;
                {
                    super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4, $anonymous5);
                    this.last_value = -1L;
                }

                @Override
                public int getValue() {
                    try {
                        int result;
                        long sent;
                        total_sent_received[0] = sent = config.getTotalBytesSent();
                        if (this.last_value == -1L) {
                            result = 0;
                            if (sent < 0x100000000L) {
                                total_sent_received_initial[0] = sent;
                            }
                        } else if (sent < this.last_value && this.last_value - sent > 0x3FFFFFFFL) {
                            long boundary = 0L;
                            boundary = this.last_value <= Integer.MAX_VALUE ? 0x80000000L : 0x100000000L;
                            total_sent_received_wrapped[0] = total_sent_received_wrapped[0] + boundary;
                            result = (int)(boundary - this.last_value + sent);
                        } else {
                            result = (int)(sent - this.last_value);
                        }
                        if (result < 0) {
                            result = 0;
                        }
                        this.last_value = sent;
                        up_average.update(result);
                        return result;
                    }
                    catch (Throwable e) {
                        return 0;
                    }
                }
            }, new ValueSourceImpl("Up Smooth", 1, colors, true, false, true){

                @Override
                public int getValue() {
                    return (int)up_average.getAverage();
                }
            }, new ValueSourceImpl("Down", 2, colors, false, false, false){
                long last_value;
                {
                    super($anonymous0, $anonymous1, $anonymous2, $anonymous3, $anonymous4, $anonymous5);
                    this.last_value = -1L;
                }

                @Override
                public int getValue() {
                    try {
                        int result;
                        long received;
                        total_sent_received[1] = received = config.getTotalBytesReceived();
                        if (this.last_value == -1L) {
                            result = 0;
                            if (received < 0x100000000L) {
                                total_sent_received_initial[1] = received;
                            }
                        } else if (received < this.last_value && this.last_value - received > 0x3FFFFFFFL) {
                            long boundary = 0L;
                            boundary = this.last_value <= Integer.MAX_VALUE ? 0x80000000L : 0x100000000L;
                            total_sent_received_wrapped[1] = total_sent_received_wrapped[1] + boundary;
                            result = (int)(boundary - this.last_value + received);
                        } else {
                            result = (int)(received - this.last_value);
                        }
                        if (result < 0) {
                            result = 0;
                        }
                        this.last_value = received;
                        down_average.update(result);
                        return result;
                    }
                    catch (Throwable e) {
                        return 0;
                    }
                }
            }, new ValueSourceImpl("Down Smooth", 3, colors, false, false, true){

                @Override
                public int getValue() {
                    return (int)down_average.getAverage();
                }
            }};
            final MultiPlotGraphic mpg = MultiPlotGraphic.getInstance(360, sources, formatter);
            String[] color_configs = new String[]{"DeviceManagerUI.legend.up", "DeviceManagerUI.legend.up.smooth", "DeviceManagerUI.legend.down", "DeviceManagerUI.legend.down.smooth"};
            Legend.LegendListener legend_listener = new Legend.LegendListener((ValueSourceImpl[])sources, mpg){
                private int hover_index = -1;
                private final /* synthetic */ ValueSourceImpl[] val$sources;
                private final /* synthetic */ MultiPlotGraphic val$mpg;
                {
                    this.val$sources = valueSourceImplArray;
                    this.val$mpg = multiPlotGraphic;
                }

                @Override
                public void hoverChange(boolean entry, int index) {
                    if (this.hover_index != -1) {
                        this.val$sources[this.hover_index].setHover(false);
                    }
                    if (entry) {
                        this.hover_index = index;
                        this.val$sources[index].setHover(true);
                    }
                    this.val$mpg.refresh(true);
                }

                @Override
                public void visibilityChange(boolean visible, int index) {
                    this.val$sources[index].setVisible(visible);
                    this.val$mpg.refresh(true);
                }
            };
            Composite gSpeed = new Composite(this.composite, 0);
            gd = new GridData(1808);
            gd.horizontalSpan = 5;
            gSpeed.setLayoutData((Object)gd);
            gSpeed.setLayout((Layout)Utils.getSimpleGridLayout(1));
            gd = new GridData(768);
            gd.horizontalSpan = 5;
            gSpeed.setBackground(Colors.red);
            Legend.createLegendComposite(this.composite, colors, color_configs, null, gd, true, legend_listener);
            Canvas speedCanvas = new Canvas(gSpeed, 262144);
            gd = new GridData(1808);
            speedCanvas.setLayoutData((Object)gd);
            mpg.initialize(speedCanvas, false);
            new AEThread2("upnp:stats"){

                @Override
                public void run() {
                    try {
                        final long[] result = config.getCommonLinkProperties();
                        Utils.execSWTThread(new Runnable(){

                            @Override
                            public void run() {
                                max_up_down.setText(String.valueOf(DisplayFormatters.formatByteCountToBitsPerSec2(result[1] / 8L)) + ", " + DisplayFormatters.formatByteCountToBitsPerSec2(result[0] / 8L));
                            }
                        });
                    }
                    catch (Throwable e) {
                        Utils.execSWTThread(new Runnable(){

                            @Override
                            public void run() {
                                max_up_down.setText(MessageText.getString("SpeedView.stats.unknown"));
                            }
                        });
                    }
                }
            }.start();
            mpg.setActive(true, 5000);
            this.refresher = new Runnable(){

                @Override
                public void run() {
                    mpg.refresh(false);
                    total_up_down.setText(String.valueOf(DisplayFormatters.formatByteCountToKiBEtc(total_sent_received[0] - total_sent_received_initial[0] + total_sent_received_wrapped[0])) + ", " + DisplayFormatters.formatByteCountToKiBEtc(total_sent_received[1] - total_sent_received_initial[1] + total_sent_received_wrapped[1]));
                }
            };
            if (force) {
                this.composite.getParent().layout(true, true);
            }
        }

        private UPnPService findService(DeviceUPnP device, String type) {
            UPnPDevice upnp_device = device.getUPnPDevice();
            if (upnp_device == null) {
                return null;
            }
            UPnPRootDevice root = upnp_device.getRootDevice();
            return this.findService(root.getDevice(), type);
        }

        private UPnPService findService(UPnPDevice device, String type) {
            UPnPService[] uPnPServiceArray = device.getServices();
            int n = uPnPServiceArray.length;
            int n2 = 0;
            while (n2 < n) {
                UPnPService service = uPnPServiceArray[n2];
                if (GeneralUtils.startsWithIgnoreCase(service.getServiceType(), type)) {
                    return service;
                }
                ++n2;
            }
            UPnPDevice[] kids = device.getSubDevices();
            if (kids != null) {
                UPnPDevice[] uPnPDeviceArray = kids;
                int n3 = kids.length;
                n = 0;
                while (n < n3) {
                    UPnPDevice kid = uPnPDeviceArray[n];
                    UPnPService s = this.findService(kid, type);
                    if (s != null) {
                        return s;
                    }
                    ++n;
                }
            }
            return null;
        }

        @Override
        public void fileAdded(TranscodeFile file) {
        }

        @Override
        public void fileChanged(TranscodeFile file, int type, Object data) {
            if (type == 1 && data == "comp") {
                this.parent.refreshTitles();
            }
        }

        private void refresh() {
            if (this.refresher != null) {
                this.refresher.run();
            }
        }

        @Override
        public void fileRemoved(TranscodeFile file) {
        }

        private void delete() {
            if (this.device instanceof DeviceMediaRenderer) {
                DeviceMediaRenderer renderer = (DeviceMediaRenderer)this.device;
                renderer.removeListener(this);
            }
        }

        @Override
        public void refresh(UISWTViewEvent event2) {
            this.refresh();
        }

        @Override
        public void updateLanguage() {
            Messages.updateLanguageForControl((Widget)this.composite);
            this.view.setTitle(this.parent.getTitle());
        }

        @Override
        public void destroy() {
            this.delete();
        }
    }

    private static abstract class ValueSourceImpl
    implements ValueSource {
        private String name;
        private int index;
        private Color[] colours;
        private boolean is_up;
        private boolean trimmable;
        private boolean is_hover;
        private boolean is_invisible;
        private boolean is_dotted;

        private ValueSourceImpl(String _name, int _index, Color[] _colours, boolean _is_up, boolean _trimmable, boolean _is_dotted) {
            this.name = _name;
            this.index = _index;
            this.colours = _colours;
            this.is_up = _is_up;
            this.trimmable = _trimmable;
            this.is_dotted = _is_dotted;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        public Color getLineColor() {
            return this.colours[this.index];
        }

        @Override
        public boolean isTrimmable() {
            return this.trimmable;
        }

        private void setHover(boolean h) {
            this.is_hover = h;
        }

        private void setVisible(boolean visible) {
            this.is_invisible = !visible;
        }

        @Override
        public int getStyle() {
            int style;
            if (this.is_invisible) {
                return 16;
            }
            int n = style = this.is_up ? 1 : 2;
            if (this.is_hover) {
                style |= 8;
            }
            if (this.is_dotted) {
                style |= 0x40;
            }
            return style;
        }

        @Override
        public int getAlpha() {
            return this.is_dotted ? 128 : 255;
        }
    }

    protected static abstract class categoryView
    extends UISWTViewMultiInstance
    implements ViewTitleInfo {
        private DeviceManagerUI ui;
        private int device_type;
        private String title;
        private String key;
        private MdiEntryVitalityImage spinner;
        private MdiEntryVitalityImage warning;
        private MdiEntryVitalityImage info;
        private int last_indicator;
        private MdiEntry mdiEntry;

        protected categoryView(DeviceManagerUI _ui, int _device_type, String _title) {
            this.ui = _ui;
            this.device_type = _device_type;
            this.title = _title;
        }

        protected void setDetails(MdiEntry entry, String _key) {
            this.mdiEntry = entry;
            this.key = _key;
            this.spinner = entry.addVitalityImage(DeviceManagerUI.SPINNER_IMAGE_ID);
            DeviceManagerUI.hideIcon(this.spinner);
            this.warning = entry.addVitalityImage(DeviceManagerUI.ALERT_IMAGE_ID);
            DeviceManagerUI.hideIcon(this.warning);
            this.info = entry.addVitalityImage(DeviceManagerUI.INFO_IMAGE_ID);
            DeviceManagerUI.hideIcon(this.info);
        }

        protected int getDeviceType() {
            return this.device_type;
        }

        protected String getKey() {
            return this.key;
        }

        protected String getTitle() {
            return this.getTitle(false);
        }

        protected String getTitle(boolean raw) {
            if (raw) {
                return this.title;
            }
            return MessageText.getString(this.title);
        }

        @Override
        public Object getTitleInfoProperty(int propertyID) {
            boolean expanded;
            boolean bl = expanded = this.mdiEntry != null && this.mdiEntry.isExpanded();
            if (propertyID == 5) {
                return this.getTitle();
            }
            if (propertyID == 0 && this.device_type == 3) {
                if (this.spinner != null) {
                    this.spinner.setVisible(!expanded && this.ui.getDeviceManager().isBusy(this.device_type));
                }
                if (!expanded) {
                    Device[] devices = this.ui.getDeviceManager().getDevices();
                    this.last_indicator = 0;
                    String all_errors = "";
                    String all_infos = "";
                    Device[] deviceArray = devices;
                    int n = devices.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Device device = deviceArray[n2];
                        if (this.device_type == device.getType()) {
                            String info;
                            String error = device.getError();
                            if (error != null) {
                                all_errors = String.valueOf(all_errors) + (all_errors.length() == 0 ? "" : "; ") + error;
                            }
                            if ((info = device.getInfo()) != null) {
                                all_infos = String.valueOf(all_infos) + (all_infos.length() == 0 ? "" : "; ") + info;
                            }
                            if (device instanceof DeviceMediaRenderer) {
                                // empty if block
                            }
                        }
                        ++n2;
                    }
                    if (all_errors.length() > 0) {
                        DeviceManagerUI.showIcon(this.warning, all_errors);
                    } else {
                        DeviceManagerUI.hideIcon(this.warning);
                        if (all_infos.length() > 0) {
                            DeviceManagerUI.showIcon(this.info, all_infos);
                        } else {
                            DeviceManagerUI.hideIcon(this.info);
                        }
                    }
                    if (this.last_indicator > 0) {
                        return String.valueOf(this.last_indicator);
                    }
                } else {
                    DeviceManagerUI.hideIcon(this.warning);
                    DeviceManagerUI.hideIcon(this.info);
                }
            }
            return null;
        }

        @Override
        public void destroy() {
            super.destroy();
            this.mdiEntry.closeView();
        }
    }

    protected static class categoryViewGeneric
    extends categoryView {
        protected categoryViewGeneric(DeviceManagerUI _ui, int _device_type, String _title) {
            super(_ui, _device_type, _title);
        }

        @Override
        public UISWTViewMultiInstance.ViewInstance createInstance(UISWTView view) {
            return new categoryViewGenericInstance(this, view);
        }
    }

    protected static class categoryViewGenericInstance
    implements UISWTViewMultiInstance.ViewInstance {
        private final categoryViewGeneric parent;
        private final UISWTView view;
        private Composite composite;

        categoryViewGenericInstance(categoryViewGeneric _parent, UISWTView _view) {
            this.parent = _parent;
            this.view = _view;
            this.view.setTitle(this.parent.getTitle(true));
        }

        @Override
        public void initialize(Composite parent_composite) {
            this.composite = new Composite(parent_composite, 0);
            FormLayout layout = new FormLayout();
            layout.marginTop = 2;
            layout.marginLeft = 2;
            layout.marginRight = 2;
            layout.marginBottom = 2;
            this.composite.setLayout((Layout)layout);
            FormData data = new FormData();
            data.left = new FormAttachment(0, 0);
            data.right = new FormAttachment(100, 0);
            data.top = new FormAttachment((Control)this.composite, 0);
            data.bottom = new FormAttachment(100, 0);
            Label label = new Label(this.composite, 0);
            label.setText("Nothing to show for " + this.parent.getTitle());
            label.setLayoutData((Object)data);
        }

        @Override
        public void updateLanguage() {
            Messages.updateLanguageForControl((Widget)this.composite);
        }
    }

    private static class deviceItem {
        private DeviceView view;
        private MdiEntry sb_entry;
        private boolean destroyed;
        private MdiEntryVitalityImage warning;
        private MdiEntryVitalityImage spinner;
        private MdiEntryVitalityImage info;

        protected deviceItem() {
        }

        protected void setMdiEntry(MdiEntry _sb_entry) {
            this.sb_entry = _sb_entry;
            this.warning = this.sb_entry.addVitalityImage(DeviceManagerUI.ALERT_IMAGE_ID);
            DeviceManagerUI.hideIcon(this.warning);
            this.spinner = this.sb_entry.addVitalityImage(DeviceManagerUI.SPINNER_IMAGE_ID);
            DeviceManagerUI.hideIcon(this.spinner);
            this.info = this.sb_entry.addVitalityImage(DeviceManagerUI.INFO_IMAGE_ID);
            DeviceManagerUI.hideIcon(this.info);
        }

        protected MdiEntry getMdiEntry() {
            return this.sb_entry;
        }

        protected void setView(DeviceView _view) {
            this.view = _view;
        }

        protected DeviceView getView() {
            return this.view;
        }

        protected void setStatus(Device device) {
            if (this.warning != null && this.info != null) {
                String error = device.getError();
                if (error != null) {
                    DeviceManagerUI.hideIcon(this.info);
                    this.warning.setToolTip(error);
                    this.warning.setImageID(DeviceManagerUI.ALERT_IMAGE_ID);
                    this.warning.setVisible(true);
                } else {
                    DeviceManagerUI.hideIcon(this.warning);
                    String info_str = device.getInfo();
                    if (info_str != null) {
                        DeviceManagerUI.showIcon(this.info, info_str);
                    } else {
                        DeviceManagerUI.hideIcon(this.info);
                    }
                }
            }
            if (this.spinner != null) {
                this.spinner.setVisible(device.isBusy());
            }
            if (this.view != null) {
                this.view.refreshTitles();
            }
        }

        protected boolean isDestroyed() {
            return this.destroyed;
        }

        protected void destroy() {
            if (!this.destroyed) {
                this.destroyed = true;
                if (this.sb_entry != null) {
                    this.sb_entry.closeView();
                }
            }
        }
    }
}

