/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.devices;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.devices.DeviceMediaRenderer;
import com.biglybt.core.devices.TranscodeException;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.installer.PluginInstaller;
import com.biglybt.pif.installer.StandardPlugin;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mdi.BaseMDI;
import com.biglybt.ui.swt.mdi.BaseMdiEntry;
import com.biglybt.ui.swt.skin.SWTSkinObject;
import com.biglybt.ui.swt.views.skin.SkinView;
import com.biglybt.ui.swt.views.utils.ManagerUtils;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class DeviceInfoArea
extends SkinView {
    private DeviceMediaRenderer device;
    private Composite main;
    private Composite parent;

    @Override
    public Object skinObjectInitialShow(SWTSkinObject skinObject, Object params) {
        BaseMdiEntry entry = BaseMDI.getEntryFromSkinObject(skinObject);
        if (entry != null) {
            this.device = (DeviceMediaRenderer)entry.getDataSource();
        }
        this.parent = (Composite)skinObject.getControl();
        return null;
    }

    @Override
    public Object skinObjectShown(SWTSkinObject skinObject, Object params) {
        super.skinObjectShown(skinObject, params);
        if (this.device == null) {
            this.initDeviceOverview();
        } else {
            this.initDeviceView();
        }
        return null;
    }

    @Override
    public Object skinObjectHidden(SWTSkinObject skinObject, Object params) {
        Utils.disposeComposite(this.main);
        return super.skinObjectHidden(skinObject, params);
    }

    private void initDeviceView() {
        this.main = new Composite(this.parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        layout.marginTop = 4;
        layout.marginBottom = 4;
        layout.marginHeight = 4;
        layout.marginWidth = 4;
        this.main.setLayout((Layout)layout);
        this.main.setLayoutData((Object)Utils.getFilledFormData());
        Composite control = new Composite(this.main, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginLeft = 0;
        control.setLayout((Layout)layout);
        GridData grid_data = new GridData(768);
        grid_data.horizontalSpan = 1;
        control.setLayoutData((Object)grid_data);
        Label dir_lab = new Label(control, 0);
        dir_lab.setText("Local directory: " + this.device.getWorkingDirectory().getAbsolutePath());
        Button show_folder_button = new Button(control, 8);
        Messages.setLanguageText((Widget)show_folder_button, "MyTorrentsView.menu.explore");
        show_folder_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ManagerUtils.open(DeviceInfoArea.this.device.getWorkingDirectory());
            }
        });
        new Label(control, 0);
        if (this.device.canFilterFilesView()) {
            final Button show_xcode_button = new Button(control, 32);
            Messages.setLanguageText((Widget)show_xcode_button, "devices.xcode.only.show");
            show_xcode_button.setSelection(this.device.getFilterFilesView());
            show_xcode_button.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    DeviceInfoArea.this.device.setFilterFilesView(show_xcode_button.getSelection());
                }
            });
        }
        final Button btnReset = new Button(this.main, 8);
        btnReset.setText("Forget Default Profile Choice");
        btnReset.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                DeviceInfoArea.this.device.setDefaultTranscodeProfile(null);
                btnReset.setEnabled(false);
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        try {
            btnReset.setEnabled(this.device.getDefaultTranscodeProfile() != null);
        }
        catch (TranscodeException e1) {
            btnReset.setEnabled(false);
        }
        btnReset.setLayoutData((Object)new GridData());
        this.parent.getParent().layout();
    }

    protected void initDeviceOverview() {
        final PluginInstaller installer = CoreFactory.getSingleton().getPluginManager().getPluginInstaller();
        boolean hasItunes = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("azitunes") != null;
        this.main = new Composite(this.parent, 0);
        this.main.setLayoutData((Object)Utils.getFilledFormData());
        FormLayout layout = new FormLayout();
        layout.marginHeight = 5;
        layout.marginWidth = 5;
        this.main.setLayout((Layout)layout);
        if (hasItunes) {
            Button itunes_button;
            Button top = itunes_button = new Button(this.main, 0);
            itunes_button.setText("Install iTunes Integration");
            itunes_button.addListener(13, new Listener(){

                public void handleEvent(Event arg0) {
                    try {
                        StandardPlugin itunes_plugin = installer.getStandardPlugin("azitunes");
                        if (itunes_plugin == null) {
                            Debug.out("iTunes standard plugin not found");
                        } else {
                            itunes_plugin.install(false);
                        }
                    }
                    catch (Throwable e) {
                        Debug.printStackTrace(e);
                    }
                }
            });
            FormData fd = new FormData();
            fd.left = new FormAttachment(0, 0);
            fd.top = new FormAttachment(0, 4);
            itunes_button.setLayoutData((Object)fd);
        } else {
            Label lblItunesInstalled;
            Label top = lblItunesInstalled = new Label(this.main, 64);
            lblItunesInstalled.setText("iTunes support is available");
        }
        Constants.isCVSVersion();
        this.parent.getParent().layout();
    }
}

