/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.core.nwmadmin;

import com.biglybt.core.Core;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.networkmanager.admin.impl.NetworkAdminImpl;
import com.biglybt.core.util.AERunnable;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ui.UIInstance;
import com.biglybt.pif.ui.UIManagerListener;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemFillListener;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.common.updater.UIUpdater;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.pif.UISWTInstance;
import com.biglybt.ui.swt.pif.UISWTStatusEntry;
import com.biglybt.ui.swt.pif.UISWTStatusEntryListener;
import com.biglybt.ui.swt.views.stats.StatsView;
import org.eclipse.swt.graphics.Image;

public class NetworkAdminSWTImpl {
    private final NetworkAdminImpl network_admin;
    private UISWTStatusEntry status;
    private Image icon_grey;
    private Image icon_green;
    private Image icon_yellow;
    private Image icon_red;
    private Image last_icon;
    private String last_tip;
    private volatile boolean is_visible;
    private UIUpdater.UIUpdaterListener uiUpdaterListener;
    private ParameterListener configBindIPListener;

    public NetworkAdminSWTImpl(Core _core, NetworkAdminImpl _network_admin) {
        this.network_admin = _network_admin;
        final PluginInterface default_pi = PluginInitializer.getDefaultInterface();
        default_pi.getUIManager().addUIListener(new UIManagerListener(){

            @Override
            public void UIAttached(final UIInstance instance) {
                if (instance instanceof UISWTInstance) {
                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                    if (uif != null) {
                        NetworkAdminSWTImpl.this.uiUpdaterListener = new UIUpdater.UIUpdaterListener(){

                            @Override
                            public void updateComplete(int count) {
                                NetworkAdminSWTImpl.this.updateStatus();
                            }
                        };
                        uif.getUIUpdater().addListener(NetworkAdminSWTImpl.this.uiUpdaterListener);
                    }
                    Utils.execSWTThread(new AERunnable(){

                        @Override
                        public void runSupport() {
                            ImageLoader imageLoader = ImageLoader.getInstance();
                            NetworkAdminSWTImpl.this.icon_grey = imageLoader.getImage("st_net_grey");
                            NetworkAdminSWTImpl.this.icon_yellow = imageLoader.getImage("st_net_yellow");
                            NetworkAdminSWTImpl.this.icon_green = imageLoader.getImage("st_net_green");
                            NetworkAdminSWTImpl.this.icon_red = imageLoader.getImage("st_net_red");
                            UISWTInstance ui_instance = (UISWTInstance)instance;
                            NetworkAdminSWTImpl.this.status = ui_instance.createStatusEntry();
                            NetworkAdminSWTImpl.this.status.setText(MessageText.getString("label.routing"));
                            NetworkAdminSWTImpl.this.status.setImageEnabled(true);
                            NetworkAdminSWTImpl.this.status.setImage(NetworkAdminSWTImpl.this.icon_grey);
                            String icon_param = "Show IP Bindings Icon";
                            final MenuItem mi_show = default_pi.getUIManager().getMenuManager().addMenuItem(NetworkAdminSWTImpl.this.status.getMenuContext(), "pairing.ui.icon.show");
                            mi_show.setStyle(2);
                            mi_show.setData(false);
                            mi_show.addListener(new MenuItemListener(){

                                @Override
                                public void selected(MenuItem menu, Object target) {
                                    COConfigurationManager.setParameter("Show IP Bindings Icon", false);
                                }
                            });
                            NetworkAdminSWTImpl.this.configBindIPListener = new ParameterListener(){

                                @Override
                                public void parameterChanged(String parameterName) {
                                    String bind_ip = COConfigurationManager.getStringParameter("Bind IP", "").trim();
                                    NetworkAdminSWTImpl.this.is_visible = bind_ip.trim().length() > 0 && COConfigurationManager.getBooleanParameter("Show IP Bindings Icon");
                                    NetworkAdminSWTImpl.this.status.setVisible(NetworkAdminSWTImpl.this.is_visible);
                                    mi_show.setData(NetworkAdminSWTImpl.this.is_visible);
                                    if (NetworkAdminSWTImpl.this.is_visible) {
                                        NetworkAdminSWTImpl.this.updateStatus();
                                    }
                                }
                            };
                            COConfigurationManager.addAndFireParameterListeners(new String[]{"Bind IP", "Show IP Bindings Icon"}, NetworkAdminSWTImpl.this.configBindIPListener);
                            MenuItem mi_sep1 = default_pi.getUIManager().getMenuManager().addMenuItem(NetworkAdminSWTImpl.this.status.getMenuContext(), "sep1");
                            mi_sep1.setStyle(4);
                            MenuItem mi_reset = default_pi.getUIManager().getMenuManager().addMenuItem(NetworkAdminSWTImpl.this.status.getMenuContext(), "menu.remove.net.binding");
                            mi_reset.addFillListener(new MenuItemFillListener(){

                                @Override
                                public void menuWillBeShown(MenuItem mi, Object data) {
                                    mi.setText(MessageText.getString("menu.remove.net.binding", new String[]{COConfigurationManager.getStringParameter("Bind IP", "")}));
                                }
                            });
                            mi_reset.addListener(new MenuItemListener(){

                                @Override
                                public void selected(MenuItem menu, Object target) {
                                    COConfigurationManager.setParameter("Enforce Bind IP", false);
                                    COConfigurationManager.setParameter("Bind IP", "");
                                    COConfigurationManager.save();
                                }
                            });
                            MenuItem mi_sep2 = default_pi.getUIManager().getMenuManager().addMenuItem(NetworkAdminSWTImpl.this.status.getMenuContext(), "sep2");
                            mi_sep2.setStyle(4);
                            MenuItem mi_options = default_pi.getUIManager().getMenuManager().addMenuItem(NetworkAdminSWTImpl.this.status.getMenuContext(), "MainWindow.menu.view.configuration");
                            mi_options.addListener(new MenuItemListener(){

                                @Override
                                public void selected(MenuItem menu, Object target) {
                                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                                    if (uif != null) {
                                        uif.getMDI().showEntryByID("ConfigView", "connection.advanced");
                                    }
                                }
                            });
                            UISWTStatusEntryListener click_listener = new UISWTStatusEntryListener(){

                                @Override
                                public void entryClicked(UISWTStatusEntry entry) {
                                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                                    if (uif != null) {
                                        uif.getMDI().loadEntryByID(StatsView.VIEW_ID, true, false, "TransferStatsView");
                                    }
                                }
                            };
                            NetworkAdminSWTImpl.this.status.setListener(click_listener);
                        }
                    });
                }
            }

            @Override
            public void UIDetached(UIInstance instance) {
                if (instance instanceof UISWTInstance) {
                    UIFunctions uif = UIFunctionsManager.getUIFunctions();
                    if (uif != null && NetworkAdminSWTImpl.this.uiUpdaterListener != null) {
                        uif.getUIUpdater().removeListener(NetworkAdminSWTImpl.this.uiUpdaterListener);
                        NetworkAdminSWTImpl.this.uiUpdaterListener = null;
                    }
                    if (NetworkAdminSWTImpl.this.status != null) {
                        NetworkAdminSWTImpl.this.status.destroy();
                        NetworkAdminSWTImpl.this.status = null;
                    }
                    if (NetworkAdminSWTImpl.this.configBindIPListener != null) {
                        COConfigurationManager.removeParameterListener("Show IP Bindings Icon", NetworkAdminSWTImpl.this.configBindIPListener);
                        COConfigurationManager.removeParameterListener("Bind IP", NetworkAdminSWTImpl.this.configBindIPListener);
                        NetworkAdminSWTImpl.this.configBindIPListener = null;
                    }
                }
            }
        });
    }

    private void updateStatus() {
        if (!this.is_visible) {
            return;
        }
        Object[] bs_status = this.network_admin.getBindingStatus();
        int bs_state = (Integer)bs_status[0];
        String tip = (String)bs_status[1];
        Image icon = bs_state == 0 ? this.icon_grey : (bs_state == 1 ? this.icon_green : (bs_state == 2 ? this.icon_yellow : this.icon_red));
        if (this.last_icon != icon || !tip.equals(this.last_tip)) {
            final Image f_icon = icon;
            final String f_tip = tip;
            Utils.execSWTThread(new AERunnable(){

                @Override
                public void runSupport() {
                    NetworkAdminSWTImpl.this.last_icon = f_icon;
                    NetworkAdminSWTImpl.this.last_tip = f_tip;
                    NetworkAdminSWTImpl.this.status.setImage(f_icon);
                    Utils.setTT(NetworkAdminSWTImpl.this.status, f_tip);
                }
            });
        }
    }
}

