/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.config.wizard;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ipc.IPCInterface;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.config.wizard.ConfigureWizard;
import com.biglybt.ui.swt.config.wizard.FinishPanel;
import com.biglybt.ui.swt.config.wizard.NatPanel;
import com.biglybt.ui.swt.wizard.AbstractWizardPanel;
import com.biglybt.ui.swt.wizard.IWizardPanel;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Widget;

public class TransferPanel2
extends AbstractWizardPanel<ConfigureWizard> {
    private static final int kbit = 1000;
    private static final int mbit = 1000000;
    private static final int[] connection_rates;
    private volatile boolean test_in_progress;
    private boolean manual_mode;
    private Label uprate_label;

    static {
        int[] nArray = new int[19];
        nArray[1] = 28800;
        nArray[2] = 56000;
        nArray[3] = 64000;
        nArray[4] = 96000;
        nArray[5] = 128000;
        nArray[6] = 192000;
        nArray[7] = 256000;
        nArray[8] = 384000;
        nArray[9] = 512000;
        nArray[10] = 640000;
        nArray[11] = 768000;
        nArray[12] = 1000000;
        nArray[13] = 2000000;
        nArray[14] = 5000000;
        nArray[15] = 10000000;
        nArray[16] = 20000000;
        nArray[17] = 50000000;
        nArray[18] = 100000000;
        connection_rates = nArray;
    }

    public TransferPanel2(ConfigureWizard wizard, IWizardPanel previous) {
        super(wizard, previous);
    }

    @Override
    public void show() {
        ((ConfigureWizard)this.wizard).setTitle(MessageText.getString("configureWizard.transfer.title"));
        ((ConfigureWizard)this.wizard).setCurrentInfo(MessageText.getString("configureWizard.transfer2.hint"));
        final Composite rootPanel = ((ConfigureWizard)this.wizard).getPanel();
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        rootPanel.setLayout((Layout)layout);
        Composite panel = new Composite(rootPanel, 0);
        GridData gridData = new GridData(1808);
        panel.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        panel.setLayout((Layout)layout);
        Label label = new Label(panel, 64);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        label.setLayoutData((Object)gridData);
        Messages.setLanguageText((Widget)label, "configureWizard.transfer2.message");
        Group gRadio = Utils.createSkinnedGroup(panel, 0);
        Messages.setLanguageText((Widget)gRadio, "configureWizard.transfer2.group");
        gRadio.setLayoutData((Object)gridData);
        layout = new GridLayout();
        layout.numColumns = 2;
        gRadio.setLayout((Layout)layout);
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        gRadio.setLayoutData((Object)gridData);
        Button auto_button = new Button((Composite)gRadio, 16);
        Messages.setLanguageText((Widget)auto_button, "auto.mode");
        auto_button.setSelection(true);
        new Label((Composite)gRadio, 0);
        label = new Label((Composite)gRadio, 0);
        Messages.setLanguageText((Widget)label, "configureWizard.transfer2.test.info");
        final Button speed_test = new Button((Composite)gRadio, 0);
        Messages.setLanguageText((Widget)speed_test, "configureWizard.transfer2.test");
        final SelectionAdapter speed_test_listener = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent arg0) {
                speed_test.setEnabled(false);
                TransferPanel2.this.test_in_progress = true;
                TransferPanel2.this.updateNextEnabled();
                rootPanel.getShell().setEnabled(false);
                UIFunctionsManager.getUIFunctions().installPlugin("mlab", "dlg.install.mlab", new UIFunctions.actionListener(){

                    @Override
                    public void actionComplete(Object result) {
                        if (result instanceof Boolean) {
                            PluginInterface pi = CoreFactory.getSingleton().getPluginManager().getPluginInterfaceByID("mlab");
                            if (pi == null) {
                                Debug.out("mlab plugin not found");
                                this.enableTest();
                            } else {
                                IPCInterface callback = new IPCInterface(){

                                    @Override
                                    public Object invoke(String methodName, Object[] params) {
                                        try {
                                            int u;
                                            Map results;
                                            Long up_rate;
                                            if (methodName.equals("results") && (up_rate = (Long)(results = (Map)params[0]).get("up")) != null && (u = up_rate.intValue()) > 0) {
                                                Utils.execSWTThread(new Runnable(){

                                                    @Override
                                                    public void run() {
                                                        TransferPanel2.this.updateUp(u, false);
                                                    }
                                                });
                                            }
                                            return null;
                                        }
                                        finally {
                                            this.enableTest();
                                        }
                                    }

                                    @Override
                                    public boolean canInvoke(String methodName, Object[] params) {
                                        return true;
                                    }
                                };
                                try {
                                    pi.getIPC().invoke("runTest", new Object[]{new HashMap(), callback, false});
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                    this.enableTest();
                                }
                            }
                        } else {
                            try {
                                Throwable error = (Throwable)result;
                                Debug.out(error);
                            }
                            finally {
                                this.enableTest();
                            }
                        }
                    }

                    protected void enableTest() {
                        Utils.execSWTThread(new Runnable(){

                            @Override
                            public void run() {
                                speed_test.setEnabled(true);
                                TransferPanel2.this.test_in_progress = false;
                                TransferPanel2.this.updateNextEnabled();
                                rootPanel.getShell().setEnabled(true);
                            }
                        });
                    }
                });
            }
        };
        speed_test.addSelectionListener((SelectionListener)speed_test_listener);
        final Button manual_button = new Button((Composite)gRadio, 16);
        Messages.setLanguageText((Widget)manual_button, "manual.mode");
        new Label((Composite)gRadio, 0);
        final Label manual_label = new Label((Composite)gRadio, 0);
        Messages.setLanguageText((Widget)manual_label, "configureWizard.transfer2.mselect");
        String[] connection_labels = new String[connection_rates.length];
        connection_labels[0] = MessageText.getString("configureWizard.transfer2.current");
        String dial_up = MessageText.getString("dial.up");
        int i = 1;
        while (i < connection_rates.length) {
            connection_labels[i] = String.valueOf(i < 3 ? String.valueOf(dial_up) + " " : "xxx/") + DisplayFormatters.formatByteCountToBitsPerSec2(connection_rates[i] / 8);
            ++i;
        }
        final Combo connection_speed = new Combo((Composite)gRadio, 12);
        int i2 = 0;
        while (i2 < connection_rates.length) {
            connection_speed.add(connection_labels[i2]);
            ++i2;
        }
        connection_speed.select(0);
        connection_speed.addListener(13, new Listener(){

            public void handleEvent(Event arg0) {
                int index = connection_speed.getSelectionIndex();
                TransferPanel2.this.updateUp(connection_rates[index] / 8, true);
            }
        });
        final Label manual2_label = new Label((Composite)gRadio, 64);
        Messages.setLanguageText((Widget)manual2_label, "configureWizard.transfer2.mselect.info");
        gridData = new GridData(768);
        gridData.horizontalSpan = 2;
        manual2_label.setLayoutData((Object)gridData);
        Listener listener = new Listener(){

            public void handleEvent(Event arg0) {
                boolean is_manual = manual_button.getSelection();
                speed_test.setEnabled(!is_manual);
                connection_speed.setEnabled(is_manual);
                manual_label.setEnabled(is_manual);
                manual2_label.setEnabled(is_manual);
                TransferPanel2.this.manual_mode = is_manual;
                TransferPanel2.this.updateNextEnabled();
            }
        };
        manual_button.addListener(13, listener);
        listener.handleEvent(null);
        this.uprate_label = new Label(panel, 64);
        gridData = new GridData(1808);
        gridData.verticalIndent = 10;
        this.uprate_label.setLayoutData((Object)gridData);
        this.updateUp(0, true);
        this.manual_mode = false;
        this.updateNextEnabled();
        if (((ConfigureWizard)this.wizard).getWizardMode() == 1) {
            Utils.execSWTThreadLater(0, new Runnable(){

                @Override
                public void run() {
                    speed_test_listener.widgetSelected(null);
                }
            });
        }
    }

    private void updateUp(int rate, boolean manual) {
        ((ConfigureWizard)this.wizard).setConnectionUploadLimit(rate, manual);
        if (rate == 0) {
            this.uprate_label.setText(MessageText.getString("configureWizard.transfer2.rate.unchanged"));
        } else {
            this.uprate_label.setText(MessageText.getString("configureWizard.transfer2.rate.changed", new String[]{String.valueOf(DisplayFormatters.formatByteCountToBitsPerSec2(rate)) + " (" + DisplayFormatters.formatByteCountToKiBEtcPerSec(rate) + ")", DisplayFormatters.formatByteCountToKiBEtcPerSec(((ConfigureWizard)this.wizard).getUploadLimit()), String.valueOf(((ConfigureWizard)this.wizard).maxActiveTorrents), String.valueOf(((ConfigureWizard)this.wizard).maxDownloads)}));
        }
    }

    private void updateNextEnabled() {
        ((ConfigureWizard)this.wizard).setPreviousEnabled(this.isPreviousEnabled());
        boolean enabled = this.isProgressEnabled();
        if (((ConfigureWizard)this.wizard).getWizardMode() != 0) {
            ((ConfigureWizard)this.wizard).setNextEnabled(false);
            ((ConfigureWizard)this.wizard).setFinishEnabled(enabled);
        } else {
            ((ConfigureWizard)this.wizard).setNextEnabled(enabled);
        }
    }

    public boolean isProgressEnabled() {
        if (this.test_in_progress) {
            return false;
        }
        return this.manual_mode || ((ConfigureWizard)this.wizard).getConnectionUploadLimit() > 0;
    }

    @Override
    public boolean isNextEnabled() {
        return this.isProgressEnabled() && ((ConfigureWizard)this.wizard).getWizardMode() == 0;
    }

    @Override
    public boolean isPreviousEnabled() {
        return !this.test_in_progress && ((ConfigureWizard)this.wizard).getWizardMode() == 0;
    }

    @Override
    public IWizardPanel getFinishPanel() {
        return new FinishPanel((ConfigureWizard)this.wizard, this);
    }

    @Override
    public IWizardPanel getNextPanel() {
        return new NatPanel((ConfigureWizard)this.wizard, this);
    }
}

