/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.config.wizard;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.ui.UserPrompterResultListener;
import com.biglybt.ui.swt.config.wizard.LanguagePanel;
import com.biglybt.ui.swt.config.wizard.TransferPanel2;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.wizard.AbstractWizardPanel;
import com.biglybt.ui.swt.wizard.Wizard;

public class ConfigureWizard
extends Wizard {
    public static final int WIZARD_MODE_FULL = 0;
    public static final int WIZARD_MODE_SPEED_TEST_AUTO = 1;
    public static final int WIZARD_MODE_SPEED_TEST_MANUAL = 2;
    private int wizard_mode;
    private int connectionUploadLimit;
    private boolean uploadLimitManual;
    private int uploadLimit;
    int maxActiveTorrents;
    int maxDownloads;
    int serverTCPListenPort = COConfigurationManager.getIntParameter("TCP.Listen.Port");
    int serverUDPListenPort = COConfigurationManager.getIntParameter("UDP.Listen.Port");
    private String _dataPath;
    private boolean _dataPathChanged;
    String torrentPath;
    boolean completed = false;

    public ConfigureWizard(boolean _modal, int _wizard_mode) {
        super("configureWizard.title", _modal);
        this.wizard_mode = _wizard_mode;
        AbstractWizardPanel panel = this.wizard_mode == 0 ? new LanguagePanel(this, null) : new TransferPanel2(this, null);
        try {
            this.torrentPath = COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory");
        }
        catch (Exception e) {
            this.torrentPath = "";
        }
        this._dataPath = COConfigurationManager.getStringParameter("Default save path");
        this.setFirstPanel(panel);
    }

    @Override
    public void onClose() {
        try {
            if (!this.completed && this.wizard_mode != 1 && !COConfigurationManager.getBooleanParameter("Wizard Completed")) {
                MessageBoxShell mb = new MessageBoxShell(MessageText.getString("wizard.close.confirmation"), MessageText.getString("wizard.close.message"), new String[]{MessageText.getString("Button.yes"), MessageText.getString("Button.no")}, 0);
                mb.open(new UserPrompterResultListener(){

                    @Override
                    public void prompterClosed(int result) {
                        if (result == 1) {
                            COConfigurationManager.setParameter("Wizard Completed", true);
                            COConfigurationManager.save();
                        }
                    }
                });
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        super.onClose();
    }

    protected String getDataPath() {
        return this._dataPath;
    }

    protected void setDataPath(String s) {
        this._dataPath = s;
        this._dataPathChanged = true;
    }

    protected boolean hasDataPathChanged() {
        return this._dataPathChanged;
    }

    protected void setConnectionUploadLimit(int rate, boolean is_manual) {
        this.connectionUploadLimit = rate;
        if (this.connectionUploadLimit != 0) {
            this.uploadLimitManual = is_manual;
            this.uploadLimit = this.connectionUploadLimit / 5 * 4;
            int kInB = DisplayFormatters.getKinB();
            this.uploadLimit = this.uploadLimit / kInB * kInB;
            if (this.uploadLimit < 5 * kInB) {
                this.uploadLimit = 5 * kInB;
            }
            int nbMaxActive = (int)(Math.pow(this.uploadLimit / kInB, 0.34) * 0.92);
            int nbMaxUploads = (int)(Math.pow(this.uploadLimit / kInB, 0.25) * 1.68);
            int nbMaxDownloads = nbMaxActive * 4 / 5;
            if (nbMaxDownloads == 0) {
                nbMaxDownloads = 1;
            }
            if (nbMaxUploads > 50) {
                nbMaxUploads = 50;
            }
            this.maxActiveTorrents = nbMaxActive;
            this.maxDownloads = nbMaxDownloads;
        } else {
            this.uploadLimitManual = false;
            this.uploadLimit = 0;
            this.maxActiveTorrents = 0;
            this.maxDownloads = 0;
        }
    }

    protected int getConnectionUploadLimit() {
        return this.connectionUploadLimit;
    }

    protected int getUploadLimit() {
        return this.uploadLimit;
    }

    protected boolean isUploadLimitManual() {
        return this.uploadLimitManual;
    }

    protected int getWizardMode() {
        return this.wizard_mode;
    }
}

