/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.config;

import com.biglybt.core.util.SimpleTimer;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimerEvent;
import com.biglybt.core.util.TimerEventPerformer;
import com.biglybt.pif.ui.config.IntParameter;
import com.biglybt.pif.ui.config.ParameterValidator;
import com.biglybt.pifimpl.local.ui.config.IntParameterImpl;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.config.BaseSwtParameter;
import com.biglybt.ui.swt.config.SwtConfigParameterValueProcessor;
import com.biglybt.ui.swt.config.SwtParameter;
import com.biglybt.ui.swt.config.SwtParameterValueProcessor;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Widget;

public class IntSwtParameter
extends BaseSwtParameter<IntSwtParameter, Integer> {
    private int valueWhenBlank;
    private Color colorHidden;
    private Label lblSuffix;
    private int iMinValue;
    private int iMaxValue;
    private boolean bTriggerOnFocusOut = false;
    private final Spinner spinner;
    private TimerEvent timedSaveEvent = null;
    private TimerEventPerformer timerEventSave;
    private boolean isZeroHidden = false;
    private boolean disableTimedSave = false;

    public IntSwtParameter(Composite composite, IntParameterImpl param) {
        this(composite, param.getConfigKeyName(), param.getLabelKey(), param.getSuffixLabelKey(), param.isLimited() ? param.getMinValue() : Integer.MIN_VALUE, param.isLimited() ? param.getMaxValue() : Integer.MAX_VALUE, param.isStoredAsString() ? new ValueProcessor(){

            @Override
            public Integer getValue(IntSwtParameter p) {
                return null;
            }

            @Override
            public boolean setValue(IntSwtParameter p, Integer value) {
                return false;
            }
        } : null);
        boolean storedAsString = param.isStoredAsString();
        if (storedAsString) {
            this.isZeroHidden = true;
            this.valueWhenBlank = param.getValueWhenBlank();
            SwtConfigParameterValueProcessor vp = new SwtConfigParameterValueProcessor(this, this.paramID, String.class){

                @Override
                public Object getValue(SwtParameter p) {
                    String valFromConfig = (String)super.getValue(p);
                    int val = IntSwtParameter.this.valueWhenBlank;
                    try {
                        if (!valFromConfig.isEmpty()) {
                            val = Integer.parseInt(valFromConfig);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    return val;
                }

                @Override
                public boolean setValue(SwtParameter p, Object value) {
                    int newVal = ((Number)value).intValue();
                    return super.setValue(p, "" + newVal);
                }
            };
            this.setValueProcessor(vp);
        }
        this.setPluginParameter(param);
    }

    public IntSwtParameter(Composite composite, String paramID, String labelKey, String suffixKey, SwtParameterValueProcessor<IntSwtParameter, Integer> valueProcessor) {
        this(composite, paramID, labelKey, suffixKey, Integer.MIN_VALUE, Integer.MAX_VALUE, valueProcessor);
    }

    public IntSwtParameter(Composite composite, String paramID, String labelKey, String suffixLabelKey, int minValue, int maxValue, SwtParameterValueProcessor<IntSwtParameter, Integer> valueProcessor) {
        super(paramID);
        Composite parent;
        if (maxValue < minValue) {
            this.debug("max < min, not good");
            maxValue = Integer.MAX_VALUE;
        }
        this.iMaxValue = maxValue;
        this.iMinValue = minValue;
        this.timerEventSave = new TimerEventPerformer(){

            @Override
            public void perform(TimerEvent event2) {
                Utils.execSWTThread(() -> {
                    if (IntSwtParameter.this.spinner.isDisposed()) {
                        return;
                    }
                    IntSwtParameter.this.setValue(IntSwtParameter.this.spinner.getSelection());
                });
            }
        };
        this.createStandardLabel(composite, labelKey);
        if (suffixLabelKey == null) {
            parent = composite;
        } else {
            parent = new Composite(composite, 0);
            GridLayout gridLayout = new GridLayout(2, false);
            gridLayout.marginWidth = 0;
            gridLayout.marginHeight = 0;
            parent.setLayout((Layout)gridLayout);
            if (this.doGridData(composite)) {
                parent.setLayoutData((Object)new GridData(768));
            }
        }
        this.spinner = new Spinner(parent, 133120);
        this.setMainControl((Control)this.spinner);
        Color cFG = this.spinner.getForeground();
        Color cBG = this.spinner.getBackground();
        this.colorHidden = new Color(cFG.getDevice(), (cFG.getRed() + cBG.getRed() * 2) / 3, (cFG.getGreen() + cBG.getGreen() * 2) / 3, (cFG.getBlue() + cBG.getBlue() * 2) / 3);
        this.spinner.addListener(12, event2 -> this.colorHidden.dispose());
        this.spinner.setMinimum(minValue);
        this.spinner.setMaximum(maxValue);
        if (this.doGridData(composite)) {
            GridData gridData = new GridData();
            this.spinner.setLayoutData((Object)gridData);
        }
        if (suffixLabelKey != null) {
            this.lblSuffix = new Label(parent, 64);
            Messages.setLanguageText((Widget)this.lblSuffix, suffixLabelKey);
            this.lblSuffix.setLayoutData((Object)Utils.getWrappableLabelGridData(1, 768));
            ClipboardCopy.addCopyToClipMenu((Control)this.lblSuffix);
        }
        if (valueProcessor != null) {
            this.setValueProcessor(valueProcessor);
        } else if (paramID != null) {
            this.setConfigValueProcessor(Integer.class);
        }
        this.spinner.addListener(13, event2 -> {
            if (!this.spinner.isFocusControl()) {
                this.setValue(this.spinner.getSelection());
            } else {
                this.bTriggerOnFocusOut = true;
                this.cancelTimedSaveEvent();
                if (!this.disableTimedSave) {
                    this.timedSaveEvent = SimpleTimer.addEvent("IntParam Saver", SystemTime.getOffsetTime(750L), this.timerEventSave);
                }
            }
        });
        this.spinner.addListener(24, event2 -> {
            String text = this.spinner.getText();
            try {
                int val = text.isEmpty() ? this.valueWhenBlank : Integer.parseInt(text);
                this.validate(val);
            }
            catch (Throwable t) {
                this.updateControl(new ParameterValidator.ValidationInfo(false, t.getMessage()));
            }
        });
        this.spinner.addListener(16, event2 -> {
            if (this.bTriggerOnFocusOut) {
                this.cancelTimedSaveEvent();
                this.setValue(this.spinner.getSelection());
            }
        });
    }

    private void cancelTimedSaveEvent() {
        if (!(this.timedSaveEvent == null || this.timedSaveEvent.hasRun() && this.timedSaveEvent.isCancelled())) {
            this.timedSaveEvent.cancel();
        }
    }

    public void setMinimumValue(int value) {
        if (this.iMinValue == value) {
            return;
        }
        Utils.execSWTThread(() -> {
            this.iMinValue = value;
            this.spinner.setMinimum(value);
            if (this.iMinValue != Integer.MIN_VALUE && this.getIntValue() < this.iMinValue) {
                this.setValue(this.iMinValue);
            }
        });
    }

    public void setMaximumValue(int value) {
        if (this.iMaxValue == value) {
            return;
        }
        Utils.execSWTThread(() -> {
            this.iMaxValue = value;
            this.spinner.setMaximum(value);
            if (this.iMaxValue != Integer.MAX_VALUE && this.getIntValue() > this.iMaxValue) {
                this.setValue(this.iMaxValue);
            }
        });
    }

    @Override
    public ParameterValidator.ValidationInfo validate(Integer newValue) {
        ParameterValidator.ValidationInfo validationInfo = null;
        if (this.iMaxValue != Integer.MAX_VALUE && newValue > this.iMaxValue) {
            validationInfo = new ParameterValidator.ValidationInfo(false, "Max " + this.iMaxValue);
        } else if (this.iMinValue != Integer.MIN_VALUE && newValue < this.iMinValue) {
            validationInfo = new ParameterValidator.ValidationInfo(false, "Min " + this.iMinValue);
        }
        if (validationInfo == null) {
            return super.validate(newValue);
        }
        this.updateControl(validationInfo);
        return validationInfo;
    }

    @Override
    public void refreshControl() {
        super.refreshControl();
        Utils.execSWTThread(() -> {
            Integer value;
            if (this.spinner.isDisposed()) {
                return;
            }
            this.refreshSuffixControl((Control)this.lblSuffix);
            if (this.pluginParam instanceof IntParameter) {
                IntParameter param = (IntParameter)this.pluginParam;
                this.setMinimumValue(param.isLimited() ? param.getMinValue() : Integer.MIN_VALUE);
                this.setMaximumValue(param.isLimited() ? param.getMaxValue() : Integer.MAX_VALUE);
            }
            if ((value = (Integer)this.getValue()) == null) {
                return;
            }
            if (this.spinner.getSelection() != value.intValue()) {
                this.spinner.setSelection(value.intValue());
            }
            if (this.isZeroHidden) {
                this.spinner.setForeground(value == 0 ? this.colorHidden : null);
            }
        });
    }

    public int getIntValue() {
        Integer value = (Integer)this.getValue();
        if (value == null) {
            return 0;
        }
        return value;
    }

    @Override
    public Control[] getControls() {
        if (this.lblSuffix == null) {
            return super.getControls();
        }
        ArrayList<Control> list = new ArrayList<Control>(Arrays.asList(super.getControls()));
        list.add((Control)this.lblSuffix);
        return list.toArray(new Control[0]);
    }

    public void disableTimedSave() {
        this.disableTimedSave = true;
    }

    public boolean isZeroHidden() {
        return this.isZeroHidden;
    }

    public void setZeroHidden(boolean isZeroHidden) {
        if (this.isZeroHidden == isZeroHidden) {
            return;
        }
        this.isZeroHidden = isZeroHidden;
        this.refreshControl();
    }

    public void setSuffixLabelKey(String suffixLabelKey) {
        if (this.lblSuffix == null) {
            return;
        }
        Utils.execSWTThread(() -> {
            if (this.lblSuffix.isDisposed()) {
                return;
            }
            Messages.updateLanguageKey((Widget)this.lblSuffix, suffixLabelKey, new String[0]);
        });
    }

    public void setSuffixLabelText(String text) {
        this.setSuffixLabelKey("!" + text + "!");
    }

    public static interface ValueProcessor
    extends SwtParameterValueProcessor<IntSwtParameter, Integer> {
    }
}

