/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.config;

import com.biglybt.pif.ui.config.ActionParameter;
import com.biglybt.pifimpl.local.ui.config.ActionParameterImpl;
import com.biglybt.pifimpl.local.ui.config.ParameterImpl;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.config.BaseSwtParameter;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.widgets.ButtonWithMinWidth;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.swt.widgets.Widget;

public class ButtonSwtParameter
extends BaseSwtParameter<ButtonSwtParameter, Object> {
    Button button;

    public ButtonSwtParameter(Composite composite, ActionParameterImpl pluginParam) {
        super(null);
        this.createStandardLabel(composite, pluginParam.getLabelKey());
        String button_key = pluginParam.getActionResource();
        String image_id = pluginParam.getImageID();
        int width = 40;
        if (image_id == null) {
            image_id = "";
        }
        if (button_key.isEmpty() && !image_id.isEmpty()) {
            ToolBar toolBar = new ToolBar(composite, 0x800000);
            ToolItem item = new ToolItem(toolBar, 8);
            item.setImage(ImageLoader.getInstance().getImage(image_id));
            item.addListener(13, ev -> {
                toolBar.forceFocus();
                this.triggerChangeListeners(true);
            });
        } else {
            ButtonWithMinWidth button = new ButtonWithMinWidth(composite, 8, width);
            this.setMainControl((Control)button);
            Messages.setLanguageText((Widget)button, button_key);
            if (!image_id.isEmpty()) {
                button.setImage(ImageLoader.getInstance().getImage(image_id));
            }
            button.addListener(13, event2 -> {
                button.forceFocus();
                this.triggerChangeListeners(true);
            });
        }
        this.setPluginParameter(pluginParam);
    }

    @Override
    protected void triggerSubClassChangeListeners() {
        if (this.pluginParam instanceof ParameterImpl) {
            ((ParameterImpl)this.pluginParam).fireParameterChanged();
        }
    }

    @Override
    public void refreshControl() {
        super.refreshControl();
        if (this.pluginParam instanceof ActionParameter) {
            Utils.execSWTThread(() -> {
                if (this.button == null || this.button.isDisposed()) {
                    return;
                }
                if (Messages.updateLanguageKey((Widget)this.button, ((ActionParameter)this.pluginParam).getActionResource(), new String[0])) {
                    Utils.relayout((Control)this.button);
                }
            });
        }
    }
}

