/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.components.shell;

import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Constants;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.UIFunctionsSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.shell.ShellManager;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class ShellFactory {
    public static Shell createMainShell(int styles) {
        Shell parent = null;
        UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
        if (uiFunctions != null) {
            parent = uiFunctions.getMainShell();
        }
        if (parent == null) {
            return ShellFactory.createShell(Utils.getDisplay());
        }
        return ShellFactory.createShell(parent, styles);
    }

    public static Shell createShell(Display disp, int styles) {
        return ShellFactory.getRegisteredShell(new AEShell(disp, styles));
    }

    public static Shell createShell(Display disp) {
        return ShellFactory.getRegisteredShell(new AEShell(disp));
    }

    public static Shell createShell(Shell parent, int styles) {
        if (parent != null && parent.isDisposed()) {
            return null;
        }
        return ShellFactory.getRegisteredShell(new AEShell(parent, styles));
    }

    public static Shell createShell(Shell parent) {
        return ShellFactory.getRegisteredShell(new AEShell(parent));
    }

    public static Shell createShell(int styles) {
        return ShellFactory.getRegisteredShell(new AEShell(styles));
    }

    private static Shell getRegisteredShell(Shell toRegister) {
        if (toRegister == null) {
            return null;
        }
        if (Constants.isOSX) {
            UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
            if (uiFunctions == null) {
                System.err.println("Main window is not initialized yet");
            } else {
                uiFunctions.createMainMenu(toRegister);
            }
        }
        ShellManager.sharedManager().addWindow(toRegister);
        return toRegister;
    }

    public static class AEShell
    extends Shell {
        private boolean inSetSize = false;

        private AEShell(int styles) {
            super(styles);
        }

        private AEShell(Display display) {
            super(display);
        }

        private AEShell(Display display, int styles) {
            super(display, AEShell.fixupStyle(styles));
        }

        private AEShell(Shell parent) {
            super(parent);
        }

        private AEShell(Shell parent, int styles) {
            super(parent, AEShell.fixupStyle(styles));
        }

        private static int fixupStyle(int style) {
            UIFunctionsSWT uiFunctions;
            if ((style & 0x38000) != 0 && Utils.anyShellHaveStyle(16416) && (uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT()) != null && uiFunctions.getMainShell() != null) {
                style |= 0x4000;
            }
            return style;
        }

        protected void checkSubclass() {
        }

        public void setImage(Image image) {
            if (!Constants.isOSX) {
                super.setImage(image);
            }
        }

        public void setImages(Image[] images) {
            if (!Constants.isOSX) {
                super.setImages(images);
            }
        }

        public Point computeSize(int wHint, int hHint) {
            if (!this.inSetSize && wHint > 0 && hHint == -1) {
                this.inSetSize = true;
                return super.computeSize(wHint, hHint);
            }
            return super.computeSize(wHint, hHint);
        }

        public void setAdjustPXforDPI(boolean adjust) {
            this.inSetSize = !adjust;
        }

        public void setSize(int width, int height) {
            if (this.inSetSize) {
                super.setSize(width, height);
                return;
            }
            this.inSetSize = true;
            try {
                super.setSize(width, height);
            }
            finally {
                this.inSetSize = false;
            }
        }

        public void pack() {
            this.inSetSize = true;
            try {
                super.pack();
            }
            finally {
                this.inSetSize = false;
            }
        }

        public void setSize(Point size) {
            if (this.inSetSize) {
                super.setSize(size);
                return;
            }
            this.inSetSize = true;
            try {
                super.setSize(size);
            }
            finally {
                this.inSetSize = false;
            }
        }

        public void open() {
            Shell firstShellWithStyle;
            Shell mainShell;
            Boolean bringToFront;
            UIFunctionsSWT uiFunctions = UIFunctionsManagerSWT.getUIFunctionsSWT();
            if (uiFunctions != null && ((bringToFront = (Boolean)this.getData("bringToFront")) == null || bringToFront.booleanValue()) && (mainShell = uiFunctions.getMainShell()) != null && mainShell.getMinimized()) {
                uiFunctions.bringToFront();
            }
            if ((firstShellWithStyle = Utils.findFirstShellWithStyle(65536)) != null && firstShellWithStyle != this) {
                firstShellWithStyle.addDisposeListener(new DisposeListener(){

                    public void widgetDisposed(DisposeEvent e) {
                        Utils.execSWTThreadLater(0, new AERunnable(){

                            @Override
                            public void runSupport() {
                                this.open();
                            }
                        });
                    }
                });
                firstShellWithStyle.setVisible(true);
                firstShellWithStyle.forceActive();
            } else if (!this.isDisposed()) {
                super.open();
            }
        }
    }
}

