/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.components.graphics;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;

public class Scale {
    private boolean wantBinary;
    private boolean useSI;
    private int pixelsPerLevel = 50;
    private int max = 1;
    private int nbLevels;
    private int displayedMax;
    private int nbPixels = 1;
    boolean isSIIECSensitive;
    private int[] scaleValues = new int[0];
    private ParameterListener parameterListener;

    public Scale() {
        this(true);
    }

    public Scale(boolean _isSIIECSensitive) {
        this.isSIIECSensitive = _isSIIECSensitive;
        this.parameterListener = new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                Scale.this.wantBinary = COConfigurationManager.getBooleanParameter("ui.scaled.graphics.binary.based");
                boolean wantSI = COConfigurationManager.getBooleanParameter("config.style.useSIUnits");
                boolean forceSI = COConfigurationManager.getBooleanParameter("config.style.forceSIValues");
                Scale.this.useSI = wantSI || forceSI;
            }
        };
        COConfigurationManager.addWeakParameterListener(this.parameterListener, true, "ui.scaled.graphics.binary.based", "config.style.useSIUnits", "config.style.forceSIValues");
    }

    public void dispose() {
        COConfigurationManager.removeWeakParameterListener(this.parameterListener, "ui.scaled.graphics.binary.based", "config.style.useSIUnits", "config.style.forceSIValues");
    }

    public boolean isSIIECSensitive() {
        return this.isSIIECSensitive;
    }

    public void setMax(int max) {
        this.max = max;
        if (max < 1) {
            max = 1;
        }
        this.computeValues();
    }

    public int getMax() {
        return this.max;
    }

    public void setNbPixels(int nbPixels) {
        this.nbPixels = nbPixels;
        if (nbPixels < 1) {
            nbPixels = 1;
        }
        this.computeValues();
    }

    private void computeValues() {
        int targetNbLevels = this.nbPixels / this.pixelsPerLevel;
        if (targetNbLevels < 1) {
            targetNbLevels = 1;
        }
        double scaleFactor = this.max / targetNbLevels;
        long powFactor = 1L;
        int scaleThing = this.wantBinary ? 2 : 10;
        double scaleMax = this.wantBinary ? 4 : 5;
        while (scaleFactor >= (double)scaleThing) {
            powFactor = (long)scaleThing * powFactor;
            scaleFactor /= (double)scaleThing;
        }
        scaleFactor = scaleFactor >= scaleMax ? scaleMax : (scaleFactor >= 2.0 ? scaleMax / 2.0 : 1.0);
        long increment = (long)(scaleFactor * (double)powFactor);
        if (this.isSIIECSensitive) {
            int divBy = 0;
            int multBy = 0;
            if (this.useSI && !this.wantBinary) {
                divBy = 1000;
                multBy = 1024;
            } else if (!this.useSI && this.wantBinary) {
                divBy = 1024;
                multBy = 1000;
            }
            if (divBy > 0) {
                long temp = increment;
                int pow = -1;
                while (temp > 0L) {
                    temp /= (long)divBy;
                    ++pow;
                }
                long temp2 = 1L;
                long temp3 = 1L;
                int i = 0;
                while (i < pow) {
                    temp2 *= (long)multBy;
                    temp3 *= (long)divBy;
                    ++i;
                }
                increment = (long)((double)increment / (double)temp3 * (double)temp2);
            }
        }
        this.nbLevels = (int)((long)this.max / increment + 1L);
        this.displayedMax = (int)(increment * (long)this.nbLevels);
        int[] result = new int[this.nbLevels + 1];
        int i = 0;
        while (i < this.nbLevels + 1) {
            result[i] = (int)((long)i * increment);
            ++i;
        }
        this.scaleValues = result;
    }

    public int[] getScaleValues() {
        return this.scaleValues;
    }

    public int getScaledValue(int value) {
        return (int)((long)value * (long)this.nbPixels / (long)this.displayedMax);
    }
}

