/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.components.graphics;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.util.AEMonitor;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.graphics.Graphic;
import com.biglybt.ui.swt.components.graphics.ValueFormater;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.mainwindow.HSLColor;
import com.biglybt.ui.swt.utils.ColorCache;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;

public class Plot3D
implements Graphic,
ParameterListener {
    private int Z_MAX = Integer.MAX_VALUE;
    private Canvas canvas;
    private String title = "";
    private String[] labels;
    private ValueFormater[] formatters;
    private int internalLoop;
    private int graphicsUpdate;
    private Point oldSize;
    protected Image bufferImage;
    protected AEMonitor this_mon = new AEMonitor("Plot3D");
    private int[][] values = new int[0][];
    private Color[] colours;

    public Plot3D(String[] _labels, ValueFormater[] _formatters) {
        this.labels = _labels;
        this.formatters = _formatters;
        COConfigurationManager.addAndFireParameterListener("Graphics Update", this);
    }

    @Override
    public void initialize(Canvas _canvas) {
        this.canvas = _canvas;
        Display device = this.canvas.getDisplay();
        this.colours = new Color[16];
        HSLColor hsl = new HSLColor();
        hsl.initHSLbyRGB(130, 240, 240);
        int step = 128 / this.colours.length;
        int hue = this.colours.length * step;
        boolean dark = Utils.isDarkAppearanceNative();
        int i = 0;
        while (i < this.colours.length) {
            hsl.setHue(hue);
            hue -= step;
            Color colour = ColorCache.getColor((Device)device, hsl.getRed(), hsl.getGreen(), hsl.getBlue());
            if (dark) {
                colour = Colors.getInstance().getSlightlyFadedColor(colour);
            }
            this.colours[i] = colour;
            ++i;
        }
        this.canvas.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                if (Plot3D.this.bufferImage != null && !Plot3D.this.bufferImage.isDisposed()) {
                    Rectangle bounds = Plot3D.this.bufferImage.getBounds();
                    if (bounds.width >= e.width + e.x && bounds.height >= e.height + e.y) {
                        e.gc.drawImage(Plot3D.this.bufferImage, e.x, e.y, e.width, e.height, e.x, e.y, e.width, e.height);
                    }
                }
            }
        });
        this.canvas.addListener(11, new Listener(){

            public void handleEvent(Event event2) {
                Plot3D.this.drawPlot();
            }
        });
    }

    public void setTitle(String str) {
        this.title = str;
    }

    public Color[] getColours() {
        return this.colours;
    }

    @Override
    public void refresh(boolean force) {
        if (this.canvas == null || this.canvas.isDisposed() || !this.canvas.isVisible()) {
            return;
        }
        Rectangle bounds = this.canvas.getClientArea();
        if (bounds.height < 30 || bounds.width < 100 || bounds.width > 2000 || bounds.height > 2000) {
            return;
        }
        boolean sizeChanged = this.oldSize == null || this.oldSize.x != bounds.width || this.oldSize.y != bounds.height;
        this.oldSize = new Point(bounds.width, bounds.height);
        ++this.internalLoop;
        if (this.internalLoop > this.graphicsUpdate) {
            this.internalLoop = 0;
        }
        if (this.internalLoop == 0 || sizeChanged || force) {
            this.drawPlot();
        }
        GC gc = new GC((Drawable)this.canvas);
        gc.drawImage(this.bufferImage, bounds.x, bounds.y);
        gc.dispose();
    }

    protected void drawPlot() {
        int PAD_TOP = 10;
        int PAD_BOTTOM = 10;
        int PAD_RIGHT = 10;
        int PAD_LEFT = 10;
        double ANGLE_RADS = 0.7;
        double ANGLE_TAN = Math.tan(0.7);
        try {
            this.this_mon.enter();
            Rectangle bounds = this.canvas.getClientArea();
            if (this.bufferImage != null && !this.bufferImage.isDisposed()) {
                this.bufferImage.dispose();
            }
            if (bounds.isEmpty()) {
                this.bufferImage = null;
                return;
            }
            this.bufferImage = new Image((Device)this.canvas.getDisplay(), bounds);
            GC image = new GC((Drawable)this.bufferImage);
            boolean dark = Utils.isDarkAppearanceNative();
            if (dark) {
                image.setBackground(this.canvas.getBackground());
                image.fillRectangle(bounds);
            }
            int max_x = 0;
            int max_y = 0;
            int max_z = 0;
            int i = 0;
            while (i < this.values.length) {
                int[] entry = this.values[i];
                if (entry[0] > max_x) {
                    max_x = entry[0];
                }
                if (entry[1] > max_y) {
                    max_y = entry[1];
                }
                if (entry[2] > max_z) {
                    max_z = entry[2];
                }
                ++i;
            }
            max_z = Math.min(max_z, this.Z_MAX);
            int usable_width = bounds.width - 10 - 10;
            int usable_height = bounds.height - 10 - 10;
            try {
                image.setAntialias(1);
            }
            catch (Exception exception) {
                // empty catch block
            }
            double x_ratio = ((double)usable_width - (double)((float)usable_height / 2.0f) / ANGLE_TAN) / (double)max_x;
            double y_ratio = (float)usable_height / 2.0f / (float)max_y;
            double z_ratio = (float)usable_height / 2.0f / (float)max_z;
            int x_axis_left_x = 10;
            int x_axis_left_y = usable_height + 10;
            int x_axis_right_x = 10 + usable_width;
            int x_axis_right_y = usable_height + 10;
            int y_axis_left_x = 10;
            int y_axis_left_y = usable_height + 10;
            int y_axis_right_x = 10 + (int)((double)((float)usable_height / 2.0f) / ANGLE_TAN);
            int y_axis_right_y = usable_height / 2;
            int z_axis_bottom_x = 10;
            int z_axis_bottom_y = usable_height + 10;
            int z_axis_top_x = 10;
            int z_axis_top_y = 10 + usable_height / 2;
            Rectangle old_clip = image.getClipping();
            Utils.setClipping(image, new Rectangle(10, 10, usable_width, usable_height));
            image.setForeground(dark ? Colors.dark_grey : Colors.grey);
            int x_lines = 10;
            int i2 = 1;
            while (i2 < x_lines) {
                int x1 = x_axis_left_x + (y_axis_right_x - y_axis_left_x) * i2 / x_lines;
                int y1 = x_axis_left_y - (y_axis_left_y - y_axis_right_y) * i2 / x_lines;
                int x2 = x_axis_right_x;
                int y2 = y1;
                image.drawLine(x1, y1, x2, y2);
                ++i2;
            }
            int y_lines = 10;
            int i3 = 1;
            while (i3 < y_lines) {
                int x1 = y_axis_left_x + (x_axis_right_x - x_axis_left_x) * i3 / x_lines;
                int y1 = y_axis_left_y;
                int x2 = y_axis_right_x + (x_axis_right_x - x_axis_left_x) * i3 / x_lines;
                int y2 = y_axis_right_y;
                image.drawLine(x1, y1, x2, y2);
                ++i3;
            }
            Utils.setClipping(image, old_clip);
            int z_lines = 10;
            int i4 = 1;
            while (i4 < z_lines) {
                int z = z_axis_bottom_y + (z_axis_top_y - z_axis_bottom_y) * i4 / z_lines;
                image.drawLine(z_axis_bottom_x, z, z_axis_bottom_x - 4, z);
                ++i4;
            }
            i4 = 0;
            while (i4 < this.values.length) {
                int[] entry = this.values[i4];
                int z = Math.min(entry[2], this.Z_MAX);
                int draw_x = (int)(x_ratio * (double)entry[0]);
                int draw_y = (int)(y_ratio * (double)entry[1]);
                int draw_z = (int)(z_ratio * (double)z);
                draw_x = (int)((double)draw_x + (double)draw_y / ANGLE_TAN);
                image.setForeground(this.colours[(int)((float)z / (float)max_z * (float)(this.colours.length - 1))]);
                image.drawLine(10 + draw_x, 10 + usable_height - draw_y, 10 + draw_x, 10 + usable_height - (draw_y + draw_z));
                ++i4;
            }
            image.setForeground(dark ? Colors.grey : Colors.black);
            image.drawRectangle(bounds.x, bounds.y, bounds.width - 1, bounds.height - 1);
            int font_height = image.getFontMetrics().getHeight();
            int char_width = image.getFontMetrics().getAverageCharWidth();
            image.drawLine(x_axis_left_x, x_axis_left_y, x_axis_right_x, x_axis_right_y);
            image.drawLine(usable_width, x_axis_right_y - 4, x_axis_right_x, x_axis_right_y);
            image.drawLine(usable_width, x_axis_right_y + 4, x_axis_right_x, x_axis_right_y);
            String x_text = String.valueOf(this.labels[0]) + " - " + this.formatters[0].format(max_x);
            image.drawText(x_text, x_axis_right_x - 20 - x_text.length() * char_width, x_axis_right_y - font_height - 2, 1);
            String z_text = String.valueOf(this.labels[2]) + " - " + this.formatters[2].format(max_z);
            image.drawText(z_text, z_axis_top_x + 4, z_axis_top_y + 10, 1);
            image.drawLine(z_axis_bottom_x, z_axis_bottom_y, z_axis_top_x, z_axis_top_y);
            image.drawLine(z_axis_top_x - 4, z_axis_top_y + 10, z_axis_top_x, z_axis_top_y);
            image.drawLine(z_axis_top_x + 4, z_axis_top_y + 10, z_axis_top_x, z_axis_top_y);
            image.drawLine(y_axis_left_x, y_axis_left_y, y_axis_right_x, y_axis_right_y);
            image.drawLine(y_axis_right_x - 6, y_axis_right_y, y_axis_right_x, y_axis_right_y);
            image.drawLine(y_axis_right_x, y_axis_right_y + 6, y_axis_right_x, y_axis_right_y);
            String y_text = String.valueOf(this.labels[1]) + " - " + this.formatters[1].format(max_y);
            image.drawText(y_text, y_axis_right_x - y_text.length() * char_width, y_axis_right_y - font_height - 2, 1);
            image.drawText(this.title, (bounds.width - this.title.length() * char_width) / 2, 1, 1);
            image.dispose();
        }
        finally {
            this.this_mon.exit();
        }
    }

    public void setMaxZ(int m) {
        this.Z_MAX = m;
    }

    @Override
    public void parameterChanged(String parameter) {
        this.graphicsUpdate = COConfigurationManager.getIntParameter("Graphics Update");
    }

    public void dispose() {
        if (this.bufferImage != null && !this.bufferImage.isDisposed()) {
            this.bufferImage.dispose();
        }
        COConfigurationManager.removeParameterListener("Graphics Update", this);
    }

    public void update(int[][] _values) {
        try {
            this.this_mon.enter();
            this.values = _values;
        }
        finally {
            this.this_mon.exit();
        }
    }
}

