/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.components;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.config.impl.ConfigurationManager;
import com.biglybt.core.util.AERunnable;
import com.biglybt.ui.swt.Messages;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.ui.swt.utils.ColorCache;
import com.biglybt.ui.swt.views.tableitems.pieces.BlocksItem;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowData;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Widget;

public class Legend {
    public static Composite createLegendComposite(Composite panel, Color[] blockColors, String[] keys) {
        return Legend.createLegendComposite(panel, blockColors, keys, true);
    }

    public static Composite createLegendComposite(Composite panel, Color[] blockColors, String[] keys, boolean horizontal) {
        Layout layout = panel.getLayout();
        GridData layoutData = null;
        if (layout instanceof GridLayout) {
            layoutData = new GridData(768);
        }
        return Legend.createLegendComposite(panel, blockColors, keys, null, layoutData, horizontal);
    }

    public static Composite createLegendComposite(Composite panel, Color[] blockColors, String[] keys, Object layoutData) {
        return Legend.createLegendComposite(panel, blockColors, keys, null, layoutData, true);
    }

    public static Composite createLegendComposite(Composite panel, Color[] blockColors, String[] keys, String[] key_texts, Object layoutData, boolean horizontal) {
        return Legend.createLegendComposite(panel, blockColors, keys, key_texts, layoutData, horizontal, null);
    }

    public static Color getLegendColor(String key, String[] keys, Color[] defs) {
        Color def = null;
        int i = 0;
        while (i < keys.length) {
            if (keys[i].equals(key)) {
                def = BlocksItem.colors[i];
            }
            ++i;
        }
        return Legend.getLegendColor(key, def);
    }

    private static Color getLegendColor(String key, Color def) {
        ConfigurationManager config = ConfigurationManager.getInstance();
        int r = config.getIntParameter(String.valueOf(key) + ".red", -1);
        if (r >= 0) {
            int g = config.getIntParameter(String.valueOf(key) + ".green");
            int b = config.getIntParameter(String.valueOf(key) + ".blue");
            return ColorCache.getColor((Device)Utils.getDisplay(), r, g, b);
        }
        return def;
    }

    public static Composite createLegendComposite(final Composite panel, final Color[] blockColors, final String[] keys, final String[] key_texts, final Object layoutData, final boolean horizontal, final LegendListener listener) {
        final ConfigurationManager config = ConfigurationManager.getInstance();
        if (blockColors.length != keys.length) {
            return null;
        }
        final Color[] defaultColors = new Color[blockColors.length];
        final ParameterListener[] paramListeners = new ParameterListener[keys.length];
        System.arraycopy(blockColors, 0, defaultColors, 0, blockColors.length);
        Composite legend = new Composite(panel, 0);
        if (layoutData != null) {
            legend.setLayoutData(layoutData);
        }
        RowLayout layout = new RowLayout(horizontal ? 256 : 512);
        layout.wrap = true;
        layout.marginBottom = 0;
        layout.marginTop = 0;
        layout.marginLeft = 0;
        layout.marginRight = 0;
        layout.marginHeight = 0;
        layout.spacing = 0;
        legend.setLayout((Layout)layout);
        int[] nArray = new int[2];
        nArray[0] = -1;
        final int[] hover_state = nArray;
        int i = 0;
        while (i < blockColors.length) {
            int f_i;
            int r = config.getIntParameter(String.valueOf(keys[i]) + ".red", -1);
            if (r >= 0) {
                Color color;
                int g = config.getIntParameter(String.valueOf(keys[i]) + ".green");
                int b = config.getIntParameter(String.valueOf(keys[i]) + ".blue");
                blockColors[i] = color = ColorCache.getColor((Device)panel.getDisplay(), r, g, b);
            }
            Composite colorSet = new Composite(legend, 0);
            colorSet.setLayout((Layout)new RowLayout(256));
            final Canvas cColor = new Canvas(colorSet, 2048);
            cColor.setData("Index", (Object)new Integer(i));
            Messages.setLanguageTooltip((Widget)cColor, "label.click.to.change.tooltip");
            cColor.addPaintListener(new PaintListener(){

                public void paintControl(PaintEvent e) {
                    int i = (Integer)cColor.getData("Index");
                    e.gc.setBackground(blockColors[i]);
                    e.gc.fillRectangle(e.x, e.y, e.width, e.height);
                }
            });
            cColor.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseUp(MouseEvent e) {
                    Integer iIndex = (Integer)cColor.getData("Index");
                    if (iIndex == null) {
                        return;
                    }
                    int index = iIndex;
                    if (e.button == 1) {
                        RGB rgb = Utils.showColorDialog((Control)panel, blockColors[index].getRGB());
                        if (rgb != null) {
                            config.setRGBParameter(keys[index], rgb.red, rgb.green, rgb.blue, true);
                        }
                    } else {
                        config.removeRGBParameter(keys[index]);
                    }
                }
            });
            final Label lblDesc = new Label(colorSet, 0);
            if (key_texts == null) {
                Messages.setLanguageText((Widget)lblDesc, keys[i]);
            } else {
                lblDesc.setText(key_texts[i]);
            }
            if (listener != null) {
                Messages.setLanguageTooltip((Widget)lblDesc, "label.click.to.showhide.tooltip");
                f_i = i;
                lblDesc.addMouseListener((MouseListener)new MouseAdapter(){

                    public void mouseUp(MouseEvent e) {
                        boolean vis = !config.getBooleanParameter(String.valueOf(keys[f_i]) + ".vis", true);
                        config.setParameter(String.valueOf(keys[f_i]) + ".vis", vis);
                        listener.visibilityChange(vis, f_i);
                        Utils.setSkinnedForeground((Control)lblDesc, vis ? null : (Utils.isDarkAppearanceNative() ? Colors.dark_grey : Colors.grey));
                    }
                });
                boolean vis = config.getBooleanParameter(String.valueOf(keys[f_i]) + ".vis", true);
                if (!vis) {
                    listener.visibilityChange(vis, i);
                    Utils.setSkinnedForeground((Control)lblDesc, Utils.isDarkAppearanceNative() ? Colors.dark_grey : Colors.grey, true);
                }
            }
            RowData data = new RowData();
            data.width = 12;
            data.height = lblDesc.computeSize((int)-1, (int)-1).y - 3;
            cColor.setLayoutData((Object)data);
            paramListeners[i] = new ParameterListener(){

                @Override
                public void parameterChanged(String parameterName) {
                    int j = 0;
                    while (j < keys.length) {
                        if (keys[j].equals(parameterName)) {
                            final int index = j;
                            final int r = config.getIntParameter(String.valueOf(keys[j]) + ".red", -1);
                            if (r >= 0) {
                                final int g = config.getIntParameter(String.valueOf(keys[j]) + ".green");
                                final int b = config.getIntParameter(String.valueOf(keys[j]) + ".blue");
                                Utils.execSWTThread(new AERunnable(){

                                    @Override
                                    public void runSupport() {
                                        Color color;
                                        if (panel == null || panel.isDisposed()) {
                                            return;
                                        }
                                        blockColors[index] = color = ColorCache.getColor((Device)panel.getDisplay(), r, g, b);
                                        cColor.redraw();
                                    }
                                });
                            } else {
                                Utils.execSWTThread(new AERunnable(){

                                    @Override
                                    public void runSupport() {
                                        if (panel == null || panel.isDisposed()) {
                                            return;
                                        }
                                        blockColors[index] = defaultColors[index];
                                        cColor.redraw();
                                    }
                                });
                            }
                        }
                        ++j;
                    }
                }
            };
            config.addParameterListener(keys[i], paramListeners[i]);
            if (listener != null) {
                f_i = i;
                Control[] controls = new Control[]{colorSet, cColor, lblDesc};
                MouseTrackListener ml = new MouseTrackListener(){

                    public void mouseEnter(MouseEvent e) {
                        Legend.handleHover(listener, true, f_i, hover_state);
                    }

                    public void mouseExit(MouseEvent e) {
                        Legend.handleHover(listener, false, f_i, hover_state);
                    }

                    public void mouseHover(MouseEvent e) {
                    }
                };
                Control[] controlArray = controls;
                int n = controls.length;
                int n2 = 0;
                while (n2 < n) {
                    Control c = controlArray[n2];
                    c.addMouseTrackListener(ml);
                    ++n2;
                }
            }
            ++i;
        }
        legend.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                int i = 0;
                while (i < keys.length) {
                    config.removeParameterListener(keys[i], paramListeners[i]);
                    ++i;
                }
            }
        });
        List<Control> legControls = Utils.getAllChildren(legend);
        legControls.add((Control)legend);
        final String keyVis = keys == null || keys.length == 0 ? null : String.valueOf(keys[0]) + ".legend.hidden";
        Listener visListener = event2 -> {
            Composite kidsPanel;
            if (keyVis != null) {
                COConfigurationManager.setParameter(keyVis, false);
            }
            legend.dispose();
            panel.layout(true, true);
            List<Control> kids = Utils.getAllChildren(panel);
            if (kids.size() == 0) {
                kidsPanel = panel.getParent();
                kids = Utils.getAllChildren(kidsPanel);
            } else {
                kidsPanel = panel;
            }
            final ArrayList<Menu> showListenersAdded = new ArrayList<Menu>();
            final ArrayList menuItemsAdded = new ArrayList();
            Listener showListener = new Listener(){

                public void handleEvent(Event ev) {
                    MenuItem[] items;
                    Menu menu = (Menu)ev.widget;
                    MenuItem[] menuItemArray = items = menu.getItems();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        MenuItem x = menuItemArray[n2];
                        if (x.getData("Legend.hacked") != null) {
                            return;
                        }
                        ++n2;
                    }
                    if (menu.getItemCount() > 0) {
                        menuItemsAdded.add(new MenuItem(menu, 2));
                    }
                    MenuItem kmi = new MenuItem(menu, 8);
                    kmi.setData("Legend.hacked", (Object)"");
                    menuItemsAdded.add(kmi);
                    Messages.setLanguageText((Widget)kmi, "menu.show.legend");
                    kmi.addListener(13, event2 -> {
                        for (Menu x : showListenersAdded) {
                            x.removeListener(22, (Listener)this);
                        }
                        for (Menu x : menuItemsAdded) {
                            x.dispose();
                        }
                        if (keyVis != null) {
                            COConfigurationManager.setParameter(keyVis, true);
                        }
                        Legend.createLegendComposite(panel, blockColors, keys, key_texts, layoutData, horizontal, listener);
                        kidsPanel.layout(true, true);
                    });
                }
            };
            for (Control kid : kids) {
                Menu km = kid.getMenu();
                if (km == null) {
                    km = new Menu(kid);
                    kid.setMenu(km);
                }
                km.addListener(22, showListener);
                showListenersAdded.add(km);
            }
        };
        for (Control c : legControls) {
            Menu menu = new Menu(c);
            c.setMenu(menu);
            MenuItem mi = new MenuItem(menu, 8);
            Messages.setLanguageText((Widget)mi, "menu.hide.legend");
            mi.addListener(13, visListener);
        }
        if (keyVis != null && !COConfigurationManager.getBooleanParameter(keyVis, true)) {
            visListener.handleEvent(null);
        }
        return legend;
    }

    private static void handleHover(final LegendListener listener, boolean entry, int index, final int[] state) {
        if (entry) {
            state[1] = state[1] + 1;
            if (state[0] != index) {
                state[0] = index;
                listener.hoverChange(true, index);
            }
        } else {
            if (state[0] == -1) {
                return;
            }
            final int timer_index = state[1] = state[1] + 1;
            Utils.execSWTThreadLater(100, new Runnable(){

                @Override
                public void run() {
                    int leaving = state[0];
                    if (timer_index != state[1] || leaving == -1) {
                        return;
                    }
                    state[0] = -1;
                    listener.hoverChange(false, leaving);
                }
            });
        }
    }

    public static interface LegendListener {
        public void hoverChange(boolean var1, int var2);

        public void visibilityChange(boolean var1, int var2);
    }
}

