/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.components;

import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.components.BufferedWidget;
import com.biglybt.ui.swt.components.DoubleBufferedLabel;
import com.biglybt.ui.swt.mainwindow.ClipboardCopy;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Widget;

public class BufferedLabel
extends BufferedWidget {
    private final Control label = (Control)this.getWidget();
    private String value = "";

    public BufferedLabel(Composite composite, int attrs) {
        super((Widget)((attrs & 0x20000000) == 0 ? new Label(composite, attrs) : new DoubleBufferedLabel(composite, attrs)));
        ClipboardCopy.addCopyToClipMenu(this.label, new ClipboardCopy.copyToClipProvider(){

            @Override
            public String getText() {
                return BufferedLabel.this.getText();
            }
        });
    }

    public BufferedLabel(Composite composite, int attrs, ClipboardCopy.copyToClipProvider clip_provider) {
        super((Widget)((attrs & 0x20000000) == 0 ? new Label(composite, attrs) : new DoubleBufferedLabel(composite, attrs)));
        ClipboardCopy.addCopyToClipMenu(this.label, clip_provider);
    }

    public void setExpandWidth() {
        this.label.addListener(9, ev -> {
            Object ld;
            int border;
            int width;
            int current_width;
            String text = this.getText();
            if (text != null && (current_width = this.label.getBounds().width) < (width = (border = this.label.getBorderWidth()) * 2 + ev.gc.stringExtent((String)text).x) && (ld = this.label.getLayoutData()) instanceof GridData) {
                GridData gd = (GridData)ld;
                if (gd.widthHint < width) {
                    gd.widthHint = width;
                    this.label.getParent().layout(true);
                }
            }
        });
    }

    public boolean isDisposed() {
        return this.label.isDisposed();
    }

    public void setLayoutData(GridData gd) {
        this.label.setLayoutData((Object)gd);
    }

    public void setLayoutData(FormData gd) {
        this.label.setLayoutData((Object)gd);
    }

    public void setLayoutData(Object ld) {
        this.label.setLayoutData(ld);
    }

    public void setData(String key, Object value) {
        this.label.setData(key, value);
    }

    public Object getData(String key) {
        return this.label.getData(key);
    }

    public Control getControl() {
        return this.label;
    }

    public void setText(String new_value) {
        String fixed_value;
        if (this.label.isDisposed()) {
            return;
        }
        if (new_value == this.value) {
            return;
        }
        if (new_value != null && this.value != null && new_value.equals(this.value)) {
            return;
        }
        this.value = new_value;
        String string = fixed_value = this.value == null ? "" : this.value.replaceAll("&", "&&");
        if (this.label instanceof Label) {
            ((Label)this.label).setText(fixed_value);
        } else {
            ((DoubleBufferedLabel)this.label).setText(fixed_value);
        }
    }

    public void setLink(String url) {
        Object[] existing = (Object[])this.label.getData();
        if (existing == null && url == null) {
            return;
        }
        if (existing != null && url != null && ((String[])existing)[0].equals(url)) {
            return;
        }
        if (url == null) {
            this.label.setData(null);
            this.label.setCursor(null);
            this.label.setForeground(null);
            Utils.setTT(this.label, null);
        } else {
            final String[] data = new String[]{url};
            this.label.setData((Object)data);
            Utils.setTT(this.label, url);
            this.label.setCursor(this.label.getDisplay().getSystemCursor(21));
            Utils.setLinkForeground(this.label);
            this.label.addMouseListener((MouseListener)new MouseAdapter(){

                public void mouseDoubleClick(MouseEvent arg0) {
                    this.showURL((Label)arg0.widget);
                }

                public void mouseUp(MouseEvent arg0) {
                    this.showURL((Label)arg0.widget);
                }

                protected void showURL(Label label) {
                    if (label.getData() == data) {
                        Utils.launch(data[0]);
                    } else {
                        label.removeMouseListener((MouseListener)this);
                    }
                }
            });
            ClipboardCopy.addCopyToClipMenu(this.label);
        }
    }

    public void setTextAndTooltip(String str) {
        this.setText(str);
        this.setToolTipText(str);
    }

    public String getText() {
        return this.value == null ? "" : this.value;
    }

    public void addMouseListener(MouseListener listener) {
        this.label.addMouseListener(listener);
    }

    public void setForeground(Color color) {
        Utils.setSkinnedForeground(this.label, color);
    }

    public void setBackground(Color color) {
        this.label.setBackground(color);
    }

    public void setCursor(Cursor cursor) {
        this.label.setCursor(cursor);
    }

    public void setToolTipText(String toolTipText) {
        String tt = this.label.getToolTipText();
        if (!(tt == toolTipText || tt != null && toolTipText != null && tt.equals(toolTipText))) {
            Utils.setTT(this.label, toolTipText);
        }
    }
}

