/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.vuzeactivity;

import com.biglybt.activities.ActivitiesEntry;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.GeneralUtils;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellMouseEvent;
import com.biglybt.pif.ui.tables.TableCellMouseMoveListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableCellToolTipListener;
import com.biglybt.ui.swt.UIFunctionsManagerSWT;
import com.biglybt.ui.swt.UIFunctionsSWT;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.shells.GCStringPrinter;
import com.biglybt.ui.swt.skin.SWTSkinFactory;
import com.biglybt.ui.swt.skin.SWTSkinProperties;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import com.biglybt.util.StringCompareUtils;
import com.biglybt.util.UrlFilter;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Display;

public class ColumnActivityText
extends CoreTableColumnSWT
implements TableCellSWTPaintListener,
TableCellRefreshListener,
TableCellMouseMoveListener,
TableCellToolTipListener {
    public static final String COLUMN_ID = "activityText";
    private Color colorLinkNormal;
    private Color colorLinkHover;
    private static Font font = null;

    public ColumnActivityText(String tableID) {
        super(COLUMN_ID, tableID);
        this.initializeAsGraphic(600);
        SWTSkinProperties skinProperties = SWTSkinFactory.getInstance().getSkinProperties();
        this.colorLinkNormal = skinProperties.getColor("color.links.normal");
        this.colorLinkHover = skinProperties.getColor("color.links.hover");
    }

    @Override
    public void cellPaint(GC gc, TableCellSWT cell) {
        GCStringPrinter sp = this.setupStringPrinter(gc, cell);
        if (sp.hasHitUrl()) {
            GCStringPrinter.URLInfo[] hitUrlInfo = sp.getHitUrlInfo();
            int i = 0;
            while (i < hitUrlInfo.length) {
                GCStringPrinter.URLInfo info = hitUrlInfo[i];
                info.urlUnderline = cell.getTableRow().isSelected();
                info.urlColor = info.urlUnderline ? null : this.colorLinkNormal;
                ++i;
            }
            int[] mouseOfs = cell.getMouseOffset();
            if (mouseOfs != null) {
                Rectangle realBounds = cell.getBounds();
                GCStringPrinter.URLInfo hitUrl = sp.getHitUrl(mouseOfs[0] + realBounds.x, mouseOfs[1] + realBounds.y);
                if (hitUrl != null) {
                    hitUrl.urlColor = this.colorLinkHover;
                }
            }
        }
        sp.printString();
        gc.setFont(null);
    }

    private GCStringPrinter setupStringPrinter(GC gc, TableCellSWT cell) {
        ActivitiesEntry entry = (ActivitiesEntry)cell.getDataSource();
        String text = entry.getText();
        Rectangle drawBounds = this.getDrawBounds(cell);
        entry.setViewed();
        if (!entry.isRead()) {
            if (font == null) {
                FontData[] fontData = gc.getFont().getFontData();
                fontData[0].setStyle(1);
                font = new Font(gc.getDevice(), fontData);
            }
            gc.setFont(font);
        }
        int style = 64;
        GCStringPrinter sp = new GCStringPrinter(gc, text, drawBounds, true, true, style);
        sp.calculateMetrics();
        return sp;
    }

    @Override
    public void refresh(TableCell cell) {
        ActivitiesEntry entry = (ActivitiesEntry)cell.getDataSource();
        cell.setSortValue((Comparable)((Object)entry.getText()));
    }

    @Override
    public void cellMouseTrigger(TableCellMouseEvent event2) {
        String oldTooltip;
        Object o;
        GCStringPrinter sp;
        Rectangle bounds;
        boolean invalidateAndRefresh;
        String tooltip;
        block24: {
            tooltip = null;
            invalidateAndRefresh = false;
            ActivitiesEntry entry = (ActivitiesEntry)event2.cell.getDataSource();
            bounds = ((TableCellSWT)event2.cell).getBounds();
            String text = entry.getText();
            GC gc = new GC((Drawable)Display.getDefault());
            sp = null;
            try {
                try {
                    sp = this.setupStringPrinter(gc, (TableCellSWT)event2.cell);
                }
                catch (Exception e) {
                    Debug.out(e);
                    gc.dispose();
                    break block24;
                }
            }
            catch (Throwable throwable) {
                gc.dispose();
                throw throwable;
            }
            gc.dispose();
        }
        if (sp != null) {
            int newCursor;
            GCStringPrinter.URLInfo hitUrl = sp.getHitUrl(event2.x + bounds.x, event2.y + bounds.y);
            if (hitUrl != null) {
                boolean ourUrl;
                String url = hitUrl.url;
                boolean bl = ourUrl = UrlFilter.getInstance().urlCanRPC(url) || url.startsWith("/") || url.startsWith("#");
                if (event2.eventType == 0 && event2.button == 1) {
                    if (!ourUrl) {
                        if (UrlUtils.isInternalProtocol(url)) {
                            try {
                                UIFunctionsManagerSWT.getUIFunctionsSWT().doSearch(url);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        } else {
                            Utils.launch(url);
                        }
                    } else {
                        UIFunctionsSWT uif = UIFunctionsManagerSWT.getUIFunctionsSWT();
                        if (uif != null) {
                            String target = hitUrl.target;
                            if (target == null) {
                                target = "browse";
                            }
                            uif.viewURL(hitUrl.url, target, "column.activity.text");
                            return;
                        }
                    }
                }
                newCursor = 21;
                if (ourUrl) {
                    try {
                        tooltip = hitUrl.title == null ? null : URLDecoder.decode(hitUrl.title, "utf-8");
                    }
                    catch (UnsupportedEncodingException unsupportedEncodingException) {}
                } else {
                    tooltip = hitUrl.url;
                }
            } else {
                newCursor = 0;
            }
            int oldCursor = ((TableCellSWT)event2.cell).getCursorID();
            if (oldCursor != newCursor) {
                invalidateAndRefresh = true;
                ((TableCellSWT)event2.cell).setCursorID(newCursor);
            }
        }
        if (((o = event2.cell.getToolTip()) == null || o instanceof String) && !StringCompareUtils.equals(oldTooltip = (String)o, tooltip)) {
            invalidateAndRefresh = true;
            event2.cell.setToolTip(tooltip);
        }
        if (invalidateAndRefresh) {
            event2.cell.invalidate();
            ((TableCellSWT)event2.cell).redraw();
        }
    }

    private Rectangle getDrawBounds(TableCellSWT cell) {
        Rectangle bounds = cell.getBounds();
        bounds.x += 4;
        bounds.width -= 4;
        return bounds;
    }

    @Override
    public void cellHover(TableCell cell) {
        if (cell.getToolTip() != null) {
            return;
        }
        if (!(cell instanceof TableCellSWT)) {
            return;
        }
        if (!Utils.isThisThreadSWT()) {
            System.err.println("you broke it");
            return;
        }
        GC gc = new GC((Drawable)Display.getDefault());
        try {
            try {
                GCStringPrinter sp = this.setupStringPrinter(gc, (TableCellSWT)cell);
                if (sp.isCutoff()) {
                    cell.setToolTip(GeneralUtils.stripOutHyperlinks(sp.getText()));
                }
            }
            catch (Throwable t) {
                Debug.out(t);
                gc.dispose();
            }
        }
        finally {
            gc.dispose();
        }
    }

    @Override
    public void cellHoverComplete(TableCell cell) {
        cell.setToolTip(null);
    }
}

