/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.utils;

import com.biglybt.activities.ActivitiesEntry;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.LightHashMap;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadTypeComplete;
import com.biglybt.pif.download.DownloadTypeIncomplete;
import com.biglybt.pif.peers.Peer;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.plugin.net.buddy.swt.columns.ColumnChatMessageCount;
import com.biglybt.ui.common.table.TableColumnCore;
import com.biglybt.ui.common.table.TableColumnCoreCreationListener;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.swt.columns.peer.ColumnPeerBoost;
import com.biglybt.ui.swt.columns.torrent.ColumnProgressETA;
import com.biglybt.ui.swt.columns.torrent.ColumnStream;
import com.biglybt.ui.swt.columns.torrent.ColumnThumbAndName;
import com.biglybt.ui.swt.columns.torrent.ColumnThumbnail;
import com.biglybt.ui.swt.columns.torrent.ColumnUnopened;
import com.biglybt.ui.swt.columns.vuzeactivity.ColumnActivityActions;
import com.biglybt.ui.swt.columns.vuzeactivity.ColumnActivityDate;
import com.biglybt.ui.swt.columns.vuzeactivity.ColumnActivityNew;
import com.biglybt.ui.swt.columns.vuzeactivity.ColumnActivityText;
import com.biglybt.ui.swt.columns.vuzeactivity.ColumnActivityType;
import com.biglybt.ui.swt.views.table.utils.TableColumnCreator;
import com.biglybt.ui.swt.views.tableitems.mytorrents.DateAddedItem;
import com.biglybt.ui.swt.views.tableitems.mytorrents.DateCompletedItem;
import com.biglybt.ui.swt.views.tableitems.mytorrents.NameItem;
import com.biglybt.ui.swt.views.tableitems.mytorrents.RankItem;
import com.biglybt.ui.swt.views.tableitems.mytorrents.ShareRatioItem;
import com.biglybt.ui.swt.views.tableitems.mytorrents.StatusItem;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class TableColumnCreatorV3 {
    public static TableColumnCore[] createAllDM(String tableID, boolean big) {
        ShareRatioItem tcShareRatioItem;
        StatusItem tcStatusItem;
        String[] oldVisibleOrder = new String[]{"unopened", "name", "TorrentStream", "size", "ProgressETA", "azsubs.ui.column.subs", "azbuddy.ui.column.msgpending", "status", "torrentspeed", "seeds", "peers", "shareRatio"};
        String[] defaultVisibleOrder = new String[]{"#", "name", "TorrentStream", "ProgressETA", "size", "torrentspeed", "eta", "RatingColumn", "azsubs.ui.column.subs", "azbuddy.ui.column.msgpending", "date_added"};
        TableColumnManager tcManager = TableColumnManager.getInstance();
        Map<String, TableColumnCore> mapTCs = tcManager.getTableColumnsAsMap(Download.class, tableID);
        tcManager.setDefaultColumnNames(tableID, defaultVisibleOrder);
        if (!tcManager.loadTableColumnSettings(Download.class, tableID) || TableColumnCreatorV3.areNoneVisible(mapTCs)) {
            TableColumnCreatorV3.setVisibility(mapTCs, defaultVisibleOrder, true);
            RankItem tc = (RankItem)mapTCs.get("#");
            if (tc != null) {
                tcManager.setDefaultSortColumnName(tableID, "#");
                tc.setSortAscending(true);
            }
        } else {
            TableColumnCreatorV3.upgradeColumns(oldVisibleOrder, defaultVisibleOrder, mapTCs);
        }
        if ((tcStatusItem = (StatusItem)mapTCs.get("status")) != null) {
            tcStatusItem.setChangeRowFG(false);
            if (big) {
                tcStatusItem.setChangeCellFG(false);
                tcStatusItem.setShowTrackerErrors(true);
            }
        }
        if (big && (tcShareRatioItem = (ShareRatioItem)mapTCs.get("shareRatio")) != null) {
            tcShareRatioItem.setChangeFG(false);
        }
        return mapTCs.values().toArray(new TableColumnCore[0]);
    }

    private static void upgradeColumns(String[] oldOrder, String[] newOrder, Map<String, TableColumnCore> mapTCs) {
        List<String> listNewOrder;
        ArrayList<String> listCurrentOrder = new ArrayList<String>();
        for (TableColumnCore tc : mapTCs.values()) {
            if (!tc.isVisible()) continue;
            listCurrentOrder.add(tc.getName());
        }
        if (oldOrder.length == listCurrentOrder.size()) {
            List<String> listOldOrder = Arrays.asList(oldOrder);
            if (listOldOrder.containsAll(listCurrentOrder)) {
                TableColumnCreatorV3.setVisibility(mapTCs, newOrder, true);
            }
        } else if (listCurrentOrder.size() > oldOrder.length && listCurrentOrder.containsAll(listNewOrder = Arrays.asList(newOrder))) {
            String[] stringArray = newOrder;
            int n = newOrder.length;
            int n2 = 0;
            while (n2 < n) {
                String id = stringArray[n2];
                TableColumnCore tc = mapTCs.get(id);
                if (tc != null) {
                    tc.setVisible(true);
                }
                ++n2;
            }
        }
    }

    public static TableColumnCore[] createIncompleteDM(String tableID, boolean big) {
        ShareRatioItem tcShareRatioItem;
        StatusItem tcStatusItem;
        String[] oldVisibleOrder = new String[]{"name", "TorrentStream", "size", "filecount", "ProgressETA", "seeds", "peers", "azsubs.ui.column.subs", "azbuddy.ui.column.msgpending"};
        String[] defaultVisibleOrder = new String[]{"#", "name", "TorrentStream", "ProgressETA", "size", "torrentspeed", "eta", "RatingColumn", "azsubs.ui.column.subs", "azbuddy.ui.column.msgpending", "date_added"};
        TableColumnManager tcManager = TableColumnManager.getInstance();
        Map<String, TableColumnCore> mapTCs = tcManager.getTableColumnsAsMap(DownloadTypeIncomplete.class, tableID);
        tcManager.setDefaultColumnNames(tableID, defaultVisibleOrder);
        if (!tcManager.loadTableColumnSettings(DownloadTypeIncomplete.class, tableID) || TableColumnCreatorV3.areNoneVisible(mapTCs)) {
            TableColumnCreatorV3.setVisibility(mapTCs, defaultVisibleOrder, true);
            RankItem tc = (RankItem)mapTCs.get("#");
            if (tc != null) {
                tcManager.setDefaultSortColumnName(tableID, "#");
                tc.setSortAscending(true);
            }
        } else {
            TableColumnCreatorV3.upgradeColumns(oldVisibleOrder, defaultVisibleOrder, mapTCs);
        }
        if ((tcStatusItem = (StatusItem)mapTCs.get("status")) != null) {
            tcStatusItem.setChangeRowFG(false);
            if (big) {
                tcStatusItem.setChangeCellFG(false);
            }
        }
        if (big && (tcShareRatioItem = (ShareRatioItem)mapTCs.get("shareRatio")) != null) {
            tcShareRatioItem.setChangeFG(false);
        }
        return mapTCs.values().toArray(new TableColumnCore[0]);
    }

    private static void setVisibility(Map<String, TableColumnCore> mapTCs, String[] defaultVisibleOrder, boolean reorder) {
        for (TableColumnCore tc : mapTCs.values()) {
            Long force_visible = (Long)tc.getUserData("ud_fv");
            if (force_visible != null && force_visible != 0L) continue;
            tc.setVisible(false);
        }
        int i = 0;
        while (i < defaultVisibleOrder.length) {
            String id = defaultVisibleOrder[i];
            TableColumnCore tc = mapTCs.get(id);
            if (tc != null) {
                tc.setVisible(true);
                if (reorder) {
                    tc.setPositionNoShift(i);
                }
            }
            ++i;
        }
    }

    public static TableColumnCore[] createCompleteDM(String tableID, boolean big) {
        ShareRatioItem tcShareRatioItem;
        StatusItem tcStatusItem;
        String[] oldVisibleOrder = new String[]{"unopened", "name", "RatingColumn", "azsubs.ui.column.subs", "azbuddy.ui.column.msgpending", "size", "status", "shareRatio", "DateCompleted"};
        String[] defaultVisibleOrder = new String[]{"#", "name", "TorrentStream", "status", "size", "torrentspeed", "RatingColumn", "azsubs.ui.column.subs", "azbuddy.ui.column.msgpending", "DateCompleted"};
        TableColumnManager tcManager = TableColumnManager.getInstance();
        Map<String, TableColumnCore> mapTCs = tcManager.getTableColumnsAsMap(DownloadTypeComplete.class, tableID);
        tcManager.setDefaultColumnNames(tableID, defaultVisibleOrder);
        if (!tcManager.loadTableColumnSettings(DownloadTypeComplete.class, tableID) || TableColumnCreatorV3.areNoneVisible(mapTCs)) {
            TableColumnCreatorV3.setVisibility(mapTCs, defaultVisibleOrder, true);
            DateCompletedItem tc = (DateCompletedItem)mapTCs.get("DateCompleted");
            if (tc != null) {
                tcManager.setDefaultSortColumnName(tableID, "DateCompleted");
                tc.setSortAscending(false);
            }
        } else {
            TableColumnCreatorV3.upgradeColumns(oldVisibleOrder, defaultVisibleOrder, mapTCs);
        }
        if ((tcStatusItem = (StatusItem)mapTCs.get("status")) != null) {
            tcStatusItem.setChangeRowFG(false);
            if (big) {
                tcStatusItem.setChangeCellFG(false);
            }
        }
        if (big && (tcShareRatioItem = (ShareRatioItem)mapTCs.get("shareRatio")) != null) {
            tcShareRatioItem.setChangeFG(false);
        }
        return mapTCs.values().toArray(new TableColumnCore[0]);
    }

    public static TableColumnCore[] createUnopenedDM(String tableID, boolean big) {
        ShareRatioItem tcShareRatioItem;
        StatusItem tcStatusItem;
        String[] oldVisibleOrder = new String[]{"unopened", "name", "azsubs.ui.column.subs", "azbuddy.ui.column.msgpending", "size", "ProgressETA", "status", "DateCompleted"};
        String[] defaultVisibleOrder = new String[]{"unopened", "name", "TorrentStream", "size", "RatingColumn", "azsubs.ui.column.subs", "azbuddy.ui.column.msgpending", "DateCompleted"};
        TableColumnManager tcManager = TableColumnManager.getInstance();
        Map<String, TableColumnCore> mapTCs = tcManager.getTableColumnsAsMap(DownloadTypeComplete.class, tableID);
        tcManager.setDefaultColumnNames(tableID, defaultVisibleOrder);
        if (!tcManager.loadTableColumnSettings(DownloadTypeComplete.class, tableID) || TableColumnCreatorV3.areNoneVisible(mapTCs)) {
            TableColumnCreatorV3.setVisibility(mapTCs, defaultVisibleOrder, true);
            DateCompletedItem tc = (DateCompletedItem)mapTCs.get("DateCompleted");
            if (tc != null) {
                tcManager.setDefaultSortColumnName(tableID, "DateCompleted");
                tc.setSortAscending(false);
            }
        } else {
            TableColumnCreatorV3.upgradeColumns(oldVisibleOrder, defaultVisibleOrder, mapTCs);
        }
        if ((tcStatusItem = (StatusItem)mapTCs.get("status")) != null) {
            tcStatusItem.setChangeRowFG(false);
            if (big) {
                tcStatusItem.setChangeCellFG(false);
            }
        }
        if (big && (tcShareRatioItem = (ShareRatioItem)mapTCs.get("shareRatio")) != null) {
            tcShareRatioItem.setChangeFG(false);
        }
        return mapTCs.values().toArray(new TableColumnCore[0]);
    }

    public static TableColumnCore[] createActivitySmall(String tableID) {
        String[] defaultVisibleOrder = new String[]{"activityNew", "activityType", "activityText", "activityActions", "activityDate"};
        TableColumnManager tcManager = TableColumnManager.getInstance();
        Map<String, TableColumnCore> mapTCs = tcManager.getTableColumnsAsMap(ActivitiesEntry.class, tableID);
        tcManager.setDefaultColumnNames(tableID, defaultVisibleOrder);
        if (!tcManager.loadTableColumnSettings(ActivitiesEntry.class, tableID) || TableColumnCreatorV3.areNoneVisible(mapTCs)) {
            ColumnActivityText tcText;
            TableColumnCreatorV3.setVisibility(mapTCs, defaultVisibleOrder, true);
            ColumnActivityDate tc = (ColumnActivityDate)mapTCs.get("activityDate");
            if (tc != null) {
                tcManager.setDefaultSortColumnName(tableID, "activityDate");
                tc.setSortAscending(false);
            }
            if ((tcText = (ColumnActivityText)mapTCs.get("activityText")) != null) {
                tcText.setWidth(445);
            }
        }
        return mapTCs.values().toArray(new TableColumnCore[0]);
    }

    public static TableColumnCore[] createActivityBig(String tableID) {
        String[] defaultVisibleOrder = new String[]{"activityNew", "activityType", "activityText", "Thumbnail", "activityActions", "activityDate"};
        TableColumnManager tcManager = TableColumnManager.getInstance();
        Map<String, TableColumnCore> mapTCs = tcManager.getTableColumnsAsMap(ActivitiesEntry.class, tableID);
        tcManager.setDefaultColumnNames(tableID, defaultVisibleOrder);
        if (!tcManager.loadTableColumnSettings(ActivitiesEntry.class, tableID) || TableColumnCreatorV3.areNoneVisible(mapTCs)) {
            ColumnActivityDate tc;
            TableColumnCreatorV3.setVisibility(mapTCs, defaultVisibleOrder, true);
            ColumnActivityText tcText = (ColumnActivityText)mapTCs.get("activityText");
            if (tcText != null) {
                tcText.setWidth(350);
            }
            if ((tc = (ColumnActivityDate)mapTCs.get("activityDate")) != null) {
                tcManager.setDefaultSortColumnName(tableID, "activityDate");
                tc.setSortAscending(false);
            }
        }
        return mapTCs.values().toArray(new TableColumnCore[0]);
    }

    private static boolean areNoneVisible(Map<String, TableColumnCore> mapTCs) {
        boolean noneVisible = true;
        for (TableColumnCore tc : mapTCs.values()) {
            if (!tc.isVisible()) continue;
            noneVisible = false;
            break;
        }
        return noneVisible;
    }

    public static void initCoreColumns() {
        TableColumnCreator.initCoreColumns();
        final LightHashMap c = new LightHashMap(7);
        c.put("unopened", new cInfo(ColumnUnopened.class, ColumnUnopened.DATASOURCE_TYPES));
        c.put("name", new cInfo(ColumnThumbAndName.class, ColumnThumbAndName.DATASOURCE_TYPES));
        c.put("TorrentStream", new cInfo(ColumnStream.class, ColumnStream.DATASOURCE_TYPES));
        c.put("date_added", new cInfo(DateAddedItem.class, DateAddedItem.DATASOURCE_TYPE));
        c.put("DateCompleted", new cInfo(DateCompletedItem.class, DateCompletedItem.DATASOURCE_TYPE));
        c.put("ProgressETA", new cInfo(ColumnProgressETA.class, ColumnProgressETA.DATASOURCE_TYPE));
        c.put(ColumnChatMessageCount.COLUMN_ID, new cInfo(ColumnChatMessageCount.class, Download.class));
        c.put(ColumnPeerBoost.COLUMN_ID, new cInfo(ColumnPeerBoost.class, Peer.class));
        Class<ActivitiesEntry> ac = ActivitiesEntry.class;
        c.put("activityNew", new cInfo(ColumnActivityNew.class, ac));
        c.put("activityType", new cInfo(ColumnActivityType.class, ac));
        c.put("activityText", new cInfo(ColumnActivityText.class, ac));
        c.put("activityActions", new cInfo(ColumnActivityActions.class, ac));
        c.put("activityDate", new cInfo(ColumnActivityDate.class, ac));
        c.put("Thumbnail", new cInfo(ColumnThumbnail.class, new Class[]{ac}));
        TableColumnManager tcManager = TableColumnManager.getInstance();
        TableColumnCoreCreationListener tcCreator = new TableColumnCoreCreationListener(){

            public TableColumnCore createTableColumnCore(Class forDataSourceType, String tableID, String columnID) {
                cInfo info = (cInfo)c.get(columnID);
                if (info.cla.isAssignableFrom(TableColumnCore.class)) {
                    return null;
                }
                try {
                    Constructor constructor = info.cla.getDeclaredConstructor(String.class);
                    TableColumnCore column = (TableColumnCore)constructor.newInstance(tableID);
                    return column;
                }
                catch (NoSuchMethodException constructor) {
                }
                catch (Exception e) {
                    Debug.out(e);
                }
                return null;
            }

            @Override
            public void tableColumnCreated(TableColumn column) {
                cInfo info = (cInfo)c.get(column.getName());
                if (column.getClass().equals(info.cla)) {
                    return;
                }
                try {
                    Constructor constructor = info.cla.getDeclaredConstructor(TableColumn.class);
                    if (constructor != null) {
                        constructor.newInstance(column);
                    }
                }
                catch (NoSuchMethodException constructor) {
                }
                catch (Exception e) {
                    Debug.out(e);
                }
            }
        };
        tcManager.unregisterColumn(NameItem.DATASOURCE_TYPE, "name");
        for (String id : c.keySet()) {
            cInfo info = (cInfo)c.get(id);
            int i = 0;
            while (i < info.forDataSourceTypes.length) {
                Class cla = info.forDataSourceTypes[i];
                tcManager.registerColumn(cla, id, tcCreator);
                ++i;
            }
        }
    }

    private static class cInfo {
        public final Class cla;
        public final Class[] forDataSourceTypes;

        public cInfo(Class cla, Class forDataSourceType) {
            this.cla = cla;
            this.forDataSourceTypes = new Class[]{forDataSourceType};
        }

        public cInfo(Class cla, Class[] forDataSourceTypes) {
            this.cla = cla;
            this.forDataSourceTypes = forDataSourceTypes;
        }
    }
}

