/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.torrent;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.torrent.PlatformTorrentUtils;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellAddedListener;
import com.biglybt.pif.ui.tables.TableCellMouseEvent;
import com.biglybt.pif.ui.tables.TableCellMouseListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableCellRefresher;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.pifimpl.UISWTGraphicImpl;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import org.eclipse.swt.graphics.Image;

public class ColumnUnopened
extends CoreTableColumnSWT
implements TableCellAddedListener,
TableCellRefreshListener,
TableCellMouseListener {
    public static final Class<?>[] DATASOURCE_TYPES = new Class[]{Download.class, DiskManagerFileInfo.class};
    public static final String COLUMN_ID = "unopened";
    private static UISWTGraphicImpl graphicCheck;
    private static UISWTGraphicImpl graphicUnCheck;
    private static UISWTGraphicImpl[] graphicsProgress;
    private static final int WIDTH = 38;

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content", "essential"});
        info.setProficiency((byte)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnUnopened(String tableID) {
        super(COLUMN_ID, tableID);
        this.addDataSourceTypes(DATASOURCE_TYPES);
        Class<ColumnUnopened> clazz = ColumnUnopened.class;
        synchronized (ColumnUnopened.class) {
            Image img;
            if (graphicCheck == null) {
                img = ImageLoader.getInstance().getImage("image.unopened");
                graphicCheck = new UISWTGraphicImpl(img);
            }
            if (graphicUnCheck == null) {
                img = ImageLoader.getInstance().getImage("image.opened");
                graphicUnCheck = new UISWTGraphicImpl(img);
            }
            if (graphicsProgress == null) {
                Image[] imgs = ImageLoader.getInstance().getImages("image.sidebar.vitality.dl");
                graphicsProgress = new UISWTGraphicImpl[imgs.length];
                int i = 0;
                while (i < imgs.length) {
                    ColumnUnopened.graphicsProgress[i] = new UISWTGraphicImpl(imgs[i]);
                    ++i;
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            TableContextMenuItem menuItem = this.addContextMenuItem("label.toggle.new.marker");
            menuItem.addMultiListener(new MenuItemListener(){

                @Override
                public void selected(MenuItem menu, Object target) {
                    Object[] dataSources;
                    Object[] objectArray = dataSources = (Object[])target;
                    int n = dataSources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Object _ds = objectArray[n2];
                        if (_ds instanceof TableRowCore) {
                            TableRowCore row = (TableRowCore)_ds;
                            _ds = row.getDataSource(true);
                        }
                        if (_ds instanceof DownloadManager) {
                            DownloadManager dm;
                            boolean x = PlatformTorrentUtils.getHasBeenOpened(dm = (DownloadManager)_ds);
                            PlatformTorrentUtils.setHasBeenOpened(dm, !x);
                        } else if (_ds instanceof com.biglybt.core.disk.DiskManagerFileInfo) {
                            com.biglybt.core.disk.DiskManagerFileInfo file = (com.biglybt.core.disk.DiskManagerFileInfo)_ds;
                            DownloadManager dm = file.getDownloadManager();
                            int ff = dm.getDownloadState().getFileFlags(file.getIndex());
                            dm.getDownloadState().setFileFlags(file.getIndex(), ff ^= 1);
                        }
                        ++n2;
                    }
                }
            });
            this.initializeAsGraphic(38);
            return;
        }
    }

    @Override
    public void cellAdded(TableCell cell) {
        cell.setMarginWidth(0);
        cell.setMarginHeight(0);
    }

    @Override
    public void refresh(TableCell cell) {
        Object ds = cell.getDataSource();
        if (ds == null) {
            return;
        }
        if (ds instanceof DownloadManager) {
            int sortVal;
            DownloadManager dm = (DownloadManager)ds;
            boolean complete = dm.getAssumedComplete();
            boolean hasBeenOpened = false;
            if (complete) {
                hasBeenOpened = PlatformTorrentUtils.getHasBeenOpened(dm);
                sortVal = hasBeenOpened ? 1 : 0;
            } else {
                int n = sortVal = this.isSortAscending() ? 2 : -1;
            }
            if (!cell.setSortValue(sortVal) && cell.isValid() && complete) {
                return;
            }
            if (!cell.isShown()) {
                return;
            }
            if (complete) {
                cell.setGraphic(hasBeenOpened ? graphicUnCheck : graphicCheck);
            } else if (dm.getState() == 50) {
                int i = TableCellRefresher.getRefreshIndex(1, graphicsProgress.length);
                cell.setGraphic(graphicsProgress[i]);
                TableCellRefresher.addCell(this, cell);
            } else {
                cell.setGraphic(null);
            }
        } else {
            int sortVal;
            com.biglybt.core.disk.DiskManagerFileInfo file = (com.biglybt.core.disk.DiskManagerFileInfo)ds;
            long len = file.getLength();
            boolean complete = len > 0L && len == file.getDownloaded();
            boolean hasBeenOpened = false;
            if (complete) {
                DownloadManager dm = file.getDownloadManager();
                if (dm == null) {
                    hasBeenOpened = false;
                    sortVal = 0;
                } else {
                    int ff = dm.getDownloadState().getFileFlags(file.getIndex());
                    hasBeenOpened = (ff & 1) != 0;
                    sortVal = hasBeenOpened ? 1 : 0;
                }
            } else {
                sortVal = 2;
            }
            if (!cell.setSortValue(sortVal) && cell.isValid() && complete) {
                return;
            }
            if (!cell.isShown()) {
                return;
            }
            if (complete) {
                cell.setGraphic(hasBeenOpened ? graphicUnCheck : graphicCheck);
            } else {
                cell.setGraphic(null);
            }
        }
    }

    @Override
    public void cellMouseTrigger(TableCellMouseEvent event2) {
        if (event2.eventType == 1 && event2.button == 1) {
            boolean hasBeenOpened;
            Object ds = event2.cell.getDataSource();
            if (ds instanceof DownloadManager) {
                DownloadManager dm = (DownloadManager)event2.cell.getDataSource();
                boolean complete = dm.getAssumedComplete();
                if (!complete) {
                    return;
                }
                hasBeenOpened = !PlatformTorrentUtils.getHasBeenOpened(dm);
                PlatformTorrentUtils.setHasBeenOpened(dm, hasBeenOpened);
            } else {
                boolean complete;
                com.biglybt.core.disk.DiskManagerFileInfo file = (com.biglybt.core.disk.DiskManagerFileInfo)ds;
                boolean bl = complete = file.getLength() == file.getDownloaded();
                if (!complete) {
                    return;
                }
                DownloadManager dm = file.getDownloadManager();
                int ff = dm.getDownloadState().getFileFlags(file.getIndex());
                hasBeenOpened = ((ff ^= 1) & 1) != 0;
                dm.getDownloadState().setFileFlags(file.getIndex(), ff);
            }
            event2.cell.setGraphic(hasBeenOpened ? graphicUnCheck : graphicCheck);
            event2.cell.invalidate();
        }
    }
}

