/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.torrent;

import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableCellToolTipListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.utils.TorrentUIUtilsV3;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import com.biglybt.util.DataSourceUtils;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ColumnThumbnail
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellSWTPaintListener,
TableCellToolTipListener {
    public static final String COLUMN_ID = "Thumbnail";
    private static final int WIDTH_SMALL = 35;
    private static final int WIDTH_BIG = 60;
    private static final int WIDTH_ACTIVITY = 80;
    private Map mapCellTorrent = new HashMap();

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
    }

    public ColumnThumbnail(String sTableID) {
        super(COLUMN_ID, 3, -2, 0, sTableID);
        if ("Activity.big".equals(sTableID)) {
            this.initializeAsGraphic(80);
        } else {
            this.initializeAsGraphic(sTableID.endsWith(".big") ? 60 : 35);
        }
    }

    public ColumnThumbnail(TableColumn column) {
        super(null, null);
        column.initialize(3, -2, 60);
        column.addListeners(this);
    }

    public void dispose(TableCell cell) {
        this.mapCellTorrent.remove(cell);
    }

    @Override
    public void refresh(TableCell cell) {
        Object ds = cell.getDataSource();
        TOTorrent newTorrent = DataSourceUtils.getTorrent(ds);
        TOTorrent torrent = (TOTorrent)this.mapCellTorrent.get(cell);
        torrent = newTorrent;
        this.mapCellTorrent.put(cell, torrent);
    }

    @Override
    public void cellPaint(GC gc, final TableCellSWT cell) {
        Object ds;
        block19: {
            int dstWidth;
            int dstHeight;
            ds = cell.getDataSource();
            Rectangle cellBounds = cell.getBounds();
            Image[] imgThumbnail = TorrentUIUtilsV3.getContentImage(ds, cellBounds.width >= 20 && cellBounds.height >= 20, new TorrentUIUtilsV3.ContentImageLoadedListener(){

                @Override
                public void contentImageLoaded(Image image, boolean wasReturned) {
                    if (!wasReturned) {
                        cell.invalidate();
                    }
                }
            });
            if (imgThumbnail == null || imgThumbnail[0] == null) {
                return;
            }
            if (cellBounds.height > 30) {
                cellBounds.y += 2;
                cellBounds.height -= 4;
            }
            Rectangle imgBounds = imgThumbnail[0].getBounds();
            if (imgBounds.height > cellBounds.height) {
                dstHeight = cellBounds.height;
                dstWidth = imgBounds.width * cellBounds.height / imgBounds.height;
            } else if (imgBounds.width > cellBounds.width) {
                dstWidth = cellBounds.width - 4;
                dstHeight = imgBounds.height * cellBounds.width / imgBounds.width;
            } else {
                dstWidth = imgBounds.width;
                dstHeight = imgBounds.height;
            }
            try {
                gc.setAdvanced(true);
                gc.setInterpolation(2);
            }
            catch (Exception exception) {
                // empty catch block
            }
            int x = cellBounds.x + (cellBounds.width - dstWidth + 1) / 2;
            int y = cellBounds.y + (cellBounds.height - dstHeight + 1) / 2;
            if (dstWidth > 0 && dstHeight > 0 && !imgBounds.isEmpty()) {
                Rectangle dst = new Rectangle(x, y, dstWidth, dstHeight);
                Rectangle lastClipping = gc.getClipping();
                try {
                    try {
                        Utils.setClipping(gc, cellBounds);
                        int i = 0;
                        while (i < imgThumbnail.length) {
                            Image image = imgThumbnail[i];
                            if (image != null) {
                                int h;
                                int w;
                                Rectangle srcBounds = image.getBounds();
                                if (i == 0) {
                                    w = dstWidth;
                                    h = dstHeight;
                                    if (imgThumbnail.length > 1) {
                                        w = w * 9 / 10;
                                        h = h * 9 / 10;
                                    }
                                    gc.drawImage(image, srcBounds.x, srcBounds.y, srcBounds.width, srcBounds.height, x, y, w, h);
                                } else {
                                    w = dstWidth * 3 / 8;
                                    h = dstHeight * 3 / 8;
                                    gc.drawImage(image, srcBounds.x, srcBounds.y, srcBounds.width, srcBounds.height, x + dstWidth - w, y + dstHeight - h, w, h);
                                }
                            }
                            ++i;
                        }
                    }
                    catch (Exception e) {
                        Debug.out(e);
                        Utils.setClipping(gc, lastClipping);
                        break block19;
                    }
                }
                catch (Throwable throwable) {
                    Utils.setClipping(gc, lastClipping);
                    throw throwable;
                }
                Utils.setClipping(gc, lastClipping);
            }
        }
        TorrentUIUtilsV3.releaseContentImage(ds);
    }

    @Override
    public void cellHover(TableCell cell) {
        final Object ds = cell.getDataSource();
        Image[] imgThumbnail = TorrentUIUtilsV3.getContentImage(ds, true, new TorrentUIUtilsV3.ContentImageLoadedListener(){

            @Override
            public void contentImageLoaded(Image image, boolean wasReturned) {
                TorrentUIUtilsV3.releaseContentImage(ds);
            }
        });
        cell.setToolTip(imgThumbnail == null ? null : imgThumbnail[0]);
    }

    @Override
    public void cellHoverComplete(TableCell cell) {
        Object ds = cell.getDataSource();
        TorrentUIUtilsV3.releaseContentImage(ds);
    }
}

