/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.torrent;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.AEThread2;
import com.biglybt.pif.disk.DiskManagerFileInfo;
import com.biglybt.pif.download.DownloadTypeIncomplete;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellAddedListener;
import com.biglybt.pif.ui.tables.TableCellMouseEvent;
import com.biglybt.pif.ui.tables.TableCellMouseListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableCellToolTipListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.common.table.TableCellCore;
import com.biglybt.ui.common.table.TableRowCore;
import com.biglybt.ui.common.table.impl.TableColumnManager;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.views.FilesView;
import com.biglybt.ui.swt.views.skin.TorrentListViewsUtils;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import com.biglybt.util.PlayUtils;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ColumnStream
extends CoreTableColumnSWT
implements TableCellSWTPaintListener,
TableCellAddedListener,
TableCellRefreshListener,
TableCellMouseListener,
TableCellToolTipListener {
    public static final String COLUMN_ID = "TorrentStream";
    public static final Class[] DATASOURCE_TYPES = new Class[]{DownloadTypeIncomplete.class, DiskManagerFileInfo.class};
    private static final int WIDTH = 62;
    private static Image imgGreen;
    private static Image imgDisabled;
    private static Image imgBlue;
    private static final Object firstLock;
    private static boolean first;
    static boolean skipPaint;

    static {
        firstLock = new Object();
        first = true;
        skipPaint = true;
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential", "content"});
        info.setProficiency((byte)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ColumnStream(String tableID) {
        super(COLUMN_ID, tableID);
        this.addDataSourceTypes(DATASOURCE_TYPES);
        this.initializeAsGraphic(62);
        this.setAlignment(3);
        Class<ColumnStream> clazz = ColumnStream.class;
        synchronized (ColumnStream.class) {
            if (imgGreen == null) {
                imgGreen = ImageLoader.getInstance().getImage("column.image.play.green");
                imgDisabled = ImageLoader.getInstance().getImage("column.image.play.off");
                imgBlue = ImageLoader.getInstance().getImage("column.image.play.blue");
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    @Override
    public void preAdd() {
        int position;
        TableColumn column;
        if (!this.isFirstLoad() || this.getPosition() >= 0 || this.getColumnAdded()) {
            return;
        }
        TableColumnManager tcManager = TableColumnManager.getInstance();
        TableColumnInfo columnInfoTAN = tcManager.getColumnInfo(null, this.getTableID(), "name");
        if (columnInfoTAN != null && (column = columnInfoTAN.getColumn()) != null && (position = column.getPosition()) >= 0) {
            this.setPosition(position + 1);
        }
    }

    private boolean noIconForYou(Object ds, TableCell cell) {
        if (ds instanceof FilesView.FilesViewTreeNode && !((FilesView.FilesViewTreeNode)ds).isLeaf()) {
            return true;
        }
        if (!(ds instanceof DownloadManager)) {
            return false;
        }
        if (!(cell instanceof TableCellCore)) {
            return false;
        }
        DownloadManager dm = (DownloadManager)ds;
        TableRowCore rowCore = ((TableCellCore)cell).getTableRowCore();
        return rowCore != null && dm.getNumFileInfos() > 1 && rowCore.isExpanded();
    }

    @Override
    public void cellPaint(GC gc, TableCellSWT cell) {
        boolean canPlay;
        Object ds = cell.getDataSource();
        if (this.noIconForYou(ds, cell)) {
            return;
        }
        Comparable sortValue = cell.getSortValue();
        if (!(sortValue instanceof Number)) {
            return;
        }
        int sortVal = ((Number)((Object)sortValue)).intValue();
        boolean canStream = (sortVal & 2) > 0;
        boolean bl = canPlay = (sortVal & 1) > 0;
        Image img = canStream ? imgBlue : (canPlay ? imgGreen : imgDisabled);
        Rectangle cellBounds = cell.getBounds();
        if (img != null && !img.isDisposed()) {
            Utils.drawImageCenterScaleDown(gc, img, cellBounds);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cellAdded(final TableCell cell) {
        cell.setMarginWidth(0);
        cell.setMarginHeight(0);
        Object object = firstLock;
        synchronized (object) {
            if (first) {
                first = false;
                new AEThread2("WaitForMS", true){

                    @Override
                    public void run() {
                        Object ds = cell.getDataSource();
                        PlayUtils.canStreamDS(ds, -1, true);
                        skipPaint = false;
                    }
                };
            }
        }
    }

    @Override
    public void refresh(TableCell cell) {
        int sortVal;
        Object ds = cell.getDataSource();
        if (this.noIconForYou(ds, cell)) {
            sortVal = 0;
        } else {
            boolean canStream = PlayUtils.canStreamDS(ds, -1, false);
            boolean canPlay = PlayUtils.canPlayDS(ds, -1, false);
            sortVal = (canStream ? 2 : 0) + (canPlay ? 1 : 0);
        }
        if (cell.setSortValue(sortVal)) {
            cell.invalidate();
        }
    }

    @Override
    public void cellMouseTrigger(TableCellMouseEvent event2) {
        if (event2.eventType == 0 && event2.button == 1) {
            Object ds = event2.cell.getDataSource();
            if (ds instanceof FilesView.FilesViewTreeNode && !((FilesView.FilesViewTreeNode)ds).isLeaf()) {
                return;
            }
            if (PlayUtils.canStreamDS(ds, -1, true) || PlayUtils.canPlayDS(ds, -1, true)) {
                TorrentListViewsUtils.playOrStreamDataSource(ds, "column", true, false);
            }
        }
    }

    @Override
    public void cellHover(TableCell cell) {
        Object ds = cell.getDataSource();
        if (this.noIconForYou(ds, cell)) {
            cell.setToolTip(null);
            return;
        }
        if (PlayUtils.canStreamDS(ds, -1, false) || PlayUtils.canPlayDS(ds, -1, false)) {
            cell.setToolTip(null);
            return;
        }
        String id = "TableColumn.TorrentStream.tooltip.disabled";
        if (ds instanceof DownloadManager && ((DownloadManager)ds).getNumFileInfos() > 1) {
            id = "TableColumn.TorrentStream.tooltip.expand";
        }
        cell.setToolTip(MessageText.getString(id));
    }

    @Override
    public void cellHoverComplete(TableCell cell) {
        cell.setToolTip(null);
    }
}

