/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.tag;

import com.biglybt.core.tag.Tag;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnExtraInfoListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import java.io.File;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public class ColumnTagIcon
implements TableCellRefreshListener,
TableCellSWTPaintListener,
TableColumnExtraInfoListener {
    public static String COLUMN_ID = "tag.icon";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public ColumnTagIcon(TableColumn column) {
        column.setWidth(30);
        column.addListeners(this);
    }

    @Override
    public void refresh(TableCell cell) {
        Tag tag = (Tag)cell.getDataSource();
        if (tag == null) {
            return;
        }
        String file = tag.getImageFile();
        if (file == null) {
            file = "";
        }
        if (!cell.setSortValue((Comparable)((Object)file)) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
    }

    @Override
    public void cellPaint(GC gc, TableCellSWT cell) {
        Tag tag = (Tag)cell.getDataSource();
        if (tag == null) {
            return;
        }
        String file = tag.getImageFile();
        if (file != null) {
            try {
                Point size = cell.getSize();
                size.x -= 2;
                size.y -= 2;
                ImageLoader.getInstance().getFileImage(new File(file), size, (image, key, returnedImmediately) -> {
                    if (image != null && returnedImmediately) {
                        if (!gc.isDisposed()) {
                            Utils.drawImageCenterScaleDown(gc, image, cell.getBounds());
                        }
                        ImageLoader.getInstance().releaseImage(key);
                    }
                });
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

