/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.tag;

import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagFeatureRateLimit;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnExtraInfoListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;

public class ColumnTagDownTotal
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static String COLUMN_ID = "tag.downtotal";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public ColumnTagDownTotal(TableColumn column) {
        column.setWidth(60);
        column.setRefreshInterval(-2);
        column.setAlignment(2);
        column.addListeners(this);
    }

    @Override
    public void refresh(TableCell cell) {
        long[] down;
        TagFeatureRateLimit rl;
        Tag tag = (Tag)cell.getDataSource();
        if (tag instanceof TagFeatureRateLimit && (rl = (TagFeatureRateLimit)((Object)tag)).supportsTagRates() && (down = rl.getTagDownloadTotal()) != null) {
            long tot = 0L;
            long[] lArray = down;
            int n = down.length;
            int n2 = 0;
            while (n2 < n) {
                long l = lArray[n2];
                tot += l;
                ++n2;
            }
            if (!cell.setSortValue(tot) && cell.isValid()) {
                return;
            }
            if (!cell.isShown()) {
                return;
            }
            cell.setText(DisplayFormatters.formatByteCountToKiBEtc(tot));
        }
    }
}

