/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.tag;

import com.biglybt.core.tag.Tag;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnExtraInfoListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Rectangle;

public class ColumnTagColor
implements TableCellRefreshListener,
TableCellSWTPaintListener,
TableColumnExtraInfoListener {
    public static String COLUMN_ID = "tag.color";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public ColumnTagColor(TableColumn column) {
        column.setWidth(30);
        column.addListeners(this);
    }

    @Override
    public void refresh(TableCell cell) {
        Tag tag = (Tag)cell.getDataSource();
        if (tag == null) {
            return;
        }
        int[] color = tag.getColor();
        if (color == null || color.length < 3) {
            return;
        }
        int sortVal = color[0] + color[1] << 8 + color[2] << 16;
        if (!cell.setSortValue(sortVal) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        cell.setForeground(color);
    }

    @Override
    public void cellPaint(GC gc, TableCellSWT cell) {
        Rectangle bounds = cell.getBounds();
        Color foregroundSWT = cell.getForegroundSWT();
        if (foregroundSWT != null) {
            gc.setBackground(foregroundSWT);
            ++bounds.x;
            ++bounds.y;
            --bounds.width;
            --bounds.height;
            gc.fillRectangle(bounds);
        }
    }
}

