/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.subscriptions;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.subs.Subscription;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.SystemTime;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.utils.TableColumnCreator;
import com.biglybt.ui.swt.views.tableitems.ColumnDateSizer;

public class ColumnSubscriptionNextUpdate
extends ColumnDateSizer {
    public static String COLUMN_ID = "next-update";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"time"});
        info.setProficiency((byte)1);
    }

    public ColumnSubscriptionNextUpdate(String sTableID) {
        super(Subscription.class, COLUMN_ID, TableColumnCreator.DATE_COLUMN_WIDTH, sTableID);
        this.setPosition(-1);
        this.setRefreshInterval(-2);
        this.setShowTime(true);
        this.setMultiline(false);
    }

    @Override
    public void refresh(TableCell cell, long timestamp) {
        long next;
        Subscription sub = (Subscription)cell.getDataSource();
        if (sub == null) {
            return;
        }
        super.refresh(cell, next, (next = sub.getNextUpdateTime()) == 0L ? Long.MAX_VALUE : next, null);
    }

    @Override
    public void cellHover(TableCell cell) {
        long timestamp_secs;
        Comparable ds = cell.getSortValue();
        if (ds instanceof Number && (timestamp_secs = ((Number)((Object)ds)).longValue() / 1000L) > 0L) {
            long eta = SystemTime.getCurrentTime() / 1000L - timestamp_secs;
            if (eta >= 0L) {
                cell.setToolTip(String.valueOf(DisplayFormatters.formatETA(eta, false)) + " " + MessageText.getString("label.ago"));
            } else {
                cell.setToolTip(DisplayFormatters.formatETA(-eta, false));
            }
        }
    }
}

