/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.subscriptions;

import com.biglybt.core.subs.Subscription;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.imageloader.ImageLoader;
import com.biglybt.ui.swt.views.table.CoreTableColumnSWT;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ColumnSubscriptionNew
extends CoreTableColumnSWT
implements TableCellRefreshListener,
TableCellSWTPaintListener {
    public static final String COLUMN_ID = "new";
    private static final int WIDTH = 38;
    private static Image imgNew;
    private Rectangle imgBounds;

    public ColumnSubscriptionNew(String tableID) {
        super(COLUMN_ID, tableID);
        this.initializeAsGraphic(38);
        this.setRefreshInterval(-2);
        this.setMinWidth(38);
        this.setMaxWidth(38);
        this.setVisible(true);
        imgNew = ImageLoader.getInstance().getImage("image.activity.unread");
        this.imgBounds = imgNew.getBounds();
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    @Override
    public void cellPaint(GC gc, TableCellSWT cell) {
        Subscription sub = (Subscription)cell.getDataSource();
        if (sub.getHistory().getNumUnread() > 0) {
            Rectangle cellBounds = cell.getBounds();
            gc.drawImage(imgNew, cellBounds.x + (cellBounds.width - this.imgBounds.width) / 2, cellBounds.y + (cellBounds.height - this.imgBounds.height) / 2);
        }
    }

    public void cellAdded(TableCell cell) {
        cell.setMarginWidth(0);
        cell.setMarginHeight(0);
    }

    @Override
    public void refresh(TableCell cell) {
        int sortVal;
        Subscription sub = (Subscription)cell.getDataSource();
        boolean isRead = sub.getHistory().getNumUnread() > 0;
        int n = sortVal = isRead ? 1 : 0;
        if (!cell.setSortValue(sortVal) && cell.isValid()) {
            return;
        }
        cell.invalidate();
    }
}

