/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.searchsubs;

import com.biglybt.core.internat.MessageText;
import com.biglybt.core.subs.SubscriptionUtils;
import com.biglybt.core.subs.util.SearchSubsResultBase;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnExtraInfoListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;

public class ColumnSearchSubResultExisting
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static String COLUMN_ID = "in";
    private static final String[] messages = new String[6];

    static {
        MessageText.addAndFireListener((old_locale, new_locale) -> {
            ColumnSearchSubResultExisting.messages[0] = "";
            ColumnSearchSubResultExisting.messages[1] = MessageText.getString("label.library");
            ColumnSearchSubResultExisting.messages[2] = MessageText.getString("label.archive");
            ColumnSearchSubResultExisting.messages[3] = MessageText.getString("label.history");
            ColumnSearchSubResultExisting.messages[4] = "?";
            ColumnSearchSubResultExisting.messages[5] = MessageText.getString("OpenTorrentWindow.mb.notTorrent.retry");
        });
    }

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)0);
    }

    public ColumnSearchSubResultExisting(TableColumn column) {
        column.initialize(3, -1, 60);
        column.setRefreshInterval(-1);
        column.addListeners(this);
    }

    @Override
    public void refresh(TableCell cell) {
        SearchSubsResultBase result = (SearchSubsResultBase)cell.getDataSource();
        int status = SubscriptionUtils.getHashStatus(result);
        if (!cell.setSortValue(status) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        cell.setText(messages[status]);
    }
}

