/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.search;

import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellAddedListener;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.ui.swt.search.SBC_SearchResult;
import com.biglybt.ui.swt.views.table.TableCellSWT;
import com.biglybt.ui.swt.views.table.TableCellSWTPaintListener;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;

public class ColumnSearchResultSite
implements TableCellSWTPaintListener,
TableCellAddedListener,
TableCellRefreshListener {
    public static final String COLUMN_ID = "site";
    private static final int WIDTH = 38;

    public ColumnSearchResultSite(TableColumn column) {
        column.initialize(3, -2, 38);
        column.addListeners(this);
        column.setRefreshInterval(-3);
        column.setType(2);
    }

    @Override
    public void cellPaint(GC gc, TableCellSWT cell) {
        SBC_SearchResult entry = (SBC_SearchResult)cell.getDataSource();
        Rectangle cellBounds = cell.getBounds();
        Image img = entry.getIcon();
        if (img != null && !img.isDisposed()) {
            gc.fillRectangle(cellBounds);
            Rectangle imgBounds = img.getBounds();
            if (cellBounds.width < imgBounds.width || cellBounds.height < imgBounds.height) {
                float dx = (float)cellBounds.width / (float)imgBounds.width;
                float dy = (float)cellBounds.height / (float)imgBounds.height;
                float d = Math.min(dx, dy);
                int newWidth = (int)((float)imgBounds.width * d);
                int newHeight = (int)((float)imgBounds.height * d);
                gc.drawImage(img, 0, 0, imgBounds.width, imgBounds.height, cellBounds.x + (cellBounds.width - newWidth) / 2, cellBounds.y + (cellBounds.height - newHeight) / 2, newWidth, newHeight);
            } else {
                gc.drawImage(img, cellBounds.x + (cellBounds.width - imgBounds.width) / 2, cellBounds.y + (cellBounds.height - imgBounds.height) / 2);
            }
        }
    }

    @Override
    public void cellAdded(TableCell cell) {
        cell.setMarginWidth(0);
        cell.setMarginHeight(0);
    }

    @Override
    public void refresh(TableCell cell) {
        SBC_SearchResult entry = (SBC_SearchResult)cell.getDataSource();
        if (entry != null) {
            long sortVal = entry.getEngine().getId();
            if (!cell.setSortValue(sortVal) && cell.isValid()) {
                return;
            }
            String name = entry.getEngine().getName();
            Image img = entry.getIcon();
            cell.setText(img == null || img.isDisposed() ? name : null);
            cell.setToolTip(name);
        }
    }
}

