/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.dlhistory;

import com.biglybt.core.history.DownloadHistory;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnExtraInfoListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.table.utils.TableColumnSWTUtils;

public class ColumnDLHistorySize
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static String COLUMN_ID = "size";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public ColumnDLHistorySize(TableColumn column) {
        column.setWidth(80);
        column.setAlignment(2);
        column.setRefreshInterval(-3);
        column.addListeners(this);
    }

    @Override
    public void refresh(TableCell cell) {
        DownloadHistory dl = (DownloadHistory)cell.getDataSource();
        long size = 0L;
        if (dl != null) {
            size = dl.getSize();
        }
        if (!cell.setSortValue(size) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        cell.setText(size <= 0L ? "" : DisplayFormatters.formatByteCountToKiBEtc(size));
        TableColumnSWTUtils.setSizeAlpha(cell, size);
    }
}

