/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.dlhistory;

import com.biglybt.core.history.DownloadHistory;
import com.biglybt.core.util.Debug;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnExtraInfoListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.debug.ObfuscateCellText;

public class ColumnDLHistorySaveLocation
implements TableCellRefreshListener,
TableColumnExtraInfoListener,
ObfuscateCellText {
    public static String COLUMN_ID = "savepath";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"content"});
        info.setProficiency((byte)0);
    }

    public ColumnDLHistorySaveLocation(TableColumn column) {
        column.setWidth(600);
        column.addListeners(this);
    }

    @Override
    public void refresh(TableCell cell) {
        DownloadHistory dl = (DownloadHistory)cell.getDataSource();
        String sl = null;
        if (dl != null) {
            sl = dl.getSaveLocation();
        }
        if (sl == null) {
            sl = "";
        }
        if (!cell.setSortValue((Comparable)((Object)sl)) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        cell.setText(sl);
    }

    @Override
    public String getObfuscatedText(TableCell cell) {
        DownloadHistory dl = (DownloadHistory)cell.getDataSource();
        if (dl == null) {
            return "";
        }
        return Debug.secretFileName(dl.getSaveLocation());
    }
}

