/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.archivedls;

import com.biglybt.core.util.Debug;
import com.biglybt.pif.download.DownloadStub;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnExtraInfoListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.debug.ObfuscateCellText;

public class ColumnArchiveDLSaveLocation
implements TableCellRefreshListener,
TableColumnExtraInfoListener,
ObfuscateCellText {
    public static String COLUMN_ID = "path";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public ColumnArchiveDLSaveLocation(TableColumn column) {
        column.setWidth(400);
        column.addListeners(this);
    }

    @Override
    public void refresh(TableCell cell) {
        DownloadStub dl = (DownloadStub)cell.getDataSource();
        String path = null;
        if (dl != null) {
            path = dl.getSavePath();
        }
        if (path == null) {
            path = "";
        }
        if (!cell.setSortValue((Comparable)((Object)path)) && cell.isValid()) {
            return;
        }
        if (!cell.isShown()) {
            return;
        }
        cell.setText(path);
    }

    @Override
    public String getObfuscatedText(TableCell cell) {
        DownloadStub dl = (DownloadStub)cell.getDataSource();
        if (dl == null) {
            return "";
        }
        return Debug.secretFileName(dl.getSavePath());
    }
}

