/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.columns.alltrackers;

import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.TimeFormatter;
import com.biglybt.pif.ui.tables.TableCell;
import com.biglybt.pif.ui.tables.TableCellRefreshListener;
import com.biglybt.pif.ui.tables.TableColumn;
import com.biglybt.pif.ui.tables.TableColumnExtraInfoListener;
import com.biglybt.pif.ui.tables.TableColumnInfo;
import com.biglybt.ui.swt.views.skin.SBC_AllTrackersView;

public class ColumnAllTrackersFailingFor
implements TableCellRefreshListener,
TableColumnExtraInfoListener {
    public static String COLUMN_ID = "alltrackers.failingfor";

    @Override
    public void fillTableColumnInfo(TableColumnInfo info) {
        info.addCategories(new String[]{"essential"});
        info.setProficiency((byte)0);
    }

    public ColumnAllTrackersFailingFor(TableColumn column) {
        column.initialize(3, -2, 80);
        column.setRefreshInterval(-2);
        column.addListeners(this);
    }

    @Override
    public void refresh(TableCell cell) {
        long since;
        long fails;
        SBC_AllTrackersView.AllTrackersViewEntry tr = (SBC_AllTrackersView.AllTrackersViewEntry)cell.getDataSource();
        long sort = 0L;
        String str = "";
        if (tr != null && (fails = tr.getConsecutiveFails()) > 0L && (since = tr.getFailingSinceTime()) > 0L) {
            sort = SystemTime.getCurrentTime() - since;
            long[] new_sort = new long[1];
            str = TimeFormatter.format3(sort / 1000L, new_sort);
            sort = new_sort[0] * 1000L;
        }
        if (!cell.setSortValue(sort) && cell.isValid()) {
            return;
        }
        cell.setText(str);
    }
}

