/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.browser.listener;

import com.biglybt.core.custom.CustomizationManagerFactory;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.messenger.browser.BrowserMessage;
import com.biglybt.core.messenger.browser.listeners.AbstractBrowserMessageListener;
import com.biglybt.core.metasearch.Engine;
import com.biglybt.core.metasearch.MetaSearch;
import com.biglybt.core.metasearch.MetaSearchManager;
import com.biglybt.core.metasearch.MetaSearchManagerFactory;
import com.biglybt.core.metasearch.Result;
import com.biglybt.core.metasearch.ResultListener;
import com.biglybt.core.metasearch.SearchException;
import com.biglybt.core.metasearch.SearchParameter;
import com.biglybt.core.metasearch.impl.web.CookieParser;
import com.biglybt.core.metasearch.impl.web.WebEngine;
import com.biglybt.core.subs.Subscription;
import com.biglybt.core.subs.SubscriptionDownloadListener;
import com.biglybt.core.subs.SubscriptionException;
import com.biglybt.core.subs.SubscriptionHistory;
import com.biglybt.core.subs.SubscriptionManagerFactory;
import com.biglybt.core.subs.SubscriptionResult;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.core.vuzefile.VuzeFile;
import com.biglybt.core.vuzefile.VuzeFileComponent;
import com.biglybt.core.vuzefile.VuzeFileHandler;
import com.biglybt.pifimpl.local.PluginInitializer;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.browser.OpenCloseSearchDetailsListener;
import com.biglybt.ui.swt.browser.listener.ExternalLoginListener;
import com.biglybt.ui.swt.browser.listener.ExternalLoginWindow;
import com.biglybt.ui.swt.mainwindow.TorrentOpener;
import com.biglybt.util.JSONUtils;
import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class MetaSearchListener
extends AbstractBrowserMessageListener {
    public static final String LISTENER_ID = "metasearch";
    public static final String OP_SEARCH = "search";
    public static final String OP_GET_ENGINES = "get-engines";
    public static final String OP_GET_ALL_ENGINES = "get-all-engines";
    public static final String OP_ENGINE_PREFERRED = "engine-preferred";
    public static final String OP_CHANGE_ENGINE_SELECTION = "change-engine-selection";
    public static final String OP_SET_SELECTED_ENGINES = "set-selected-engines";
    public static final String OP_GET_AUTO_MODE = "get-auto-mode";
    public static final String OP_SAVE_TEMPLATE = "save-template";
    public static final String OP_LOAD_TEMPLATE = "load-template";
    public static final String OP_DELETE_TEMPLATE = "delete-template";
    public static final String OP_TEST_TEMPLATE = "test-template";
    public static final String OP_EXPORT_TEMPLATE = "export-template";
    public static final String OP_IMPORT_TEMPLATE = "import-template";
    public static final String OP_OPEN_SEARCH_RESULTS = "open-search-results";
    public static final String OP_CLOSE_SEARCH_RESULTS = "close-search-results";
    public static final String OP_LOAD_TORRENT = "load-torrent";
    public static final String OP_HAS_LOAD_TORRENT = "has-load-torrent";
    public static final String OP_ENGINE_LOGIN = "engine-login";
    public static final String OP_GET_LOGIN_COOKIES = "get-login-cookies";
    public static final String OP_CREATE_SUBSCRIPTION = "create-subscription";
    public static final String OP_READ_SUBSCRIPTION = "read-subscription";
    public static final String OP_UPDATE_SUBSCRIPTION = "update-subscription";
    public static final String OP_READ_SUBSCRIPTION_RESULTS = "read-subscription-results";
    public static final String OP_DELETE_SUBSCRIPTION_RESULTS = "delete-subscription-results";
    public static final String OP_MARK_SUBSCRIPTION_RESULTS = "mark-subscription-results";
    public static final String OP_DOWNLOAD_SUBSCRIPTION = "download-subscription";
    public static final String OP_SUBSCRIPTION_SET_AUTODL = "subscription-set-auto-download";
    public static final String OP_IS_CUSTOMISED = "is-customized";
    public static final String OP_ADD_EXTERNAL_LINKS = "add-external-links";
    private static final Set active_subs_auth = new HashSet();
    private final OpenCloseSearchDetailsListener openCloseSearchDetailsListener;

    public MetaSearchListener(OpenCloseSearchDetailsListener openCloseSearchDetailsListener) {
        super(LISTENER_ID);
        this.openCloseSearchDetailsListener = openCloseSearchDetailsListener;
    }

    @Override
    public void handleMessage(BrowserMessage message) {
        block155: {
            String opid = message.getOperationId();
            MetaSearchManager metaSearchManager = MetaSearchManagerFactory.getSingleton();
            metaSearchManager.log("BrowserListener: received " + message);
            if (OP_SEARCH.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                this.search(decodedMap, null);
            } else if (OP_ENGINE_PREFERRED.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                long engine_id = (Long)decodedMap.get("engine_id");
                Engine engine = this.getEngineFromId(engine_id);
                if (engine != null) {
                    metaSearchManager.getMetaSearch().enginePreferred(engine);
                }
            } else if (OP_ENGINE_LOGIN.equals(opid)) {
                final Map decodedMap = message.getDecodedMap();
                long engine_id = (Long)decodedMap.get("engine_id");
                Long sid = (Long)decodedMap.get("sid");
                final Engine engine = this.getEngineFromId(engine_id);
                if (engine != null && engine instanceof WebEngine) {
                    final WebEngine webEngine = (WebEngine)engine;
                    Utils.execSWTThread(new Runnable(){

                        @Override
                        public void run() {
                            new ExternalLoginWindow(new ExternalLoginListener(){
                                private String previous_cookies;
                                private boolean search_done;

                                @Override
                                public void canceled(ExternalLoginWindow window) {
                                }

                                @Override
                                public void cookiesFound(ExternalLoginWindow window, String cookies) {
                                    if (this.handleCookies(cookies, false)) {
                                        window.close();
                                    }
                                }

                                @Override
                                public void done(ExternalLoginWindow window, String cookies) {
                                    this.handleCookies(cookies, true);
                                }

                                private boolean handleCookies(String cookies, boolean force_if_ready) {
                                    boolean skip_search;
                                    if (this.search_done) {
                                        return false;
                                    }
                                    String[] required = webEngine.getRequiredCookies();
                                    boolean bl = skip_search = required.length == 0 && !force_if_ready;
                                    if (CookieParser.cookiesContain(required, cookies)) {
                                        webEngine.setCookies(cookies);
                                        if (this.previous_cookies == null || !this.previous_cookies.equals(cookies)) {
                                            this.previous_cookies = cookies;
                                            if (!skip_search) {
                                                this.search_done = true;
                                                MetaSearchListener.this.search(decodedMap, webEngine);
                                            }
                                        }
                                    }
                                    return this.search_done;
                                }
                            }, webEngine.getName(), webEngine.getLoginPageUrl(), false, webEngine.getAuthMethod(), engine.isMine());
                        }
                    });
                } else {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    if (sid != null) {
                        params.put("sid", sid);
                    }
                    params.put("error", "engine not found or not a web engine");
                    this.sendBrowserMessage(LISTENER_ID, "engineFailed", params);
                }
            } else if (OP_GET_LOGIN_COOKIES.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                final String url = ((String)decodedMap.get("url")).replaceAll("%s", "");
                Utils.execSWTThread(new Runnable(){

                    @Override
                    public void run() {
                        new ExternalLoginWindow(new ExternalLoginListener(){

                            @Override
                            public void canceled(ExternalLoginWindow window) {
                                MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "setCookiesFailed", new HashMap());
                            }

                            @Override
                            public void cookiesFound(ExternalLoginWindow window, String cookies) {
                            }

                            @Override
                            public void done(ExternalLoginWindow window, String cookies) {
                                String[] cookieNames = CookieParser.getCookiesNames(cookies);
                                HashMap<String, Object> params = new HashMap<String, Object>();
                                params.put("cookieNames", cookieNames);
                                params.put("currentCookie", cookies);
                                params.put("cookieMethod", window.proxyCaptureModeRequired() ? "proxy" : "transparent");
                                MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "setCookies", params);
                            }
                        }, url, url, true, "proxy", true);
                    }
                });
            } else if (OP_GET_ENGINES.equals(opid)) {
                String subscriptionId = null;
                try {
                    Map decodedMap = message.getDecodedMap();
                    subscriptionId = (String)decodedMap.get("subs_id");
                }
                catch (Exception decodedMap) {
                    // empty catch block
                }
                Engine[] engines = null;
                if (subscriptionId != null) {
                    engines = new Engine[]{};
                    Subscription subs = SubscriptionManagerFactory.getSingleton().getSubscriptionByID(subscriptionId);
                    if (subs != null) {
                        try {
                            Engine engine = subs.getEngine();
                            if (engine != null) {
                                engines = new Engine[]{engine};
                            }
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                }
                if (engines == null) {
                    engines = metaSearchManager.getMetaSearch().getEngines(true, true);
                }
                ArrayList params = new ArrayList();
                int i = 0;
                while (i < engines.length) {
                    Engine engine = engines[i];
                    if (engine.isActive() && engine.getSource() != 0 || subscriptionId != null) {
                        HashMap<String, Object> engineMap = new HashMap<String, Object>();
                        engineMap.put("id", new Long(engine.getId()));
                        engineMap.put("name", engine.getName());
                        engineMap.put("favicon", engine.getIcon());
                        engineMap.put("dl_link_css", engine.getDownloadLinkCSS());
                        engineMap.put("selected", Engine.SEL_STATE_STRINGS[engine.getSelectionState()]);
                        engineMap.put("type", Engine.ENGINE_SOURCE_STRS[engine.getSource()]);
                        engineMap.put("shareable", engine.isShareable());
                        params.add(engineMap);
                    }
                    ++i;
                }
                this.sendBrowserMessage(LISTENER_ID, "enginesUsed", params);
            } else if (OP_GET_ALL_ENGINES.equals(opid)) {
                Engine[] engines = metaSearchManager.getMetaSearch().getEngines(false, true);
                ArrayList params = new ArrayList();
                int i = 0;
                while (i < engines.length) {
                    Engine engine = engines[i];
                    if (engine.getSource() != 0) {
                        HashMap<String, Object> engineMap = new HashMap<String, Object>();
                        engineMap.put("id", new Long(engine.getId()));
                        engineMap.put("name", engine.getName());
                        engineMap.put("favicon", engine.getIcon());
                        engineMap.put("dl_link_css", engine.getDownloadLinkCSS());
                        engineMap.put("selected", Engine.SEL_STATE_STRINGS[engine.getSelectionState()]);
                        engineMap.put("type", Engine.ENGINE_SOURCE_STRS[engine.getSource()]);
                        engineMap.put("shareable", engine.isShareable());
                        params.add(engineMap);
                    }
                    ++i;
                }
                this.sendBrowserMessage(LISTENER_ID, "engineList", params);
            } else if (OP_SET_SELECTED_ENGINES.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                List template_ids = (List)decodedMap.get("template_ids");
                long[] ids = new long[template_ids.size()];
                int i = 0;
                while (i < ids.length) {
                    Map m = (Map)template_ids.get(i);
                    ids[i] = (Long)m.get("id");
                    ++i;
                }
                boolean auto = (Boolean)decodedMap.get("auto");
                Boolean is_default = (Boolean)decodedMap.get("set_default");
                boolean skip = false;
                if (is_default != null && is_default.booleanValue() && CustomizationManagerFactory.getSingleton().getActiveCustomization() != null) {
                    skip = true;
                }
                try {
                    if (!skip) {
                        metaSearchManager.setSelectedEngines(ids, auto);
                    }
                    HashMap params = new HashMap();
                    this.sendBrowserMessage(LISTENER_ID, "setSelectedCompleted", params);
                }
                catch (Throwable e) {
                    Debug.out(e);
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("error", Debug.getNestedExceptionMessage(e));
                    this.sendBrowserMessage(LISTENER_ID, "setSelectedFailed", params);
                }
            } else if (OP_CHANGE_ENGINE_SELECTION.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                MetaSearch ms = metaSearchManager.getMetaSearch();
                Engine[] engines = ms.getEngines(false, true);
                HashSet<Long> selected = new HashSet<Long>();
                int i = 0;
                while (i < engines.length) {
                    Engine e = engines[i];
                    if (e.getSelectionState() == 2) {
                        selected.add(new Long(e.getId()));
                    }
                    ++i;
                }
                List l_engines = (List)decodedMap.get("engines");
                int i2 = 0;
                while (i2 < l_engines.size()) {
                    Map map = (Map)l_engines.get(i2);
                    long id = (Long)map.get("id");
                    String str = (String)map.get("selected");
                    if (str.equalsIgnoreCase(Engine.SEL_STATE_STRINGS[2])) {
                        selected.add(new Long(id));
                    } else if (str.equalsIgnoreCase(Engine.SEL_STATE_STRINGS[0])) {
                        selected.remove(new Long(id));
                    }
                    ++i2;
                }
                long[] ids = new long[selected.size()];
                Iterator it = selected.iterator();
                int pos = 0;
                while (it.hasNext()) {
                    long id = (Long)it.next();
                    ids[pos++] = id;
                }
                try {
                    metaSearchManager.setSelectedEngines(ids, metaSearchManager.isAutoMode());
                    HashMap params = new HashMap();
                    this.sendBrowserMessage(LISTENER_ID, "changeEngineSelectionCompleted", params);
                }
                catch (Throwable e) {
                    Debug.out(e);
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("error", Debug.getNestedExceptionMessage(e));
                    this.sendBrowserMessage(LISTENER_ID, "changeEngineSelectionFailed", params);
                }
            } else if (OP_GET_AUTO_MODE.equals(opid)) {
                boolean mode = metaSearchManager.isAutoMode();
                HashMap<String, Boolean> params = new HashMap<String, Boolean>();
                params.put("auto", mode);
                boolean custom = CustomizationManagerFactory.getSingleton().getActiveCustomization() != null;
                params.put("is_custom", custom);
                this.sendBrowserMessage(LISTENER_ID, "getAutoModeResult", params);
            } else if (OP_SAVE_TEMPLATE.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                String type_str = (String)decodedMap.get("type");
                String name = (String)decodedMap.get("name");
                Long l_id = (Long)decodedMap.get("id");
                long id = l_id == null ? -1L : l_id;
                String json = (String)decodedMap.get("value");
                String cookies = (String)decodedMap.get("current_cookie");
                try {
                    Engine engine = metaSearchManager.addEngine(id, type_str.equals("json") ? 2 : 1, name, json);
                    engine.setMine(true);
                    if (cookies != null && engine instanceof WebEngine) {
                        WebEngine we = (WebEngine)engine;
                        we.setCookies(cookies);
                    }
                    HashMap<String, Long> params = new HashMap<String, Long>();
                    params.put("id", new Long(engine.getId()));
                    this.sendBrowserMessage(LISTENER_ID, "saveTemplateCompleted", params);
                }
                catch (Throwable e) {
                    Debug.out(e);
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("id", new Long(id));
                    params.put("error", Debug.getNestedExceptionMessage(e));
                    this.sendBrowserMessage(LISTENER_ID, "saveTemplateFailed", params);
                }
            } else if (OP_LOAD_TEMPLATE.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                long id = (Long)decodedMap.get("id");
                Engine engine = metaSearchManager.getMetaSearch().getEngine(id);
                if (engine == null) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("id", new Long(id));
                    params.put("error", "Template not found");
                    this.sendBrowserMessage(LISTENER_ID, "loadTemplateFailed", params);
                } else {
                    try {
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put("id", new Long(engine.getId()));
                        params.put("name", engine.getName());
                        int type = engine.getType();
                        params.put("type", type < Engine.ENGINE_TYPE_STRS.length ? Engine.ENGINE_TYPE_STRS[type] : Integer.valueOf(type));
                        params.put("value", JSONObject.escape(engine.exportToJSONString()));
                        params.put("shareable", engine.isShareable());
                        params.put("uid", engine.getUID());
                        params.put("supports_direct_download", engine.supportsField(102) || engine.supportsField(105));
                        params.put("auto_dl_supported", engine.getAutoDownloadSupported() == 1);
                        this.sendBrowserMessage(LISTENER_ID, "loadTemplateCompleted", params);
                    }
                    catch (Throwable e) {
                        Debug.out(e);
                        HashMap<String, Object> params = new HashMap<String, Object>();
                        params.put("id", new Long(id));
                        params.put("error", Debug.getNestedExceptionMessage(e));
                        this.sendBrowserMessage(LISTENER_ID, "loadTemplateFailed", params);
                    }
                }
            } else if (OP_DELETE_TEMPLATE.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                long id = (Long)decodedMap.get("id");
                Engine engine = metaSearchManager.getMetaSearch().getEngine(id);
                if (engine == null) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("id", new Long(id));
                    params.put("error", "Template not found");
                    this.sendBrowserMessage(LISTENER_ID, "deleteTemplateFailed", params);
                } else if (engine.getSource() != 2) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("id", new Long(id));
                    params.put("error", "Template is not local");
                    this.sendBrowserMessage(LISTENER_ID, "deleteTemplateFailed", params);
                } else {
                    engine.delete();
                    HashMap<String, Long> params = new HashMap<String, Long>();
                    params.put("id", new Long(id));
                    this.sendBrowserMessage(LISTENER_ID, "deleteTemplateCompleted", params);
                }
            } else if (OP_TEST_TEMPLATE.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                final long id = (Long)decodedMap.get("id");
                long match_count = (Long)decodedMap.get("max_matches");
                String searchText = (String)decodedMap.get("searchText");
                String headers = (String)decodedMap.get("headers");
                final Long sid = (Long)decodedMap.get("sid");
                Engine engine = metaSearchManager.getMetaSearch().getEngine(id);
                if (engine == null) {
                    HashMap<String, Object> params = new HashMap<String, Object>();
                    params.put("id", new Long(id));
                    params.put("error", "Template not found");
                    if (sid != null) {
                        params.put("sid", sid);
                    }
                    this.sendBrowserMessage(LISTENER_ID, "testTemplateFailed", params);
                } else {
                    SearchParameter parameter = new SearchParameter("s", searchText);
                    SearchParameter[] parameters = new SearchParameter[]{parameter};
                    try {
                        engine.search(parameters, new HashMap(), (int)match_count, (int)match_count, headers, new ResultListener(){
                            private String content;
                            private List matches = new ArrayList();

                            @Override
                            public void contentReceived(Engine engine, String _content) {
                                this.content = _content;
                            }

                            @Override
                            public void matchFound(Engine engine, String[] fields) {
                                this.matches.add(fields);
                            }

                            @Override
                            public void resultsReceived(Engine engine, Result[] results) {
                            }

                            @Override
                            public void resultsComplete(Engine engine) {
                                HashMap<String, Object> params = new HashMap<String, Object>();
                                params.put("id", new Long(id));
                                if (sid != null) {
                                    params.put("sid", sid);
                                }
                                params.put("content", JSONObject.escape(this.content));
                                JSONArray l_matches = new JSONArray();
                                params.put("matches", l_matches);
                                int i = 0;
                                while (i < this.matches.size()) {
                                    String[] match = (String[])this.matches.get(i);
                                    JSONArray l_match = new JSONArray();
                                    l_matches.add(l_match);
                                    Collections.addAll(l_match, match);
                                    ++i;
                                }
                                MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "testTemplateCompleted", params);
                            }

                            @Override
                            public void engineFailed(Engine engine, Throwable e) {
                                Debug.out(e);
                                HashMap<String, Object> params = new HashMap<String, Object>();
                                params.put("id", new Long(id));
                                params.put("error", Debug.getNestedExceptionMessage(e));
                                if (sid != null) {
                                    params.put("sid", sid);
                                }
                                MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "testTemplateFailed", params);
                            }

                            @Override
                            public void engineRequiresLogin(Engine engine, Throwable e) {
                                HashMap<String, Object> params = new HashMap<String, Object>();
                                params.put("id", new Long(id));
                                params.put("error", Debug.getNestedExceptionMessage(e));
                                if (sid != null) {
                                    params.put("sid", sid);
                                }
                                MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "testTemplateRequiresLogin", params);
                            }
                        });
                    }
                    catch (SearchException searchException) {}
                }
            } else if (OP_EXPORT_TEMPLATE.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                final long id = (Long)decodedMap.get("id");
                final Engine engine = metaSearchManager.getMetaSearch().getEngine(id);
                if (engine == null) {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("error", "template '" + id + "' not found");
                    this.sendBrowserMessage(LISTENER_ID, "exportTemplateFailed", params);
                } else {
                    final Shell shell = Utils.findAnyShell();
                    shell.getDisplay().asyncExec((Runnable)new AERunnable(){

                        @Override
                        public void runSupport() {
                            FileDialog dialog = new FileDialog(shell, 139264);
                            dialog.setFilterPath(TorrentOpener.getFilterPathData());
                            dialog.setText(MessageText.getString("metasearch.export.select.template.file"));
                            dialog.setFilterExtensions(VuzeFileHandler.getVuzeFileFilterExtensions());
                            dialog.setFilterNames(VuzeFileHandler.getVuzeFileFilterExtensions());
                            String path = TorrentOpener.setFilterPathData(dialog.open());
                            if (path != null) {
                                if (!VuzeFileHandler.isAcceptedVuzeFileName(path)) {
                                    path = VuzeFileHandler.getVuzeFileName(path);
                                }
                                try {
                                    engine.exportToVuzeFile(new File(path));
                                    HashMap<String, Long> params = new HashMap<String, Long>();
                                    params.put("id", new Long(id));
                                    MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "exportTemplateCompleted", params);
                                }
                                catch (Throwable e) {
                                    Debug.out(e);
                                    HashMap<String, Object> params = new HashMap<String, Object>();
                                    params.put("id", new Long(id));
                                    params.put("error", "save failed: " + Debug.getNestedExceptionMessage(e));
                                    MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "exportTemplateFailed", params);
                                }
                            } else {
                                HashMap<String, Object> params = new HashMap<String, Object>();
                                params.put("id", new Long(id));
                                params.put("error", "operation cancelled");
                                MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "exportTemplateFailed", params);
                            }
                        }
                    });
                }
            } else if (OP_IMPORT_TEMPLATE.equals(opid)) {
                final Shell shell = Utils.findAnyShell();
                shell.getDisplay().asyncExec((Runnable)new AERunnable(){

                    @Override
                    public void runSupport() {
                        FileDialog dialog = new FileDialog(shell, 135168);
                        dialog.setFilterPath(TorrentOpener.getFilterPathData());
                        dialog.setText(MessageText.getString("metasearch.import.select.template.file"));
                        dialog.setFilterExtensions(VuzeFileHandler.getVuzeFileFilterExtensions());
                        dialog.setFilterNames(VuzeFileHandler.getVuzeFileFilterExtensions());
                        String path = TorrentOpener.setFilterPathData(dialog.open());
                        if (path != null) {
                            VuzeFileHandler vfh = VuzeFileHandler.getSingleton();
                            VuzeFile vf = vfh.loadAndHandleVuzeFile(path, 1);
                            if (vf == null) {
                                HashMap<String, String> params = new HashMap<String, String>();
                                params.put("error", "invalid .biglybt file");
                                MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "importTemplateFailed", params);
                            } else {
                                VuzeFileComponent[] comps = vf.getComponents();
                                int i = 0;
                                while (i < comps.length) {
                                    Engine engine;
                                    VuzeFileComponent comp2 = comps[i];
                                    if (comp2.getType() == 1 && (engine = (Engine)comp2.getData(Engine.VUZE_FILE_COMPONENT_ENGINE_KEY)) != null) {
                                        HashMap<String, Long> params = new HashMap<String, Long>();
                                        params.put("id", new Long(engine.getId()));
                                        MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "importTemplateCompleted", params);
                                        return;
                                    }
                                    ++i;
                                }
                                HashMap<String, String> params = new HashMap<String, String>();
                                params.put("error", "invalid search template file");
                                MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "importTemplateFailed", params);
                            }
                        } else {
                            HashMap<String, String> params = new HashMap<String, String>();
                            params.put("error", "operation cancelled");
                            MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "importTemplateFailed", params);
                        }
                    }
                });
            } else if (OP_OPEN_SEARCH_RESULTS.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                this.openCloseSearchDetailsListener.openSearchResults(decodedMap);
            } else if (OP_CLOSE_SEARCH_RESULTS.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                this.openCloseSearchDetailsListener.closeSearchResults(decodedMap);
            } else if (OP_LOAD_TORRENT.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                String torrentUrl = (String)decodedMap.get("torrent_url");
                String referer_str = (String)decodedMap.get("referer_url");
                try {
                    Map headers = UrlUtils.getBrowserHeaders(referer_str);
                    String subscriptionId = (String)decodedMap.get("subs_id");
                    String subscriptionResultId = (String)decodedMap.get("subs_rid");
                    if (subscriptionId != null) {
                        Subscription subs = SubscriptionManagerFactory.getSingleton().getSubscriptionByID(subscriptionId);
                        if (subs != null) {
                            try {
                                WebEngine webEngine;
                                Engine engine = subs.getEngine();
                                if (engine != null && engine instanceof WebEngine && (webEngine = (WebEngine)engine).isNeedsAuth()) {
                                    headers.put("Cookie", webEngine.getCookies());
                                }
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                            if (subscriptionResultId != null) {
                                subs.addPotentialAssociation(subscriptionResultId, torrentUrl);
                            }
                        }
                    } else {
                        try {
                            WebEngine webEngine;
                            long engineID = (Long)decodedMap.get("engine_id");
                            Engine engine = metaSearchManager.getMetaSearch().getEngine(engineID);
                            if (engine != null) {
                                engine.addPotentialAssociation(torrentUrl);
                            }
                            if (engine != null && engine instanceof WebEngine && (webEngine = (WebEngine)engine).isNeedsAuth()) {
                                headers.put("Cookie", webEngine.getCookies());
                            }
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    try {
                        String hash = (String)decodedMap.get("hash");
                        if (hash != null && !torrentUrl.toLowerCase(Locale.US).startsWith("magnet:")) {
                            headers.put("X-Alternative-URI-1", UrlUtils.getMagnetURI(Base32.decode(hash)));
                        }
                    }
                    catch (Throwable hash) {
                        // empty catch block
                    }
                    PluginInitializer.getDefaultInterface().getDownloadManager().addDownload(new URL(torrentUrl), headers);
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("torrent_url", torrentUrl);
                    params.put("referer_url", referer_str);
                    this.sendBrowserMessage(LISTENER_ID, "loadTorrentCompleted", params);
                }
                catch (Exception e) {
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("torrent_url", torrentUrl);
                    params.put("referer_url", referer_str);
                    params.put("error", e.getMessage());
                    this.sendBrowserMessage(LISTENER_ID, "loadTorrentFailed", params);
                }
            } else if (OP_HAS_LOAD_TORRENT.equals(opid)) {
                HashMap<String, String> params = new HashMap<String, String>();
                params.put("result", "1");
                this.sendBrowserMessage(LISTENER_ID, "hasLoadTorrent", params);
            } else if (OP_CREATE_SUBSCRIPTION.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                Long tid = (Long)decodedMap.get("tid");
                String name = (String)decodedMap.get("name");
                Boolean isPublic = (Boolean)decodedMap.get("is_public");
                Map options = (Map)decodedMap.get("options");
                Boolean isEnabled = (Boolean)options.get("is_enabled");
                Boolean autoDownload = (Boolean)options.get("auto_dl");
                HashMap<String, Object> result = new HashMap<String, Object>();
                if (tid != null) {
                    result.put("tid", tid);
                }
                try {
                    JSONObject payload = new JSONObject();
                    payload.put("engine_id", decodedMap.get("engine_id"));
                    payload.put("search_term", decodedMap.get("search_term"));
                    payload.put("filters", decodedMap.get("filters"));
                    payload.put("schedule", decodedMap.get("schedule"));
                    payload.put("options", decodedMap.get("options"));
                    Subscription subs = SubscriptionManagerFactory.getSingleton().create(name, isPublic, payload.toString());
                    subs.getHistory().setDetails(isEnabled == null ? true : isEnabled, autoDownload == null ? false : autoDownload);
                    result.put("id", subs.getID());
                    subs.requestAttention();
                    this.sendBrowserMessage(LISTENER_ID, "createSubscriptionCompleted", result);
                }
                catch (Throwable e) {
                    Debug.out(e);
                    result.put("error", "create failed: " + Debug.getNestedExceptionMessage(e));
                    this.sendBrowserMessage(LISTENER_ID, "createSubscriptionFailed", result);
                }
            } else if (OP_READ_SUBSCRIPTION.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                Long tid = (Long)decodedMap.get("tid");
                String sid = (String)decodedMap.get("id");
                HashMap<String, Object> result = new HashMap<String, Object>();
                if (tid != null) {
                    result.put("tid", tid);
                }
                try {
                    Subscription subs = SubscriptionManagerFactory.getSingleton().getSubscriptionByID(sid);
                    if (subs == null) {
                        result.put("error", "Subscription not found");
                        this.sendBrowserMessage(LISTENER_ID, "readSubscriptionFailed", result);
                        break block155;
                    }
                    boolean shareable = subs.isShareable();
                    result.put("id", subs.getID());
                    result.put("name", subs.getName());
                    result.put("is_public", shareable && subs.isPublic());
                    result.put("is_author", subs.isMine());
                    result.put("is_shareable", shareable);
                    result.put("auto_dl_supported", subs.isAutoDownloadSupported());
                    SubscriptionHistory history = subs.getHistory();
                    HashMap<String, Boolean> options = new HashMap<String, Boolean>();
                    result.put("options", options);
                    options.put("is_enabled", history.isEnabled());
                    options.put("auto_dl", history.isAutoDownload());
                    HashMap<String, Long> info = new HashMap<String, Long>();
                    result.put("info", info);
                    info.put("last_scan", new Long(history.getLastScanTime()));
                    info.put("last_new", new Long(history.getLastNewResultTime()));
                    info.put("num_unread", new Long(history.getNumUnread()));
                    info.put("num_read", new Long(history.getNumRead()));
                    String json = subs.getJSON();
                    Map map = JSONUtils.decodeJSON(json);
                    result.put("engine_id", map.get("engine_id"));
                    result.put("search_term", map.get("search_term"));
                    result.put("filters", map.get("filters"));
                    result.put("schedule", map.get("schedule"));
                    this.sendBrowserMessage(LISTENER_ID, "readSubscriptionCompleted", result);
                }
                catch (Throwable e) {
                    Debug.out(e);
                    result.put("error", "read failed: " + Debug.getNestedExceptionMessage(e));
                    this.sendBrowserMessage(LISTENER_ID, "readSubscriptionFailed", result);
                }
            } else if (OP_UPDATE_SUBSCRIPTION.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                Long tid = (Long)decodedMap.get("tid");
                String name = (String)decodedMap.get("name");
                Boolean isPublic = (Boolean)decodedMap.get("is_public");
                String sid = (String)decodedMap.get("id");
                Map options = (Map)decodedMap.get("options");
                Boolean isEnabled = (Boolean)options.get("is_enabled");
                Boolean autoDownload = (Boolean)options.get("auto_dl");
                HashMap<String, Object> result = new HashMap<String, Object>();
                if (tid != null) {
                    result.put("tid", tid);
                }
                try {
                    Subscription subs = SubscriptionManagerFactory.getSingleton().getSubscriptionByID(sid);
                    if (subs == null) {
                        result.put("error", "Subscription not found");
                        this.sendBrowserMessage(LISTENER_ID, "updateSubscriptionFailed", result);
                        break block155;
                    }
                    JSONObject payload = new JSONObject();
                    payload.put("engine_id", decodedMap.get("engine_id"));
                    payload.put("search_term", decodedMap.get("search_term"));
                    payload.put("filters", decodedMap.get("filters"));
                    payload.put("schedule", decodedMap.get("schedule"));
                    payload.put("options", decodedMap.get("options"));
                    boolean changed = subs.setDetails(name, isPublic, payload.toString());
                    subs.getHistory().setDetails(isEnabled == null ? true : isEnabled, autoDownload == null ? false : autoDownload);
                    if (changed) {
                        subs.reset();
                        try {
                            subs.getManager().getScheduler().downloadAsync(subs, true);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                    }
                    result.put("id", subs.getID());
                    this.sendBrowserMessage(LISTENER_ID, "updateSubscriptionCompleted", result);
                }
                catch (Throwable e) {
                    Debug.out(e);
                    result.put("error", "update failed: " + Debug.getNestedExceptionMessage(e));
                    this.sendBrowserMessage(LISTENER_ID, "updateSubscriptionFailed", result);
                }
            } else if (OP_SUBSCRIPTION_SET_AUTODL.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                String sid = (String)decodedMap.get("id");
                Long tid = (Long)decodedMap.get("tid");
                Boolean autoDownload = (Boolean)decodedMap.get("auto_dl");
                HashMap<String, Object> result = new HashMap<String, Object>();
                if (tid != null) {
                    result.put("tid", tid);
                }
                try {
                    Subscription subs = SubscriptionManagerFactory.getSingleton().getSubscriptionByID(sid);
                    if (subs == null) {
                        result.put("error", "Subscription not found");
                        this.sendBrowserMessage(LISTENER_ID, "setSubscriptionAutoDownloadFailed", result);
                        break block155;
                    }
                    subs.getHistory().setAutoDownload(autoDownload);
                    this.sendBrowserMessage(LISTENER_ID, "setSubscriptionAutoDownloadCompleted", result);
                }
                catch (Throwable e) {
                    Debug.out(e);
                    result.put("error", "update failed: " + Debug.getNestedExceptionMessage(e));
                    this.sendBrowserMessage(LISTENER_ID, "setSubscriptionAutoDownloadFailed", result);
                }
            } else if (OP_READ_SUBSCRIPTION_RESULTS.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                Long tid = (Long)decodedMap.get("tid");
                String sid = (String)decodedMap.get("id");
                final HashMap<String, Object> result = new HashMap<String, Object>();
                if (tid != null) {
                    result.put("tid", tid);
                }
                try {
                    Subscription subs = SubscriptionManagerFactory.getSingleton().getSubscriptionByID(sid);
                    if (subs == null) {
                        result.put("error", "Subscription not found");
                        this.sendBrowserMessage(LISTENER_ID, "readSubscriptionResultsFailed", result);
                        break block155;
                    }
                    result.put("id", subs.getID());
                    if (this.handleSubscriptionAuth(subs, result)) break block155;
                    if (subs.getHistory().getLastScanTime() == 0L) {
                        subs.getManager().getScheduler().download(subs, false, new SubscriptionDownloadListener(){

                            @Override
                            public void complete(Subscription subs) {
                                if (!MetaSearchListener.this.handleSubscriptionAuth(subs, result)) {
                                    MetaSearchListener.this.encodeResults(subs, result);
                                    MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "readSubscriptionResultsCompleted", result);
                                    MetaSearchListener.this.openCloseSearchDetailsListener.resizeMainBrowser();
                                }
                            }

                            @Override
                            public void failed(Subscription subs, SubscriptionException error) {
                                Debug.out(error);
                                result.put("error", "read failed: " + Debug.getNestedExceptionMessage(error));
                                MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "readSubscriptionResultsFailed", result);
                            }
                        });
                        break block155;
                    }
                    this.encodeResults(subs, result);
                    this.sendBrowserMessage(LISTENER_ID, "readSubscriptionResultsCompleted", result);
                    this.openCloseSearchDetailsListener.resizeMainBrowser();
                }
                catch (Throwable e) {
                    Debug.out(e);
                    result.put("error", "read failed: " + Debug.getNestedExceptionMessage(e));
                    this.sendBrowserMessage(LISTENER_ID, "readSubscriptionFailed", result);
                }
            } else if (OP_DELETE_SUBSCRIPTION_RESULTS.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                String sid = (String)decodedMap.get("id");
                List rids = (List)decodedMap.get("rids");
                try {
                    Subscription subs = SubscriptionManagerFactory.getSingleton().getSubscriptionByID(sid);
                    if (subs == null) {
                        HashMap<String, String> params = new HashMap<String, String>();
                        params.put("error", "Subscription not found");
                        this.sendBrowserMessage(LISTENER_ID, "deleteSubscriptionResultsFailed", params);
                        break block155;
                    }
                    String[] rids_a = rids.toArray(new String[rids.size()]);
                    subs.getHistory().deleteResults(rids_a);
                    HashMap<String, List> result = new HashMap<String, List>();
                    result.put("rids", rids);
                    this.sendBrowserMessage(LISTENER_ID, "deleteSubscriptionResultsCompleted", result);
                }
                catch (Throwable e) {
                    Debug.out(e);
                    HashMap<String, String> params = new HashMap<String, String>();
                    params.put("error", "delete failed: " + Debug.getNestedExceptionMessage(e));
                    this.sendBrowserMessage(LISTENER_ID, "deleteSubscriptionResultsFailed", params);
                }
            } else if (OP_MARK_SUBSCRIPTION_RESULTS.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                String sid = (String)decodedMap.get("id");
                List rids = (List)decodedMap.get("rids");
                List reads = (List)decodedMap.get("reads");
                HashMap<String, Object> result = new HashMap<String, Object>();
                try {
                    Subscription subs = SubscriptionManagerFactory.getSingleton().getSubscriptionByID(sid);
                    if (subs == null) {
                        result.put("error", "Subscription not found");
                        this.sendBrowserMessage(LISTENER_ID, "markSubscriptionResultsFailed", result);
                        break block155;
                    }
                    String[] rids_a = rids.toArray(new String[rids.size()]);
                    boolean[] reads_a = new boolean[reads.size()];
                    int i = 0;
                    while (i < reads.size()) {
                        reads_a[i] = (Boolean)reads.get(i);
                        ++i;
                    }
                    subs.getHistory().markResults(rids_a, reads_a);
                    result.put("rids", rids);
                    result.put("reads", reads);
                    this.sendBrowserMessage(LISTENER_ID, "markSubscriptionResultsCompleted", result);
                }
                catch (Throwable e) {
                    Debug.out(e);
                    result.put("error", "mark failed: " + Debug.getNestedExceptionMessage(e));
                    this.sendBrowserMessage(LISTENER_ID, "markSubscriptionResultsFailed", result);
                }
            } else if (OP_DOWNLOAD_SUBSCRIPTION.equals(opid)) {
                Map decodedMap = message.getDecodedMap();
                Long tid = (Long)decodedMap.get("tid");
                String sid = (String)decodedMap.get("id");
                final HashMap<String, Object> result = new HashMap<String, Object>();
                if (tid != null) {
                    result.put("tid", tid);
                }
                try {
                    Subscription subs = SubscriptionManagerFactory.getSingleton().getSubscriptionByID(sid);
                    if (subs == null) {
                        result.put("error", "Subscription not found");
                        this.sendBrowserMessage(LISTENER_ID, "downloadSubscriptionFailed", result);
                    } else {
                        result.put("id", subs.getID());
                        if (!this.handleSubscriptionAuth(subs, result)) {
                            subs.getManager().getScheduler().download(subs, false, new SubscriptionDownloadListener(){

                                @Override
                                public void complete(Subscription subs) {
                                    if (!MetaSearchListener.this.handleSubscriptionAuth(subs, result)) {
                                        MetaSearchListener.this.encodeResults(subs, result);
                                        MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "downloadSubscriptionCompleted", result);
                                    }
                                }

                                @Override
                                public void failed(Subscription subs, SubscriptionException error) {
                                    Debug.out(error);
                                    result.put("error", "read failed: " + Debug.getNestedExceptionMessage(error));
                                    MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "downloadSubscriptionFailed", result);
                                }
                            });
                        }
                    }
                }
                catch (Throwable e) {
                    Debug.out(e);
                    result.put("error", "read failed: " + Debug.getNestedExceptionMessage(e));
                    this.sendBrowserMessage(LISTENER_ID, "downloadSubscriptionFailed", result);
                }
            } else if (OP_IS_CUSTOMISED.equals(opid)) {
                boolean custom = CustomizationManagerFactory.getSingleton().getActiveCustomization() != null;
                HashMap<String, Boolean> params = new HashMap<String, Boolean>();
                params.put("is_custom", custom);
                this.sendBrowserMessage(LISTENER_ID, "isCustomizedResult", params);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected boolean handleSubscriptionAuth(final Subscription subs, final Map result) {
        if (!subs.getHistory().isAuthFail()) {
            return false;
        }
        try {
            Engine engine = subs.getEngine();
            if (!(engine instanceof WebEngine)) {
                return false;
            }
            final WebEngine webEngine = (WebEngine)engine;
            Set set = active_subs_auth;
            synchronized (set) {
                if (active_subs_auth.contains(subs)) {
                    return false;
                }
                active_subs_auth.add(subs);
            }
            Utils.execSWTThread(new Runnable(){

                @Override
                public void run() {
                    new ExternalLoginWindow(new ExternalLoginListener(){
                        private String previous_cookies;
                        private boolean result_sent;

                        @Override
                        public void canceled(ExternalLoginWindow window) {
                            try {
                                MetaSearchListener.this.encodeResults(subs, result);
                                MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "readSubscriptionResultsCompleted", result);
                            }
                            finally {
                                this.completed();
                            }
                        }

                        @Override
                        public void cookiesFound(ExternalLoginWindow window, String cookies) {
                            if (this.handleCookies(cookies, false)) {
                                window.close();
                            }
                        }

                        @Override
                        public void done(ExternalLoginWindow window, String cookies) {
                            try {
                                if (!this.handleCookies(cookies, true)) {
                                    MetaSearchListener.this.encodeResults(subs, result);
                                    MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "readSubscriptionResultsCompleted", result);
                                }
                            }
                            finally {
                                this.completed();
                            }
                        }

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         */
                        private void completed() {
                            Set set = active_subs_auth;
                            synchronized (set) {
                                active_subs_auth.remove(subs);
                            }
                        }

                        private boolean handleCookies(String cookies, boolean force_if_ready) {
                            boolean skip;
                            if (this.result_sent) {
                                return false;
                            }
                            String[] required = webEngine.getRequiredCookies();
                            boolean bl = skip = required.length == 0 && !force_if_ready;
                            if (CookieParser.cookiesContain(required, cookies)) {
                                webEngine.setCookies(cookies);
                                if (this.previous_cookies == null || !this.previous_cookies.equals(cookies)) {
                                    this.previous_cookies = cookies;
                                    if (!skip) {
                                        this.result_sent = true;
                                        try {
                                            subs.getManager().getScheduler().download(subs, false, new SubscriptionDownloadListener(){

                                                @Override
                                                public void complete(Subscription subs) {
                                                    result.put("id", subs.getID());
                                                    MetaSearchListener.this.encodeResults(subs, result);
                                                    MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "readSubscriptionResultsCompleted", result);
                                                }

                                                @Override
                                                public void failed(Subscription subs, SubscriptionException error) {
                                                    Debug.out(error);
                                                    result.put("error", "read failed: " + Debug.getNestedExceptionMessage(error));
                                                    MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "readSubscriptionResultsFailed", result);
                                                }
                                            });
                                        }
                                        catch (Throwable error) {
                                            Debug.out(error);
                                            result.put("error", "read failed: " + Debug.getNestedExceptionMessage(error));
                                            MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "readSubscriptionResultsFailed", result);
                                        }
                                    }
                                }
                            }
                            return this.result_sent;
                        }
                    }, webEngine.getName(), webEngine.getLoginPageUrl(), false, webEngine.getAuthMethod(), subs.isMine());
                }
            });
            return true;
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
            return false;
        }
    }

    protected void search(Map decodedMap, Engine target) {
        Subscription subs;
        String subscriptionId;
        int max_per_engine;
        String searchText = (String)decodedMap.get("searchText");
        String headers = (String)decodedMap.get("headers");
        final Long sid = (Long)decodedMap.get("sid");
        Boolean mature = (Boolean)decodedMap.get("mature");
        Long l_max_per_engine = (Long)decodedMap.get("maxResultsPerEngine");
        int n = max_per_engine = l_max_per_engine == null ? 100 : l_max_per_engine.intValue();
        if (max_per_engine < 1) {
            max_per_engine = 1;
        }
        if (target == null && (subscriptionId = (String)decodedMap.get("subs_id")) != null && (subs = SubscriptionManagerFactory.getSingleton().getSubscriptionByID(subscriptionId)) != null) {
            try {
                Engine engine = subs.getEngine();
                if (engine != null) {
                    target = engine;
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
        ResultListener listener = new ResultListener(){

            @Override
            public void contentReceived(Engine engine, String content) {
            }

            @Override
            public void matchFound(Engine engine, String[] fields) {
            }

            @Override
            public void engineFailed(Engine engine, Throwable e) {
                Debug.out(e);
                Map params = this.getParams(engine);
                params.put("error", Debug.getNestedExceptionMessage(e));
                MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "engineFailed", params);
            }

            @Override
            public void engineRequiresLogin(Engine engine, Throwable e) {
                Map params = this.getParams(engine);
                params.put("error", Debug.getNestedExceptionMessage(e));
                MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "engineRequiresLogin", params);
            }

            @Override
            public void resultsComplete(Engine engine) {
                MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "engineCompleted", this.getParams(engine));
            }

            @Override
            public void resultsReceived(Engine engine, Result[] results) {
                Map params = this.getParams(engine);
                ArrayList<Map> resultsList = new ArrayList<Map>(results.length);
                int i = 0;
                while (i < results.length) {
                    Result result = results[i];
                    resultsList.add(result.toJSONMap());
                    ++i;
                }
                params.put("results", resultsList);
                MetaSearchListener.this.sendBrowserMessage(MetaSearchListener.LISTENER_ID, "resultsReceived", params);
            }

            protected Map getParams(Engine engine) {
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("id", new Long(engine.getId()));
                params.put("name", engine.getName());
                params.put("favicon", engine.getIcon());
                params.put("dl_link_css", engine.getDownloadLinkCSS());
                params.put("shareable", engine.isShareable());
                if (sid != null) {
                    params.put("sid", sid);
                }
                return params;
            }
        };
        ArrayList<SearchParameter> sps = new ArrayList<SearchParameter>();
        sps.add(new SearchParameter("s", searchText));
        if (mature != null) {
            sps.add(new SearchParameter("m", mature.toString()));
        }
        SearchParameter[] parameters = sps.toArray(new SearchParameter[sps.size()]);
        MetaSearchManager metaSearchManager = MetaSearchManagerFactory.getSingleton();
        HashMap<String, String> context2 = new HashMap<String, String>();
        context2.put("force_full", "true");
        context2.put("batch_millis", "1000");
        context2.put("remove_dup_hash", "true");
        if (target == null) {
            metaSearchManager.getMetaSearch().search(listener, parameters, headers, context2, max_per_engine);
        } else {
            metaSearchManager.getMetaSearch().search(new Engine[]{target}, listener, parameters, headers, context2, max_per_engine);
        }
    }

    protected void encodeResults(Subscription subs, Map result) {
        JSONArray results_list = new JSONArray();
        SubscriptionResult[] results = subs.getHistory().getResults(false);
        int i = 0;
        while (i < results.length) {
            SubscriptionResult r = results[i];
            results_list.add(r.toJSONMap());
            ++i;
        }
        result.put("results", results_list);
    }

    protected Engine getEngineFromId(long id) {
        MetaSearchManager metaSearchManager = MetaSearchManagerFactory.getSingleton();
        Engine[] engines = metaSearchManager.getMetaSearch().getEngines(false, true);
        int i = 0;
        while (i < engines.length) {
            Engine engine = engines[i];
            if (engine.getId() == id) {
                return engine;
            }
            ++i;
        }
        return null;
    }

    public boolean sendBrowserMessage(String key, String op, Map params) {
        MetaSearchManagerFactory.getSingleton().log("BrowserListener: sent " + op + ": " + params);
        return this.context.sendBrowserMessage(key, op, params);
    }

    public boolean sendBrowserMessage(String key, String op, Collection params) {
        MetaSearchManagerFactory.getSingleton().log("BrowserListener: sent " + op + ": " + params);
        return this.context.sendBrowserMessage(key, op, params);
    }
}

