/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt.beta;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Constants;
import com.biglybt.pif.update.UpdateCheckInstance;
import com.biglybt.pif.update.UpdateCheckInstanceListener;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.ui.mdi.MultipleDocumentInterface;
import com.biglybt.ui.swt.beta.BetaWizardStart;
import com.biglybt.ui.swt.shells.MessageBoxShell;
import com.biglybt.ui.swt.update.UpdateMonitor;
import com.biglybt.ui.swt.wizard.Wizard;

public class BetaWizard
extends Wizard {
    private boolean beta_enabled;
    private boolean beta_was_enabled;
    private boolean finished;

    public BetaWizard() {
        super("beta.wizard.title", false);
        this.beta_was_enabled = this.beta_enabled = COConfigurationManager.getBooleanParameter("Beta Programme Enabled");
        BetaWizardStart panel = new BetaWizardStart(this);
        this.setFirstPanel(panel);
    }

    @Override
    public void onClose() {
        MultipleDocumentInterface mdi;
        super.onClose();
        if (!this.finished) {
            return;
        }
        COConfigurationManager.setParameter("Beta Programme Enabled", this.beta_enabled);
        UIFunctions uif = UIFunctionsManager.getUIFunctions();
        if (uif != null && (mdi = uif.getMDI()) != null) {
            if (this.beta_enabled) {
                mdi.showEntryByID("BetaProgramme");
            } else {
                mdi.closeEntryByID("BetaProgramme");
            }
        }
        if (!this.beta_enabled && Constants.IS_CVS_VERSION) {
            MessageBoxShell mb = new MessageBoxShell(34, MessageText.getString("beta.wizard.disable.title"), MessageText.getString("beta.wizard.disable.text"));
            mb.open(null);
        } else if (this.beta_enabled && !this.beta_was_enabled) {
            UpdateMonitor.getSingleton(CoreFactory.getSingleton()).performCheck(true, false, false, new UpdateCheckInstanceListener(){

                @Override
                public void cancelled(UpdateCheckInstance instance) {
                }

                @Override
                public void complete(UpdateCheckInstance instance) {
                }
            });
        }
    }

    protected boolean getBetaEnabled() {
        return this.beta_enabled;
    }

    protected void setBetaEnabled(boolean b) {
        this.beta_enabled = b;
    }

    public void finish() {
        this.finished = true;
        this.close();
    }
}

