/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.Utils;
import com.biglybt.ui.swt.mainwindow.Colors;
import com.biglybt.util.StringCompareUtils;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseMoveListener;
import org.eclipse.swt.events.MouseTrackAdapter;
import org.eclipse.swt.events.MouseTrackListener;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class TextWithHistory {
    private static final int MAX_MATCHES = 10;
    private static final int MAX_HISTORY = 64;
    private final boolean disabled;
    private final String config_prefix;
    private final String enabled_prefix;
    private final Text text;
    private final Color text_bg;
    private List<String> history;
    private Shell current_shell;
    private org.eclipse.swt.widgets.List list;
    private boolean mouse_entered;
    private boolean menu_visible;
    private boolean keyDownShowsHistory = true;

    public TextWithHistory(String _config_prefix, Text _text) {
        this(_config_prefix, _config_prefix, _text);
    }

    public TextWithHistory(String _config_prefix, String _enabled_prefix, Text _text) {
        Listener l;
        this.config_prefix = _config_prefix;
        this.enabled_prefix = _enabled_prefix;
        this.text = _text;
        this.text_bg = this.text.getBackground();
        TextWithHistory existing = (TextWithHistory)this.text.getData("TextWithHistory::instance");
        if (existing != null) {
            if (!StringCompareUtils.equals(this.config_prefix, existing.config_prefix)) {
                Debug.out("Config keys differ: " + this.config_prefix + "/" + existing.config_prefix);
            }
            this.disabled = true;
            return;
        }
        this.text.setData("TextWithHistory::instance", (Object)this);
        this.disabled = Constants.isLinux;
        if (this.disabled) {
            return;
        }
        this.loadHistory();
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!COConfigurationManager.getBooleanParameter(String.valueOf(TextWithHistory.this.enabled_prefix) + ".enabled", true)) {
                    if (TextWithHistory.this.current_shell != null) {
                        TextWithHistory.this.current_shell.dispose();
                    }
                    return;
                }
                String current_text = TextWithHistory.this.text.getText().trim();
                TextWithHistory.this.handleSearch(current_text, false);
            }
        });
        this.text.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
                final Shell shell = TextWithHistory.this.current_shell;
                if (shell != null) {
                    Utils.execSWTThreadLater(TextWithHistory.this.mouse_entered ? 500 : 0, new Runnable(){

                        @Override
                        public void run() {
                            if (TextWithHistory.this.current_shell == shell && !TextWithHistory.this.menu_visible) {
                                shell.dispose();
                            }
                        }
                    });
                }
            }

            public void focusGained(FocusEvent e) {
            }
        });
        Listener[] old_down = this.text.getListeners(1);
        Listener[] old_up = this.text.getListeners(2);
        Listener[] listenerArray = old_down;
        int n = old_down.length;
        int n2 = 0;
        while (n2 < n) {
            l = listenerArray[n2];
            this.text.removeListener(1, l);
            ++n2;
        }
        listenerArray = old_up;
        n = old_up.length;
        n2 = 0;
        while (n2 < n) {
            l = listenerArray[n2];
            this.text.removeListener(2, l);
            ++n2;
        }
        this.text.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyPressed(KeyEvent e) {
                int key = e.keyCode;
                if (TextWithHistory.this.list == null || TextWithHistory.this.list.isDisposed()) {
                    String current_text;
                    if (key == 0x1000002 && TextWithHistory.this.keyDownShowsHistory && (current_text = TextWithHistory.this.text.getText().trim()).length() == 0) {
                        TextWithHistory.this.handleSearch(current_text, true);
                        e.doit = false;
                    }
                    return;
                }
                if (key == 0x1000002) {
                    e.doit = false;
                    int curr = TextWithHistory.this.list.getSelectionIndex();
                    if (++curr < TextWithHistory.this.list.getItemCount()) {
                        TextWithHistory.this.list.setSelection(curr);
                    }
                } else if (key == 0x1000001) {
                    int curr = TextWithHistory.this.list.getSelectionIndex();
                    if (--curr < 0) {
                        TextWithHistory.this.list.deselectAll();
                    } else {
                        TextWithHistory.this.list.setSelection(curr);
                    }
                    e.doit = false;
                } else if ((key == 13 || key == 10 || key == 0x1000050) && TextWithHistory.this.fireSelected()) {
                    e.doit = false;
                }
            }
        });
        listenerArray = old_down;
        n = old_down.length;
        n2 = 0;
        while (n2 < n) {
            l = listenerArray[n2];
            this.text.addListener(1, l);
            ++n2;
        }
        listenerArray = old_up;
        n = old_up.length;
        n2 = 0;
        while (n2 < n) {
            l = listenerArray[n2];
            this.text.addListener(2, l);
            ++n2;
        }
        this.text.addListener(8, e -> {
            if (!COConfigurationManager.getBooleanParameter(String.valueOf(this.enabled_prefix) + ".enabled", true)) {
                return;
            }
            String current_text = this.text.getText().trim();
            if (current_text.length() == 0) {
                this.handleSearch(current_text, true);
                e.doit = false;
            }
        });
    }

    public void setKeDownShowsHistory(boolean b) {
        this.keyDownShowsHistory = b;
    }

    private void handleSearch(String current_text, boolean force) {
        List<String> current_matches = this.match(current_text);
        if (!(current_text.length() != 0 && current_matches.size() != 0 || force)) {
            if (this.current_shell != null) {
                this.current_shell.dispose();
            }
            return;
        }
        if (this.current_shell == null) {
            this.mouse_entered = false;
            this.menu_visible = false;
            this.current_shell = new Shell(this.text.getShell(), 524296);
            this.current_shell.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent e) {
                    TextWithHistory.this.current_shell = null;
                    TextWithHistory.this.list = null;
                    TextWithHistory.this.mouse_entered = false;
                    TextWithHistory.this.menu_visible = false;
                }
            });
        } else {
            String[] items = this.list.getItems();
            if (items.length == current_matches.size()) {
                boolean same = true;
                int i = 0;
                while (i < items.length) {
                    if (!items[i].equals(current_matches.get(i))) {
                        same = false;
                        break;
                    }
                    ++i;
                }
                if (same) {
                    return;
                }
            }
            Utils.disposeComposite((Composite)this.current_shell, false);
        }
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        this.current_shell.setLayout((Layout)layout);
        this.current_shell.setBackground(this.text_bg);
        final Composite comp2 = new Composite((Composite)this.current_shell, 0);
        comp2.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.marginLeft = 2;
        layout.marginRight = 2;
        layout.marginBottom = 2;
        comp2.setLayout((Layout)layout);
        comp2.setBackground(this.text_bg);
        comp2.addPaintListener(new PaintListener(){

            public void paintControl(PaintEvent e) {
                GC gc = e.gc;
                gc.setForeground(Colors.dark_grey);
                Rectangle bounds = comp2.getBounds();
                gc.drawLine(0, 0, 0, bounds.height - 1);
                gc.drawLine(bounds.width - 1, 0, bounds.width - 1, bounds.height - 1);
                gc.drawLine(0, bounds.height - 1, bounds.width - 1, bounds.height - 1);
            }
        });
        this.list = new org.eclipse.swt.widgets.List(comp2, 0);
        this.list.setLayoutData((Object)new GridData(1808));
        for (String match : current_matches) {
            this.list.add(match);
        }
        this.list.setFont(this.text.getFont());
        this.list.setBackground(this.text_bg);
        this.list.deselectAll();
        this.list.addMouseMoveListener(new MouseMoveListener(){

            public void mouseMove(MouseEvent e) {
                int item_height = TextWithHistory.this.list.getItemHeight();
                int y = e.y;
                int item_index = y / item_height;
                if (TextWithHistory.this.list.getSelectionIndex() != item_index) {
                    TextWithHistory.this.list.setSelection(item_index);
                }
            }
        });
        this.list.addMouseTrackListener((MouseTrackListener)new MouseTrackAdapter(){

            public void mouseEnter(MouseEvent e) {
                TextWithHistory.this.mouse_entered = true;
            }

            public void mouseExit(MouseEvent e) {
                TextWithHistory.this.list.deselectAll();
                TextWithHistory.this.mouse_entered = false;
            }
        });
        this.list.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextWithHistory.this.fireSelected();
            }
        });
        Menu menu = new Menu((Control)this.list);
        this.list.setMenu(menu);
        MenuItem mi = new MenuItem(menu, 8);
        mi.setText(MessageText.getString("label.clear.history"));
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                TextWithHistory.this.clearHistory();
            }
        });
        mi = new MenuItem(menu, 2);
        mi = new MenuItem(menu, 8);
        mi.setText(MessageText.getString("label.disable.history"));
        mi.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                COConfigurationManager.setParameter(String.valueOf(TextWithHistory.this.enabled_prefix) + ".enabled", false);
            }
        });
        menu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                TextWithHistory.this.menu_visible = true;
            }

            public void menuHidden(MenuEvent e) {
                TextWithHistory.this.menu_visible = false;
            }
        });
        this.current_shell.pack(true);
        this.current_shell.layout(true, true);
        Rectangle bounds = this.text.getBounds();
        Point shell_pos = this.text.toDisplay(0, bounds.height + (Constants.isOSX ? 2 : 0));
        this.current_shell.setLocation(shell_pos);
        Rectangle shell_size = this.current_shell.getBounds();
        shell_size.width += 4;
        if (shell_size.width > bounds.width) {
            shell_size.width = bounds.width;
        } else if (shell_size.width < 200 && bounds.width >= 200) {
            shell_size.width = 200;
        }
        this.current_shell.setBounds(shell_size);
        this.current_shell.setVisible(true);
    }

    private boolean fireSelected() {
        String[] selection = this.list.getSelection();
        if (selection.length > 0) {
            String chars = selection[0];
            this.text.setText(chars);
            this.text.setSelection(chars.length());
            if (this.current_shell != null) {
                this.current_shell.dispose();
            }
            return true;
        }
        if (this.current_shell != null) {
            this.current_shell.dispose();
        }
        return false;
    }

    private List<String> match(String str) {
        str = str.trim();
        ArrayList<String> matches = new ArrayList<String>();
        for (String h : this.history) {
            if (!(h = h.trim()).startsWith(str)) continue;
            matches.add(h);
            if (matches.size() == 10) break;
        }
        return matches;
    }

    private void loadHistory() {
        final ParameterListener listener = new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                List<String> sl = COConfigurationManager.getStringListParameter(name);
                TextWithHistory.this.history = new ArrayList();
                if (sl != null) {
                    TextWithHistory.this.history.addAll(sl);
                }
            }
        };
        COConfigurationManager.addAndFireParameterListener(String.valueOf(this.config_prefix) + ".data", listener);
        this.text.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                COConfigurationManager.removeParameterListener(String.valueOf(TextWithHistory.this.config_prefix) + ".data", listener);
            }
        });
    }

    private void clearHistory() {
        String key = String.valueOf(this.config_prefix) + ".data";
        List<String> sl = COConfigurationManager.getStringListParameter(key);
        sl.clear();
        COConfigurationManager.setParameter(key, sl);
    }

    public void addHistory(String str) {
        if (this.disabled) {
            return;
        }
        str = str.trim();
        String key = String.valueOf(this.config_prefix) + ".data";
        List<String> sl = COConfigurationManager.getStringListParameter(key);
        sl.clear();
        sl.add(str);
        for (String h : this.history) {
            if (str.startsWith(h)) continue;
            sl.add(h);
            if (sl.size() == 64) break;
        }
        COConfigurationManager.setParameter(key, sl);
        COConfigurationManager.setDirty();
    }
}

