/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.swt;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.util.AEDiagnostics;
import com.biglybt.core.util.Debug;
import com.biglybt.ui.swt.BrowserWrapperFake;
import com.biglybt.ui.swt.BrowserWrapperSWTFactory;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.browser.StatusTextListener;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public abstract class BrowserWrapper {
    public static BrowserWrapper createBrowser(Composite composite, int style) {
        AEDiagnostics.waitForDumpChecks(10000L);
        boolean use_fake = COConfigurationManager.getBooleanParameter("browser.internal.disable");
        if (use_fake) {
            return new BrowserWrapperFake(composite, style, null);
        }
        return BrowserWrapperSWTFactory.create(composite, style);
    }

    protected BrowserWrapper() {
    }

    public abstract boolean isFake();

    public abstract Composite getControl();

    public abstract void setVisible(boolean var1);

    public abstract boolean isVisible();

    public abstract boolean isDisposed();

    public abstract void dispose();

    public abstract boolean execute(String var1);

    public abstract boolean isBackEnabled();

    public abstract String getUrl();

    public abstract void setUrl(String var1);

    public abstract void setText(String var1);

    public abstract void setData(String var1, Object var2);

    public abstract Object getData(String var1);

    public abstract void back();

    public abstract void refresh();

    public abstract void update();

    public abstract Shell getShell();

    public abstract Display getDisplay();

    public abstract Composite getParent();

    public abstract Object getLayoutData();

    public abstract void setLayoutData(Object var1);

    public abstract void setFocus();

    public abstract void addListener(int var1, Listener var2);

    public abstract void addLocationListener(LocationListener var1);

    public abstract void removeLocationListener(LocationListener var1);

    public abstract void addTitleListener(TitleListener var1);

    public abstract void addProgressListener(ProgressListener var1);

    public abstract void removeProgressListener(ProgressListener var1);

    public abstract void addOpenWindowListener(OpenWindowListener var1);

    public abstract void setBrowser(WindowEvent var1);

    public abstract void addCloseWindowListener(CloseWindowListener var1);

    public abstract void addDisposeListener(DisposeListener var1);

    public abstract void removeDisposeListener(DisposeListener var1);

    public abstract void addStatusTextListener(StatusTextListener var1);

    public abstract void removeStatusTextListener(StatusTextListener var1);

    public abstract BrowserFunction addBrowserFunction(String var1, BrowserFunction var2);

    public static abstract class BrowserFunction {
        private BrowserFunction delegate;

        public void bind(BrowserFunction _delegate) {
            this.delegate = _delegate;
        }

        public abstract Object function(Object[] var1);

        public boolean isDisposed() {
            if (this.delegate != null) {
                return this.delegate.isDisposed();
            }
            Debug.out("wrong");
            return false;
        }

        public void dispose() {
            if (this.delegate != null) {
                this.delegate.dispose();
            }
            Debug.out("wrong");
        }
    }

    public static interface OpenWindowListener {
        public void open(WindowEvent var1);
    }

    public static interface WindowEvent {
        public void setRequired(boolean var1);
    }
}

