/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.console.commands;

import com.biglybt.core.stats.StatsWriterFactory;
import com.biglybt.core.stats.StatsWriterStreamer;
import com.biglybt.ui.console.ConsoleInput;
import com.biglybt.ui.console.commands.IConsoleCommand;
import java.io.FileOutputStream;
import java.util.List;

public class XML
extends IConsoleCommand {
    public XML() {
        super("xml");
    }

    @Override
    public String getCommandDescriptions() {
        return "xml [<file>]\t\t\t\tOutput stats in xml format (to <file> if given)";
    }

    public void execute(String commandName, ConsoleInput ci, List args) {
        StatsWriterStreamer sws = StatsWriterFactory.createStreamer(ci.getCore());
        String file = null;
        if (args != null && !args.isEmpty()) {
            file = (String)args.get(0);
        }
        if (file == null) {
            try {
                ci.out.println("> -----");
                sws.write(ci.out);
                ci.out.println("> -----");
            }
            catch (Exception e) {
                ci.out.println("> Exception while trying to output xml stats:" + e.getMessage());
            }
        } else {
            try {
                try (FileOutputStream os = new FileOutputStream(file);){
                    sws.write(os);
                }
                ci.out.println("> XML stats successfully written to " + file);
            }
            catch (Exception e) {
                ci.out.println("> Exception while trying to write xml stats:" + e.getMessage());
            }
        }
    }
}

