/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.console.commands;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.tracker.host.TRHost;
import com.biglybt.core.tracker.host.TRHostException;
import com.biglybt.core.tracker.host.TRHostTorrent;
import com.biglybt.ui.console.ConsoleInput;
import com.biglybt.ui.console.commands.TorrentCommand;
import java.util.List;

public class TorrentPublish
extends TorrentCommand {
    public TorrentPublish() {
        super("publish", null, "Publishing");
    }

    protected boolean performCommand(ConsoleInput ci, DownloadManager dm, List args) {
        TOTorrent torrent = dm.getTorrent();
        if (torrent != null) {
            try {
                TRHost host = ci.core.getTrackerHost();
                TRHostTorrent existing = host.getHostTorrent(torrent);
                if (existing == null) {
                    host.publishTorrent(torrent);
                } else {
                    try {
                        existing.remove();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }
            catch (TRHostException e) {
                e.printStackTrace(ci.out);
                return false;
            }
            return true;
        }
        return false;
    }

    @Override
    public String getCommandDescriptions() {
        return "publish (<torrentoptions>)\t\tPublish or stop publishing torrent(s).";
    }
}

