/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.console.commands;

import com.biglybt.core.download.DownloadManager;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadRemovalVetoException;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.ui.console.ConsoleInput;
import com.biglybt.ui.console.commands.TorrentCommand;
import java.util.List;

public class TorrentArchive
extends TorrentCommand {
    public TorrentArchive() {
        super("torrent_archive", "tar", "Archiving");
    }

    protected boolean performCommand(ConsoleInput ci, DownloadManager dm, List args) {
        block4: {
            try {
                Download download = PluginCoreUtils.wrap(dm);
                if (!download.canStubbify()) {
                    ci.out.println("> Can't archive as torrent is not in archiveable state");
                    break block4;
                }
                download.stubbify();
                return true;
            }
            catch (DownloadRemovalVetoException e) {
                ci.out.println("> Veto when archiving torrent (" + e.getMessage() + ")");
            }
            catch (Exception e) {
                e.printStackTrace(ci.out);
            }
        }
        return false;
    }

    @Override
    public String getCommandDescriptions() {
        return "torrent_archive (<torrentoptions>)\tr\tArchive torrent(s).";
    }
}

