/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.console.commands;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.util.SHA1Hasher;
import com.biglybt.ui.common.ExternalUIConst;
import com.biglybt.ui.common.util.StringPattern;
import com.biglybt.ui.console.ConsoleConfigSections;
import com.biglybt.ui.console.ConsoleInput;
import com.biglybt.ui.console.commands.IConsoleCommand;
import com.biglybt.ui.console.util.PrintUtils;
import java.io.PrintStream;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class Set
extends IConsoleCommand {
    private static final String NULL_STRING = "__NULL__";

    public Set() {
        super("set", "+");
    }

    @Override
    public String getCommandDescriptions() {
        return "set [options] [parameter] [value]\t\t+\tSet a configuration parameter. Use \"param name\" when the name includes a space. If value is omitted, the current setting is shown. Parameter may be a wildcard to narrow results";
    }

    public void printHelpExtra(PrintStream out, List args) {
        out.println("> -----");
        out.println("'set' common parameter abbreviations: ");
        out.println("\tmax_up: Maximum upload speed in KB/sec");
        out.println("\tmax_down: Maximum download speed in KB/sec");
        out.println("'set' options: ");
        out.println("\t-export\t\tPrints all the options with non-defaut values.");
    }

    public void execute(String commandName, ConsoleInput ci, List args) {
        boolean non_defaults = false;
        Iterator it = args.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (!arg.equals("-export")) continue;
            non_defaults = true;
            it.remove();
        }
        if (args.isEmpty()) {
            this.displayOptions(ci.out, new StringPattern("*"), non_defaults);
            return;
        }
        String external_name = (String)args.get(0);
        String internal_name = (String)ExternalUIConst.parameterlegacy.get(external_name);
        if (internal_name == null || internal_name.length() == 0) {
            internal_name = external_name;
        }
        switch (args.size()) {
            case 1: {
                StringPattern sp = new StringPattern(internal_name);
                if (sp.hasWildcard()) {
                    this.displayOptions(ci.out, sp, non_defaults);
                    break;
                }
                ConsoleConfigSections.ParameterWithConfigSection paramInfo = ConsoleConfigSections.getInstance().getParameter(internal_name);
                if (paramInfo != null) {
                    PrintUtils.printParam(ci.out, paramInfo.configSection, true, paramInfo.parameter, false);
                    break;
                }
                if (!COConfigurationManager.doesParameterDefaultExist(internal_name)) {
                    ci.out.println("> Command 'set': Parameter '" + external_name + "' unknown.");
                    return;
                }
                ParameterDeprecated param = ParameterDeprecated.get(internal_name, external_name);
                ci.out.println(param.getString(false));
                break;
            }
            case 2: 
            case 3: {
                String type;
                String setto = (String)args.get(1);
                if (args.size() == 2) {
                    ParameterDeprecated param = ParameterDeprecated.get(internal_name, external_name);
                    type = param.getType();
                } else {
                    type = (String)args.get(2);
                }
                boolean success = false;
                if (type.equalsIgnoreCase("int") || type.equalsIgnoreCase("integer")) {
                    COConfigurationManager.setParameter(internal_name, Integer.parseInt(setto));
                    success = true;
                } else if (type.equalsIgnoreCase("bool") || type.equalsIgnoreCase("boolean")) {
                    boolean value = setto.equalsIgnoreCase("true") || setto.equalsIgnoreCase("y") || setto.equals("1");
                    COConfigurationManager.setParameter(internal_name, value);
                    success = true;
                } else if (type.equalsIgnoreCase("float")) {
                    COConfigurationManager.setParameter(internal_name, Float.parseFloat(setto));
                    success = true;
                } else if (type.equalsIgnoreCase("string")) {
                    COConfigurationManager.setParameter(internal_name, setto);
                    success = true;
                } else if (type.equalsIgnoreCase("password")) {
                    SHA1Hasher hasher = new SHA1Hasher();
                    byte[] password = setto.getBytes();
                    byte[] encoded = password.length > 0 ? hasher.calculateHash(password) : password;
                    COConfigurationManager.setParameter(internal_name, encoded);
                    success = true;
                }
                if (success) {
                    COConfigurationManager.save();
                    ci.out.println("> Parameter '" + external_name + "' set to '" + setto + "'. [" + type + "]");
                    ConsoleConfigSections.ParameterWithConfigSection paramInfo = ConsoleConfigSections.getInstance().getParameter(internal_name);
                    if (paramInfo == null) break;
                    PrintUtils.printParam(ci.out, paramInfo.configSection, true, paramInfo.parameter, false);
                    break;
                }
                ci.out.println("ERROR: invalid type given");
                break;
            }
            default: {
                ci.out.println("Usage: 'set \"parameter\" value type', where type = int, bool, float, string, password");
            }
        }
    }

    private void displayOptions(PrintStream out, StringPattern sp, boolean non_defaults) {
        sp.setIgnoreCase(true);
        Iterator<String> I = non_defaults ? COConfigurationManager.getDefinedParameters().iterator() : COConfigurationManager.getAllowedParameters().iterator();
        HashMap backmap = new HashMap();
        for (Map.Entry entry : ExternalUIConst.parameterlegacy.entrySet()) {
            backmap.put(entry.getValue(), entry.getKey());
        }
        TreeSet<String> srt = new TreeSet<String>();
        while (I.hasNext()) {
            String internal_name = I.next();
            String external_name = (String)backmap.get(internal_name);
            if (external_name == null) {
                external_name = internal_name;
            }
            if (!sp.matches(external_name)) continue;
            ParameterDeprecated param = ParameterDeprecated.get(internal_name, external_name);
            if (non_defaults) {
                if (param.isDefault()) continue;
                srt.add(param.getString(true));
                continue;
            }
            srt.add(param.getString(false));
        }
        I = srt.iterator();
        while (I.hasNext()) {
            out.println(I.next());
        }
    }

    protected static String quoteIfNeeded(String str) {
        if (str.indexOf(32) == -1) {
            return str;
        }
        return "\"" + str + "\"";
    }

    private static class ParameterDeprecated {
        private static final int PARAM_INT = 1;
        private static final int PARAM_BOOLEAN = 2;
        private static final int PARAM_STRING = 4;
        private static final int PARAM_OTHER = 8;
        private int type;
        private String iname;
        private String ename;
        private Object value;
        private boolean isSet;
        private Object def;

        public static ParameterDeprecated get(String internal_name, String external_name) {
            int underscoreIndex = external_name.indexOf(95);
            char nextchar = external_name.charAt(underscoreIndex + 1);
            if (internal_name != external_name && "ibs".indexOf(nextchar) >= 0) {
                try {
                    if (nextchar == 'i') {
                        int value = COConfigurationManager.getIntParameter(internal_name, Integer.MIN_VALUE);
                        return new ParameterDeprecated(internal_name, external_name, value == Integer.MIN_VALUE ? null : new Integer(value));
                    }
                    if (nextchar == 'b') {
                        if (COConfigurationManager.getIntParameter(internal_name, Integer.MIN_VALUE) != Integer.MIN_VALUE) {
                            boolean b = COConfigurationManager.getBooleanParameter(internal_name);
                            return new ParameterDeprecated(internal_name, external_name, b);
                        }
                        return new ParameterDeprecated(internal_name, external_name, null);
                    }
                    String value = COConfigurationManager.getStringParameter(internal_name, Set.NULL_STRING);
                    return new ParameterDeprecated(internal_name, external_name, Set.NULL_STRING.equals(value) ? null : value);
                }
                catch (Throwable value) {
                    // empty catch block
                }
            }
            Object v = COConfigurationManager.getParameter(internal_name);
            try {
                if (v instanceof Long || v instanceof Integer) {
                    int value = COConfigurationManager.getIntParameter(internal_name, Integer.MIN_VALUE);
                    return new ParameterDeprecated(internal_name, external_name, value == Integer.MIN_VALUE ? null : new Integer(value));
                }
                if (v instanceof Boolean) {
                    boolean value = COConfigurationManager.getBooleanParameter(internal_name);
                    return new ParameterDeprecated(internal_name, external_name, value);
                }
                if (v instanceof String || v instanceof byte[]) {
                    String value = COConfigurationManager.getStringParameter(internal_name);
                    return new ParameterDeprecated(internal_name, external_name, Set.NULL_STRING.equals(value) ? null : value);
                }
                return new ParameterDeprecated(internal_name, external_name, v, 8);
            }
            catch (Throwable e2) {
                return new ParameterDeprecated(internal_name, external_name, v, 8);
            }
        }

        public ParameterDeprecated(String iname, String ename, Boolean val) {
            this(iname, ename, val, 2);
        }

        public ParameterDeprecated(String iname, String ename, Integer val) {
            this(iname, ename, val, 1);
        }

        public ParameterDeprecated(String iname, String ename, String val) {
            this(iname, ename, val, 4);
        }

        private ParameterDeprecated(String _iname, String _ename, Object _val, int _type) {
            this.type = _type;
            this.iname = _iname;
            this.ename = _ename;
            this.value = _val;
            boolean bl = this.isSet = this.value != null;
            if (!this.isSet) {
                this.def = COConfigurationManager.getDefault(this.iname);
                if (this.def != null && this.def instanceof Long) {
                    this.type = 1;
                }
            }
        }

        public String getType() {
            switch (this.type) {
                case 2: {
                    return "bool";
                }
                case 1: {
                    return "int";
                }
                case 4: {
                    return "string";
                }
            }
            return "unknown";
        }

        public boolean isDefault() {
            return !this.isSet;
        }

        public String getString(boolean set_format) {
            if (this.isSet) {
                if (set_format) {
                    return "set " + Set.quoteIfNeeded(this.ename) + " " + Set.quoteIfNeeded(this.value.toString()) + " " + this.getType();
                }
                return "> " + this.ename + ": " + this.value + " [" + this.getType() + "]";
            }
            if (this.def == null) {
                return "> " + this.ename + " is not set. [" + this.getType() + "]";
            }
            return "> " + this.ename + " is not set. [" + this.getType() + ", default: " + this.def + "]";
        }
    }
}

