/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.console.commands;

import com.biglybt.core.util.AERunStateHandler;
import com.biglybt.ui.console.ConsoleInput;
import com.biglybt.ui.console.commands.IConsoleCommand;
import java.util.HashMap;
import java.util.List;

public class RunState
extends IConsoleCommand {
    public RunState() {
        super("runstate", "rs");
    }

    @Override
    public String getCommandDescriptions() {
        return "runstate\t\trs\tShows and modified the current Vuze run-state.";
    }

    @Override
    public void execute(String commandName, ConsoleInput ci, List<String> args) {
        ci.out.println("Current run state:");
        long mode = AERunStateHandler.getResourceMode();
        HashMap<String, Long> mode_map = new HashMap<String, Long>();
        mode_map.put("all", -1L);
        int i = 0;
        while (i < AERunStateHandler.RS_MODES.length) {
            String[] bits;
            String mode_name = AERunStateHandler.RS_MODE_NAMES[i];
            long mode_value = AERunStateHandler.RS_MODES[i];
            String[] stringArray = bits = mode_name.split(":");
            int n = bits.length;
            int n2 = 0;
            while (n2 < n) {
                String bit = stringArray[n2];
                mode_map.put(bit.trim().toLowerCase(), mode_value);
                ++n2;
            }
            ++i;
        }
        boolean bad = false;
        for (String arg : args) {
            String[] bits = arg.split("=");
            if (bits.length != 2) {
                bad = true;
                break;
            }
            Long this_mode = (Long)mode_map.get(bits[0].toLowerCase());
            if (this_mode == null) {
                bad = true;
                continue;
            }
            boolean on = false;
            String rhs = bits[1].toLowerCase();
            if (rhs.equals("on")) {
                on = true;
            } else if (!rhs.equals("off")) {
                bad = true;
            }
            if (bad) continue;
            mode = on ? (mode |= this_mode.longValue()) : (mode &= this_mode ^ 0xFFFFFFFFFFFFFFFFL);
            AERunStateHandler.setResourceMode(mode);
        }
        if (bad) {
            ci.out.println("> Command 'runstate': invalid parameters (example: dui=On, all=off)");
        } else {
            int i2 = 0;
            while (i2 < AERunStateHandler.RS_MODES.length) {
                String mode_name = AERunStateHandler.RS_MODE_NAMES[i2];
                long mode_value = AERunStateHandler.RS_MODES[i2];
                ci.out.println("\t" + mode_name + "=" + ((mode & mode_value) == 0L ? "Off" : "On"));
                ++i2;
            }
        }
    }
}

