/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.console.commands;

import com.biglybt.core.internat.MessageText;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pifimpl.local.ui.config.ParameterGroupImpl;
import com.biglybt.ui.config.BaseConfigSection;
import com.biglybt.ui.config.ConfigSectionImpl;
import com.biglybt.ui.console.ConsoleConfigSections;
import com.biglybt.ui.console.ConsoleInput;
import com.biglybt.ui.console.commands.IConsoleCommand;
import com.biglybt.ui.console.util.PrintUtils;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;

public class Config
extends IConsoleCommand {
    public static final int COL_LEN_SECTION_KEY = 30;
    public static final int COL_LEN_SECTION_NAME = 30;
    public static final int COL_LEN_PARAM_KEY = 50;
    public static final String FORMAT_KEY = "%1$-50s";
    public static final int COL_LEN_PARAMTYPE = 11;
    public static final String FORMAT_PARAMTYPE = "%1$-11s";

    public Config() {
        super("config", "cfg");
    }

    @Override
    public void execute(String commandName, ConsoleInput console, List<String> args) {
        String action;
        if (args.isEmpty()) {
            Config.printHelpExtra(console.out, commandName, null);
            return;
        }
        switch (action = args.get(0).toLowerCase()) {
            case "sections": {
                Config.printSections(console.out);
                break;
            }
            case "s": 
            case "section": {
                if (args.size() < 2) {
                    console.out.println("Missing ID");
                    break;
                }
                Config.printSection(console.out, args.get(1));
                break;
            }
            case "find": {
                boolean isRegex;
                if (args.size() < 2) {
                    console.out.println("Missing Text");
                    break;
                }
                StringBuilder sb = new StringBuilder();
                int start = 1;
                String first = args.get(start);
                boolean bl = isRegex = first.equals("regex") && args.size() > 2;
                if (isRegex) {
                    first = args.get(++start);
                }
                sb.append(first);
                int i = ++start;
                while (i < args.size()) {
                    sb.append(' ');
                    sb.append(args.get(i));
                    ++i;
                }
                Config.search(console.out, sb.toString(), isRegex);
                break;
            }
            default: {
                Config.printSection(console.out, action);
            }
        }
    }

    private static void search(PrintStream out, String s, boolean isRegex) {
        List<BaseConfigSection> sections = ConsoleConfigSections.getInstance().getAllConfigSections(true);
        int count = 0;
        for (BaseConfigSection section : sections) {
            Pattern regex;
            List<Parameter> results;
            boolean needsBuild;
            boolean bl = needsBuild = !section.isBuilt();
            if (needsBuild) {
                section.build();
                section.postBuild();
            }
            if (!(results = section.search(regex = isRegex ? Pattern.compile(s) : (s.endsWith("*") ? Pattern.compile("^" + Pattern.quote(s.substring(0, s.length() - 1)) + ".*", 2) : Pattern.compile(Pattern.quote(s), 2)))).isEmpty()) {
                count += results.size();
                PrintUtils.showBox(out, PrintUtils.getFriendlyConfigSectionID(section), MessageText.getString(section.getSectionNameKey()));
                for (Parameter result : results) {
                    PrintUtils.printParam(out, section, false, result, true);
                }
                out.println();
            }
            if (!needsBuild) continue;
            section.deleteConfigSection();
        }
        out.println(String.valueOf(count) + " found for " + s);
    }

    private static void printSection(PrintStream out, String sectionID) {
        boolean needsBuild;
        List<BaseConfigSection> configSections = ConsoleConfigSections.getInstance().getAllConfigSections(false);
        BaseConfigSection section = null;
        for (BaseConfigSection configSection : configSections) {
            if (configSection == null || !PrintUtils.getFriendlyConfigSectionID(configSection).equalsIgnoreCase(sectionID)) continue;
            section = configSection;
            break;
        }
        if (section == null) {
            out.println("No section " + sectionID);
            return;
        }
        boolean bl = needsBuild = !section.isBuilt();
        if (needsBuild) {
            section.build();
            section.postBuild();
        }
        try {
            Parameter[] paramArray = section.getParamArray();
            ArrayList<Parameter> params = new ArrayList<Parameter>();
            Parameter[] parameterArray = paramArray;
            int n = paramArray.length;
            int n2 = 0;
            while (n2 < n) {
                Parameter param = parameterArray[n2];
                if (param instanceof ParameterGroupImpl) {
                    params.add(params.size() - ((ParameterGroupImpl)param).size(true), param);
                } else {
                    params.add(param);
                }
                ++n2;
            }
            PrintUtils.showBox(out, PrintUtils.getFriendlyConfigSectionID(section), MessageText.getString(section.getSectionNameKey()));
            StringBuffer groupIndent = new StringBuffer();
            boolean isFirst = true;
            Stack<PrintUtils.ParamGroupInfo> pgInfoStack = new Stack<PrintUtils.ParamGroupInfo>();
            PrintUtils.ParamGroupInfo pgInfo = new PrintUtils.ParamGroupInfo(1, true, null);
            for (Parameter param : params) {
                isFirst = PrintUtils.printParam(out, section, param, groupIndent, isFirst, pgInfo, pgInfoStack);
            }
            while (groupIndent.length() > 0) {
                groupIndent.replace(0, 2, "");
                PrintUtils.endGroup(out, groupIndent, null);
            }
        }
        finally {
            if (needsBuild) {
                section.deleteConfigSection();
            }
        }
    }

    private static void printSections(PrintStream out) {
        List<BaseConfigSection> configSections = ConsoleConfigSections.getInstance().getAllConfigSections(true);
        out.print(String.format("%1$-30s", "ID"));
        out.print(" \u2502 ");
        out.print(String.format("%1$-30s", "Name"));
        out.println(" \u2502Min\u2502Max\u2502 Parent");
        PrintUtils.outDupChar(out, '\u2500', 31);
        out.print('\u253c');
        PrintUtils.outDupChar(out, '\u2500', 32);
        out.print('\u253c');
        PrintUtils.outDupChar(out, '\u2500', 3);
        out.print('\u253c');
        PrintUtils.outDupChar(out, '\u2500', 3);
        out.print('\u253c');
        PrintUtils.outDupChar(out, '\u2500', 12);
        out.println();
        for (BaseConfigSection configSection : configSections) {
            if (configSection == null) continue;
            out.print(String.format("%1$-30s", PrintUtils.getFriendlyConfigSectionID(configSection)));
            out.print(" \u2502 ");
            out.print(String.format("%1$-30s", MessageText.getString(configSection.getSectionNameKey())));
            out.print(" \u2502 ");
            out.print(configSection.getMinUserMode());
            out.print(" \u2502 ");
            out.print(configSection.getMaxUserMode());
            out.print(" \u2502 ");
            String parentSectionID = configSection.getParentSectionID();
            if (!"root".equals(parentSectionID)) {
                out.print(MessageText.getString(ConfigSectionImpl.getSectionNameKey(parentSectionID)));
            }
            out.println();
        }
        PrintUtils.outDupChar(out, '\u2500', 31);
        out.print('\u2534');
        PrintUtils.outDupChar(out, '\u2500', 32);
        out.print('\u2534');
        PrintUtils.outDupChar(out, '\u2500', 3);
        out.print('\u2534');
        PrintUtils.outDupChar(out, '\u2500', 3);
        out.print('\u2534');
        PrintUtils.outDupChar(out, '\u2500', 12);
        out.println();
    }

    @Override
    public String getCommandDescriptions() {
        return "config";
    }

    @Override
    public void printHelpExtra(PrintStream out, List<String> args) {
        Config.printHelpExtra(out, "config", args);
    }

    public static void printHelpExtra(PrintStream out, String command, List<String> args) {
        String[] commands = new String[]{"sections", "section <section id>", "find <text>", "find <text>*", "find regex <regex>"};
        String[] extra = new String[]{"Lists config sections", "Lists parameters in config section", "Find parameters containing text (case insensitive)", "Find parameters starting with text (case insensitive)", "Find parameters using regex. Case sensitive, use (?i) for insensitive"};
        int i = 0;
        while (i < commands.length) {
            out.print(command);
            out.print(' ');
            out.print(String.format("%1$-30s", commands[i]));
            out.print(' ');
            out.println(extra[i]);
            ++i;
        }
    }
}

