/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.console;

import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Vector;

public class CommandReader
extends Reader {
    private static final int ENTER = 0;
    private static final int TAB = 1;
    private static final int QUOTE = 3;
    private static final int ESCAPE = 4;
    private static final int NONQUOTEDESCAPE = 5;
    private Reader in;

    public CommandReader(Reader _in) {
        this.in = _in;
    }

    private void ensureOpen() throws IOException {
        if (this.in == null) {
            throw new IOException("Stream closed");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            if (this.in != null) {
                this.in.close();
                this.in = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            return this.in.read();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(char[] cbuf, int off, int len) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            this.ensureOpen();
            return this.in.read(cbuf, off, len);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readLine() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            int ch;
            this.ensureOpen();
            StringBuilder line = new StringBuilder();
            while ((char)(ch = this.in.read()) != '\n') {
                if (ch == -1) {
                    throw new IOException("stream closed");
                }
                line.append((char)ch);
            }
            return line.toString().trim();
        }
    }

    public List parseCommandLine(String commandLine) {
        StringBuffer current = new StringBuffer();
        Vector<String> args = new Vector<String>();
        boolean allowEmpty = false;
        boolean bailout = commandLine.length() == 0;
        int index = 0;
        int state = 0;
        block25: while (!bailout) {
            char ch = commandLine.charAt(index++);
            bailout = index == commandLine.length();
            char c = ch;
            block0 : switch (state) {
                case 0: {
                    switch (c) {
                        case '\"': {
                            state = 3;
                            break;
                        }
                        case '\\': {
                            state = 5;
                            break;
                        }
                        case '\r': {
                            break;
                        }
                        default: {
                            current.append(c);
                        }
                    }
                    if (state != 0 || c != ' ' && !bailout) continue block25;
                    String arg = current.toString().trim();
                    if (arg.length() > 0 || allowEmpty) {
                        args.addElement(arg);
                        allowEmpty = false;
                    }
                    current = new StringBuffer();
                    break;
                }
                case 3: {
                    switch (c) {
                        case '\"': {
                            allowEmpty = true;
                            state = 0;
                            break block0;
                        }
                        case '\\': {
                            state = 4;
                            break block0;
                        }
                    }
                    current.append(c);
                    break;
                }
                case 4: {
                    switch (c) {
                        case 'n': {
                            c = '\n';
                            break;
                        }
                        case 'r': {
                            c = '\r';
                            break;
                        }
                        case 't': {
                            c = '\t';
                            break;
                        }
                        case 'b': {
                            c = '\b';
                            break;
                        }
                        case 'f': {
                            c = '\f';
                            break;
                        }
                        default: {
                            current.append('\\');
                        }
                    }
                    state = 3;
                    current.append(c);
                    break;
                }
                case 5: {
                    switch (c) {
                        case ';': {
                            state = 0;
                            current.append(c);
                            break block0;
                        }
                    }
                    state = 0;
                    current.append('\\');
                    current.append(c);
                }
            }
        }
        if (state == 0 && (current.toString().trim().length() > 0 || allowEmpty)) {
            String arg = current.toString().trim();
            args.addElement(arg);
        }
        return args;
    }
}

