/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.config;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.util.FileUtil;
import com.biglybt.pif.ui.config.UIParameterContext;
import com.biglybt.pifimpl.local.ui.config.HyperlinkParameterImpl;
import com.biglybt.pifimpl.local.ui.config.LabelParameterImpl;
import com.biglybt.pifimpl.local.ui.config.UIParameterImpl;
import com.biglybt.ui.config.ConfigSectionImpl;
import java.io.File;
import java.util.List;

public class ConfigSectionPlugins
extends ConfigSectionImpl {
    private UIParameterContext paramContextPluginList;

    public ConfigSectionPlugins() {
        super("plugins", "root");
    }

    public void init(UIParameterContext paramContextPluginList) {
        this.paramContextPluginList = paramContextPluginList;
    }

    @Override
    public void build() {
        String sAppPluginDir;
        String sUserPluginDir;
        if (!CoreFactory.isCoreRunning()) {
            this.add(new LabelParameterImpl("core.not.available"), new List[0]);
        }
        String sep = File.separator;
        File fUserPluginDir = FileUtil.getUserFile("plugins");
        try {
            sUserPluginDir = fUserPluginDir.getCanonicalPath();
        }
        catch (Throwable e) {
            sUserPluginDir = fUserPluginDir.toString();
        }
        if (!sUserPluginDir.endsWith(sep)) {
            sUserPluginDir = String.valueOf(sUserPluginDir) + sep;
        }
        File fAppPluginDir = FileUtil.getApplicationFile("plugins");
        try {
            sAppPluginDir = fAppPluginDir.getCanonicalPath();
        }
        catch (Throwable e) {
            sAppPluginDir = fAppPluginDir.toString();
        }
        if (!sAppPluginDir.endsWith(sep)) {
            sAppPluginDir = String.valueOf(sAppPluginDir) + sep;
        }
        this.add(new LabelParameterImpl("ConfigView.pluginlist.whereToPut"), new List[0]);
        File dirUserPlugin = FileUtil.newFile(sUserPluginDir, new String[0]);
        if (!dirUserPlugin.exists() || !dirUserPlugin.isDirectory()) {
            dirUserPlugin = dirUserPlugin.getParentFile();
        }
        HyperlinkParameterImpl paramUserPluginDir = new HyperlinkParameterImpl("!" + sUserPluginDir.replaceAll("&", "&&") + "!", dirUserPlugin.getAbsolutePath());
        this.add(paramUserPluginDir, new List[0]);
        paramUserPluginDir.setIndent(1, false);
        this.add(new LabelParameterImpl("ConfigView.pluginlist.whereToPutOr"), new List[0]);
        File dirAppPlugin = FileUtil.newFile(sAppPluginDir, new String[0]);
        if (!dirAppPlugin.exists() || !dirAppPlugin.isDirectory()) {
            dirAppPlugin = dirAppPlugin.getParentFile();
        }
        HyperlinkParameterImpl paramAppPluginDir = new HyperlinkParameterImpl("!" + sAppPluginDir.replaceAll("&", "&&") + "!", dirAppPlugin.getAbsolutePath());
        this.add(paramAppPluginDir, new List[0]);
        paramAppPluginDir.setIndent(1, false);
        if (this.paramContextPluginList != null) {
            this.add(new LabelParameterImpl("ConfigView.pluginlist.info"), new List[0]);
            this.add("PluginList", new UIParameterImpl(this.paramContextPluginList, null), new List[0]);
        }
    }
}

