/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.config;

import com.biglybt.core.CoreFactory;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.ipfilter.IpFilter;
import com.biglybt.core.ipfilter.IpFilterManager;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.pif.ui.config.UIParameterContext;
import com.biglybt.pifimpl.local.ui.config.ActionParameterImpl;
import com.biglybt.pifimpl.local.ui.config.BooleanParameterImpl;
import com.biglybt.pifimpl.local.ui.config.FileParameterImpl;
import com.biglybt.pifimpl.local.ui.config.FloatParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntParameterImpl;
import com.biglybt.pifimpl.local.ui.config.LabelParameterImpl;
import com.biglybt.pifimpl.local.ui.config.ParameterGroupImpl;
import com.biglybt.pifimpl.local.ui.config.UIParameterImpl;
import com.biglybt.ui.config.ConfigSectionImpl;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class ConfigSectionIPFilter
extends ConfigSectionImpl {
    public static final String SECTION_ID = "ipfilter";
    IpFilter filter;
    LabelParameterImpl percentage_blocked;
    private UIParameterContext paramContextIPEditor;

    public ConfigSectionIPFilter() {
        super(SECTION_ID, "root");
    }

    public void init(UIParameterContext paramContextIPEditor) {
        this.paramContextIPEditor = paramContextIPEditor;
    }

    @Override
    public void build() {
        if (!CoreFactory.isCoreRunning()) {
            this.add(new LabelParameterImpl("core.not.available"), new List[0]);
            return;
        }
        IpFilterManager ipFilterManager = CoreFactory.getSingleton().getIpFilterManager();
        this.filter = ipFilterManager.getIPFilter();
        BooleanParameterImpl enabled = new BooleanParameterImpl("Ip Filter Enabled", "ConfigView.section.ipfilter.enable");
        this.add(enabled, new List[0]);
        BooleanParameterImpl deny = new BooleanParameterImpl("Ip Filter Allow", "ConfigView.section.ipfilter.allow");
        this.add(deny, new List[0]);
        this.add(new BooleanParameterImpl("Ip Filter Banning Persistent", "ConfigView.section.ipfilter.persistblocking"), new List[0]);
        this.add(new BooleanParameterImpl("Ip Filter Disable For Updates", "ConfigView.section.ipfilter.disable.for.updates"), new List[0]);
        ArrayList listBlockBanning = new ArrayList();
        BooleanParameterImpl enable_bad_data_banning = new BooleanParameterImpl("Ip Filter Enable Banning", "ConfigView.section.ipfilter.enablebanning");
        this.add(enable_bad_data_banning, listBlockBanning);
        FloatParameterImpl discard_ratio = new FloatParameterImpl("Ip Filter Ban Discard Ratio", "ConfigView.section.ipfilter.discardbanning");
        this.add(discard_ratio, listBlockBanning);
        IntParameterImpl discard_min = new IntParameterImpl("Ip Filter Ban Discard Min KB", "");
        this.add(discard_min, listBlockBanning);
        discard_min.setIndent(1, true);
        discard_min.setLabelText(MessageText.getString("ConfigView.section.ipfilter.discardminkb", new String[]{DisplayFormatters.getUnit(1)}));
        IntParameterImpl block_banning = new IntParameterImpl("Ip Filter Ban Block Limit", "ConfigView.section.ipfilter.blockbanning", 0, 256);
        this.add(block_banning, listBlockBanning);
        BooleanParameterImpl dont_ban_lan = new BooleanParameterImpl("Ip Filter Dont Ban LAN", "ConfigView.section.ipfilter.dontbanlan");
        this.add(dont_ban_lan, listBlockBanning);
        enable_bad_data_banning.addEnabledOnSelection(block_banning, discard_ratio, discard_min);
        ParameterGroupImpl pgBlockBanning = new ParameterGroupImpl("ConfigView.section.ipfilter.peerblocking.group", listBlockBanning);
        this.add("pgBlockBanning", pgBlockBanning, new List[0]);
        ArrayList listAutoLoad = new ArrayList();
        FileParameterImpl pathParameter = new FileParameterImpl("Ip Filter Autoload File", "ConfigView.section.ipfilter.autoload.file", "*.dat" + File.pathSeparator + "*.p2p" + File.pathSeparator + "*.p2b" + File.pathSeparator + "*.txt", "*.*");
        this.add(pathParameter, new List[0]);
        pathParameter.setFileNameHint("ipfilter.dat");
        pathParameter.setDialogTitleKey("ConfigView.section.ipfilter.autoload.file");
        ActionParameterImpl btnLoadNow = new ActionParameterImpl(null, "ConfigView.section.ipfilter.autoload.loadnow");
        this.add(btnLoadNow, new List[0]);
        btnLoadNow.addListener(p -> {
            btnLoadNow.setEnabled(false);
            COConfigurationManager.setParameter("Ip Filter Autoload Last Date", 0);
            try {
                if (UrlUtils.isURL(pathParameter.getValue())) {
                    this.filter.reload();
                } else {
                    this.filter.reloadSync();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            btnLoadNow.setEnabled(true);
        });
        FileParameterImpl pathV6Parameter = new FileParameterImpl("Ip Filter V6 Autoload File", "ConfigView.section.ipfilter.autoload.v6.file", "*.txt", "*.*");
        this.add(pathV6Parameter, new List[0]);
        pathV6Parameter.setDialogTitleKey("ConfigView.section.ipfilter.autoload.v6.file");
        ActionParameterImpl btnV6LoadNow = new ActionParameterImpl(null, "ConfigView.section.ipfilter.autoload.loadnow");
        this.add(btnV6LoadNow, new List[0]);
        btnV6LoadNow.addListener(p -> {
            btnV6LoadNow.setEnabled(false);
            COConfigurationManager.setParameter("Ip Filter Autoload Last Date", 0);
            try {
                if (UrlUtils.isURL(pathV6Parameter.getValue())) {
                    this.filter.reload();
                } else {
                    this.filter.reloadSync();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            btnV6LoadNow.setEnabled(true);
        });
        ParameterGroupImpl pgPathAndLoad = new ParameterGroupImpl(null, pathParameter, btnLoadNow, pathV6Parameter, btnV6LoadNow);
        this.add("pgPathAndLoad", pgPathAndLoad, listAutoLoad);
        pgPathAndLoad.setNumberOfColumns(2);
        int initial_reload_period = COConfigurationManager.getIntParameter("Ip Filter Autoload Days");
        IntParameterImpl reload_period = new IntParameterImpl("Ip Filter Autoload Days", "ConfigView.section.ipfilter.autoload.period", 1, 31);
        this.add(reload_period, listAutoLoad);
        this.add(new LabelParameterImpl("ConfigView.section.ipfilter.autoload.info"), listAutoLoad);
        BooleanParameterImpl clear_on_reload = new BooleanParameterImpl("Ip Filter Clear On Reload", "ConfigView.section.ipfilter.clear.on.reload");
        this.add(clear_on_reload, listAutoLoad);
        ParameterGroupImpl pgAutoLoad = new ParameterGroupImpl("ConfigView.section.ipfilter.autoload.group", listAutoLoad);
        this.add("pgAutoLoad", pgAutoLoad, new List[0]);
        BooleanParameterImpl enableDesc = new BooleanParameterImpl("Ip Filter Enable Description Cache", "ConfigView.section.ipfilter.enable.descriptionCache");
        this.add(enableDesc, 1, new List[0]);
        if (this.paramContextIPEditor != null) {
            this.add("IPEditor", new UIParameterImpl(this.paramContextIPEditor, null), new List[0]);
        }
    }
}

