/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui.config;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.peer.PEPeerSource;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.ui.config.IntParameter;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pif.ui.config.ParameterValidator;
import com.biglybt.pifimpl.local.ui.config.BooleanParameterImpl;
import com.biglybt.pifimpl.local.ui.config.HyperlinkParameterImpl;
import com.biglybt.pifimpl.local.ui.config.IntParameterImpl;
import com.biglybt.pifimpl.local.ui.config.LabelParameterImpl;
import com.biglybt.pifimpl.local.ui.config.ParameterGroupImpl;
import com.biglybt.pifimpl.local.ui.config.StringParameterImpl;
import com.biglybt.ui.config.ConfigSectionImpl;
import java.util.ArrayList;
import java.util.List;

public class ConfigSectionConnection
extends ConfigSectionImpl {
    public ConfigSectionConnection() {
        super("server", "root");
    }

    @Override
    public void build() {
        String msg_text;
        String config_name;
        String[] stringArray;
        ArrayList listTopParams = new ArrayList();
        int userMode = COConfigurationManager.getIntParameter("User Mode");
        boolean separate_ports = userMode > 1 || COConfigurationManager.getIntParameter("TCP.Listen.Port") != COConfigurationManager.getIntParameter("UDP.Listen.Port");
        IntParameterImpl paramTCPListenPort = new IntParameterImpl("TCP.Listen.Port", separate_ports ? "ConfigView.label.tcplistenport" : "ConfigView.label.serverport", 1, 65535);
        this.add(paramTCPListenPort, listTopParams);
        paramTCPListenPort.addIntegerValidator((p, toValue) -> {
            if (toValue == Constants.INSTANCE_PORT) {
                return new ParameterValidator.ValidationInfo(false, "Can't be same port as biglybt.instance.port");
            }
            return new ParameterValidator.ValidationInfo(true);
        });
        paramTCPListenPort.addListener(p -> {
            if (!separate_ports) {
                int value = ((IntParameterImpl)p).getValue();
                COConfigurationManager.setParameter("UDP.Listen.Port", value);
                COConfigurationManager.setParameter("UDP.NonData.Listen.Port", value);
            }
        });
        if (separate_ports) {
            boolean MULTI_UDP = false;
            IntParameterImpl paramUDPListenPort = new IntParameterImpl("UDP.Listen.Port", "ConfigView.label.udplistenport", 1, 65535);
            this.add(paramUDPListenPort, listTopParams);
            paramUDPListenPort.addIntegerValidator((p, toValue) -> {
                if (toValue == Constants.INSTANCE_PORT) {
                    return new ParameterValidator.ValidationInfo(false, "Can't be same port as biglybt.instance.port");
                }
                return new ParameterValidator.ValidationInfo(true);
            });
            paramUDPListenPort.addListener(p -> {
                if (!MULTI_UDP) {
                    COConfigurationManager.setParameter("UDP.NonData.Listen.Port", ((IntParameter)p).getValue());
                }
            });
            if (MULTI_UDP) {
                BooleanParameterImpl paramNonDataSamePort = new BooleanParameterImpl("UDP.NonData.Listen.Port.Same", "ConfigView.section.connection.nondata.udp.same");
                this.add(paramNonDataSamePort, new List[0]);
                paramNonDataSamePort.addListener(param -> {
                    if (!param.hasBeenSet()) {
                        COConfigurationManager.removeParameter("UDP.NonData.Listen.Port");
                    }
                });
                IntParameterImpl paramNonDataUDPPort = new IntParameterImpl("UDP.NonData.Listen.Port", null);
                this.add(paramNonDataUDPPort, new List[0]);
                paramNonDataUDPPort.addIntegerValidator((p, toValue) -> {
                    if (toValue == Constants.INSTANCE_PORT) {
                        return new ParameterValidator.ValidationInfo(false, "Can't be same port as biglybt.instance.port");
                    }
                    return new ParameterValidator.ValidationInfo(true);
                });
                ParameterGroupImpl paramGroupMulti = new ParameterGroupImpl(null, paramNonDataSamePort, paramNonDataUDPPort);
                paramGroupMulti.setNumberOfColumns(3);
                this.add("gMultiUDP", paramGroupMulti, listTopParams);
                paramUDPListenPort.addListener(p -> {
                    if (!paramNonDataSamePort.getValue()) {
                        return;
                    }
                    int udp_listen_port = ((IntParameterImpl)p).getValue();
                    if (udp_listen_port != Constants.INSTANCE_PORT) {
                        COConfigurationManager.setParameter("UDP.NonData.Listen.Port", udp_listen_port);
                        paramNonDataUDPPort.setValue(udp_listen_port);
                    }
                });
                paramNonDataSamePort.addDisabledOnSelection((Parameter)paramNonDataUDPPort);
                paramNonDataSamePort.addListener(p -> {
                    if (!((BooleanParameterImpl)p).getValue()) {
                        return;
                    }
                    int udp_listen_port = COConfigurationManager.getIntParameter("UDP.Listen.Port");
                    if (COConfigurationManager.getIntParameter("UDP.NonData.Listen.Port") != udp_listen_port) {
                        COConfigurationManager.setParameter("UDP.NonData.Listen.Port", udp_listen_port);
                        paramNonDataUDPPort.setValue(udp_listen_port);
                    }
                });
                BooleanParameterImpl paramEnableTCP = new BooleanParameterImpl("TCP.Listen.Port.Enable", "ConfigView.section.connection.tcp.enable");
                this.add(paramEnableTCP, listTopParams);
                BooleanParameterImpl paramEnableUDP = new BooleanParameterImpl("UDP.Listen.Port.Enable", "ConfigView.section.connection.udp.enable");
                this.add(paramEnableUDP, listTopParams);
                paramEnableTCP.addEnabledOnSelection((Parameter)paramTCPListenPort);
                paramEnableUDP.addEnabledOnSelection((Parameter)paramUDPListenPort);
            }
        }
        this.add("g0", new ParameterGroupImpl(null, listTopParams), new List[0]);
        BooleanParameterImpl paramRandEnable = new BooleanParameterImpl("Listen.Port.Randomize.Enable", "ConfigView.section.connection.port.rand.enable");
        this.add(paramRandEnable, 1, new List[0]);
        StringParameterImpl paramRandRange = new StringParameterImpl("Listen.Port.Randomize.Range", "ConfigView.section.connection.port.rand.range");
        this.add(paramRandRange, 1, new List[0]);
        BooleanParameterImpl paramRandTogether = new BooleanParameterImpl("Listen.Port.Randomize.Together", "ConfigView.section.connection.port.rand.together");
        this.add(paramRandTogether, 1, new List[0]);
        paramRandEnable.addEnabledOnSelection(paramRandRange, paramRandTogether);
        BooleanParameterImpl paramTCPPublicEnable = new BooleanParameterImpl("peercontrol.tcp.public.enable", "ConfigView.section.connection.tcp.pubic.peer.enable");
        this.add(paramTCPPublicEnable, 2, new List[0]);
        BooleanParameterImpl paramUDPPublicEnable = new BooleanParameterImpl("peercontrol.udp.public.enable", "ConfigView.section.connection.udp.pubic.peer.enable");
        this.add(paramUDPPublicEnable, 2, new List[0]);
        BooleanParameterImpl paramPreferUDP = new BooleanParameterImpl("peercontrol.prefer.udp", "ConfigView.section.connection.prefer.udp");
        this.add(paramPreferUDP, 2, new List[0]);
        BooleanParameterImpl paramPreferIPv6 = new BooleanParameterImpl("peercontrol.prefer.ipv6", "ConfigView.section.connection.prefer.ipv6");
        this.add(paramPreferIPv6, 2, new List[0]);
        if (userMode < 2) {
            this.add(new HyperlinkParameterImpl("ConfigView.section.connection.serverport.wiki", "Utils.link.visit", "https://wiki.biglybt.com/w/Why_ports_like_6881_are_no_good_choice"), new List[0]);
        }
        if (userMode > 0) {
            ArrayList listHTTP = new ArrayList();
            HyperlinkParameterImpl paramVisitHere = new HyperlinkParameterImpl("ConfigView.label.please.visit.here", "ConfigView.section.connection.group.http.info", "https://wiki.biglybt.com/w/HTTP_Seeding");
            this.add(paramVisitHere, listHTTP);
            BooleanParameterImpl paramEnableHTTP = new BooleanParameterImpl("HTTP.Data.Listen.Port.Enable", "ConfigView.section.connection.http.enable");
            this.add(paramEnableHTTP, listHTTP);
            IntParameterImpl paramHttpPort = new IntParameterImpl("HTTP.Data.Listen.Port", "ConfigView.section.connection.http.port");
            this.add(paramHttpPort, listHTTP);
            IntParameterImpl paramHttpPortOverride = new IntParameterImpl("HTTP.Data.Listen.Port.Override", "ConfigView.section.connection.http.portoverride");
            this.add(paramHttpPortOverride, listHTTP);
            paramEnableHTTP.addEnabledOnSelection(paramHttpPort, paramHttpPortOverride);
            ParameterGroupImpl pgHTTP = new ParameterGroupImpl("ConfigView.section.connection.group.http", listHTTP);
            pgHTTP.setMinimumRequiredUserMode(1);
            this.add("pgHTTP", pgHTTP, new List[0]);
        }
        if (userMode > 0) {
            String[] units = new String[]{DisplayFormatters.getRateUnit(1)};
            BooleanParameterImpl paramWebSeedAct = new BooleanParameterImpl("webseed.activation.uses.availability", "ConfigView.section.connection.webseed.act.on.avail");
            this.add(paramWebSeedAct, new List[0]);
            IntParameterImpl paramWebSeedMinSpeed = new IntParameterImpl("webseed.activation.min.speed.kbps", "");
            paramWebSeedMinSpeed.setLabelText(MessageText.getString("ConfigView.section.connection.webseed.min.speed.kbps", units));
            paramWebSeedMinSpeed.setIndent(1, true);
            this.add(paramWebSeedMinSpeed, new List[0]);
            paramWebSeedAct.addEnabledOnSelection((Parameter)paramWebSeedMinSpeed);
            this.add("pgWS", new ParameterGroupImpl("ConfigView.section.connection.group.webseed", paramWebSeedAct, paramWebSeedMinSpeed), new List[0]);
        }
        if (userMode > 0) {
            ArrayList listPS = new ArrayList();
            this.add(new LabelParameterImpl("ConfigView.section.connection.group.peersources.info"), listPS);
            stringArray = PEPeerSource.PS_SOURCES;
            int n = PEPeerSource.PS_SOURCES.length;
            int n2 = 0;
            while (n2 < n) {
                String p2 = stringArray[n2];
                config_name = "Peer Source Selection Default." + p2;
                msg_text = "ConfigView.section.connection.peersource." + p2;
                this.add(new BooleanParameterImpl(config_name, msg_text), listPS);
                ++n2;
            }
            this.add("pgPS", new ParameterGroupImpl("ConfigView.section.connection.group.peersources", listPS), new List[0]);
        }
        if (userMode > 1) {
            ArrayList listNetworks = new ArrayList();
            this.add(new LabelParameterImpl("ConfigView.section.connection.group.networks.info"), listNetworks);
            stringArray = AENetworkClassifier.AT_NETWORKS;
            int n = AENetworkClassifier.AT_NETWORKS.length;
            int n3 = 0;
            while (n3 < n) {
                String nn = stringArray[n3];
                config_name = "Network Selection Default." + nn;
                msg_text = "ConfigView.section.connection.networks." + nn;
                this.add(new BooleanParameterImpl(config_name, msg_text), listNetworks);
                ++n3;
            }
            this.add("con.net.gap0", new LabelParameterImpl(""), listNetworks);
            BooleanParameterImpl paramNetworksPrompt = new BooleanParameterImpl("Network Selection Prompt", "ConfigView.section.connection.networks.prompt");
            paramNetworksPrompt.setAllowedUiTypes("swt");
            this.add(paramNetworksPrompt, listNetworks);
            this.add("pgNetworks", new ParameterGroupImpl("ConfigView.section.connection.group.networks", listNetworks), new List[0]);
        }
    }
}

