/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.ui;

import com.biglybt.core.Core;
import com.biglybt.core.CoreException;
import com.biglybt.core.CoreFactory;
import com.biglybt.core.CoreLifecycleAdapter;
import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.impl.CoreSingleInstanceClient;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.Debug;
import com.biglybt.launcher.Launcher;
import com.biglybt.ui.common.IUserInterface;
import com.biglybt.ui.common.StartServer;
import com.biglybt.ui.common.UIConst;
import com.biglybt.ui.common.UserInterfaceFactory;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.StringTokenizer;
import javax.swing.JOptionPane;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public class Main {
    public static final boolean DEBUG_STARTUPTIME = System.getProperty("DEBUG_STARTUPTIME", "0").equals("1");
    public static String DEFAULT_UI = "swt";
    public static StartServer startServer = null;
    protected static Core core;
    private static CommandLine commands;
    private static volatile boolean stopping;
    private static volatile boolean stopped;
    private static long lastDebugTime;
    private static boolean neverStarted;
    private static IUserInterface newUI;

    public static void main(String[] args) {
        boolean mi;
        if (DEBUG_STARTUPTIME) {
            lastDebugTime = System.currentTimeMillis();
        }
        if (Launcher.checkAndLaunch(Main.class, args)) {
            return;
        }
        COConfigurationManager.preInitialise();
        if (DEBUG_STARTUPTIME) {
            Main.logTime("args: " + Arrays.toString(args));
        }
        Thread.currentThread().setName(Constants.APP_NAME);
        String mi_str = System.getProperty("MULTI_INSTANCE");
        boolean bl = mi = mi_str != null && mi_str.equalsIgnoreCase("true");
        if (DEBUG_STARTUPTIME) {
            Main.logTime("preInit");
        }
        try {
            Options uiOptions = new Options();
            Option.Builder builder = Option.builder("u").longOpt("ui").argName("uis").hasArg();
            uiOptions.addOption(builder.build());
            if (Constants.isWindows) {
                builder = Option.builder("console");
                uiOptions.addOption(builder.build());
            }
            try {
                CommandLine commandLine = new DefaultParser().parse(uiOptions, args, true);
                Main.buildUIList(commandLine);
            }
            catch (ParseException commandLine) {
                // empty catch block
            }
            Options options = UIConst.buildOptions();
            commands = UIConst.buildCommandLine(options, args);
            if (commands == null) {
                System.exit(0);
            }
            if (DEBUG_STARTUPTIME) {
                Main.logTime("buildCommandLine");
            }
            if (!mi) {
                startServer = new StartServer();
                if (startServer.getServerState() == 0) {
                    System.setProperty("transitory.startup", "1");
                    args = Main.CocoaMagic(args);
                    if (!new CoreSingleInstanceClient().sendArgs(args, 5000)) {
                        String msg = "There appears to be another process already listening on socket [127.0.0.1:" + Constants.INSTANCE_PORT + "].\n\nLocate and terminate the other program or change the control port\n\n" + "See the wiki for details, " + "https://wiki.biglybt.com/w/Commandline_options#Changing_the_Control_Port";
                        System.err.println(msg);
                        try {
                            JOptionPane.showMessageDialog(null, msg, "Error", 0);
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        return;
                    }
                    return;
                }
                if (commands.hasOption("closedown") || commands.hasOption("shutdown") || commands.hasOption("restart")) {
                    return;
                }
                if (DEBUG_STARTUPTIME) {
                    Main.logTime("StartServer");
                }
            } else {
                System.out.println("MULTI_INSTANCE enabled");
            }
            if (commands != null && commands.hasOption('h')) {
                HelpFormatter hf = new HelpFormatter();
                hf.setOptionComparator(null);
                hf.printHelp("[options] [torrent [torrent ...]]", options);
                if (startServer != null) {
                    startServer.stopIt();
                }
                System.exit(0);
            }
            boolean isFirst = true;
            for (IUserInterface ui : UIConst.UIS.values()) {
                ui.init(isFirst, UIConst.UIS.size() > 1);
                isFirst = false;
            }
            neverStarted = true;
            core = CoreFactory.create();
            if (DEBUG_STARTUPTIME) {
                Main.logTime("Core Create");
            }
            for (IUserInterface ui : UIConst.UIS.values()) {
                ui.coreCreated(core);
            }
            if (DEBUG_STARTUPTIME) {
                Main.logTime("UIConst.setBiglyBTCore");
            }
            UIConst.processArgs(commands, options, args);
            if (DEBUG_STARTUPTIME) {
                Main.logTime("UIConst.processArgs");
            }
            if (startServer != null) {
                startServer.setDaemon(true);
                startServer.start();
            }
            neverStarted = !core.isStarted();
            core.addLifecycleListener(new CoreLifecycleAdapter(){

                @Override
                public void started(Core core) {
                    neverStarted = false;
                }

                @Override
                public void stopping(Core core) {
                    stopping = true;
                }

                @Override
                public void stopped(Core core) {
                    if (startServer != null) {
                        startServer.stopIt();
                    }
                    stopped = true;
                }
            });
            for (IUserInterface ui : UIConst.UIS.values()) {
                ui.takeMainThread();
                if (stopping) break;
            }
            if (neverStarted) {
                if (DEBUG_STARTUPTIME) {
                    Main.logTime("takeMainThread");
                }
                core.start();
                if (DEBUG_STARTUPTIME) {
                    Main.logTime("coreStart");
                }
            }
            if (!stopping) {
                while (!stopped) {
                    try {
                        Thread.sleep(200L);
                        if (newUI == null) continue;
                        IUserInterface threadTaker = newUI;
                        newUI = null;
                        threadTaker.takeMainThread();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
        }
        catch (CoreException e) {
            System.out.println("Start fails:");
            e.printStackTrace();
        }
        if (DEBUG_STARTUPTIME) {
            Main.logTime("DONE");
        }
    }

    private static void logTime(String s) {
        System.out.println(String.valueOf(System.currentTimeMillis() - lastDebugTime) + "ms] " + s);
        lastDebugTime = System.currentTimeMillis();
    }

    private static void buildUIList(CommandLine commands) {
        if (UIConst.UIS == null) {
            UIConst.UIS = new LinkedHashMap();
        }
        if (commands == null) {
            UIConst.UIS.put(DEFAULT_UI, UserInterfaceFactory.getUI(DEFAULT_UI));
            return;
        }
        if (commands.hasOption('u')) {
            String uinames = commands.getOptionValue('u');
            if (uinames.indexOf(44) == -1) {
                if (!UIConst.UIS.containsKey(uinames)) {
                    UIConst.UIS.put(uinames, UserInterfaceFactory.getUI(uinames));
                }
            } else {
                StringTokenizer stok = new StringTokenizer(uinames, ",");
                while (stok.hasMoreTokens()) {
                    String uin = stok.nextToken();
                    if (UIConst.UIS.containsKey(uin)) continue;
                    UIConst.UIS.put(uin, UserInterfaceFactory.getUI(uin));
                }
            }
        } else if (UIConst.UIS.isEmpty() && !commands.hasOption('c') && !commands.hasOption('e')) {
            UIConst.UIS.put(DEFAULT_UI, UserInterfaceFactory.getUI(DEFAULT_UI));
        }
    }

    private static String[] CocoaMagic(String[] args) {
        if (!Constants.isOSX) {
            return args;
        }
        try {
            System.setProperty("osxaccess.light", "1");
            Class<?> claOSXAccess = Class.forName("com.biglybt.platform.macosx.access.jnilib.OSXAccess");
            if (claOSXAccess != null) {
                Method method = claOSXAccess.getMethod("runLight", String[].class);
                Object invoke = method.invoke(null, new Object[]{args});
                return (String[])invoke;
            }
        }
        catch (Throwable e) {
            Debug.printStackTrace(e);
        }
        return args;
    }

    public static void setNewUI(IUserInterface newUI) {
        Main.newUI = newUI;
    }

    static /* synthetic */ boolean access$0() {
        return neverStarted;
    }

    static /* synthetic */ boolean access$2() {
        return stopping;
    }

    static /* synthetic */ boolean access$4() {
        return stopped;
    }
}

