/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.upnp;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AsyncDispatcher;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.net.upnp.services.UPnPWANConnection;
import com.biglybt.plugin.upnp.UPnPMapping;
import com.biglybt.plugin.upnp.UPnPMappingListener;
import com.biglybt.plugin.upnp.UPnPMappingManagerListener;
import com.biglybt.plugin.upnp.UPnPPlugin;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class UPnPMappingManager {
    private static UPnPMappingManager singleton;
    private UPnPPlugin plugin;
    private List<UPnPMapping> mappings = new ArrayList<UPnPMapping>();
    private CopyOnWriteList<UPnPMappingManagerListener> listeners = new CopyOnWriteList();
    private AsyncDispatcher async_dispatcher = new AsyncDispatcher();

    protected static synchronized UPnPMappingManager getSingleton(UPnPPlugin plugin) {
        if (singleton == null) {
            singleton = new UPnPMappingManager(plugin);
        }
        return singleton;
    }

    protected UPnPMappingManager(UPnPPlugin _plugin) {
        this.plugin = _plugin;
        this.addConfigPort("upnp.mapping.dataport", false, "UDP.Listen.Port.Enable", "UDP.Listen.Port");
        this.addConfigPort("upnp.mapping.trackerclientudp", false, "Server Enable UDP", "UDP.NonData.Listen.Port");
        this.addConfigPort("upnp.mapping.dataport", true, "TCP.Listen.Port.Enable", "TCP.Listen.Port");
        this.addConfigPortList("upnp.mapping.dataport", true, "TCP.Listen.Port.Enable", "TCP.Listen.AdditionalPorts");
        this.addConfigPort("upnp.mapping.dataport", true, "HTTP.Data.Listen.Port.Enable", "HTTP.Data.Listen.Port");
        this.addConfigPort("upnp.mapping.tcptrackerport", true, "Tracker Port Enable", "Tracker Port");
        this.addConfigPortX("upnp.mapping.tcptrackerport", true, "Tracker Port Enable", "Tracker Port Backups");
        this.addConfigPort("upnp.mapping.tcpssltrackerport", true, "Tracker Port SSL Enable", "Tracker Port SSL");
        this.addConfigPortX("upnp.mapping.tcpssltrackerport", true, "Tracker Port SSL Enable", "Tracker Port SSL Backups");
        this.addConfigPort("upnp.mapping.udptrackerport", false, "Tracker Port UDP Enable", "Tracker Port");
    }

    protected void serviceFound(UPnPWANConnection service) {
        boolean save_config = false;
        if ((service.getCapabilities() & 1) == 0) {
            UPnPMapping[] maps = this.getMappings();
            int i = 0;
            while (i < maps.length) {
                List others;
                UPnPMapping map = maps[i];
                if (map.isEnabled() && map.isTCP() && (others = this.getMappingEx(false, map.getPort())).size() != 0) {
                    boolean enabled = false;
                    int j = 0;
                    while (j < others.size()) {
                        UPnPMapping other = (UPnPMapping)others.get(j);
                        if (other.isEnabled()) {
                            enabled = true;
                        }
                        ++j;
                    }
                    if (enabled) {
                        UPnPMapping other;
                        int new_port;
                        while (this.getMapping(true, new_port = RandomUtils.generateRandomNetworkListenPort()) != null || this.getMapping(false, new_port) != null) {
                        }
                        int new_port_1 = new_port;
                        while (this.getMapping(true, new_port = RandomUtils.generateRandomNetworkListenPort()) != null || this.getMapping(false, new_port) != null || new_port_1 == new_port) {
                        }
                        int new_port_2 = new_port;
                        String others_str = "";
                        int j2 = 0;
                        while (j2 < others.size()) {
                            other = (UPnPMapping)others.get(j2);
                            if (other.isEnabled()) {
                                others_str = String.valueOf(others_str) + (others_str.length() == 0 ? "" : ",") + other.getString(new_port_2);
                            }
                            ++j2;
                        }
                        this.plugin.logAlert(2, "upnp.portchange.alert", new String[]{map.getString(new_port_1), String.valueOf(map.getPort()), others_str, String.valueOf(map.getPort())});
                        map.setPort(new_port_1);
                        j2 = 0;
                        while (j2 < others.size()) {
                            other = (UPnPMapping)others.get(j2);
                            if (other.isEnabled()) {
                                other.setPort(new_port_2);
                            }
                            ++j2;
                        }
                        save_config = true;
                    }
                }
                ++i;
            }
        }
        if (save_config) {
            COConfigurationManager.save();
        }
    }

    protected UPnPMapping addConfigPort(String name_resource, boolean tcp, boolean enabled, final String int_param_name) {
        int value = COConfigurationManager.getIntParameter(int_param_name);
        final UPnPMapping mapping2 = this.addMapping(name_resource, tcp, value, enabled);
        mapping2.addListener(new UPnPMappingListener(){

            @Override
            public void mappingChanged(UPnPMapping mapping2) {
                COConfigurationManager.setParameter(int_param_name, mapping2.getPort());
            }

            @Override
            public void mappingDestroyed(UPnPMapping mapping2) {
            }
        });
        this.addConfigListener(int_param_name, new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                mapping2.setPort(COConfigurationManager.getIntParameter(int_param_name));
            }
        });
        return mapping2;
    }

    protected void addConfigPort(String name_resource, boolean tcp, final String enabler_param_name, final String int_param_name) {
        boolean enabled = COConfigurationManager.getBooleanParameter(enabler_param_name);
        final UPnPMapping mapping2 = this.addConfigPort(name_resource, tcp, enabled, int_param_name);
        mapping2.addListener(new UPnPMappingListener(){

            @Override
            public void mappingChanged(UPnPMapping mapping2) {
                COConfigurationManager.setParameter(int_param_name, mapping2.getPort());
            }

            @Override
            public void mappingDestroyed(UPnPMapping mapping2) {
            }
        });
        this.addConfigListener(enabler_param_name, new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                mapping2.setEnabled(COConfigurationManager.getBooleanParameter(enabler_param_name));
            }
        });
    }

    protected void addConfigPortList(final String name_resource, final boolean tcp, final String enabler_param_name, final String list_param_name) {
        COConfigurationManager.addAndFireParameterListener(list_param_name, new ParameterListener(){
            List<Long> existing_ports = new ArrayList<Long>();

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void parameterChanged(String parameterName) {
                List<Long> list = this.existing_ports;
                synchronized (list) {
                    boolean enabled = COConfigurationManager.getBooleanParameter(enabler_param_name);
                    List ports = COConfigurationManager.getListParameter(list_param_name, new ArrayList());
                    for (Long port : ports) {
                        if (this.existing_ports.contains(port)) continue;
                        this.existing_ports.add(port);
                        final UPnPMapping mapping2 = UPnPMappingManager.this.addMapping(name_resource, tcp, port.intValue(), enabled);
                        mapping2.addListener(new UPnPMappingListener(){

                            @Override
                            public void mappingChanged(UPnPMapping mapping2) {
                                Debug.out("not supported");
                            }

                            @Override
                            public void mappingDestroyed(UPnPMapping mapping2) {
                            }
                        });
                        UPnPMappingManager.this.addConfigListener(enabler_param_name, new ParameterListener(){

                            @Override
                            public void parameterChanged(String name) {
                                mapping2.setEnabled(COConfigurationManager.getBooleanParameter(enabler_param_name));
                            }
                        });
                    }
                }
            }
        });
    }

    protected void addConfigPortX(final String name_resource, final boolean tcp, final String enabler_param_name, final String string_param_name) {
        final ArrayList config_mappings = new ArrayList();
        ParameterListener l1 = new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                boolean enabled = COConfigurationManager.getBooleanParameter(enabler_param_name);
                List ports = UPnPMappingManager.this.stringToPorts(COConfigurationManager.getStringParameter(string_param_name));
                int i = 0;
                while (i < ports.size()) {
                    int port = (Integer)ports.get(i);
                    if (config_mappings.size() <= i) {
                        UPnPMapping mapping2 = UPnPMappingManager.this.addMapping(name_resource, tcp, port, enabled);
                        mapping2.setEnabled(enabled);
                        config_mappings.add(mapping2);
                    } else {
                        ((UPnPMapping)config_mappings.get(i)).setPort(port);
                    }
                    ++i;
                }
                i = ports.size();
                while (i < config_mappings.size()) {
                    ((UPnPMapping)config_mappings.get(i)).setEnabled(false);
                    ++i;
                }
            }
        };
        this.addConfigListener(string_param_name, l1);
        ParameterListener l2 = new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                List ports = UPnPMappingManager.this.stringToPorts(COConfigurationManager.getStringParameter(string_param_name));
                boolean enabled = COConfigurationManager.getBooleanParameter(enabler_param_name);
                int i = 0;
                while (i < (enabled ? ports.size() : config_mappings.size())) {
                    ((UPnPMapping)config_mappings.get(i)).setEnabled(enabled);
                    ++i;
                }
            }
        };
        this.addConfigListener(enabler_param_name, l2);
        l1.parameterChanged(null);
        l2.parameterChanged(null);
    }

    protected List stringToPorts(String str) {
        str = str.replace(',', ';');
        StringTokenizer tok = new StringTokenizer(str, ";");
        ArrayList<Integer> res = new ArrayList<Integer>();
        while (tok.hasMoreTokens()) {
            try {
                res.add(new Integer(tok.nextToken().trim()));
            }
            catch (Throwable e) {
                Debug.out("Invalid port entry in '" + str + "'", e);
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UPnPMapping addMapping(String desc_resource, boolean tcp, int port, boolean enabled) {
        UPnPMapping mapping2 = new UPnPMapping(desc_resource, tcp, port, enabled);
        List<UPnPMapping> list = this.mappings;
        synchronized (list) {
            this.mappings.add(mapping2);
        }
        this.added(mapping2);
        return mapping2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UPnPMapping[] getMappings() {
        List<UPnPMapping> list = this.mappings;
        synchronized (list) {
            UPnPMapping[] res = new UPnPMapping[this.mappings.size()];
            this.mappings.toArray(res);
            return res;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public UPnPMapping getMapping(boolean tcp, int port) {
        List<UPnPMapping> list = this.mappings;
        synchronized (list) {
            int i = 0;
            while (i < this.mappings.size()) {
                UPnPMapping mapping2 = this.mappings.get(i);
                if (mapping2.isTCP() == tcp && mapping2.getPort() == port) {
                    return mapping2;
                }
                ++i;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List getMappingEx(boolean tcp, int port) {
        ArrayList<UPnPMapping> res = new ArrayList<UPnPMapping>();
        List<UPnPMapping> list = this.mappings;
        synchronized (list) {
            int i = 0;
            while (i < this.mappings.size()) {
                UPnPMapping mapping2 = this.mappings.get(i);
                if (mapping2.isTCP() == tcp && mapping2.getPort() == port) {
                    res.add(mapping2);
                }
                ++i;
            }
        }
        return res;
    }

    protected void added(UPnPMapping mapping2) {
        mapping2.addListener(new UPnPMappingListener(){

            @Override
            public void mappingChanged(UPnPMapping mapping2) {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void mappingDestroyed(UPnPMapping mapping2) {
                List list = UPnPMappingManager.this.mappings;
                synchronized (list) {
                    UPnPMappingManager.this.mappings.remove(mapping2);
                }
            }
        });
        for (UPnPMappingManagerListener listener : this.listeners) {
            try {
                listener.mappingAdded(mapping2);
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        }
    }

    public void addListener(UPnPMappingManagerListener l) {
        this.listeners.add(l);
    }

    public void removeListener(UPnPMappingManagerListener l) {
        this.listeners.remove(l);
    }

    protected void addConfigListener(final String param, final ParameterListener listener) {
        COConfigurationManager.addParameterListener(param, new ParameterListener(){

            @Override
            public void parameterChanged(String name) {
                UPnPMappingManager.this.async_dispatcher.dispatch(new AERunnable(){

                    @Override
                    public void runSupport() {
                        listener.parameterChanged(param);
                    }
                });
            }
        });
    }
}

