/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.startstoprules.defaultplugin;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.impl.ConfigurationDefaults;
import com.biglybt.core.config.impl.ConfigurationParameterNotFoundException;
import com.biglybt.core.internat.MessageText;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DisplayFormatters;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.ui.UIManager;
import com.biglybt.pif.ui.config.BooleanParameter;
import com.biglybt.pif.ui.config.FloatParameter;
import com.biglybt.pif.ui.config.IntListParameter;
import com.biglybt.pif.ui.config.IntParameter;
import com.biglybt.pif.ui.config.LabelParameter;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pif.ui.config.ParameterGroup;
import com.biglybt.pif.ui.config.ParameterListener;
import com.biglybt.pif.ui.config.ParameterWithSuffix;
import com.biglybt.pif.ui.model.BasicPluginConfigModel;
import java.util.ArrayList;

public class StartStopConfigModel {
    public static final String SECTION_ID_Q = "queue";
    public static final String SECTION_ID_Q_SEEDING = "queue.seeding";
    public static final String SECTION_ID_Q_DL = "queue.downloading";
    public static final String SECTION_ID_Q_SEEDING_AUTO_STARTING = "queue.seeding.autoStarting";
    public static final String SECTION_ID_Q_SEEDING_FP = "queue.seeding.firstPriority";
    public static final String SECTION_ID_Q_SEEDING_IGNORE = "queue.seeding.ignore";
    private final PluginInterface pi;
    private final ConfigurationDefaults def;

    public StartStopConfigModel(PluginInterface pi) {
        this.pi = pi;
        this.def = ConfigurationDefaults.getInstance();
        this.initQueueSection();
        this.initDownloadingSection();
        this.initSeedingSection();
        this.initSeedingAutoStarting();
        this.initSeedingFirstPriority();
        this.initSeedingIgnore();
    }

    private void initSeedingIgnore() {
        UIManager manager = this.pi.getUIManager();
        BasicPluginConfigModel model = manager.createBasicPluginConfigModel(SECTION_ID_Q_SEEDING, SECTION_ID_Q_SEEDING_IGNORE);
        model.addLabelParameter2("ConfigView.label.autoSeedingIgnoreInfo");
        ArrayList<ParameterWithSuffix> listIgnore = new ArrayList<ParameterWithSuffix>();
        IntParameter ignoreSeedCount = model.addIntParameter2("StartStopManager_iIgnoreSeedCount", "ConfigView.label.ignoreSeeds", 0, 0, 9999);
        listIgnore.add(ignoreSeedCount);
        ignoreSeedCount.setSuffixLabelKey("ConfigView.label.seeds");
        IntParameter stopPeersRatio = this.addDefaultedIntParam(model, "Stop Peers Ratio", "ConfigView.label.seeding.ignoreRatioPeers", 0, 9999);
        listIgnore.add(stopPeersRatio);
        stopPeersRatio.setSuffixLabelKey("ConfigView.label.peers");
        IntParameter ignoreRatioPeersSeedStart = model.addIntParameter2("StartStopManager_iIgnoreRatioPeersSeedStart", "ConfigView.label.seeding.fakeFullCopySeedStart", 0, 0, 9999);
        listIgnore.add(ignoreRatioPeersSeedStart);
        ignoreRatioPeersSeedStart.setSuffixLabelKey("ConfigView.label.seeds");
        ignoreRatioPeersSeedStart.setIndent(1, true);
        FloatParameter stopRatio = this.addDefaultedFloatParam(model, "Stop Ratio", "ConfigView.label.seeding.ignoreShareRatio", 1.0f, -1.0f, true, 1);
        listIgnore.add(stopRatio);
        stopRatio.setSuffixLabelText(":1");
        IntParameter ignoreShareRatioSeedStart = model.addIntParameter2("StartStopManager_iIgnoreShareRatioSeedStart", "ConfigView.label.seeding.fakeFullCopySeedStart", 0, 0, 9999);
        listIgnore.add(ignoreShareRatioSeedStart);
        ignoreShareRatioSeedStart.setSuffixLabelKey("ConfigView.label.seeds");
        ignoreShareRatioSeedStart.setIndent(1, true);
        listIgnore.add(model.addBooleanParameter2("StartStopManager_bIgnore0Peers", "ConfigView.label.seeding.ignore0Peers", true));
        model.createGroup("ConfigView.label.seeding.ignore", listIgnore.toArray(new Parameter[0]));
    }

    private void initSeedingFirstPriority() {
        UIManager manager = this.pi.getUIManager();
        BasicPluginConfigModel model = manager.createBasicPluginConfigModel(SECTION_ID_Q_SEEDING, SECTION_ID_Q_SEEDING_FP);
        model.addLabelParameter2("ConfigView.label.seeding.firstPriority.info");
        ArrayList<Parameter> listFP = new ArrayList<Parameter>();
        String[] fpLabels = new String[]{MessageText.getString("ConfigView.text.all"), MessageText.getString("ConfigView.text.any")};
        int[] nArray = new int[2];
        nArray[1] = 1;
        int[] fpValues = nArray;
        IntListParameter firstPriorityType = model.addIntListParameter2("StartStopManager_iFirstPriority_Type", "ConfigView.label.seeding.firstPriority", fpValues, fpLabels, 1);
        firstPriorityType.setSuffixLabelKey("ConfigView.label.seeding.firstPriority.following");
        listFP.add(model.createGroup(null, firstPriorityType));
        String[] minQueueLabels = new String[57];
        int[] minQueueValues = new int[57];
        int mqpos = 0;
        minQueueLabels[mqpos] = MessageText.getString("ConfigView.text.ignore");
        minQueueValues[mqpos++] = 0;
        minQueueLabels[mqpos] = "1:2 (0.5)";
        minQueueValues[mqpos++] = 500;
        minQueueLabels[mqpos] = "3:4 (0.75)";
        minQueueValues[mqpos++] = 750;
        minQueueLabels[mqpos] = "1:1";
        minQueueValues[mqpos++] = 1000;
        minQueueLabels[mqpos] = "5:4 (1.25)";
        minQueueValues[mqpos++] = 1250;
        minQueueLabels[mqpos] = "3:2 (1.5)";
        minQueueValues[mqpos++] = 1500;
        minQueueLabels[mqpos] = "7:4 (1.75)";
        minQueueValues[mqpos++] = 1750;
        minQueueLabels[mqpos] = "2:1";
        minQueueValues[mqpos++] = 2000;
        int i = mqpos;
        while (i < minQueueLabels.length) {
            minQueueLabels[i] = String.valueOf(i - 5) + ":1";
            minQueueValues[i] = (i - 5) * 1000;
            ++i;
        }
        listFP.add(model.addIntListParameter2("StartStopManager_iFirstPriority_ShareRatio", "ConfigView.label.seeding.firstPriority.shareRatio", minQueueValues, minQueueLabels, 500));
        String sMinutes = MessageText.getString("ConfigView.text.minutes");
        String sHours = MessageText.getString("ConfigView.text.hours");
        String[] dlTimeLabels = new String[15];
        int[] dlTimeValues = new int[15];
        dlTimeLabels[0] = MessageText.getString("ConfigView.text.ignore");
        dlTimeValues[0] = 0;
        int i2 = 1;
        while (i2 < dlTimeValues.length) {
            dlTimeLabels[i2] = "<= " + (i2 + 2) + " " + sHours;
            dlTimeValues[i2] = (i2 + 2) * 60;
            ++i2;
        }
        listFP.add(model.addIntListParameter2("StartStopManager_iFirstPriority_DLMinutes", "ConfigView.label.seeding.firstPriority.DLMinutes", dlTimeValues, dlTimeLabels, 0));
        String[] seedTimeLabels = new String[15];
        int[] seedTimeValues = new int[15];
        seedTimeLabels[0] = MessageText.getString("ConfigView.text.ignore");
        seedTimeValues[0] = 0;
        seedTimeLabels[1] = "<= 90 " + sMinutes;
        seedTimeValues[1] = 90;
        int i3 = 2;
        while (i3 < seedTimeValues.length) {
            seedTimeLabels[i3] = "<= " + i3 + " " + sHours;
            seedTimeValues[i3] = i3 * 60;
            ++i3;
        }
        listFP.add(model.addIntListParameter2("StartStopManager_iFirstPriority_SeedingMinutes", "ConfigView.label.seeding.firstPriority.seedingMinutes", seedTimeValues, seedTimeLabels, 0));
        model.createGroup("ConfigView.label.seeding.firstPriority.FP", listFP.toArray(new Parameter[0]));
        ArrayList<Parameter> listIgnoreFP = new ArrayList<Parameter>();
        String[] ignoreSPRatioLabels = new String[15];
        int[] ignoreSPRatioValues = new int[15];
        ignoreSPRatioLabels[0] = MessageText.getString("ConfigView.text.ignore");
        ignoreSPRatioValues[0] = 0;
        int i4 = 1;
        while (i4 < ignoreSPRatioLabels.length) {
            ignoreSPRatioLabels[i4] = String.valueOf(i4 * 10) + " " + ":1";
            ignoreSPRatioValues[i4] = i4 * 10;
            ++i4;
        }
        listIgnoreFP.add(model.addIntListParameter2("StartStopManager_iFirstPriority_ignoreSPRatio", "ConfigView.label.seeding.firstPriority.ignoreSPRatio", ignoreSPRatioValues, ignoreSPRatioLabels, 0));
        listIgnoreFP.add(model.addBooleanParameter2("StartStopManager_bFirstPriority_ignore0Peer", "ConfigView.label.seeding.firstPriority.ignore0Peer", !COConfigurationManager.getStringParameter("ui", "").equals("az2")));
        int[] availIdleMinutes = new int[]{5, 10, 15, 20, 30, 45, 60, 120, 180, 240, 300, 360, 420, 480, 720, 1080, 1440, 2880, 4320, 10080};
        String[] ignoreIdleMinutesLabels = new String[availIdleMinutes.length + 1];
        int[] ignoreIdleMinutesValues = new int[availIdleMinutes.length + 1];
        ignoreIdleMinutesLabels[0] = MessageText.getString("ConfigView.text.ignore");
        ignoreIdleMinutesValues[0] = 0;
        int i5 = 0;
        while (i5 < availIdleMinutes.length) {
            int mins = availIdleMinutes[i5];
            ignoreIdleMinutesLabels[i5 + 1] = mins < 60 ? String.valueOf(mins) + " " + sMinutes : String.valueOf(mins / 60) + " " + sHours;
            ignoreIdleMinutesValues[i5 + 1] = availIdleMinutes[i5];
            ++i5;
        }
        listIgnoreFP.add(model.addIntListParameter2("StartStopManager_iFirstPriority_ignoreIdleMinutes", "ConfigView.label.seeding.firstPriority.ignoreIdle", ignoreIdleMinutesValues, ignoreIdleMinutesLabels, 0));
        LabelParameter fpIgnoreInfo = model.addLabelParameter2("ConfigView.label.seeding.firstPriority.ignore.info");
        listIgnoreFP.add(fpIgnoreInfo);
        fpIgnoreInfo.setLabelText(fpIgnoreInfo.getLabelText().replaceAll("\n", " "));
        model.createGroup("ConfigView.label.seeding.firstPriority.ignore", listIgnoreFP.toArray(new Parameter[0]));
        model.addBooleanParameter2("StartStopManager_bTagFirstPriority", "ConfigView.label.queue.tagfirstpriority", false);
    }

    private void initSeedingAutoStarting() {
        UIManager manager = this.pi.getUIManager();
        BasicPluginConfigModel model = manager.createBasicPluginConfigModel(SECTION_ID_Q_SEEDING, SECTION_ID_Q_SEEDING_AUTO_STARTING);
        int[] nArray = new int[5];
        nArray[0] = 1;
        nArray[1] = 2;
        nArray[2] = 4;
        nArray[3] = 3;
        int[] rankValues = nArray;
        String[] rankLabels = new String[]{MessageText.getString("ConfigView.label.seeding.rankType.peerSeed"), MessageText.getString("ConfigView.label.seeding.rankType.seed"), MessageText.getString("ConfigView.label.seeding.rankType.peer"), MessageText.getString("ConfigView.label.seeding.rankType.timedRotation"), MessageText.getString("ConfigView.label.seeding.rankType.none")};
        IntListParameter paramRankType = model.addIntListParameter2("StartStopManager_iRankType", null, rankValues, rankLabels, 1);
        paramRankType.setListType(2);
        IntParameter paramSeedFallback = model.addIntParameter2("StartStopManager_iRankTypeSeedFallback", "ConfigView.label.seeding.rankType.seed.fallback", 0, 0, Integer.MAX_VALUE);
        paramSeedFallback.setSuffixLabelKey("ConfigView.label.seeds");
        ParameterGroup pgSeedOptions = model.createGroup("ConfigView.label.seeding.rankType.seed.options", paramSeedFallback);
        IntParameter paramMinSeedingTimeWithPeers = model.addIntParameter2("StartStopManager_iTimed_MinSeedingTimeWithPeers", "ConfigView.label.seeding.rankType.timed.minTimeWithPeers", 0, 0, Integer.MAX_VALUE);
        ParameterGroup pgTimedOptions = model.createGroup("ConfigView.label.seeding.rankType.timed.options", paramMinSeedingTimeWithPeers);
        ParameterGroup pgRankTypeOptions = model.createGroup(null, pgSeedOptions, pgTimedOptions);
        model.createGroup("ConfigView.label.seeding.rankType", paramRankType, pgRankTypeOptions).setNumberOfColumns(2);
        ArrayList<ParameterWithSuffix> listPSorSC = new ArrayList<ParameterWithSuffix>();
        listPSorSC.add(model.addBooleanParameter2("StartStopManager_bPreferLargerSwarms", "ConfigView.label.seeding.preferLargerSwarms", true));
        String[] boostQRPeersLabels = new String[9];
        int[] boostQRPeersValues = new int[9];
        String peers = MessageText.getString("ConfigView.text.peers");
        int i = 0;
        while (i < boostQRPeersValues.length) {
            boostQRPeersLabels[i] = String.valueOf(i + 1) + " " + peers;
            boostQRPeersValues[i] = i + 1;
            ++i;
        }
        listPSorSC.add(model.addIntListParameter2("StartStopManager_iMinPeersToBoostNoSeeds", "ConfigView.label.minPeersToBoostNoSeeds", boostQRPeersValues, boostQRPeersLabels, 1));
        ParameterGroup pgPSorSC = model.createGroup(null, listPSorSC.toArray(new Parameter[0]));
        ParameterListener rankTypeListener = param -> {
            int rankType = paramRankType.getValue();
            pgSeedOptions.setVisible(rankType == 2);
            pgTimedOptions.setVisible(rankType == 3);
            pgPSorSC.setVisible(rankType == 1 || rankType == 2);
            pgSeedOptions.setEnabled(rankType == 2);
            pgTimedOptions.setEnabled(rankType == 3);
            pgPSorSC.setEnabled(rankType == 1 || rankType == 2);
        };
        paramRankType.addListener(rankTypeListener);
        rankTypeListener.parameterChanged(null);
        model.addBooleanParameter2("StartStopManager_bAutoStart0Peers", "ConfigView.label.seeding.autoStart0Peers", false);
    }

    private void initSeedingSection() {
        UIManager manager = this.pi.getUIManager();
        BasicPluginConfigModel model = manager.createBasicPluginConfigModel(SECTION_ID_Q, SECTION_ID_Q_SEEDING);
        model.addIntParameter2("StartStopManager_iMinSeedingTime", "ConfigView.label.minSeedingTime", 600, 0, Integer.MAX_VALUE);
        BooleanParameter dontStartMore = model.addBooleanParameter2("StartStopManager_bStartNoMoreSeedsWhenUpLimitMet", "ConfigView.label.bStartNoMoreSeedsWhenUpLimitMet", false);
        IntParameter slack = model.addIntParameter2("StartStopManager_bStartNoMoreSeedsWhenUpLimitMetSlack", "ConfigView.label.bStartNoMoreSeedsWhenUpLimitMetSlack", 95, 0, Integer.MAX_VALUE);
        slack.setIndent(1, true);
        BooleanParameter slackIsPercent = model.addBooleanParameter2("StartStopManager_bStartNoMoreSeedsWhenUpLimitMetPercent", "ConfigView.label.bStartNoMoreSeedsWhenUpLimitMetPercent", true);
        slackIsPercent.setIndent(1, true);
        dontStartMore.addEnabledOnSelection(slack, slackIsPercent);
        this.addDefaultedBooleanParam(model, "Disconnect Seed", "ConfigView.label.disconnetseed");
        this.addDefaultedBooleanParam(model, "Use Super Seeding", "ConfigView.label.userSuperSeeding");
        this.addDefaultedBooleanParam(model, "Enable Light Seeding", "ConfigView.label.enableLightSeeding");
        model.addIntParameter2("Light Seed Slots Reserved", "ConfigView.label.light.seeding.reserved.slots", 4, 0, 1024);
        model.addIntParameter2("Flexible Seed Slots", "ConfigView.label.seeding.flexible.slots", 5, 0, 1024);
        model.addBooleanParameter2("StartStopManager_bAutoReposition", "ConfigView.label.seeding.autoReposition", false);
        model.addIntParameter2("StartStopManager_iAddForSeedingDLCopyCount", "ConfigView.label.seeding.addForSeedingDLCopyCount", 1, 0, Integer.MAX_VALUE);
        IntParameter paramFakeFullCopy = model.addIntParameter2("StartStopManager_iNumPeersAsFullCopy", "ConfigView.label.seeding.numPeersAsFullCopy", 0, 0, Integer.MAX_VALUE);
        paramFakeFullCopy.setSuffixLabelKey("ConfigView.label.peers");
        IntParameter fakeFullCopySeedStart = model.addIntParameter2("StartStopManager_iFakeFullCopySeedStart", "ConfigView.label.seeding.fakeFullCopySeedStart", 1, 0, Integer.MAX_VALUE);
        fakeFullCopySeedStart.setSuffixLabelKey("ConfigView.label.seeds");
        fakeFullCopySeedStart.setIndent(1, true);
        ParameterListener fakeFullCopyListener = p -> {
            try {
                int iNumPeersAsFullCopy = paramFakeFullCopy.getValue();
                boolean enabled = iNumPeersAsFullCopy != 0;
                fakeFullCopySeedStart.setEnabled(enabled);
            }
            catch (Exception exception) {
                // empty catch block
            }
        };
        paramFakeFullCopy.addListener(fakeFullCopyListener);
        fakeFullCopyListener.parameterChanged(null);
    }

    private void initQueueSection() {
        UIManager manager = this.pi.getUIManager();
        BasicPluginConfigModel model = manager.createBasicPluginConfigModel("root", SECTION_ID_Q);
        IntParameter maxDLs = this.addDefaultedIntParam(model, "max downloads", "ConfigView.label.maxdownloads", 0, Integer.MAX_VALUE);
        BooleanParameter ignoreChecking = model.addBooleanParameter2("StartStopManager_bMaxDownloadIgnoreChecking", "ConfigView.label.ignoreChecking", false);
        ignoreChecking.setIndent(1, true);
        IntParameter maxActiv = this.addDefaultedIntParam(model, "max active torrents", "ConfigView.label.maxactivetorrents", 0, Integer.MAX_VALUE);
        BooleanParameter maxActiveWhenSeedingEnabled = model.addBooleanParameter2("StartStopManager_bMaxActiveTorrentsWhenSeedingEnabled", "ConfigView.label.queue.maxactivetorrentswhenseeding", false);
        maxActiveWhenSeedingEnabled.setIndent(1, true);
        IntParameter maxActivWhenSeeding = model.addIntParameter2("StartStopManager_iMaxActiveTorrentsWhenSeeding", null, 0, 0, Integer.MAX_VALUE);
        maxActiveWhenSeedingEnabled.addListener(param -> {
            if (!maxActiveWhenSeedingEnabled.hasBeenSet()) {
                maxActivWhenSeeding.resetToDefault();
            }
        });
        maxActiveWhenSeedingEnabled.addEnabledOnSelection((Parameter)maxActivWhenSeeding);
        ParameterGroup pgMaxActivWhenSeeding = model.createGroup(null, maxActiveWhenSeedingEnabled, maxActivWhenSeeding);
        pgMaxActivWhenSeeding.setNumberOfColumns(2);
        IntParameter minDLs = model.addIntParameter2("min downloads", "ConfigView.label.mindownloads", 1, 0, maxDLs.getValue());
        BooleanParameter minmaxlink = model.addBooleanParameter2("StartStopManager_bMaxMinDLLinked", "ConfigView.label.maxmindownloadlinked", false);
        minmaxlink.setIndent(1, true);
        minmaxlink.addDisabledOnSelection((Parameter)minDLs);
        maxDLs.addListener(p -> {
            int iMaxDLs = maxDLs.getValue();
            minDLs.setMaxValue(iMaxDLs);
            int iMaxActive = maxActiv.getValue();
            if ((iMaxDLs == 0 || iMaxDLs > iMaxActive) && iMaxActive != 0) {
                maxActiv.setValue(iMaxDLs);
            }
        });
        maxActiv.addListener(p -> {
            int iMaxDLs = maxDLs.getValue();
            int iMaxActive = maxActiv.getValue();
            if ((iMaxDLs == 0 || iMaxDLs > iMaxActive) && iMaxActive != 0) {
                maxDLs.setValue(iMaxActive);
            }
        });
        ArrayList<Integer> values = new ArrayList<Integer>();
        int exp = 29;
        int val = 0;
        while (val <= 0x800000) {
            values.add(val);
            if (val < 256) {
                val += 64;
                continue;
            }
            if (val < 1024) {
                val += 256;
                continue;
            }
            if (val < 16384) {
                val += 1024;
                continue;
            }
            val = (int)(Math.pow(2.0, exp++ / 2) + (exp % 2 == 0 ? Math.pow(2.0, (exp - 3) / 2) : 0.0));
        }
        String[] activeDLLabels = new String[values.size()];
        int[] activeDLValues = new int[activeDLLabels.length];
        int i = 0;
        while (i < activeDLLabels.length) {
            activeDLValues[i] = (Integer)values.get(i);
            activeDLLabels[i] = DisplayFormatters.formatByteCountToKiBEtcPerSec(activeDLValues[i], true);
            ++i;
        }
        model.addIntListParameter2("StartStopManager_iMinSpeedForActiveDL", "ConfigView.label.minSpeedForActiveDL", activeDLValues, activeDLLabels, 512);
        String[] activeSeedingLabels = new String[values.size() - 4];
        int[] activeSeedingValues = new int[activeSeedingLabels.length];
        System.arraycopy(activeDLLabels, 0, activeSeedingLabels, 0, activeSeedingLabels.length);
        System.arraycopy(activeDLValues, 0, activeSeedingValues, 0, activeSeedingValues.length);
        IntListParameter minSpeedForActiveSeeding = model.addIntListParameter2("StartStopManager_iMinSpeedForActiveSeeding", "ConfigView.label.minSpeedForActiveSeeding", activeSeedingValues, activeSeedingLabels, 512);
        IntParameter maxStalledSeeding = model.addIntParameter2("StartStopManager_iMaxStalledSeeding", "ConfigView.label.maxStalledSeeding", 5, 0, Integer.MAX_VALUE);
        maxStalledSeeding.setIndent(1, true);
        BooleanParameter maxStalledSeedingIgnoreZP = model.addBooleanParameter2("StartStopManager_bMaxStalledSeedingIgnoreZP", "ConfigView.label.maxStalledSeedingIgnoreZP", true);
        maxStalledSeedingIgnoreZP.setIndent(1, true);
        ParameterListener minSpeedForActiveSeedingListener = p -> {
            boolean enabled = minSpeedForActiveSeeding.getValue() != 0;
            maxStalledSeeding.setEnabled(enabled);
            maxStalledSeedingIgnoreZP.setEnabled(enabled);
        };
        minSpeedForActiveSeeding.addListener(minSpeedForActiveSeedingListener);
        minSpeedForActiveSeedingListener.parameterChanged(null);
        model.addBooleanParameter2("StartStopManager_bStopOnceBandwidthMet", "ConfigView.label.queue.stoponcebandwidthmet", true);
        model.addBooleanParameter2("StartStopManager_bNewSeedsMoveTop", "ConfigView.label.queue.newseedsmovetop", true);
        model.addBooleanParameter2("StartStopManager_bRetainForceStartWhenComplete", "ConfigView.label.queue.retainforce", false);
        BooleanParameter paramAlertOnClose = this.addDefaultedBooleanParam(model, "Alert on close", "ConfigView.label.showpopuponclose");
        paramAlertOnClose.setAllowedUiTypes("swt");
        model.addBooleanParameter2("StartStopManager_bDebugLog", "ConfigView.label.queue.debuglog", false);
    }

    public void initDownloadingSection() {
        UIManager manager = this.pi.getUIManager();
        BasicPluginConfigModel model = manager.createBasicPluginConfigModel(SECTION_ID_Q, SECTION_ID_Q_DL);
        model.addHyperlinkParameter2("ConfigView.label.please.visit.here", "https://wiki.biglybt.com/w/Downloading_Rules");
        String[] orderLabels = new String[]{MessageText.getString("label.order"), MessageText.getString("label.seed.count"), MessageText.getString("label.reverse.seed.count"), MessageText.getString("TableColumn.header.size"), MessageText.getString("label.reverse.size"), MessageText.getString("label.speed"), MessageText.getString("TableColumn.header.eta"), MessageText.getString("TableColumn.header.file.priorities"), MessageText.getString("TableColumn.header.remaining")};
        int[] nArray = new int[9];
        nArray[1] = 1;
        nArray[2] = 3;
        nArray[3] = 4;
        nArray[4] = 5;
        nArray[5] = 2;
        nArray[6] = 6;
        nArray[7] = 7;
        nArray[8] = 8;
        int[] orderValues = nArray;
        IntListParameter sort_type = model.addIntListParameter2("StartStopManager_Downloading_iSortType", "label.prioritize.downloads.based.on", orderValues, orderLabels, 0);
        ArrayList<Parameter> listSpeed = new ArrayList<Parameter>();
        listSpeed.add(model.addLabelParameter2("ConfigView.label.downloading.info"));
        IntParameter testTime = model.addIntParameter2("StartStopManager_Downloading_iTestTimeSecs", "ConfigView.label.downloading.testTime", 120);
        listSpeed.add(testTime);
        testTime.setMinValue(60);
        IntParameter reTest = model.addIntParameter2("StartStopManager_Downloading_iRetestTimeMins", "ConfigView.label.downloading.reTest", 30);
        listSpeed.add(reTest);
        reTest.setMinValue(0);
        BooleanParameter testActive = model.addBooleanParameter2("StartStopManager_Downloading_bTestActive", "ConfigView.label.downloading.testActive", false);
        listSpeed.add(testActive);
        ParameterListener sortTypeListener = p -> {
            int type = sort_type.getValue();
            boolean is_speed = type == 2 || type == 6;
            testTime.setEnabled(is_speed);
            reTest.setEnabled(is_speed);
            testActive.setEnabled(is_speed);
        };
        sort_type.addListener(sortTypeListener);
        sortTypeListener.parameterChanged(null);
        model.createGroup("label.speed.options", listSpeed.toArray(new Parameter[0]));
        model.addBooleanParameter2("StartStopManager_bAddForDownloadingSR1", "ConfigView.label.downloading.addsr1", true);
    }

    private IntParameter addDefaultedIntParam(BasicPluginConfigModel model, String key, String labelKey, int min, int max) {
        try {
            return model.addIntParameter2(key, labelKey, this.def.getIntParameter(key), min, max);
        }
        catch (ConfigurationParameterNotFoundException e) {
            Debug.out(e);
            return null;
        }
    }

    private FloatParameter addDefaultedFloatParam(BasicPluginConfigModel model, String key, String labelKey, float min, float max, boolean allowZero, int digitsAfterDecimal) {
        try {
            return model.addFloatParameter2(key, labelKey, this.def.getFloatParameter(key), min, max, allowZero, digitsAfterDecimal);
        }
        catch (ConfigurationParameterNotFoundException e) {
            Debug.out(e);
            return null;
        }
    }

    private BooleanParameter addDefaultedBooleanParam(BasicPluginConfigModel model, String key, String labelKey) {
        try {
            return model.addBooleanParameter2(key, labelKey, this.def.getBooleanParameter(key));
        }
        catch (ConfigurationParameterNotFoundException e) {
            Debug.out(e);
            return null;
        }
    }
}

