/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.net.netstatus;

import com.biglybt.core.networkmanager.ConnectionEndpoint;
import com.biglybt.core.networkmanager.IncomingMessageQueue;
import com.biglybt.core.networkmanager.NetworkConnection;
import com.biglybt.core.networkmanager.NetworkManager;
import com.biglybt.core.networkmanager.OutgoingMessageQueue;
import com.biglybt.core.networkmanager.ProtocolEndpoint;
import com.biglybt.core.networkmanager.ProtocolEndpointFactory;
import com.biglybt.core.peermanager.PeerManager;
import com.biglybt.core.peermanager.PeerManagerRegistration;
import com.biglybt.core.peermanager.PeerManagerRegistrationAdapter;
import com.biglybt.core.peermanager.messaging.Message;
import com.biglybt.core.peermanager.messaging.bittorrent.BTBitfield;
import com.biglybt.core.peermanager.messaging.bittorrent.BTHandshake;
import com.biglybt.core.peermanager.messaging.bittorrent.BTHave;
import com.biglybt.core.peermanager.messaging.bittorrent.BTMessageDecoder;
import com.biglybt.core.peermanager.messaging.bittorrent.BTMessageEncoder;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.DelayedEvent;
import com.biglybt.core.util.DirectByteBuffer;
import com.biglybt.core.util.HashWrapper;
import com.biglybt.core.util.RandomUtils;
import com.biglybt.core.util.SystemTime;
import com.biglybt.plugin.net.netstatus.NetStatusProtocolTester;
import com.biglybt.plugin.net.netstatus.NetStatusProtocolTesterListener;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.Set;

public class NetStatusProtocolTesterBT {
    private static Random random = RandomUtils.SECURE_RANDOM;
    private NetStatusProtocolTester tester;
    private boolean test_initiator;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private byte[] my_hash;
    private byte[] peer_id;
    private InetAddress explicit_bind;
    private PeerManagerRegistration pm_reg;
    private long start_time = SystemTime.getCurrentTime();
    private List sessions = new ArrayList();
    private int session_id_next;
    private int outbound_attempts = 0;
    private int outbound_connects = 0;
    private int inbound_connects = 0;
    private boolean outbound_connections_complete;
    private AESemaphore completion_sem = new AESemaphore("Completion");
    private boolean destroyed;

    protected NetStatusProtocolTesterBT(NetStatusProtocolTester _tester, boolean _test_initiator) {
        this.tester = _tester;
        this.test_initiator = _test_initiator;
    }

    public void setBindIP(InetAddress a) {
        this.log("Bind IP set to " + a);
        this.explicit_bind = a;
    }

    protected void start() {
        this.my_hash = new byte[20];
        random.nextBytes(this.my_hash);
        this.peer_id = new byte[20];
        random.nextBytes(this.peer_id);
        this.pm_reg = PeerManager.getSingleton().registerLegacyManager(new HashWrapper(this.my_hash), new PeerManagerRegistrationAdapter(){

            @Override
            public byte[][] getSecrets() {
                return new byte[][]{NetStatusProtocolTesterBT.this.my_hash};
            }

            @Override
            public byte[] getHashOverride() {
                return null;
            }

            @Override
            public int getNbPieces() {
                return 1;
            }

            @Override
            public int getExtendedMessagingMode() {
                return 2;
            }

            @Override
            public byte[] getPeerID() {
                return NetStatusProtocolTesterBT.this.peer_id;
            }

            @Override
            public int getHashOverrideLocalPort(boolean only_if_allocated) {
                return 0;
            }

            @Override
            public boolean manualRoute(NetworkConnection connection) {
                NetStatusProtocolTesterBT.this.log("Got incoming connection from " + connection.getEndpoint().getNotionalAddress());
                new Session(connection, null);
                return true;
            }

            @Override
            public boolean isPeerSourceEnabled(String peer_source) {
                return true;
            }

            @Override
            public int activateRequest(InetSocketAddress remote_address) {
                return 1;
            }

            @Override
            public void deactivateRequest(InetSocketAddress remote_address) {
            }

            @Override
            public String getDescription() {
                return "NetStatusPlugin - router";
            }
        });
        this.log("Incoming routing established for " + ByteFormatter.encodeString(this.my_hash));
    }

    protected byte[] getServerHash() {
        return this.my_hash;
    }

    protected long getStartTime(long now) {
        if (now < this.start_time) {
            this.start_time = now;
        }
        return this.start_time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void testOutbound(InetSocketAddress address, byte[] their_hash, boolean use_crypto) {
        if (NetworkManager.getCryptoRequired(0)) {
            use_crypto = true;
        }
        this.log("Making outbound connection to " + address);
        NetStatusProtocolTesterBT netStatusProtocolTesterBT = this;
        synchronized (netStatusProtocolTesterBT) {
            ++this.outbound_attempts;
        }
        boolean allow_fallback = false;
        ProtocolEndpoint pe = ProtocolEndpointFactory.createEndpoint(1, address);
        ConnectionEndpoint connection_endpoint = new ConnectionEndpoint(address);
        connection_endpoint.addProtocol(pe);
        NetworkConnection connection = NetworkManager.getSingleton().createConnection(connection_endpoint, new BTMessageEncoder(), new BTMessageDecoder(), use_crypto, allow_fallback, new byte[][]{their_hash});
        new Session(connection, their_hash);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        ArrayList to_close = new ArrayList();
        List list = this.sessions;
        synchronized (list) {
            if (this.destroyed) {
                return;
            }
            this.destroyed = true;
            to_close.addAll(this.sessions);
            this.sessions.clear();
        }
        int i = 0;
        while (i < to_close.size()) {
            Session session = (Session)to_close.get(i);
            session.close();
            ++i;
        }
        this.pm_reg.unregister();
        this.checkCompletion();
        this.log("Incoming routing destroyed for " + ByteFormatter.encodeString(this.my_hash));
    }

    protected boolean isDestroyed() {
        return this.destroyed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutboundConnectionsComplete() {
        List list = this.sessions;
        synchronized (list) {
            this.outbound_connections_complete = true;
        }
        this.checkCompletion();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkCompletion() {
        boolean inform = false;
        List list = this.sessions;
        synchronized (list) {
            if (this.completion_sem.isReleasedForever()) {
                return;
            }
            if (this.destroyed || this.outbound_connections_complete && this.sessions.size() == 0) {
                inform = true;
                this.completion_sem.releaseForever();
            }
        }
        if (inform) {
            Iterator it = this.listeners.iterator();
            while (it.hasNext()) {
                try {
                    ((NetStatusProtocolTesterListener)it.next()).complete(this);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
        }
    }

    public boolean waitForCompletion(long max_millis) {
        if (max_millis == 0L) {
            this.completion_sem.reserve();
            return true;
        }
        return this.completion_sem.reserve(max_millis);
    }

    public void addListener(NetStatusProtocolTesterListener l) {
        this.listeners.add(l);
    }

    public void removeListener(NetStatusProtocolTesterListener l) {
        this.listeners.remove(l);
    }

    public int getOutboundConnects() {
        return this.outbound_connects;
    }

    public int getInboundConnects() {
        return this.inbound_connects;
    }

    public String getStatus() {
        return "sessions=" + this.sessions.size() + ", out_attempts=" + this.outbound_attempts + ", out_connect=" + this.outbound_connects + ", in_connect=" + this.inbound_connects;
    }

    protected void log(String str) {
        this.log(str, false);
    }

    protected void log(String str, boolean detailed) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                ((NetStatusProtocolTesterListener)it.next()).log(str, detailed);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        this.tester.log(str);
    }

    protected void logError(String str) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                ((NetStatusProtocolTesterListener)it.next()).logError(str);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        this.tester.log(str);
    }

    protected void logError(String str, Throwable e) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                ((NetStatusProtocolTesterListener)it.next()).logError(str, e);
            }
            catch (Throwable f) {
                Debug.printStackTrace(f);
            }
        }
        this.tester.log(str, e);
    }

    public class Session {
        private NetworkConnection connection;
        private int session_id;
        private boolean initiator;
        private byte[] info_hash;
        private boolean handshake_sent;
        private boolean handshake_received;
        private boolean bitfield_sent;
        private boolean bitfield_received;
        private int num_pieces;
        private boolean is_seed;
        private Set missing_pieces = new HashSet();
        private boolean connected;
        private boolean closing;
        private boolean closed;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Session(NetworkConnection _connection, byte[] _info_hash) {
            this.connection = _connection;
            this.info_hash = _info_hash;
            this.initiator = this.info_hash != null;
            List list = NetStatusProtocolTesterBT.this.sessions;
            synchronized (list) {
                NetStatusProtocolTesterBT netStatusProtocolTesterBT2 = NetStatusProtocolTesterBT.this;
                netStatusProtocolTesterBT2.session_id_next = netStatusProtocolTesterBT2.session_id_next + 1;
                this.session_id = NetStatusProtocolTesterBT.this.session_id_next;
                if (NetStatusProtocolTesterBT.this.destroyed) {
                    this.log("Already destroyed");
                    this.close();
                    return;
                }
                if (!NetStatusProtocolTesterBT.this.test_initiator && !this.initiator) {
                    int responder_sessions = 0;
                    int i = 0;
                    while (i < NetStatusProtocolTesterBT.this.sessions.size()) {
                        Session existing_session = (Session)NetStatusProtocolTesterBT.this.sessions.get(i);
                        if (!existing_session.isInitiator()) {
                            ++responder_sessions;
                        }
                        ++i;
                    }
                    if (responder_sessions >= 2) {
                        this.log("Too many responder sessions");
                        this.close();
                        return;
                    }
                }
                NetStatusProtocolTesterBT.this.sessions.add(this);
                this.is_seed = this.initiator && NetStatusProtocolTesterBT.this.sessions.size() % 2 == 0;
            }
            Iterator it = NetStatusProtocolTesterBT.this.listeners.iterator();
            while (it.hasNext()) {
                try {
                    ((NetStatusProtocolTesterListener)it.next()).sessionAdded(this);
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
            }
            this.connection.connect(3, new NetworkConnection.ConnectionListener(){
                final String type;
                {
                    this.type = Session.this.initiator ? "Outbound" : "Inbound";
                }

                @Override
                public int connectStarted(int default_connect_timeout) {
                    Session.this.log(String.valueOf(this.type) + " connect start", true);
                    return default_connect_timeout;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public final void connectSuccess(ByteBuffer remaining_initial_data) {
                    Session.this.log(String.valueOf(this.type) + " connect success, protocol=" + Session.this.connection.getTransport().getProtocol(), true);
                    Session.this.connected = true;
                    NetStatusProtocolTesterBT netStatusProtocolTesterBT = NetStatusProtocolTesterBT.this;
                    synchronized (netStatusProtocolTesterBT) {
                        if (Session.this.initiator) {
                            NetStatusProtocolTesterBT netStatusProtocolTesterBT2 = NetStatusProtocolTesterBT.this;
                            netStatusProtocolTesterBT2.outbound_connects = netStatusProtocolTesterBT2.outbound_connects + 1;
                        } else {
                            NetStatusProtocolTesterBT netStatusProtocolTesterBT3 = NetStatusProtocolTesterBT.this;
                            netStatusProtocolTesterBT3.inbound_connects = netStatusProtocolTesterBT3.inbound_connects + 1;
                        }
                    }
                    Session.this.connected();
                }

                @Override
                public final void connectFailure(Throwable e) {
                    if (!Session.this.closing) {
                        Session.this.logError(String.valueOf(this.type) + " connect failed: " + Debug.getNestedExceptionMessage(e));
                    }
                    Session.this.close();
                }

                @Override
                public final void exceptionThrown(Throwable e) {
                    if (!Session.this.closing) {
                        Session.this.logError(String.valueOf(this.type) + " connection failure", e);
                    }
                    Session.this.close();
                }

                @Override
                public Object getConnectionProperty(String property_name) {
                    if (property_name == "explicit_bind") {
                        return NetStatusProtocolTesterBT.this.explicit_bind;
                    }
                    return null;
                }

                @Override
                public String getDescription() {
                    return "NetStatusPlugin - " + this.type;
                }
            });
        }

        public boolean isInitiator() {
            return this.initiator;
        }

        public boolean isConnected() {
            return this.connected;
        }

        public boolean isSeed() {
            return this.is_seed;
        }

        public boolean isOK() {
            return this.bitfield_received;
        }

        protected void connected() {
            this.connection.getIncomingMessageQueue().registerQueueListener(new IncomingMessageQueue.MessageQueueListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public boolean messageReceived(Message message) {
                    try {
                        BTHave have;
                        String message_id = message.getID();
                        Session.this.log("Incoming message received: " + message.getID(), true);
                        if (message_id.equals("BT_HANDSHAKE")) {
                            Session.this.handshake_received = true;
                            BTHandshake handshake = (BTHandshake)message;
                            Session.this.info_hash = handshake.getDataHash();
                            Session.this.num_pieces = 500 + (Session.this.info_hash[0] & 0xFF);
                            if (Session.this.num_pieces % 8 == 0) {
                                Session session = Session.this;
                                session.num_pieces = session.num_pieces - 1;
                            }
                            if (!Session.this.is_seed) {
                                int missing = random.nextInt(Session.this.num_pieces / 2) + 5;
                                int i = 0;
                                while (i < missing) {
                                    Session.this.missing_pieces.add(new Integer(random.nextInt(Session.this.num_pieces)));
                                    ++i;
                                }
                            }
                            Session.this.sendHandshake();
                            Session.this.sendBitfield();
                            Session.this.connection.getIncomingMessageQueue().getDecoder().resumeDecoding();
                        } else if (message_id.equals("BT_BITFIELD")) {
                            Session.this.bitfield_received = true;
                            BTBitfield bitfield = (BTBitfield)message;
                            ByteBuffer bb = bitfield.getBitfield().getBuffer((byte)0);
                            byte[] contents = new byte[bb.remaining()];
                            bb.get(contents);
                        } else if (message_id.equals("BT_HAVE") && (have = (BTHave)message).getPieceNumber() == Session.this.num_pieces) {
                            List list = NetStatusProtocolTesterBT.this.sessions;
                            synchronized (list) {
                                Session.this.closing = true;
                            }
                            Session.this.close();
                        }
                        return true;
                    }
                    finally {
                        message.destroy();
                    }
                }

                @Override
                public final void protocolBytesReceived(int byte_count) {
                }

                @Override
                public final void dataBytesReceived(int byte_count) {
                }

                @Override
                public boolean isPriority() {
                    return true;
                }
            });
            this.connection.getOutgoingMessageQueue().registerQueueListener(new OutgoingMessageQueue.MessageQueueListener(){

                @Override
                public final boolean messageAdded(Message message) {
                    return true;
                }

                @Override
                public final void messageQueued(Message message) {
                }

                @Override
                public final void messageRemoved(Message message) {
                }

                @Override
                public final void messageSent(Message message) {
                    Session.this.log("Outgoing message sent: " + message.getID(), true);
                }

                @Override
                public final void protocolBytesSent(int byte_count) {
                }

                @Override
                public final void dataBytesSent(int byte_count) {
                }

                @Override
                public void flush() {
                }
            });
            this.connection.startMessageProcessing();
            if (this.initiator) {
                this.sendHandshake();
            }
        }

        protected void sendHandshake() {
            if (!this.handshake_sent) {
                this.handshake_sent = true;
                this.connection.getOutgoingMessageQueue().addMessage(new BTHandshake(this.info_hash, NetStatusProtocolTesterBT.this.peer_id, 0, 1), false);
            }
        }

        protected void sendHave(int piece_number) {
            BTHave message = new BTHave(piece_number, 1);
            OutgoingMessageQueue out_q = this.connection.getOutgoingMessageQueue();
            out_q.addMessage(message, false);
            out_q.flush();
        }

        protected void sendBitfield() {
            if (!this.bitfield_sent) {
                this.bitfield_sent = true;
                byte[] bits = new byte[(this.num_pieces + 7) / 8];
                int pos = 0;
                int i = 0;
                int bToSend = 0;
                while (i < this.num_pieces) {
                    boolean has_piece;
                    if (i % 8 == 0) {
                        bToSend = 0;
                    }
                    bToSend <<= 1;
                    boolean bl = has_piece = !this.missing_pieces.contains(new Integer(i));
                    if (has_piece) {
                        ++bToSend;
                    }
                    if (i % 8 == 7) {
                        bits[pos++] = (byte)bToSend;
                    }
                    ++i;
                }
                if (i % 8 != 0) {
                    bits[pos++] = (byte)(bToSend <<= 8 - i % 8);
                }
                DirectByteBuffer buffer = new DirectByteBuffer(ByteBuffer.wrap(bits));
                this.connection.getOutgoingMessageQueue().addMessage(new BTBitfield(buffer, 1), false);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected void close() {
            List list = NetStatusProtocolTesterBT.this.sessions;
            synchronized (list) {
                NetStatusProtocolTesterBT.this.sessions.remove(this);
                if (!this.closing) {
                    this.closing = true;
                } else {
                    this.closed = true;
                }
            }
            if (this.closed) {
                this.log("Closing connection", true);
                this.connection.close(null);
            } else {
                this.sendHave(this.num_pieces);
                new DelayedEvent("NetStatus:delayClose", 5000L, new AERunnable(){

                    @Override
                    public void runSupport() {
                        if (!Session.this.closed) {
                            Session.this.close();
                        }
                    }
                });
            }
            NetStatusProtocolTesterBT.this.checkCompletion();
        }

        public String getProtocolString() {
            String str = "";
            if (this.connected) {
                str = "connected";
                str = String.valueOf(str) + this.addSent("hand", this.handshake_sent);
                str = String.valueOf(str) + this.addRecv("hand", this.handshake_received);
                str = String.valueOf(str) + this.addSent("bitf", this.bitfield_sent);
                str = String.valueOf(str) + this.addRecv("bitf", this.bitfield_received);
            } else {
                str = "not connected";
            }
            return str;
        }

        protected String addSent(String str, boolean ok) {
            if (ok) {
                return ", " + str + " sent";
            }
            return ", " + str + " !sent";
        }

        protected String addRecv(String str, boolean ok) {
            if (ok) {
                return ", " + str + " recv";
            }
            return ", " + str + " !recv";
        }

        protected String getLogPrefix() {
            return "(" + (this.initiator ? "L" : "R") + (this.is_seed ? "S" : "L") + " " + this.session_id + ") ";
        }

        protected void log(String str) {
            NetStatusProtocolTesterBT.this.log(String.valueOf(this.getLogPrefix()) + str);
        }

        protected void log(String str, boolean is_detailed) {
            NetStatusProtocolTesterBT.this.log(String.valueOf(this.getLogPrefix()) + str, is_detailed);
        }

        protected void logError(String str) {
            NetStatusProtocolTesterBT.this.logError(String.valueOf(this.getLogPrefix()) + str);
        }

        protected void logError(String str, Throwable e) {
            NetStatusProtocolTesterBT.this.logError(String.valueOf(this.getLogPrefix()) + str, e);
        }
    }
}

