/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.net.buddy;

import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.pif.peers.Peer;
import com.biglybt.plugin.net.buddy.tracker.BuddyPluginTracker;

public class PartialBuddy {
    private final BuddyPluginTracker tracker;
    private final String ip;
    private final int tcp_port;
    private final int udp_port;
    private final String key;
    private final String name;

    public static String getPartialBuddyKey(Peer peer) {
        String ip = peer.getIp();
        if (AENetworkClassifier.categoriseAddress(ip) == "Public") {
            return String.valueOf(ip) + "/" + peer.getTCPListenPort() + "/" + peer.getUDPListenPort();
        }
        return ip;
    }

    public PartialBuddy(BuddyPluginTracker _tracker, Peer peer) {
        this.tracker = _tracker;
        this.ip = peer.getIp();
        this.tcp_port = peer.getTCPListenPort();
        this.udp_port = peer.getUDPListenPort();
        String n = this.ip;
        if (AENetworkClassifier.categoriseAddress(this.ip) == "Public") {
            this.key = String.valueOf(this.ip) + "/" + this.tcp_port + "/" + this.udp_port;
            if (n.contains(":")) {
                n = "[" + this.ip + "]";
            }
            if (this.tcp_port == 0) {
                if (this.udp_port != 0) {
                    n = String.valueOf(n) + ":0/" + this.udp_port;
                }
            } else {
                n = String.valueOf(n) + ":" + this.tcp_port;
                if (this.tcp_port != this.udp_port) {
                    n = String.valueOf(n) + "/" + this.udp_port;
                }
            }
        } else {
            this.key = this.ip;
        }
        this.name = n;
    }

    public String getIP() {
        return this.ip;
    }

    public String getDownloadsSummary() {
        return this.tracker.getDownloadsSummary(this);
    }

    public void remove() {
        this.tracker.removePartialBuddy(this);
    }

    public String getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.key;
    }
}

