/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.net.buddy;

import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SystemTime;
import com.biglybt.plugin.net.buddy.BuddyPlugin;
import com.biglybt.plugin.net.buddy.BuddyPluginBuddy;
import com.biglybt.plugin.net.buddy.BuddyPluginBuddyMessage;
import com.biglybt.plugin.net.buddy.BuddyPluginBuddyMessageListener;
import com.biglybt.plugin.net.buddy.BuddyPluginBuddyReplyListener;
import com.biglybt.plugin.net.buddy.BuddyPluginException;
import com.biglybt.plugin.net.buddy.BuddyPluginPasswordException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BuddyPluginBuddyMessageHandler {
    private BuddyPluginBuddy buddy;
    private File store;
    private Map config_map;
    private int message_count;
    private int pending_deletes;
    private int next_message_id;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private BuddyPluginBuddyMessage active_message;
    private long last_failure;
    private long last_pending_success;

    protected BuddyPluginBuddyMessageHandler(BuddyPluginBuddy _buddy, File _store) {
        this.buddy = _buddy;
        this.store = _store;
        this.loadConfig();
        if (this.message_count > 0) {
            this.buddy.persistentDispatchPending();
        }
    }

    public BuddyPluginBuddy getBuddy() {
        return this.buddy;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuddyPluginBuddyMessage queueMessage(int subsystem, Map content, int timeout_millis) throws BuddyPluginException {
        boolean dispatch_pending;
        BuddyPluginBuddyMessage message;
        BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
        synchronized (buddyPluginBuddyMessageHandler) {
            int id = this.next_message_id++;
            message = new BuddyPluginBuddyMessage(this, id, subsystem, content, timeout_millis, SystemTime.getCurrentTime());
            this.storeMessage(message);
            dispatch_pending = this.message_count == 1;
        }
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                ((BuddyPluginBuddyMessageListener)it.next()).messageQueued(message);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        if (dispatch_pending) {
            this.buddy.persistentDispatchPending();
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPersistentDispatch() {
        boolean request_dispatch = false;
        BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
        synchronized (buddyPluginBuddyMessageHandler) {
            long now = SystemTime.getCurrentTime();
            if (now < this.last_failure) {
                this.last_failure = now;
            }
            if (now < this.last_pending_success) {
                this.last_pending_success = now;
            }
            if (this.last_pending_success > 0L && now - this.last_pending_success >= 300000L) {
                request_dispatch = true;
            } else if (this.active_message == null && this.message_count != 0 && this.last_failure != 0L) {
                request_dispatch = now - this.last_failure >= 300000L;
            }
        }
        if (request_dispatch) {
            this.buddy.persistentDispatchPending();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void persistentDispatch() {
        this.checkPendingSuccess();
        BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
        synchronized (buddyPluginBuddyMessageHandler) {
            if (this.active_message != null || this.message_count == 0) {
                return;
            }
            List messages = (List)this.config_map.get("messages");
            Map map = (Map)messages.get(0);
            try {
                this.active_message = this.restoreMessage(map);
            }
            catch (Throwable e) {
                Debug.out("Failed to restore message, deleting it", e);
                messages.remove(0);
                try {
                    this.saveConfig();
                }
                catch (Throwable f) {
                    this.buddy.log("Config save failed during delete of bad message", f);
                }
            }
        }
        boolean request_ok = false;
        try {
            Map request2 = this.active_message.getRequest();
            request_ok = true;
            this.buddy.sendMessage(this.active_message.getSubsystem(), request2, this.active_message.getTimeout(), new BuddyPluginBuddyReplyListener(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 * Unable to fully structure code
                 */
                @Override
                public void replyReceived(BuddyPluginBuddy from_buddy, Map reply) {
                    message = BuddyPluginBuddyMessageHandler.access$0(BuddyPluginBuddyMessageHandler.this);
                    it = BuddyPluginBuddyMessageHandler.access$1(BuddyPluginBuddyMessageHandler.this).iterator();
                    processing_ok = true;
                    try {
                        var6_6 = BuddyPluginBuddyMessageHandler.this;
                        synchronized (var6_6) {
                            v0 = BuddyPluginBuddyMessageHandler.this;
                            BuddyPluginBuddyMessageHandler.access$3(v0, BuddyPluginBuddyMessageHandler.access$2(v0) + 1);
                            // MONITOREXIT @DISABLED, blocks:[0, 1, 8] lbl10 : MonitorExitStatement: MONITOREXIT : var6_6
                            if (true) ** GOTO lbl21
                        }
                        do {
                            try {
                                if (((BuddyPluginBuddyMessageListener)it.next()).deliverySucceeded(message, reply)) continue;
                                processing_ok = false;
                            }
                            catch (Throwable e) {
                                Debug.printStackTrace(e);
                            }
lbl21:
                            // 4 sources

                        } while (it.hasNext());
                    }
                    catch (Throwable var7_9) {
                        var8_12 = BuddyPluginBuddyMessageHandler.this;
                        synchronized (var8_12) {
                            v2 = BuddyPluginBuddyMessageHandler.this;
                            BuddyPluginBuddyMessageHandler.access$3(v2, BuddyPluginBuddyMessageHandler.access$2(v2) - 1);
                        }
                        throw var7_9;
                    }
                    var8_13 = BuddyPluginBuddyMessageHandler.this;
                    synchronized (var8_13) {
                        v4 = BuddyPluginBuddyMessageHandler.this;
                        BuddyPluginBuddyMessageHandler.access$3(v4, BuddyPluginBuddyMessageHandler.access$2(v4) - 1);
                    }
                    if (processing_ok) {
                        message.delete();
                    } else {
                        e = BuddyPluginBuddyMessageHandler.this;
                        synchronized (e) {
                            found = false;
                            messages = (List)BuddyPluginBuddyMessageHandler.access$4(BuddyPluginBuddyMessageHandler.this).get("messages");
                            if (messages != null) {
                                i = 0;
                                while (i < messages.size()) {
                                    msg = (Map)messages.get(i);
                                    if (message.getID() == ((Long)msg.get("id")).intValue()) {
                                        found = true;
                                        messages.remove(i);
                                        try {
                                            BuddyPluginBuddyMessageHandler.this.writeReply(message, reply);
                                            pending_success = (ArrayList<Map>)BuddyPluginBuddyMessageHandler.access$4(BuddyPluginBuddyMessageHandler.this).get("pending_success");
                                            if (pending_success == null) {
                                                pending_success = new ArrayList<Map>();
                                                BuddyPluginBuddyMessageHandler.access$4(BuddyPluginBuddyMessageHandler.this).put("pending_success", pending_success);
                                            }
                                            pending_success.add(msg);
                                            BuddyPluginBuddyMessageHandler.access$5(BuddyPluginBuddyMessageHandler.this, SystemTime.getCurrentTime());
                                            BuddyPluginBuddyMessageHandler.access$6(BuddyPluginBuddyMessageHandler.this).log("Message moved to pending success queue after listener failed");
                                            BuddyPluginBuddyMessageHandler.this.saveConfig();
                                        }
                                        catch (Throwable e) {
                                            BuddyPluginBuddyMessageHandler.access$6(BuddyPluginBuddyMessageHandler.this).log("Config save failed during message pending queueing", e);
                                        }
                                        break;
                                    }
                                    ++i;
                                }
                            }
                            if (!found) {
                                BuddyPluginBuddyMessageHandler.access$6(BuddyPluginBuddyMessageHandler.this).log("Failed to find message " + message.getID());
                            }
                        }
                    }
                    var7_11 = BuddyPluginBuddyMessageHandler.this;
                    synchronized (var7_11) {
                        BuddyPluginBuddyMessageHandler.access$7(BuddyPluginBuddyMessageHandler.this, null);
                        messages_queued = BuddyPluginBuddyMessageHandler.access$8(BuddyPluginBuddyMessageHandler.this) > 0;
                        BuddyPluginBuddyMessageHandler.access$9(BuddyPluginBuddyMessageHandler.this, 0L);
                    }
                    if (messages_queued) {
                        BuddyPluginBuddyMessageHandler.access$6(BuddyPluginBuddyMessageHandler.this).persistentDispatchPending();
                    }
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void sendFailed(BuddyPluginBuddy to_buddy, BuddyPluginException cause) {
                    BuddyPluginBuddyMessage message = BuddyPluginBuddyMessageHandler.this.active_message;
                    BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = BuddyPluginBuddyMessageHandler.this;
                    synchronized (buddyPluginBuddyMessageHandler) {
                        BuddyPluginBuddyMessageHandler.this.active_message = null;
                        BuddyPluginBuddyMessageHandler.this.last_failure = SystemTime.getCurrentTime();
                    }
                    BuddyPluginBuddyMessageHandler.this.reportFailed(message, cause, true);
                }
            });
        }
        catch (Throwable cause) {
            BuddyPluginBuddyMessage message = this.active_message;
            BuddyPluginBuddyMessageHandler e = this;
            synchronized (e) {
                this.active_message = null;
                this.last_failure = SystemTime.getCurrentTime();
            }
            boolean do_subsequent = true;
            if (!request_ok && !(cause instanceof BuddyPluginPasswordException)) {
                this.buddy.logMessage("Message request unavailable, deleting message");
                message.delete();
                boolean messages_queued = false;
                BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler2 = this;
                synchronized (buddyPluginBuddyMessageHandler2) {
                    this.last_failure = 0L;
                    messages_queued = this.message_count > 0;
                }
                if (messages_queued) {
                    do_subsequent = false;
                    this.buddy.persistentDispatchPending();
                }
            }
            this.reportFailed(message, cause, do_subsequent);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reportFailed(BuddyPluginBuddyMessage message, Throwable cause, boolean do_subsequent) {
        BuddyPluginException b_cause = cause instanceof BuddyPluginException ? (BuddyPluginException)cause : new BuddyPluginException("Failed to send message", cause);
        this.reportFailedSupport(message, b_cause);
        if (do_subsequent) {
            ArrayList<BuddyPluginBuddyMessage> other_messages = new ArrayList<BuddyPluginBuddyMessage>();
            BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
            synchronized (buddyPluginBuddyMessageHandler) {
                List messages = (List)this.config_map.get("messages");
                int i = 0;
                while (i < messages.size()) {
                    try {
                        BuddyPluginBuddyMessage msg = this.restoreMessage((Map)messages.get(i));
                        if (msg.getID() != message.getID()) {
                            other_messages.add(msg);
                        }
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            if (other_messages.size() > 0) {
                BuddyPluginException o_cause = new BuddyPluginException("Reporting probable failure to subsequent messages");
                int i = 0;
                while (i < other_messages.size()) {
                    this.reportFailedSupport((BuddyPluginBuddyMessage)other_messages.get(i), o_cause);
                    ++i;
                }
            }
        }
    }

    protected void reportFailedSupport(BuddyPluginBuddyMessage message, BuddyPluginException cause) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                ((BuddyPluginBuddyMessageListener)it.next()).deliveryFailed(message, cause);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkPendingSuccess() {
        ArrayList<BuddyPluginBuddyMessage> pending_messages = new ArrayList<BuddyPluginBuddyMessage>();
        boolean save_pending = false;
        BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
        synchronized (buddyPluginBuddyMessageHandler) {
            this.last_pending_success = 0L;
            List pending_success = (List)this.config_map.get("pending_success");
            if (pending_success == null || pending_success.size() == 0) {
                return;
            }
            Iterator it = pending_success.iterator();
            while (it.hasNext()) {
                Map map = (Map)it.next();
                try {
                    pending_messages.add(this.restoreMessage(map));
                }
                catch (Throwable e) {
                    this.buddy.log("Failed to restore message from pending success queue", e);
                    it.remove();
                    save_pending = true;
                }
            }
        }
        int i = 0;
        while (i < pending_messages.size()) {
            block21: {
                BuddyPluginBuddyMessage message = (BuddyPluginBuddyMessage)pending_messages.get(i);
                try {
                    Map reply = message.getReply();
                    Iterator it = this.listeners.iterator();
                    boolean processing_ok = true;
                    while (it.hasNext()) {
                        try {
                            if (((BuddyPluginBuddyMessageListener)it.next()).deliverySucceeded(message, reply)) continue;
                            processing_ok = false;
                        }
                        catch (Throwable e) {
                            Debug.printStackTrace(e);
                        }
                    }
                    if (processing_ok) {
                        message.delete();
                        break block21;
                    }
                    BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler2 = this;
                    synchronized (buddyPluginBuddyMessageHandler2) {
                        this.last_pending_success = SystemTime.getCurrentTime();
                    }
                }
                catch (BuddyPluginPasswordException e) {
                    this.buddy.log("Failed to restore message reply", e);
                }
                catch (Throwable e) {
                    this.buddy.log("Failed to restore message reply - deleting message", e);
                    message.delete();
                }
            }
            ++i;
        }
        if (save_pending) {
            try {
                this.saveConfig();
            }
            catch (Throwable e) {
                this.buddy.log("Save failed during pending success processing", e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getMessageCount() {
        BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
        synchronized (buddyPluginBuddyMessageHandler) {
            return this.message_count - this.pending_deletes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void deleteMessage(BuddyPluginBuddyMessage message) {
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            try {
                ((BuddyPluginBuddyMessageListener)it.next()).messageDeleted(message);
            }
            catch (Throwable e) {
                Debug.printStackTrace(e);
            }
        }
        BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
        synchronized (buddyPluginBuddyMessageHandler) {
            String[] keys = new String[]{"messages", "pending_success", "explicit"};
            int i = 0;
            while (i < keys.length) {
                List messages = (List)this.config_map.get(keys[i]);
                if (messages != null) {
                    boolean found = false;
                    int j = 0;
                    while (j < messages.size()) {
                        Map msg = (Map)messages.get(j);
                        if (message.getID() == ((Long)msg.get("id")).intValue()) {
                            messages.remove(j);
                            found = true;
                            break;
                        }
                        ++j;
                    }
                    if (found) {
                        this.deleteRequest(message);
                        this.deleteReply(message);
                        try {
                            this.saveConfig();
                        }
                        catch (Throwable e) {
                            this.buddy.log("Config save failed during message delete", e);
                        }
                        return;
                    }
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void destroy() {
        BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
        synchronized (buddyPluginBuddyMessageHandler) {
            this.config_map.clear();
            try {
                this.saveConfig();
            }
            catch (Throwable e) {
                this.buddy.log("Config save failed during destroy", e);
            }
        }
    }

    protected void writeRequest(BuddyPluginBuddyMessage message, Map content) throws BuddyPluginException {
        this.writeContent(String.valueOf(message.getID()) + ".req.dat", content);
    }

    protected Map readRequest(BuddyPluginBuddyMessage message) throws BuddyPluginException {
        return this.readContent(String.valueOf(message.getID()) + ".req.dat");
    }

    protected void writeReply(BuddyPluginBuddyMessage message, Map content) throws BuddyPluginException {
        this.writeContent(String.valueOf(message.getID()) + ".rep.dat", content);
    }

    protected Map readReply(BuddyPluginBuddyMessage message) throws BuddyPluginException {
        return this.readContent(String.valueOf(message.getID()) + ".rep.dat");
    }

    protected void writeContent(String target_str, Map content) throws BuddyPluginException {
        if (!this.store.exists() && !this.store.mkdirs()) {
            throw new BuddyPluginException("Failed to create " + this.store);
        }
        File target = FileUtil.newFile(this.store, target_str);
        try {
            BuddyPlugin.CryptoResult result = this.buddy.encrypt(BEncoder.encode(content));
            HashMap<String, Object> store_map = new HashMap<String, Object>();
            store_map.put("pk", this.buddy.getPlugin().getPublicKey());
            store_map.put("data", result.getPayload());
            if (!this.buddy.writeConfigFile(target, store_map)) {
                throw new BuddyPluginException("failed to write " + target);
            }
        }
        catch (BuddyPluginException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new BuddyPluginException("Failed to write message", e);
        }
    }

    protected Map readContent(String target_str) throws BuddyPluginException {
        File target = FileUtil.newFile(this.store, target_str);
        if (!target.exists()) {
            throw new BuddyPluginException("Failed to read persisted message - " + target + " doesn't exist");
        }
        Map map = this.buddy.readConfigFile(target);
        if (map.size() == 0) {
            throw new BuddyPluginException("Failed to read persisted message file " + target);
        }
        try {
            String pk = new String((byte[])map.get("pk"));
            if (!pk.equals(this.buddy.getPlugin().getPublicKey())) {
                throw new BuddyPluginException("Can't decrypt message as key changed");
            }
            byte[] data = (byte[])map.get("data");
            return BDecoder.decode(this.buddy.decrypt(data).getPayload());
        }
        catch (BuddyPluginException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new BuddyPluginException("Failed to read message", e);
        }
    }

    protected void deleteRequest(BuddyPluginBuddyMessage message) {
        this.deleteRequest(message.getID());
    }

    protected void deleteRequest(int id) {
        File target = FileUtil.newFile(this.store, String.valueOf(id) + ".req.dat");
        if (target.exists() && !target.delete()) {
            Debug.out("Failed to delete " + target);
        }
    }

    protected void deleteReply(BuddyPluginBuddyMessage message) {
        this.deleteReply(message.getID());
    }

    protected void deleteReply(int id) {
        File target = FileUtil.newFile(this.store, String.valueOf(id) + ".rep.dat");
        if (target.exists() && !target.delete()) {
            Debug.out("Failed to delete " + target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BuddyPluginBuddyMessage storeExplicitMessage(int type, Map msg) {
        BuddyPluginBuddyMessage message;
        BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
        synchronized (buddyPluginBuddyMessageHandler) {
            int id = this.next_message_id++;
            try {
                message = new BuddyPluginBuddyMessage(this, id, 1024 + type, msg, 0, SystemTime.getCurrentTime());
                this.storeExplicitMessage(message);
            }
            catch (Throwable e) {
                this.buddy.log("Failed to store explicit message", e);
                return null;
            }
        }
        return message;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<BuddyPluginBuddyMessage> retrieveExplicitMessages(int type) {
        ArrayList<BuddyPluginBuddyMessage> result = new ArrayList<BuddyPluginBuddyMessage>();
        BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
        synchronized (buddyPluginBuddyMessageHandler) {
            List messages = (List)this.config_map.get("explicit");
            if (messages != null) {
                int i = 0;
                while (i < messages.size()) {
                    try {
                        BuddyPluginBuddyMessage msg = this.restoreMessage((Map)messages.get(i));
                        if (msg.getSubsystem() == 1024 + type) {
                            result.add(msg);
                        }
                    }
                    catch (Throwable e) {
                        this.buddy.log("Failed to restore message", e);
                    }
                    ++i;
                }
            }
        }
        return result;
    }

    protected void storeExplicitMessage(BuddyPluginBuddyMessage msg) throws BuddyPluginException {
        this.storeMessageSupport(msg, "explicit");
    }

    protected void storeMessage(BuddyPluginBuddyMessage msg) throws BuddyPluginException {
        this.storeMessageSupport(msg, "messages");
    }

    protected void storeMessageSupport(BuddyPluginBuddyMessage msg, String key) throws BuddyPluginException {
        ArrayList messages = (ArrayList)this.config_map.get(key);
        if (messages == null) {
            messages = new ArrayList();
            this.config_map.put(key, messages);
        }
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("id", new Long(msg.getID()));
        map.put("ss", new Long(msg.getSubsystem()));
        map.put("to", new Long(msg.getTimeout()));
        map.put("cr", new Long(msg.getCreateTime()));
        messages.add(map);
        this.saveConfig();
    }

    protected BuddyPluginBuddyMessage restoreMessage(Map map) throws BuddyPluginException {
        int id = ((Long)map.get("id")).intValue();
        int ss = ((Long)map.get("ss")).intValue();
        int to = ((Long)map.get("to")).intValue();
        long cr = (Long)map.get("cr");
        return new BuddyPluginBuddyMessage(this, id, ss, null, to, cr);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadConfig() {
        int exp_count;
        List explicit;
        int ps_count;
        List pending_success;
        File config_file = FileUtil.newFile(this.store, "messages.dat");
        this.config_map = config_file.exists() ? this.buddy.readConfigFile(config_file) : new HashMap();
        List messages = (List)this.config_map.get("messages");
        if (messages != null) {
            this.message_count = messages.size();
            if (this.message_count > 0) {
                Map last_msg = (Map)messages.get(this.message_count - 1);
                this.next_message_id = ((Long)last_msg.get("id")).intValue() + 1;
            }
        }
        if ((pending_success = (List)this.config_map.get("pending_success")) != null && (ps_count = pending_success.size()) > 0) {
            Map last_msg = (Map)pending_success.get(ps_count - 1);
            this.next_message_id = Math.max(this.next_message_id, ((Long)last_msg.get("id")).intValue() + 1);
            BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler = this;
            synchronized (buddyPluginBuddyMessageHandler) {
                this.last_pending_success = SystemTime.getCurrentTime();
            }
        }
        if ((explicit = (List)this.config_map.get("explicit")) != null && (exp_count = explicit.size()) > 0) {
            Map last_msg = (Map)explicit.get(exp_count - 1);
            this.next_message_id = Math.max(this.next_message_id, ((Long)last_msg.get("id")).intValue() + 1);
        }
    }

    protected void saveConfig() throws BuddyPluginException {
        File config_file = FileUtil.newFile(this.store, "messages.dat");
        List messages = (List)this.config_map.get("messages");
        List pending = (List)this.config_map.get("pending_success");
        List explicit = (List)this.config_map.get("explicit");
        if (!(messages != null && messages.size() != 0 || pending != null && pending.size() != 0 || explicit != null && explicit.size() != 0)) {
            if (this.store.exists()) {
                File[] files = this.store.listFiles();
                int i = 0;
                while (i < files.length) {
                    files[i].delete();
                    ++i;
                }
                this.store.delete();
            }
            this.message_count = 0;
            this.next_message_id = 0;
        } else {
            if (!this.store.exists() && !this.store.mkdirs()) {
                throw new BuddyPluginException("Failed to create " + this.store);
            }
            if (!this.buddy.writeConfigFile(config_file, this.config_map)) {
                throw new BuddyPluginException("Failed to write" + config_file);
            }
            this.message_count = messages == null ? 0 : messages.size();
        }
    }

    public void addListener(BuddyPluginBuddyMessageListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(BuddyPluginBuddyMessageListener listener) {
        this.listeners.remove(listener);
    }

    static /* synthetic */ CopyOnWriteList access$1(BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler) {
        return buddyPluginBuddyMessageHandler.listeners;
    }

    static /* synthetic */ int access$2(BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler) {
        return buddyPluginBuddyMessageHandler.pending_deletes;
    }

    static /* synthetic */ void access$3(BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler, int n) {
        buddyPluginBuddyMessageHandler.pending_deletes = n;
    }

    static /* synthetic */ Map access$4(BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler) {
        return buddyPluginBuddyMessageHandler.config_map;
    }

    static /* synthetic */ void access$5(BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler, long l) {
        buddyPluginBuddyMessageHandler.last_pending_success = l;
    }

    static /* synthetic */ BuddyPluginBuddy access$6(BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler) {
        return buddyPluginBuddyMessageHandler.buddy;
    }

    static /* synthetic */ int access$8(BuddyPluginBuddyMessageHandler buddyPluginBuddyMessageHandler) {
        return buddyPluginBuddyMessageHandler.message_count;
    }
}

