/*
 * Decompiled with CFR 0.152.
 */
package com.biglybt.plugin.magnet;

import com.biglybt.core.config.COConfigurationManager;
import com.biglybt.core.config.ParameterListener;
import com.biglybt.core.download.DownloadManager;
import com.biglybt.core.networkmanager.admin.NetworkAdmin;
import com.biglybt.core.networkmanager.impl.tcp.TCPNetworkManager;
import com.biglybt.core.peer.PEPeer;
import com.biglybt.core.peer.PEPeerManager;
import com.biglybt.core.tag.Tag;
import com.biglybt.core.tag.TagManager;
import com.biglybt.core.tag.TagManagerFactory;
import com.biglybt.core.tag.Taggable;
import com.biglybt.core.torrent.TOTorrent;
import com.biglybt.core.torrent.TOTorrentAnnounceURLGroup;
import com.biglybt.core.torrent.TOTorrentAnnounceURLSet;
import com.biglybt.core.torrent.TOTorrentException;
import com.biglybt.core.torrent.TOTorrentFactory;
import com.biglybt.core.torrent.impl.TorrentOpenOptions;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerFactory;
import com.biglybt.core.tracker.client.TRTrackerAnnouncerResponsePeer;
import com.biglybt.core.util.AENetworkClassifier;
import com.biglybt.core.util.AERunnable;
import com.biglybt.core.util.AESemaphore;
import com.biglybt.core.util.AETemporaryFileHandler;
import com.biglybt.core.util.AEThread2;
import com.biglybt.core.util.BDecoder;
import com.biglybt.core.util.BEncoder;
import com.biglybt.core.util.Base32;
import com.biglybt.core.util.ByteArrayHashMap;
import com.biglybt.core.util.ByteFormatter;
import com.biglybt.core.util.Constants;
import com.biglybt.core.util.CopyOnWriteList;
import com.biglybt.core.util.Debug;
import com.biglybt.core.util.FileUtil;
import com.biglybt.core.util.SystemTime;
import com.biglybt.core.util.ThreadPool;
import com.biglybt.core.util.TorrentUtils;
import com.biglybt.core.util.UrlUtils;
import com.biglybt.net.magneturi.MagnetURIHandler;
import com.biglybt.net.magneturi.MagnetURIHandlerException;
import com.biglybt.net.magneturi.MagnetURIHandlerListener;
import com.biglybt.net.magneturi.MagnetURIHandlerProgressListener;
import com.biglybt.pif.Plugin;
import com.biglybt.pif.PluginInterface;
import com.biglybt.pif.PluginListener;
import com.biglybt.pif.ddb.DistributedDatabase;
import com.biglybt.pif.download.Download;
import com.biglybt.pif.download.DownloadException;
import com.biglybt.pif.sharing.ShareException;
import com.biglybt.pif.sharing.ShareResource;
import com.biglybt.pif.sharing.ShareResourceDir;
import com.biglybt.pif.sharing.ShareResourceFile;
import com.biglybt.pif.torrent.Torrent;
import com.biglybt.pif.torrent.TorrentAttribute;
import com.biglybt.pif.ui.UIInstance;
import com.biglybt.pif.ui.UIManagerListener;
import com.biglybt.pif.ui.config.BooleanParameter;
import com.biglybt.pif.ui.config.IntParameter;
import com.biglybt.pif.ui.config.Parameter;
import com.biglybt.pif.ui.config.StringListParameter;
import com.biglybt.pif.ui.config.StringParameter;
import com.biglybt.pif.ui.menus.MenuItem;
import com.biglybt.pif.ui.menus.MenuItemListener;
import com.biglybt.pif.ui.model.BasicPluginConfigModel;
import com.biglybt.pif.ui.tables.TableContextMenuItem;
import com.biglybt.pif.ui.tables.TableManager;
import com.biglybt.pif.ui.tables.TableRow;
import com.biglybt.pif.utils.LocaleListener;
import com.biglybt.pif.utils.LocaleUtilities;
import com.biglybt.pifimpl.local.PluginCoreUtils;
import com.biglybt.plugin.magnet.MagnetPluginListener;
import com.biglybt.plugin.magnet.MagnetPluginMDDownloader;
import com.biglybt.plugin.magnet.MagnetPluginProgressListener;
import com.biglybt.ui.UIFunctions;
import com.biglybt.ui.UIFunctionsManager;
import com.biglybt.util.MapUtils;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;

public class MagnetPlugin
implements Plugin {
    public static final int FL_NONE = 0;
    public static final int FL_DISABLE_MD_LOOKUP = 1;
    public static final int FL_NO_MD_LOOKUP_DELAY = 2;
    public static final int FL_RECOVERING = 4;
    private static final int MD_LOOKUP_DELAY_SECS_DEFAULT = 0;
    private static final String[] MD_EXTRA_TRACKERS = new String[]{"udp://tracker.opentrackr.org:1337/announce"};
    private static final String PLUGIN_NAME = "Magnet URI Handler";
    private static final String PLUGIN_CONFIGSECTION_ID = "plugins.magnetplugin";
    public static final String[] SOURCE_VALUES = new String[]{"0", "1", "2"};
    public static final String[] SOURCE_KEYS = new String[]{"never", "shares", "always"};
    public static final String[] SOURCE_STRINGS = new String[SOURCE_KEYS.length];
    protected static final Object DM_TAG_CACHE = new Object();
    protected static final Object DM_CATEGORY_CACHE = new Object();
    protected static final Object DM_DN_CHANGED = new Object();
    private static DistributedDatabase[] db_holder = new DistributedDatabase[1];
    private static AESemaphore db_waiter = new AESemaphore("Grab DDB");
    private PluginInterface plugin_interface;
    private CopyOnWriteList listeners = new CopyOnWriteList();
    private boolean first_download = true;
    private static final int PLUGIN_DOWNLOAD_TIMEOUT_SECS_DEFAULT = 0;
    private BooleanParameter md_lookup;
    private IntParameter md_lookup_delay;
    private StringParameter md_extra_trackers;
    private IntParameter timeout_param;
    private StringListParameter sources_param;
    private IntParameter sources_extra_param;
    private BooleanParameter magnet_recovery;
    private IntParameter magnet_recovery_concurrency;
    private Map<String, BooleanParameter> net_params = new HashMap<String, BooleanParameter>();
    private static ByteArrayHashMap<DownloadActivity> download_activities = new ByteArrayHashMap();

    public static void load(PluginInterface plugin_interface) {
        plugin_interface.getPluginProperties().setProperty("plugin.version", "1.0");
        plugin_interface.getPluginProperties().setProperty("plugin.name", PLUGIN_NAME);
    }

    @Override
    public void initialize(PluginInterface _plugin_interface) {
        Download[] downloads;
        this.plugin_interface = _plugin_interface;
        MagnetURIHandler uri_handler = MagnetURIHandler.getSingleton();
        final LocaleUtilities lu = this.plugin_interface.getUtilities().getLocaleUtilities();
        lu.addListener(new LocaleListener(){

            @Override
            public void localeChanged(Locale l) {
                MagnetPlugin.this.updateLocale(lu);
            }
        });
        this.updateLocale(lu);
        BasicPluginConfigModel config = this.plugin_interface.getUIManager().createBasicPluginConfigModel("plugins", PLUGIN_CONFIGSECTION_ID);
        config.addInfoParameter2("MagnetPlugin.current.port", String.valueOf(uri_handler.getPort()));
        this.md_lookup = config.addBooleanParameter2("MagnetPlugin.use.md.download", "MagnetPlugin.use.md.download", true);
        this.md_lookup_delay = config.addIntParameter2("MagnetPlugin.use.md.download.delay", "MagnetPlugin.use.md.download.delay", 0);
        String et_default = "";
        String[] stringArray = MD_EXTRA_TRACKERS;
        int n = MD_EXTRA_TRACKERS.length;
        int n2 = 0;
        while (n2 < n) {
            String etd = stringArray[n2];
            et_default = String.valueOf(et_default) + (et_default.isEmpty() ? "" : "\n") + etd;
            ++n2;
        }
        this.md_extra_trackers = config.addStringParameter2("MagnetPlugin.md.extra.trackers", "MagnetPlugin.md.extra.trackers", et_default);
        this.md_extra_trackers.setMultiLine(3);
        this.md_lookup.addEnabledOnSelection((Parameter)this.md_lookup_delay);
        this.md_lookup.addEnabledOnSelection((Parameter)this.md_extra_trackers);
        this.timeout_param = config.addIntParameter2("MagnetPlugin.timeout.secs", "MagnetPlugin.timeout.secs", 0);
        this.sources_param = config.addStringListParameter2("MagnetPlugin.add.sources", "MagnetPlugin.add.sources", SOURCE_VALUES, SOURCE_STRINGS, SOURCE_VALUES[1]);
        this.sources_extra_param = config.addIntParameter2("MagnetPlugin.add.sources.extra", "MagnetPlugin.add.sources.extra", 0);
        this.magnet_recovery = config.addBooleanParameter2("MagnetPlugin.recover.magnets", "MagnetPlugin.recover.magnets", true);
        this.magnet_recovery_concurrency = config.addIntParameter2("MagnetPlugin.recover.magnets.conc", "MagnetPlugin.recover.magnets.conc", 32, 8, 512);
        this.magnet_recovery_concurrency.setIndent(1, true);
        this.magnet_recovery.addEnabledOnSelection((Parameter)this.magnet_recovery_concurrency);
        BooleanParameter rename = config.addBooleanParameter2("MagnetPlugin.rename.using.dn", "MagnetPlugin.rename.using.dn", false);
        BooleanParameter rename_ext = config.addBooleanParameter2("MagnetPlugin.rename.using.dn.only.with.ext", "MagnetPlugin.rename.using.dn.only.with.ext", false);
        rename_ext.setIndent(1, true);
        rename.addEnabledOnSelection((Parameter)rename_ext);
        BooleanParameter position = config.addBooleanParameter2("MagnetPlugin.dl.position.from.mag.time", "MagnetPlugin.dl.position.from.mag.time", true);
        Parameter[] nps = new Parameter[AENetworkClassifier.AT_NETWORKS.length];
        int i = 0;
        while (i < nps.length) {
            String nn = AENetworkClassifier.AT_NETWORKS[i];
            String config_name = "Network Selection Default." + nn;
            String msg_text = "ConfigView.section.connection.networks." + nn;
            final BooleanParameter param = config.addBooleanParameter2(config_name, msg_text, COConfigurationManager.getBooleanParameter(config_name));
            COConfigurationManager.addParameterListener(config_name, new ParameterListener(){

                @Override
                public void parameterChanged(String name) {
                    param.setDefaultValue(COConfigurationManager.getBooleanParameter(name));
                }
            });
            nps[i] = param;
            this.net_params.put(nn, param);
            ++i;
        }
        config.createGroup("label.default.nets", nps);
        MenuItemListener listener = new MenuItemListener(){

            @Override
            public void selected(MenuItem _menu, Object _target) {
                TableRow[] rows = (TableRow[])_target;
                String cb_all_data = "";
                TableRow[] tableRowArray = rows;
                int n = rows.length;
                int n2 = 0;
                while (n2 < n) {
                    block32: {
                        String sources;
                        boolean add_sources;
                        String cb_data;
                        int n3;
                        int n4;
                        String[] stringArray;
                        String[] nets;
                        String name;
                        Torrent torrent;
                        ShareResource share;
                        Download download;
                        block34: {
                            Object ds;
                            block35: {
                                block33: {
                                    TableRow row = tableRowArray[n2];
                                    ds = row.getDataSource();
                                    download = null;
                                    share = null;
                                    if (!(ds instanceof ShareResourceFile)) break block33;
                                    ShareResourceFile sf = (ShareResourceFile)ds;
                                    try {
                                        torrent = sf.getItem().getTorrent();
                                    }
                                    catch (ShareException e) {
                                        break block32;
                                    }
                                    name = sf.getName();
                                    share = sf;
                                    break block34;
                                }
                                if (!(ds instanceof ShareResourceDir)) break block35;
                                ShareResourceDir sd = (ShareResourceDir)ds;
                                try {
                                    torrent = sd.getItem().getTorrent();
                                }
                                catch (ShareException e) {
                                    break block32;
                                }
                                name = sd.getName();
                                share = sd;
                                break block34;
                            }
                            if (!(ds instanceof Download)) break block32;
                            download = (Download)ds;
                            torrent = download.getTorrent();
                            name = download.getName();
                        }
                        boolean is_share = false;
                        HashSet<Object> networks = new HashSet<Object>();
                        if (share != null) {
                            is_share = true;
                            Map<String, String> properties = share.getProperties();
                            if (properties != null && (nets = properties.get("networks")) != null) {
                                String[] bits;
                                stringArray = bits = nets.split(",");
                                n4 = bits.length;
                                n3 = 0;
                                while (n3 < n4) {
                                    Object bit = stringArray[n3];
                                    if ((bit = AENetworkClassifier.internalise(((String)bit).trim())) != null) {
                                        networks.add(bit);
                                    }
                                    ++n3;
                                }
                            }
                        }
                        if (download != null) {
                            TorrentAttribute ta = MagnetPlugin.this.plugin_interface.getTorrentManager().getAttribute("Networks");
                            nets = download.getListAttribute(ta);
                            networks.addAll(Arrays.asList(nets));
                            try {
                                byte[] hash = download.getTorrentHash();
                                if (MagnetPlugin.this.plugin_interface.getShareManager().lookupShare(hash) != null) {
                                    is_share = true;
                                }
                            }
                            catch (Throwable hash) {
                                // empty catch block
                            }
                        }
                        String string = cb_data = download == null ? UrlUtils.getMagnetURI(name, torrent) : UrlUtils.getMagnetURI(download);
                        if (download != null) {
                            List<Tag> tags = TagManagerFactory.getTagManager().getTagsForTaggable(3, (Taggable)PluginCoreUtils.unwrap(download));
                            for (Tag tag : tags) {
                                if (!tag.isPublic() || tag.isTagAuto()[0]) continue;
                                cb_data = String.valueOf(cb_data) + "&tag=" + UrlUtils.encode(tag.getTagName(true));
                            }
                        }
                        boolean bl = add_sources = (sources = MagnetPlugin.this.sources_param.getValue()).equals("2") || sources.equals("1") && is_share;
                        if (add_sources) {
                            if (networks.isEmpty()) {
                                stringArray = AENetworkClassifier.AT_NETWORKS;
                                n4 = AENetworkClassifier.AT_NETWORKS.length;
                                n3 = 0;
                                while (n3 < n4) {
                                    String net = stringArray[n3];
                                    if (MagnetPlugin.this.isNetworkEnabled(net)) {
                                        networks.add(net);
                                    }
                                    ++n3;
                                }
                            }
                            if (networks.contains("Public") && !cb_data.contains("xsource=")) {
                                int extra;
                                int port;
                                DownloadManager dm = download == null ? null : PluginCoreUtils.unwrap(download);
                                InetAddress ip = NetworkAdmin.getSingleton().getDefaultPublicAddress();
                                InetAddress ip_v6 = NetworkAdmin.getSingleton().getDefaultPublicAddressV6();
                                int n5 = port = dm == null ? TCPNetworkManager.getSingleton().getDefaultTCPListeningPortNumber() : dm.getTCPListeningPortNumber();
                                if (ip != null && port > 0) {
                                    cb_data = String.valueOf(cb_data) + "&xsource=" + UrlUtils.encode(UrlUtils.getURLForm(ip, port));
                                }
                                if (ip_v6 != null && port > 0) {
                                    cb_data = String.valueOf(cb_data) + "&xsource=" + UrlUtils.encode(UrlUtils.getURLForm(ip_v6, port));
                                }
                                if ((extra = MagnetPlugin.this.sources_extra_param.getValue()) > 0) {
                                    if (download == null && torrent != null) {
                                        download = MagnetPlugin.this.plugin_interface.getDownloadManager().getDownload(torrent);
                                    }
                                    if (download != null) {
                                        Map response_cache;
                                        HashSet<String> added = new HashSet<String>();
                                        PEPeerManager pm = dm.getPeerManager();
                                        if (pm != null) {
                                            List<PEPeer> peers = pm.getPeers();
                                            for (PEPeer peer : peers) {
                                                int peer_port;
                                                String peer_ip = peer.getIp();
                                                if (AENetworkClassifier.categoriseAddress(peer_ip) != "Public" || (peer_port = peer.getTCPListenPort()) <= 0) continue;
                                                cb_data = String.valueOf(cb_data) + "&xsource=" + UrlUtils.encode(UrlUtils.getURLForm(peer_ip, peer_port));
                                                added.add(peer_ip);
                                                if (--extra == 0) break;
                                            }
                                        }
                                        if (extra > 0 && (response_cache = dm.getDownloadState().getTrackerResponseCache()) != null) {
                                            List<TRTrackerAnnouncerResponsePeer> peers = TRTrackerAnnouncerFactory.getCachedPeers(response_cache);
                                            for (TRTrackerAnnouncerResponsePeer peer : peers) {
                                                int peer_port;
                                                String peer_ip = peer.getAddress();
                                                if (AENetworkClassifier.categoriseAddress(peer_ip) != "Public" || added.contains(peer_ip) || (peer_port = peer.getPort()) <= 0) continue;
                                                cb_data = String.valueOf(cb_data) + "&xsource=" + UrlUtils.encode(UrlUtils.getURLForm(peer_ip, peer_port));
                                                added.add(peer_ip);
                                                if (--extra == 0) break;
                                            }
                                        }
                                    }
                                }
                            }
                        }
                        cb_all_data = String.valueOf(cb_all_data) + (cb_all_data.length() == 0 ? "" : "\n") + cb_data;
                    }
                    ++n2;
                }
                try {
                    MagnetPlugin.this.plugin_interface.getUIManager().copyToClipBoard(cb_all_data);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
            }
        };
        final ArrayList<TableContextMenuItem> menus = new ArrayList<TableContextMenuItem>();
        String[] stringArray2 = TableManager.TABLE_MYTORRENTS_ALL;
        int param = TableManager.TABLE_MYTORRENTS_ALL.length;
        int msg_text = 0;
        while (msg_text < param) {
            String table = stringArray2[msg_text];
            TableContextMenuItem menu = this.plugin_interface.getUIManager().getTableManager().addContextMenuItem(table, "MagnetPlugin.contextmenu.exporturi");
            menu.addMultiListener(listener);
            menu.setHeaderCategory("Social");
            menus.add(menu);
            ++msg_text;
        }
        uri_handler.addListener(new MagnetURIHandlerListener(){

            @Override
            public byte[] badge() {
                InputStream is = this.getClass().getClassLoader().getResourceAsStream("com/biglybt/plugin/magnet/Magnet.gif");
                if (is == null) {
                    return null;
                }
                try {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    try {
                        int len;
                        byte[] buffer = new byte[8192];
                        while ((len = is.read(buffer)) > 0) {
                            baos.write(buffer, 0, len);
                        }
                    }
                    finally {
                        is.close();
                    }
                    return baos.toByteArray();
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                    return null;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public byte[] download(MagnetURIHandlerProgressListener muh_listener, byte[] hash, String args, InetSocketAddress[] sources, long timeout) throws MagnetURIHandlerException {
                try {
                    Torrent torrent;
                    DownloadManager core_dm;
                    Download dl = MagnetPlugin.this.plugin_interface.getDownloadManager().getDownload(hash);
                    if (dl != null && !(core_dm = PluginCoreUtils.unwrap(dl)).getDownloadState().getFlag(512L) && (torrent = dl.getTorrent()) != null) {
                        byte[] torrent_data = torrent.writeToBEncodedData();
                        torrent_data = MagnetPlugin.this.addTrackersAndWebSeedsEtc(torrent_data, args, new HashSet(), Collections.emptyList(), Collections.emptyMap());
                        return torrent_data;
                    }
                }
                catch (Throwable e) {
                    Debug.printStackTrace(e);
                }
                final Object[] result = new Object[1];
                final AESemaphore sem = new AESemaphore("dlwait");
                DownloadAsyncListener dl_listener = new DownloadAsyncListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void failed(MagnetURIHandlerException error) {
                        Object[] objectArray = result;
                        synchronized (result) {
                            result[0] = error;
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            sem.release();
                            return;
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void complete(byte[] torrent_data) {
                        Object[] objectArray = result;
                        synchronized (result) {
                            result[0] = torrent_data;
                            // ** MonitorExit[var2_2] (shouldn't be in output)
                            sem.release();
                            return;
                        }
                    }
                };
                MagnetPlugin.this.recoverableDownload(muh_listener, hash, args, sources, Collections.emptyList(), Collections.emptyMap(), timeout, SystemTime.getCurrentTime(), false, dl_listener);
                sem.reserve();
                Object[] objectArray = result;
                synchronized (result) {
                    Object r = result[0];
                    if (r instanceof MagnetURIHandlerException) {
                        throw (MagnetURIHandlerException)r;
                    }
                    // ** MonitorExit[var10_11] (shouldn't be in output)
                    return (byte[])r;
                }
            }

            @Override
            public boolean download(URL url) throws MagnetURIHandlerException {
                try {
                    MagnetPlugin.this.plugin_interface.getDownloadManager().addDownload(url, false);
                    return true;
                }
                catch (DownloadException e) {
                    throw new MagnetURIHandlerException("Operation failed", e);
                }
            }

            @Override
            public boolean set(String name, Map values) {
                List l = MagnetPlugin.this.listeners.getList();
                int i = 0;
                while (i < l.size()) {
                    if (((MagnetPluginListener)l.get(i)).set(name, values)) {
                        return true;
                    }
                    ++i;
                }
                return false;
            }

            @Override
            public int get(String name, Map values) {
                List l = MagnetPlugin.this.listeners.getList();
                int i = 0;
                while (i < l.size()) {
                    int res = ((MagnetPluginListener)l.get(i)).get(name, values);
                    if (res != Integer.MIN_VALUE) {
                        return res;
                    }
                    ++i;
                }
                return Integer.MIN_VALUE;
            }
        });
        this.plugin_interface.getUIManager().addUIListener(new UIManagerListener(){

            @Override
            public void UIAttached(UIInstance instance) {
                if (instance.getUIType().equals("swt")) {
                    try {
                        Class.forName("com.biglybt.plugin.magnet.swt.MagnetPluginUISWT").getConstructor(UIInstance.class, TableContextMenuItem[].class).newInstance(instance, menus.toArray(new TableContextMenuItem[menus.size()]));
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                    }
                }
            }

            @Override
            public void UIDetached(UIInstance instance) {
            }
        });
        final ArrayList<Download> to_delete = new ArrayList<Download>();
        Download[] downloadArray = downloads = this.plugin_interface.getDownloadManager().getDownloads();
        int n3 = downloads.length;
        int n4 = 0;
        while (n4 < n3) {
            Download download = downloadArray[n4];
            if (download.getFlag(512L)) {
                to_delete.add(download);
            }
            ++n4;
        }
        final AESemaphore delete_done = new AESemaphore("delete waiter");
        if (to_delete.size() > 0) {
            AEThread2 t = new AEThread2("MagnetPlugin:delmds", true){

                @Override
                public void run() {
                    try {
                        for (Download download : to_delete) {
                            try {
                                download.stopAndRemove(true, true);
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                    }
                    finally {
                        delete_done.release();
                    }
                }
            };
            t.start();
        } else {
            delete_done.release();
        }
        this.plugin_interface.addListener(new PluginListener(){

            @Override
            public void initializationComplete() {
                AEThread2 t = new AEThread2("MagnetPlugin:init", true){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void run() {
                        delete_done.reserve();
                        MagnetPlugin.this.recoverDownloads();
                        try {
                            try {
                                DistributedDatabase db = MagnetPlugin.this.plugin_interface.getDistributedDatabase();
                                DistributedDatabase[] distributedDatabaseArray = db_holder;
                                synchronized (distributedDatabaseArray) {
                                    db_holder[0] = db;
                                }
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                                db_waiter.releaseForever();
                            }
                        }
                        finally {
                            db_waiter.releaseForever();
                        }
                    }
                };
                t.start();
            }

            @Override
            public void closedownInitiated() {
                MagnetPlugin.this.updateRecoverableDownloads();
            }

            @Override
            public void closedownComplete() {
            }
        });
    }

    public String addSource(Download download, String magnet, InetSocketAddress address) {
        String sources;
        boolean add_sources;
        boolean is_share = false;
        try {
            byte[] hash = download.getTorrentHash();
            if (this.plugin_interface.getShareManager().lookupShare(hash) != null) {
                is_share = true;
            }
        }
        catch (Throwable hash) {
            // empty catch block
        }
        boolean bl = add_sources = (sources = this.sources_param.getValue()).equals("2") || sources.equals("1") && is_share;
        if (add_sources) {
            String arg = "&xsource=" + UrlUtils.encode(UrlUtils.getURLForm(address));
            magnet = String.valueOf(magnet) + arg;
        }
        return magnet;
    }

    protected void updateLocale(LocaleUtilities lu) {
        int i = 0;
        while (i < SOURCE_STRINGS.length) {
            MagnetPlugin.SOURCE_STRINGS[i] = lu.getLocalisedMessageText("MagnetPlugin.add.sources." + SOURCE_KEYS[i]);
            ++i;
        }
        if (this.sources_param != null) {
            this.sources_param.setLabels(SOURCE_STRINGS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverDownloads() {
        Map active;
        boolean recover = this.magnet_recovery.getValue();
        ByteArrayHashMap<DownloadActivity> byteArrayHashMap = download_activities;
        synchronized (byteArrayHashMap) {
            active = COConfigurationManager.getMapParameter("MagnetPlugin.active.magnets", new HashMap());
            if (active.size() > 0) {
                active = BEncoder.cloneMap(active);
                if (!recover) {
                    COConfigurationManager.setParameter("MagnetPlugin.active.magnets", new HashMap());
                }
            }
        }
        HashSet<String> active_hashes = new HashSet<String>(active.size());
        if (recover && !active.isEmpty()) {
            int conc = this.magnet_recovery_concurrency.getValue();
            if (conc < 1) {
                conc = 1;
            }
            ThreadPool tp2 = new ThreadPool("Magnet Recovery", conc, true);
            ArrayList sorted = new ArrayList(active.values());
            Collections.sort(sorted, (m1, m2) -> {
                Long t2;
                Long t1 = (Long)m1.get("added");
                if (t1 == (t2 = (Long)m2.get("added"))) {
                    return 0;
                }
                if (t1 == null) {
                    return -1;
                }
                if (t2 == null) {
                    return 1;
                }
                long diff = t1 - t2;
                if (diff < 0L) {
                    return -1;
                }
                if (diff == 0L) {
                    return 0;
                }
                return 1;
            });
            for (Map map : sorted) {
                final byte[] hash = (byte[])map.get("hash");
                try {
                    active_hashes.add(ByteFormatter.encodeString(hash));
                    final String args = MapUtils.getMapString(map, "args", "");
                    InetSocketAddress[] sources = new InetSocketAddress[]{};
                    List l_sources = (List)map.get("sources");
                    if (l_sources != null && !l_sources.isEmpty()) {
                        ArrayList<InetSocketAddress> l_ias = new ArrayList<InetSocketAddress>();
                        for (Map m : l_sources) {
                            try {
                                int port = ((Number)m.get("port")).intValue();
                                if (map.containsKey("host")) {
                                    String unresolved_host = MapUtils.getMapString(map, "host", "");
                                    l_ias.add(InetSocketAddress.createUnresolved(unresolved_host, port));
                                    continue;
                                }
                                byte[] address = (byte[])map.get("address");
                                l_ias.add(new InetSocketAddress(InetAddress.getByAddress(address), port));
                            }
                            catch (Throwable e) {
                                Debug.out(e);
                            }
                        }
                        sources = l_ias.toArray(new InetSocketAddress[l_ias.size()]);
                    }
                    List l_tags = null;
                    try {
                        l_tags = BDecoder.decodeStrings((List)map.get("tags"));
                    }
                    catch (Throwable m) {
                        // empty catch block
                    }
                    final List f_tags = l_tags;
                    final Map other_metadata = (Map)map.get("other_metadata");
                    final long timeout = ((Number)map.get("timeout")).longValue();
                    final Long added_time = (Long)map.get("added");
                    final InetSocketAddress[] f_sources = sources;
                    tp2.run(new AERunnable(){

                        @Override
                        public void runSupport() {
                            DownloadAsyncListener dl_listener = new DownloadAsyncListener(){

                                @Override
                                public void failed(MagnetURIHandlerException error) {
                                    Debug.out(error);
                                }

                                @Override
                                public void complete(byte[] result) {
                                    if (result != null) {
                                        try {
                                            File torrent_file;
                                            TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedByteArray(result);
                                            String torrent_name = FileUtil.convertOSSpecificChars(String.valueOf(TorrentUtils.getLocalisedName(torrent)) + ".torrent", false);
                                            String dir = null;
                                            if (COConfigurationManager.getBooleanParameter("Save Torrent Files") && (dir = COConfigurationManager.getDirectoryParameter("General_sDefaultTorrent_Directory")) != null) {
                                                if (dir.length() > 0) {
                                                    File f = FileUtil.newFile(dir, new String[0]);
                                                    if (!f.exists()) {
                                                        f.mkdirs();
                                                    }
                                                    if (!f.isDirectory() || !f.canWrite()) {
                                                        dir = null;
                                                    }
                                                } else {
                                                    dir = null;
                                                }
                                            }
                                            if ((torrent_file = dir != null ? FileUtil.newFile(dir, torrent_name) : FileUtil.newFile(AETemporaryFileHandler.getTempDirectory(), torrent_name)).exists()) {
                                                torrent_file = AETemporaryFileHandler.createTempFile();
                                            }
                                            TorrentUtils.writeToFile(torrent, torrent_file, false);
                                            UIFunctions uif = UIFunctionsManager.getUIFunctions();
                                            TorrentOpenOptions torrentOptions = new TorrentOpenOptions(null);
                                            torrentOptions.setDeleteFileOnCancel(true);
                                            torrentOptions.setTorrentFile(torrent_file.getAbsolutePath());
                                            torrentOptions.setTorrent(torrent);
                                            uif.addTorrentWithOptions(false, torrentOptions);
                                        }
                                        catch (Throwable e) {
                                            Debug.out(e);
                                        }
                                    }
                                }
                            };
                            MagnetPlugin.this.recoverableDownload(null, hash, args, f_sources, f_tags, other_metadata, timeout, added_time, true, dl_listener);
                        }
                    });
                    Thread.sleep(500L);
                }
                catch (Throwable e) {
                    Debug.out(e);
                    ByteArrayHashMap<DownloadActivity> byteArrayHashMap2 = download_activities;
                    synchronized (byteArrayHashMap2) {
                        Map temp = COConfigurationManager.getMapParameter("MagnetPlugin.active.magnets", new HashMap());
                        String hash_str = Base32.encode(hash);
                        temp.remove(hash_str);
                    }
                    COConfigurationManager.setDirty();
                }
            }
        }
        AEThread2.createAndStartDaemon("MagnetPlugin:mdtidy", () -> {
            try {
                File torrents_dir = FileUtil.getUserFile("torrents");
                File md_dir = FileUtil.newFile(torrents_dir, "md");
                File[] files = md_dir.listFiles();
                if (files != null) {
                    long now = SystemTime.getCurrentTime();
                    File[] fileArray = files;
                    int n = files.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String name;
                        File f = fileArray[n2];
                        if (now - f.lastModified() > 86400000L && (name = f.getName()).length() == 40 && !active_hashes.contains(name)) {
                            Debug.outNoStack("Deleting dead magnet download storage for " + name);
                            FileUtil.recursiveDeleteNoCheck(f);
                        }
                        ++n2;
                    }
                }
            }
            catch (Throwable e) {
                Debug.out(e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateRecoverableDownloads() {
        boolean recover = this.magnet_recovery.getValue();
        if (recover) {
            ByteArrayHashMap<DownloadActivity> byteArrayHashMap = download_activities;
            synchronized (byteArrayHashMap) {
                Map active = COConfigurationManager.getMapParameter("MagnetPlugin.active.magnets", new HashMap());
                if (active.size() > 0) {
                    active = BEncoder.cloneMap(active);
                    boolean do_update = false;
                    for (Map map : active.values()) {
                        try {
                            DownloadManager core_dm;
                            byte[] hash = (byte[])map.get("hash");
                            Download download = this.plugin_interface.getDownloadManager().getDownload(hash);
                            if (download == null || !this.updateInitialMetadata(map, core_dm = PluginCoreUtils.unwrap(download))) continue;
                            do_update = true;
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                    }
                    if (do_update) {
                        COConfigurationManager.setParameter("MagnetPlugin.active.magnets", active);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void recoverableDownload(final MagnetURIHandlerProgressListener muh_listener, byte[] hash, String args, InetSocketAddress[] sources, List<String> tags, Map<String, Object> other_metadata, long timeout, Long added_time, boolean is_recovering, final DownloadAsyncListener _dl_listener) {
        boolean recover = this.magnet_recovery.getValue();
        String hash_str = Base32.encode(hash);
        final Runnable run_finally = () -> {
            if (recover) {
                ByteArrayHashMap<DownloadActivity> byteArrayHashMap = download_activities;
                synchronized (byteArrayHashMap) {
                    Map active = COConfigurationManager.getMapParameter("MagnetPlugin.active.magnets", new HashMap());
                    active.remove(hash_str);
                }
                COConfigurationManager.setDirty();
            }
        };
        try {
            if (recover) {
                HashMap<String, Object> map = new HashMap<String, Object>();
                map.put("hash", hash);
                map.put("args", args);
                if (added_time != null) {
                    map.put("added", added_time);
                    other_metadata = other_metadata == null ? new HashMap<String, Object>() : new HashMap<String, Object>(other_metadata);
                    other_metadata.put("added_time", added_time);
                }
                ArrayList l_sources = new ArrayList();
                map.put("sources", l_sources);
                if (sources != null && sources.length > 0) {
                    InetSocketAddress[] inetSocketAddressArray = sources;
                    int n = sources.length;
                    int n2 = 0;
                    while (n2 < n) {
                        InetSocketAddress isa = inetSocketAddressArray[n2];
                        try {
                            HashMap<String, Integer> m = new HashMap<String, Integer>();
                            m.put("port", isa.getPort());
                            if (isa.isUnresolved()) {
                                map.put("host", isa.getHostName());
                            } else {
                                InetAddress ia = isa.getAddress();
                                map.put("address", ia.getAddress());
                            }
                            l_sources.add(m);
                        }
                        catch (Throwable e) {
                            Debug.out(e);
                        }
                        ++n2;
                    }
                }
                if (tags != null) {
                    map.put("tags", tags);
                }
                if (other_metadata != null) {
                    map.put("other_metadata", other_metadata);
                }
                map.put("timeout", timeout);
                ByteArrayHashMap<DownloadActivity> byteArrayHashMap = download_activities;
                synchronized (byteArrayHashMap) {
                    Map active = COConfigurationManager.getMapParameter("MagnetPlugin.active.magnets", new HashMap());
                    active.put(hash_str, map);
                    COConfigurationManager.setParameter("MagnetPlugin.active.magnets", active);
                }
                COConfigurationManager.setDirty();
            }
            DownloadAsyncListener dl_listener = new DownloadAsyncListener(){

                @Override
                public void failed(MagnetURIHandlerException error) {
                    try {
                        _dl_listener.failed(error);
                    }
                    finally {
                        run_finally.run();
                    }
                }

                @Override
                public void complete(byte[] torrent_data) {
                    try {
                        _dl_listener.complete(torrent_data);
                    }
                    finally {
                        run_finally.run();
                    }
                }
            };
            this.downloadAsync(muh_listener == null ? null : new MagnetPluginProgressListener(){

                @Override
                public void reportSize(long size) {
                    muh_listener.reportSize(size);
                }

                @Override
                public void reportActivity(String str) {
                    muh_listener.reportActivity(str);
                }

                @Override
                public void reportCompleteness(int percent) {
                    muh_listener.reportCompleteness(percent);
                }

                @Override
                public void reportContributor(InetSocketAddress address) {
                }

                @Override
                public boolean cancelled() {
                    return muh_listener.cancelled();
                }

                @Override
                public boolean verbose() {
                    return muh_listener.verbose();
                }
            }, hash, args, sources, tags, other_metadata, timeout, is_recovering ? 6 : 0, dl_listener);
        }
        catch (Throwable e) {
            try {
                _dl_listener.failed(new MagnetURIHandlerException("Magnet download failed", e));
            }
            finally {
                run_finally.run();
            }
        }
    }

    public boolean isNetworkEnabled(String net) {
        return this.net_params.get(net).getValue();
    }

    public URL getMagnetURL(byte[] hash) {
        try {
            return new URL(UrlUtils.getMagnetURI(hash));
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    public URL getMagnetURL(TOTorrent torrent) throws TOTorrentException {
        try {
            return new URL(UrlUtils.getMagnetURI(torrent));
        }
        catch (Throwable e) {
            Debug.out(e);
            return null;
        }
    }

    public List<String> getExtraTrackers() {
        String[] bits;
        String extra = this.md_extra_trackers.getValue();
        ArrayList<String> result = new ArrayList<String>();
        String[] stringArray = bits = extra.split("\n");
        int n = bits.length;
        int n2 = 0;
        while (n2 < n) {
            String bit = stringArray[n2];
            if (!(bit = bit.trim()).isEmpty()) {
                result.add(bit);
            }
            ++n2;
        }
        return result;
    }

    public byte[] badge() {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] download(MagnetPluginProgressListener listener, byte[] hash, String args, InetSocketAddress[] sources, List<String> tags, Map<String, Object> other_metadata, long timeout, int flags) throws MagnetURIHandlerException {
        final Object[] result = new Object[1];
        final AESemaphore sem = new AESemaphore("dlwait");
        DownloadAsyncListener dl_listener = new DownloadAsyncListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void failed(MagnetURIHandlerException error) {
                Object[] objectArray = result;
                synchronized (result) {
                    result[0] = error;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    sem.release();
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void complete(byte[] torrent_data) {
                Object[] objectArray = result;
                synchronized (result) {
                    result[0] = torrent_data;
                    // ** MonitorExit[var2_2] (shouldn't be in output)
                    sem.release();
                    return;
                }
            }
        };
        this.downloadAsync(listener, hash, args, sources, tags, other_metadata, timeout, flags, dl_listener);
        sem.reserve();
        Object[] objectArray = result;
        synchronized (result) {
            Object r = result[0];
            if (r instanceof MagnetURIHandlerException) {
                throw (MagnetURIHandlerException)r;
            }
            // ** MonitorExit[var13_12] (shouldn't be in output)
            return (byte[])r;
        }
    }

    public void downloadAsync(MagnetPluginProgressListener listener, byte[] hash, final String args, InetSocketAddress[] sources, final List<String> tags, final Map<String, Object> other_metadata, long timeout, int flags, final DownloadAsyncListener dl_listener) {
        DownloadResultListener result_listener = new DownloadResultListener(){

            @Override
            public void failed(MagnetURIHandlerException error) {
                dl_listener.failed(error);
            }

            @Override
            public void complete(DownloadResult result) {
                if (result == null) {
                    dl_listener.complete(null);
                } else {
                    dl_listener.complete(MagnetPlugin.this.addTrackersAndWebSeedsEtc(result, args, tags, other_metadata));
                }
            }
        };
        this.downloadSupport(listener, hash, args, sources, tags, other_metadata, timeout, flags, result_listener);
    }

    private byte[] addTrackersAndWebSeedsEtc(DownloadResult result, String args, List<String> tags, Map<String, Object> other_metadata) {
        byte[] torrent_data = result.getTorrentData();
        Set networks = result.getNetworks();
        DownloadManager dm = result.getDownload();
        if (dm != null) {
            tags = (List)dm.getUserData(DM_TAG_CACHE);
            other_metadata = this.getInitialMetadata(dm, other_metadata);
            String category = (String)dm.getUserData(DM_CATEGORY_CACHE);
            if (category != null) {
                MapUtils.setMapString(other_metadata, "category", category);
            }
        }
        return this.addTrackersAndWebSeedsEtc(torrent_data, args, networks, tags, other_metadata);
    }

    private byte[] addTrackersAndWebSeedsEtc(byte[] torrent_data, String args, Set<String> networks, List<String> initial_tags, Map<String, Object> other_metadata) {
        if (initial_tags == null) {
            initial_tags = Collections.emptyList();
        }
        if (other_metadata == null) {
            other_metadata = new HashMap<String, Object>();
        }
        ArrayList<String> new_web_seeds = new ArrayList<String>();
        ArrayList<String> new_trackers = new ArrayList<String>();
        HashSet<String> tags = new HashSet<String>();
        String dn = null;
        if (args != null) {
            String[] bits;
            String[] stringArray = bits = args.split("&");
            int n = bits.length;
            int n2 = 0;
            while (n2 < n) {
                String bit = stringArray[n2];
                String[] x = bit.split("=");
                if (x.length == 2) {
                    Iterator lhs = x[0].toLowerCase();
                    String rhs = x[1];
                    if (((String)((Object)lhs)).equals("ws")) {
                        try {
                            new_web_seeds.add(new URL(UrlUtils.decode(rhs)).toExternalForm());
                        }
                        catch (Throwable throwable) {}
                    } else if (((String)((Object)lhs)).equals("tr")) {
                        try {
                            new_trackers.add(new URL(UrlUtils.decode(rhs)).toExternalForm());
                        }
                        catch (Throwable throwable) {}
                    } else if (((String)((Object)lhs)).equals("tag")) {
                        tags.add(UrlUtils.decode(rhs));
                    } else if (((String)((Object)lhs)).equals("dn")) {
                        dn = UrlUtils.decode(rhs);
                    }
                }
                ++n2;
            }
        }
        if (dn != null || new_web_seeds.size() > 0 || new_trackers.size() > 0 || networks.size() > 0 || !initial_tags.isEmpty() || !other_metadata.isEmpty()) {
            try {
                TOTorrent torrent = TOTorrentFactory.deserialiseFromBEncodedByteArray(torrent_data);
                boolean update_torrent = false;
                if (dn != null && TorrentUtils.getDisplayName(torrent) == null) {
                    String t_name = torrent.getUTF8Name();
                    if (t_name == null) {
                        t_name = new String(torrent.getName(), Constants.UTF_8);
                    }
                    if (!dn.equals(t_name)) {
                        TorrentUtils.setDisplayName(torrent, dn);
                        update_torrent = true;
                    }
                }
                if (new_web_seeds.size() > 0) {
                    Object obj = torrent.getAdditionalProperty("url-list");
                    ArrayList<String> existing = new ArrayList<String>();
                    if (obj instanceof byte[]) {
                        try {
                            new_web_seeds.remove(new URL(new String((byte[])obj, "UTF-8")).toExternalForm());
                        }
                        catch (Throwable throwable) {}
                    } else if (obj instanceof List) {
                        List l = (List)obj;
                        for (byte[] b : l) {
                            try {
                                existing.add(new URL(new String(b, "UTF-8")).toExternalForm());
                            }
                            catch (Throwable rhs) {
                                // empty catch block
                            }
                        }
                    }
                    boolean update_ws = false;
                    for (String e : new_web_seeds) {
                        if (existing.contains(e)) continue;
                        existing.add(e);
                        update_ws = true;
                    }
                    if (update_ws) {
                        ArrayList<byte[]> l = new ArrayList<byte[]>();
                        for (String s : existing) {
                            l.add(s.getBytes("UTF-8"));
                        }
                        torrent.setAdditionalProperty("url-list", l);
                        update_torrent = true;
                    }
                }
                if (new_trackers.size() > 0) {
                    TOTorrentAnnounceURLSet[] sets;
                    URL announce_url = torrent.getAnnounceURL();
                    new_trackers.remove(announce_url.toExternalForm());
                    TOTorrentAnnounceURLGroup group = torrent.getAnnounceURLGroup();
                    TOTorrentAnnounceURLSet[] tOTorrentAnnounceURLSetArray = sets = group.getAnnounceURLSets();
                    int rhs = sets.length;
                    int s = 0;
                    while (s < rhs) {
                        URL[] set_urls;
                        TOTorrentAnnounceURLSet set = tOTorrentAnnounceURLSetArray[s];
                        URL[] uRLArray = set_urls = set.getAnnounceURLs();
                        int n = set_urls.length;
                        int n3 = 0;
                        while (n3 < n) {
                            URL set_url = uRLArray[n3];
                            new_trackers.remove(set_url.toExternalForm());
                            ++n3;
                        }
                        ++s;
                    }
                    if (new_trackers.size() > 0) {
                        TOTorrentAnnounceURLSet[] new_sets = new TOTorrentAnnounceURLSet[sets.length + new_trackers.size()];
                        System.arraycopy(sets, 0, new_sets, 0, sets.length);
                        int i = 0;
                        while (i < new_trackers.size()) {
                            TOTorrentAnnounceURLSet new_set;
                            new_sets[i + sets.length] = new_set = group.createAnnounceURLSet(new URL[]{new URL((String)new_trackers.get(i))});
                            ++i;
                        }
                        group.setAnnounceURLSets(new_sets);
                        update_torrent = true;
                    }
                }
                if (networks.size() > 0) {
                    TorrentUtils.setNetworkCache(torrent, new ArrayList<String>(networks));
                    update_torrent = true;
                }
                if (tags.size() > 0) {
                    TorrentUtils.setTagCache(torrent, new ArrayList<String>(tags));
                    update_torrent = true;
                }
                if (this.setInitialMetadata(torrent, initial_tags, other_metadata)) {
                    update_torrent = true;
                }
                if (update_torrent) {
                    torrent_data = BEncoder.encode(torrent.serialiseToMap());
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return torrent_data;
    }

    protected List<String> getInitialTags(DownloadManager from_dm) {
        ArrayList<String> tag_names = new ArrayList<String>();
        try {
            List<Tag> tags = TagManagerFactory.getTagManager().getTagsForTaggable(3, (Taggable)from_dm);
            if (!tags.isEmpty()) {
                for (Tag t : tags) {
                    if (t.isTagAuto()[0]) continue;
                    tag_names.add(t.getTagName(true));
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return tag_names;
    }

    protected boolean updateInitialMetadata(Map map, DownloadManager from_dm) {
        List<String> tag_names = this.getInitialTags(from_dm);
        boolean updated = false;
        if (!tag_names.isEmpty()) {
            map.put("tags", tag_names);
            updated = true;
        } else if (map.remove("tags") != null) {
            updated = true;
        }
        Map<String, Object> other_metadata = this.getInitialMetadata(from_dm, (Map)map.get("other_metadata"));
        if (!other_metadata.isEmpty()) {
            map.put("other_metadata", other_metadata);
            updated = true;
        } else if (map.remove("other_metadata") != null) {
            updated = true;
        }
        return updated;
    }

    protected void setDNChanged(DownloadManager dm) {
        dm.setUserData(DM_DN_CHANGED, "");
    }

    protected Map<String, Object> getInitialMetadata(DownloadManager dm, Map<String, Object> existing_md) {
        Map<String, Object> latest = TorrentUtils.getInitialMetadata(dm, dm.getUserData(DM_DN_CHANGED) != null);
        if (existing_md == null) {
            return latest;
        }
        HashMap<String, Object> merged = new HashMap<String, Object>(existing_md);
        merged.putAll(latest);
        return merged;
    }

    protected void setInitialMetadata(DownloadManager to_dm, List<String> tags, Map<String, Object> other_metadata) {
        if (tags != null) {
            try {
                TagManager tm = TagManagerFactory.getTagManager();
                for (String tn : tags) {
                    Tag tag = tm.getTagType(3).getTag(tn, true);
                    if (tag == null) continue;
                    tag.addTaggable(to_dm);
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (other_metadata != null && !other_metadata.isEmpty()) {
            TorrentUtils.setInitialMetadata(to_dm, other_metadata, true);
        }
    }

    private boolean setInitialMetadata(TOTorrent torrent, List<String> tags, Map<String, Object> other_metadata) {
        boolean update = false;
        if (!tags.isEmpty()) {
            TorrentUtils.setInitialTags(torrent, new ArrayList<String>(tags));
            update = true;
        }
        if (!other_metadata.isEmpty()) {
            TorrentUtils.setInitialMetadata(torrent, other_metadata);
            update = true;
        }
        return update;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadSupport(MagnetPluginProgressListener listener, byte[] hash, String args, InetSocketAddress[] sources, List<String> tags, Map<String, Object> initial_metadata, long timeout, int flags, DownloadResultListener _result_listener) {
        block19: {
            DownloadActivity activity;
            boolean new_activity = false;
            ByteArrayHashMap<DownloadActivity> byteArrayHashMap = download_activities;
            synchronized (byteArrayHashMap) {
                activity = download_activities.get(hash);
                if (activity == null) {
                    activity = new DownloadActivity();
                    download_activities.put(hash, activity);
                    new_activity = true;
                }
                activity.addListener(_result_listener);
            }
            if (new_activity) {
                final DownloadActivity f_activity = activity;
                try {
                    try {
                        DownloadResultListener result_listener = new DownloadResultListener(){

                            @Override
                            public void complete(DownloadResult result) {
                                f_activity.setResult(result);
                            }

                            @Override
                            public void failed(MagnetURIHandlerException error) {
                                f_activity.setResult(error);
                            }
                        };
                        this._downloadSupport(listener, hash, args, sources, tags, initial_metadata, timeout, flags, result_listener);
                    }
                    catch (Throwable e) {
                        activity.setResult(e);
                        ByteArrayHashMap<DownloadActivity> byteArrayHashMap2 = download_activities;
                        synchronized (byteArrayHashMap2) {
                            download_activities.remove(hash);
                            break block19;
                        }
                    }
                }
                catch (Throwable throwable) {
                    ByteArrayHashMap<DownloadActivity> byteArrayHashMap3 = download_activities;
                    synchronized (byteArrayHashMap3) {
                        download_activities.remove(hash);
                    }
                    throw throwable;
                }
                ByteArrayHashMap<DownloadActivity> byteArrayHashMap4 = download_activities;
                synchronized (byteArrayHashMap4) {
                    download_activities.remove(hash);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    private void _downloadSupport(MagnetPluginProgressListener listener, byte[] hash, String args, InetSocketAddress[] sources, List<String> tags, Map<String, Object> initial_metadata, long _timeout, int flags, DownloadResultListener result_listener) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [41[MONITOR]], but top level block is 74[WHILELOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected String getMessageText(String resource, String ... params) {
        return this.plugin_interface.getUtilities().getLocaleUtilities().getLocalisedMessageText("MagnetPlugin." + resource, params);
    }

    public void addListener(MagnetPluginListener listener) {
        this.listeners.add(listener);
    }

    public void removeListener(MagnetPluginListener listener) {
        this.listeners.remove(listener);
    }

    private static class DownloadActivity {
        private boolean result_set;
        private DownloadResult result;
        private MagnetURIHandlerException error;
        private List<DownloadResultListener> listeners = new ArrayList<DownloadResultListener>(2);

        private DownloadActivity() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(DownloadResultListener l) {
            boolean already_done;
            DownloadActivity downloadActivity = this;
            synchronized (downloadActivity) {
                already_done = this.result_set;
                if (!already_done) {
                    this.listeners.add(l);
                }
            }
            if (already_done) {
                if (this.error != null) {
                    l.failed(this.error);
                } else {
                    l.complete(this.result);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setResult(DownloadResult _result) {
            List<DownloadResultListener> to_do;
            DownloadActivity downloadActivity = this;
            synchronized (downloadActivity) {
                this.result_set = true;
                this.result = _result;
                to_do = this.listeners;
                this.listeners = new ArrayList<DownloadResultListener>();
            }
            for (DownloadResultListener l : to_do) {
                try {
                    l.complete(_result);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setResult(Throwable _error) {
            List<DownloadResultListener> to_do;
            DownloadActivity downloadActivity = this;
            synchronized (downloadActivity) {
                this.result_set = true;
                this.error = _error instanceof MagnetURIHandlerException ? (MagnetURIHandlerException)_error : new MagnetURIHandlerException("Download failed", _error);
                to_do = this.listeners;
                this.listeners = new ArrayList<DownloadResultListener>();
            }
            for (DownloadResultListener l : to_do) {
                try {
                    l.failed(this.error);
                }
                catch (Throwable e) {
                    Debug.out(e);
                }
            }
        }
    }

    private static interface DownloadAsyncListener {
        public void complete(byte[] var1);

        public void failed(MagnetURIHandlerException var1);
    }

    private static class DownloadResult {
        private final byte[] data;
        private final Set<String> networks;
        private final DownloadManager dm;

        private DownloadResult(byte[] torrent_data, Set<String> networks_enabled, Set<String> additional_networks, MagnetPluginMDDownloader mdd) {
            this.data = torrent_data;
            this.networks = new HashSet<String>();
            this.networks.addAll(networks_enabled);
            this.networks.addAll(additional_networks);
            this.dm = mdd == null ? null : mdd.getDownloadManager();
        }

        private DownloadManager getDownload() {
            return this.dm;
        }

        private byte[] getTorrentData() {
            return this.data;
        }

        private Set<String> getNetworks() {
            return this.networks;
        }
    }

    private static interface DownloadResultListener {
        public void complete(DownloadResult var1);

        public void failed(MagnetURIHandlerException var1);
    }
}

